/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    private Vector items = new Vector();

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        this.items.addElement(string);
        OS.List_Add(this.internal_handle, string, this.items.size() - 1);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        if (index < 0 || index > this.items.size()) {
            List.error(6);
        }
        this.items.insertElementAt(string, index);
        OS.List_Add(this.internal_handle, string, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            List.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean causesTraversal(int detail) {
        switch (detail) {
            case 32: 
            case 64: {
                return false;
            }
        }
        return true;
    }

    public void deselect(int index) {
        this.checkWidget();
        OS.List_Deselect(this.internal_handle, index);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.List_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
        boolean multiple = false;
        if ((this.internal_style & 4) != 0) {
            multiple = false;
        } else if ((this.internal_style & 2) != 0) {
            multiple = true;
        }
        OS.List_SetMultipleMode(this.internal_handle, multiple);
    }

    void createScrollBars() {
        this.horizontalBar = null;
        this.verticalBar = null;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            int[] size = OS.List_GetMinimumSize(this.internal_handle, this.items.size());
            width = size[0];
            height = size[1];
        }
        if (hHint != -1) {
            height = hHint + 2 * this.getBorderWidth();
        }
        if (wHint != -1) {
            width = wHint + 2 * this.getBorderWidth();
        }
        return new Point(width, height);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        for (int i = start; i <= end; ++i) {
            OS.List_Deselect(this.internal_handle, i);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            OS.List_Deselect(this.internal_handle, indices[i]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        OS.List_DeselectAll(this.internal_handle);
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.List_GetCurrentItemIndex(this.internal_handle);
    }

    public String getItem(int index) {
        this.checkWidget();
        if (this.items.size() == 0) {
            List.error(8);
        }
        if (index < 0 || index >= this.items.size()) {
            List.error(6);
        }
        return (String)this.items.elementAt(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.List_GetItemHeight(this.internal_handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] array = new String[this.items.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)this.items.elementAt(i);
        }
        return array;
    }

    public String[] getSelection() {
        String[] selection;
        this.checkWidget();
        int[] indices = OS.List_GetSelectionIndices(this.internal_handle);
        if (indices == null || indices.length == 0) {
            selection = new String[]{};
        } else {
            int itemCount = this.items.size();
            if (indices.length > itemCount) {
                List.error(9);
            }
            selection = new String[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index < 0 || index >= itemCount) {
                    List.error(8);
                    continue;
                }
                selection[i] = (String)this.items.elementAt(index);
            }
        }
        return selection;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.List_GetSelectionCount(this.internal_handle);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = OS.List_GetSelectionIndex(this.internal_handle);
        return index;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return OS.List_GetSelectionIndices(this.internal_handle);
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.List_GetTopItemIndex(this.internal_handle);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        int index = -1;
        if (start >= 0) {
            for (int i = start; i < this.items.size(); ++i) {
                String test = (String)this.items.elementAt(i);
                if (!test.equals(string)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        return OS.List_IsSelected(this.internal_handle, index);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            List.error(6);
        }
        this.items.removeElementAt(index);
        OS.List_Remove(this.internal_handle, index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start < 0 || end >= this.items.size()) {
            SWT.error(6);
        }
        for (int index = end; index >= start; --index) {
            this.items.removeElementAt(index);
            OS.List_Remove(this.internal_handle, index);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int index = -1;
        int itemCount = this.items.size();
        for (int i = 0; i < itemCount; ++i) {
            String test = (String)this.items.elementAt(i);
            if (!test.equals(string)) continue;
            this.items.removeElementAt(i);
            index = i;
            break;
        }
        if (index == -1) {
            SWT.error(5);
        } else {
            OS.List_Remove(this.internal_handle, index);
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int itemCount = this.items.size();
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (0 > start || start > end || end >= itemCount) {
            List.error(6);
        }
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index == last) continue;
            this.items.removeElementAt(newIndices[i]);
            OS.List_Remove(this.internal_handle, newIndices[i]);
            last = index;
        }
    }

    void sort(int[] items) {
        int length = items.length;
        for (int gap = length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < length; ++i) {
                for (int j = i - gap; j >= 0; j -= gap) {
                    if (items[j] > items[j + gap]) continue;
                    int swap = items[j];
                    items[j] = items[j + gap];
                    items[j + gap] = swap;
                }
            }
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.items.removeAllElements();
        OS.List_RemoveAll(this.internal_handle);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            List.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        OS.List_Select(this.internal_handle, index);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int itemCount = this.items.size();
        if ((this.internal_style & 4) != 0) {
            if (start == end && start >= 0 && end < itemCount) {
                OS.List_Select(this.internal_handle, start);
            }
        } else {
            start = Math.max(0, start);
            end = Math.min(itemCount - 1, end);
            for (int i = start; i <= end; ++i) {
                OS.List_Select(this.internal_handle, i);
            }
        }
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        if ((this.internal_style & 4) != 0 && indices.length > 1) {
            return;
        }
        int itemCount = this.items.size();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index < 0 || index >= itemCount) continue;
            OS.List_Select(this.internal_handle, index);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.internal_style & 4) != 0) {
            return;
        }
        int itemCount = this.items.size();
        if (itemCount > 0) {
            this.select(0, itemCount - 1);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        int itemCount = this.items.size();
        if (index < 0 || index >= itemCount) {
            List.error(6);
        }
        this.items.setElementAt(string, index);
        OS.List_SetItem(this.internal_handle, index, string);
    }

    public void setItems(String[] newItems) {
        this.checkWidget();
        if (newItems == null) {
            List.error(4);
        }
        this.items.removeAllElements();
        OS.List_RemoveAll(this.internal_handle);
        for (int i = 0; i < newItems.length; ++i) {
            this.items.addElement(newItems[i]);
            OS.List_Add(this.internal_handle, newItems[i], i);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if ((this.internal_style & 4) != 0 && (index < 0 || index >= this.items.size())) {
            this.deselectAll();
            return;
        }
        this.setSelection(index, index);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if ((this.internal_style & 4) != 0) {
            if (start < 0 && end < 0) {
                return;
            }
            if (end > start) {
                return;
            }
        }
        this.select(start, end);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        this.deselectAll();
        if ((this.internal_style & 4) != 0 && indices.length > 1) {
            return;
        }
        this.select(indices);
    }

    public void setSelection(String[] newItems) {
        this.checkWidget();
        if (newItems == null) {
            List.error(4);
        }
        this.deselectAll();
        if ((this.internal_style & 4) != 0 && newItems.length > 1) {
            return;
        }
        for (int i = 0; i < newItems.length; ++i) {
            int index = 0;
            String string = newItems[i];
            if (string == null) continue;
            while ((index = this.indexOf(string, index)) != -1) {
                this.select(index);
                if ((this.internal_style & 4) != 0 && this.isSelected(index)) {
                    this.showSelection();
                    return;
                }
                ++index;
            }
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        OS.List_SetTopItemIndex(this.internal_handle, index);
    }

    public void showSelection() {
        this.checkWidget();
        OS.List_MakeSelectionVisible(this.internal_handle);
    }

    private void listCallback(int index, int type) {
        switch (type) {
            case 1: {
                this.internal_sendEvent(13);
                break;
            }
            case 2: {
                this.internal_sendEvent(14);
            }
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle r = this.getBounds();
        r.x = 0;
        r.y = 0;
        return r;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
            case 0x1000001: {
                if (this.getFocusIndex() > 0) break;
                return true;
            }
            case 0x1000002: {
                if (this.getFocusIndex() < this.getItemCount() - 1) break;
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

