/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = new Path("$nl$");
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static Properties productCustomization;
    private static Properties productTranslation;
    private static Properties commandLineCustomization;
    private EclipsePreferences loadLevel;
    private String qualifier;
    private int segmentCount;
    private WeakReference pluginReference;
    public static String pluginCustomizationFile;
    static /* synthetic */ Class class$0;

    static {
        pluginCustomizationFile = null;
    }

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string, Object object) {
        this(eclipsePreferences, string);
        this.pluginReference = new WeakReference<Object>(object);
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        if (eclipsePreferences instanceof DefaultPreferences) {
            this.pluginReference = ((DefaultPreferences)eclipsePreferences).pluginReference;
        }
        String string2 = this.absolutePath();
        this.segmentCount = DefaultPreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = DefaultPreferences.getSegment(string2, 1);
    }

    private void applyBundleDefaults() {
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path("preferences.ini"), null);
        if (uRL == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL uRL2 = FileLocator.find((Bundle)bundle, (IPath)NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION), null);
        if (uRL2 == null && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(uRL), this.loadProperties(uRL2));
    }

    private void applyCommandLineDefaults() {
        if (commandLineCustomization == null) {
            String string = pluginCustomizationFile;
            if (string == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Command-line preferences customization file not specified.");
                }
                return;
            }
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Using command-line preference customization file: " + string);
            }
            commandLineCustomization = this.loadProperties(string);
        }
        this.applyDefaults(null, commandLineCustomization, null);
    }

    private void applyDefaults(String string, Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            Path path = new Path(string2);
            String string4 = path.lastSegment();
            path = path.removeLastSegments(1);
            String string5 = string;
            if (string == null) {
                string5 = path.segment(0);
                path = path.removeFirstSegments(1);
            }
            if (!this.name().equals(string5)) continue;
            string3 = this.translatePreference(string3, properties2);
            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting default preference: " + new Path(this.absolutePath()).append((IPath)path).append(string4) + '=' + string3);
            }
            ((EclipsePreferences)this.internalNode(path.toString(), false, null)).internalPut(string4, string3);
        }
    }

    public IEclipsePreferences node(String string, Object object) {
        return this.internalNode(string, true, object);
    }

    private void applyRuntimeDefaults() {
        WeakReference weakReference = PreferencesService.getDefault().applyRuntimeDefaults(this.name(), this.pluginReference);
        if (weakReference != null) {
            this.pluginReference = weakReference;
        }
    }

    private void applyProductDefaults() {
        if (productCustomization == null) {
            BundleContext bundleContext = Activator.getContext();
            if (bundleContext != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.internal.preferences.exchange.IProductPreferencesService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
                serviceTracker.open();
                IProductPreferencesService iProductPreferencesService = (IProductPreferencesService)serviceTracker.getService();
                if (iProductPreferencesService != null) {
                    productCustomization = iProductPreferencesService.getProductCustomization();
                    productTranslation = iProductPreferencesService.getProductTranslation();
                }
                serviceTracker.close();
            } else {
                PrefsMessages.message("Product-specified preferences called before plugin is started");
            }
            if (productCustomization == null) {
                productCustomization = new Properties();
            }
        }
        if (!productCustomization.isEmpty()) {
            this.applyDefaults(null, productCustomization, productTranslation);
        }
    }

    public void flush() {
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences eclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = eclipsePreferences;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new DefaultPreferences(eclipsePreferences, string, object);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void load() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.applyRuntimeDefaults();
        this.applyBundleDefaults();
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(URL var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 89->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private String translatePreference(String string, Properties properties) {
        string = string.trim();
        if (properties == null || string.startsWith(KEY_DOUBLE_PREFIX)) {
            return string;
        }
        if (string.startsWith(KEY_PREFIX)) {
            int n = string.indexOf(" ");
            String string2 = n == -1 ? string.substring(1) : string.substring(1, n);
            String string3 = n == -1 ? string : string.substring(n + 1);
            return properties.getProperty(string2, string3);
        }
        return string;
    }
}

