/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static /* synthetic */ Class class$0;

    public EclipseCommandProvider(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        return ((Object)stringBuffer).toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String string) {
        try {
            long l = Long.parseLong(string);
            return state.getBundle(l);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] bundleDescriptionArray = state.getBundles(string);
            if (bundleDescriptionArray.length > 0) {
                return bundleDescriptionArray[0];
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _diag(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference serviceReference;
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
            commandInterpreter.print("  ");
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
            if (platformAdmin == null) {
                Object var10_5 = null;
                this.context.ungetService(serviceReference);
                return;
            }
            State state = platformAdmin.getState(false);
            block5: while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                commandInterpreter.println(String.valueOf(bundleDescription.getLocation()) + " [" + bundleDescription.getBundleId() + "]");
                VersionConstraint[] versionConstraintArray = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDescription);
                ResolverError[] resolverErrorArray = platformAdmin.getState(false).getResolverErrors(bundleDescription);
                int n = 0;
                while (true) {
                    if (n >= resolverErrorArray.length) break;
                    if ((resolverErrorArray[n].getType() & 0x8007) == 0) {
                        commandInterpreter.print("  ");
                        commandInterpreter.println(resolverErrorArray[n].toString());
                    }
                    ++n;
                }
                n = 0;
                while (true) {
                    if (n >= versionConstraintArray.length) {
                        if (versionConstraintArray.length == 0 && resolverErrorArray.length == 0) {
                            commandInterpreter.print("  ");
                            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                        }
                        string = commandInterpreter.nextArgument();
                        continue block5;
                    }
                    commandInterpreter.print("  ");
                    commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray[n]));
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        Object var10_7 = null;
        this.context.ungetService(serviceReference);
    }
}

