/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.StateWriter;
import org.eclipse.osgi.internal.resolver.SystemState;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class StateObjectFactoryImpl
implements StateObjectFactory {
    public BundleDescription createBundleDescription(Dictionary dictionary, String string, long l) throws BundleException {
        return this.createBundleDescription(null, dictionary, string, l);
    }

    public BundleDescription createBundleDescription(State state, Dictionary dictionary, String string, long l) throws BundleException {
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)StateBuilder.createBundleDescription((StateImpl)state, dictionary, string);
        bundleDescriptionImpl.setBundleId(l);
        return bundleDescriptionImpl;
    }

    public BundleDescription createBundleDescription(long l, String string, Version version, String string2, BundleSpecification[] bundleSpecificationArray, HostSpecification hostSpecification, ImportPackageSpecification[] importPackageSpecificationArray, ExportPackageDescription[] exportPackageDescriptionArray, String[] stringArray, boolean bl) {
        return this.createBundleDescription(l, string, version, string2, bundleSpecificationArray, hostSpecification, importPackageSpecificationArray, exportPackageDescriptionArray, stringArray, bl, true, true, null, null, null, null);
    }

    public BundleDescription createBundleDescription(long l, String string, Version version, String string2, BundleSpecification[] bundleSpecificationArray, HostSpecification hostSpecification, ImportPackageSpecification[] importPackageSpecificationArray, ExportPackageDescription[] exportPackageDescriptionArray, String[] stringArray, boolean bl, boolean bl2, boolean bl3, String string3, String string4, GenericSpecification[] genericSpecificationArray, GenericDescription[] genericDescriptionArray) {
        return this.createBundleDescription(l, string, version, string2, bundleSpecificationArray, hostSpecification, importPackageSpecificationArray, exportPackageDescriptionArray, bl, bl2, bl3, string3, ManifestElement.getArrayFromList(string4), genericSpecificationArray, genericDescriptionArray);
    }

    public BundleDescription createBundleDescription(long l, String string, Version version, String string2, BundleSpecification[] bundleSpecificationArray, HostSpecification hostSpecification, ImportPackageSpecification[] importPackageSpecificationArray, ExportPackageDescription[] exportPackageDescriptionArray, boolean bl, boolean bl2, boolean bl3, String string3, String[] stringArray, GenericSpecification[] genericSpecificationArray, GenericDescription[] genericDescriptionArray) {
        BundleDescriptionImpl bundleDescriptionImpl = new BundleDescriptionImpl();
        bundleDescriptionImpl.setBundleId(l);
        bundleDescriptionImpl.setSymbolicName(string);
        bundleDescriptionImpl.setVersion(version);
        bundleDescriptionImpl.setLocation(string2);
        bundleDescriptionImpl.setRequiredBundles(bundleSpecificationArray);
        bundleDescriptionImpl.setHost(hostSpecification);
        bundleDescriptionImpl.setImportPackages(importPackageSpecificationArray);
        bundleDescriptionImpl.setExportPackages(exportPackageDescriptionArray);
        bundleDescriptionImpl.setStateBit(2, bl);
        bundleDescriptionImpl.setStateBit(64, bl2);
        bundleDescriptionImpl.setStateBit(128, bl3);
        bundleDescriptionImpl.setPlatformFilter(string3);
        bundleDescriptionImpl.setExecutionEnvironments(stringArray);
        bundleDescriptionImpl.setGenericRequires(genericSpecificationArray);
        bundleDescriptionImpl.setGenericCapabilities(genericDescriptionArray);
        return bundleDescriptionImpl;
    }

    public BundleDescription createBundleDescription(BundleDescription bundleDescription) {
        BundleDescriptionImpl bundleDescriptionImpl = new BundleDescriptionImpl();
        bundleDescriptionImpl.setBundleId(bundleDescription.getBundleId());
        bundleDescriptionImpl.setSymbolicName(bundleDescription.getSymbolicName());
        bundleDescriptionImpl.setVersion(bundleDescription.getVersion());
        bundleDescriptionImpl.setLocation(bundleDescription.getLocation());
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        BundleSpecification[] bundleSpecificationArray2 = new BundleSpecification[bundleSpecificationArray.length];
        int n = 0;
        while (n < bundleSpecificationArray2.length) {
            bundleSpecificationArray2[n] = this.createBundleSpecification(bundleSpecificationArray[n]);
            ++n;
        }
        bundleDescriptionImpl.setRequiredBundles(bundleSpecificationArray2);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        ExportPackageDescription[] exportPackageDescriptionArray2 = new ExportPackageDescription[exportPackageDescriptionArray.length];
        int n2 = 0;
        while (n2 < exportPackageDescriptionArray2.length) {
            exportPackageDescriptionArray2[n2] = this.createExportPackageDescription(exportPackageDescriptionArray[n2]);
            ++n2;
        }
        bundleDescriptionImpl.setExportPackages(exportPackageDescriptionArray2);
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        ImportPackageSpecification[] importPackageSpecificationArray2 = new ImportPackageSpecification[importPackageSpecificationArray.length];
        int n3 = 0;
        while (n3 < importPackageSpecificationArray2.length) {
            importPackageSpecificationArray2[n3] = this.createImportPackageSpecification(importPackageSpecificationArray[n3]);
            ++n3;
        }
        bundleDescriptionImpl.setImportPackages(importPackageSpecificationArray2);
        if (bundleDescription.getHost() != null) {
            bundleDescriptionImpl.setHost(this.createHostSpecification(bundleDescription.getHost()));
        }
        bundleDescriptionImpl.setStateBit(2, bundleDescription.isSingleton());
        bundleDescriptionImpl.setStateBit(64, bundleDescription.attachFragments());
        bundleDescriptionImpl.setStateBit(128, bundleDescription.dynamicFragments());
        bundleDescriptionImpl.setStateBit(32, bundleDescription.hasDynamicImports());
        bundleDescriptionImpl.setPlatformFilter(bundleDescription.getPlatformFilter());
        bundleDescriptionImpl.setExecutionEnvironments(bundleDescription.getExecutionEnvironments());
        bundleDescriptionImpl.setGenericCapabilities(this.createGenericCapabilities(bundleDescription.getGenericCapabilities()));
        bundleDescriptionImpl.setGenericRequires(this.createGenericRequires(bundleDescription.getGenericRequires()));
        return bundleDescriptionImpl;
    }

    private GenericDescription[] createGenericCapabilities(GenericDescription[] genericDescriptionArray) {
        if (genericDescriptionArray == null || genericDescriptionArray.length == 0) {
            return null;
        }
        GenericDescription[] genericDescriptionArray2 = new GenericDescription[genericDescriptionArray.length];
        int n = 0;
        while (n < genericDescriptionArray.length) {
            GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
            genericDescriptionImpl.setName(genericDescriptionArray[n].getName());
            genericDescriptionImpl.setVersion(genericDescriptionArray[n].getVersion());
            genericDescriptionImpl.setAttributes(genericDescriptionArray[n].getAttributes());
            genericDescriptionArray2[n] = genericDescriptionImpl;
            ++n;
        }
        return genericDescriptionArray2;
    }

    private GenericSpecification[] createGenericRequires(GenericSpecification[] genericSpecificationArray) {
        if (genericSpecificationArray == null || genericSpecificationArray.length == 0) {
            return null;
        }
        GenericSpecification[] genericSpecificationArray2 = new GenericSpecification[genericSpecificationArray.length];
        int n = 0;
        while (n < genericSpecificationArray.length) {
            GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
            genericSpecificationImpl.setName(genericSpecificationArray[n].getName());
            try {
                genericSpecificationImpl.setMatchingFilter(genericSpecificationArray[n].getMatchingFilter());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            genericSpecificationArray2[n] = genericSpecificationImpl;
            ++n;
        }
        return genericSpecificationArray2;
    }

    public BundleSpecification createBundleSpecification(String string, VersionRange versionRange, boolean bl, boolean bl2) {
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        bundleSpecificationImpl.setName(string);
        bundleSpecificationImpl.setVersionRange(versionRange);
        bundleSpecificationImpl.setExported(bl);
        bundleSpecificationImpl.setOptional(bl2);
        return bundleSpecificationImpl;
    }

    public BundleSpecification createBundleSpecification(BundleSpecification bundleSpecification) {
        BundleSpecificationImpl bundleSpecificationImpl = new BundleSpecificationImpl();
        bundleSpecificationImpl.setName(bundleSpecification.getName());
        bundleSpecificationImpl.setVersionRange(bundleSpecification.getVersionRange());
        bundleSpecificationImpl.setExported(bundleSpecification.isExported());
        bundleSpecificationImpl.setOptional(bundleSpecification.isOptional());
        return bundleSpecificationImpl;
    }

    public HostSpecification createHostSpecification(String string, VersionRange versionRange) {
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        hostSpecificationImpl.setName(string);
        hostSpecificationImpl.setVersionRange(versionRange);
        return hostSpecificationImpl;
    }

    public HostSpecification createHostSpecification(HostSpecification hostSpecification) {
        HostSpecificationImpl hostSpecificationImpl = new HostSpecificationImpl();
        hostSpecificationImpl.setName(hostSpecification.getName());
        hostSpecificationImpl.setVersionRange(hostSpecification.getVersionRange());
        return hostSpecificationImpl;
    }

    public ImportPackageSpecification createImportPackageSpecification(String string, VersionRange versionRange, String string2, VersionRange versionRange2, Map map, Map map2, BundleDescription bundleDescription) {
        ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
        importPackageSpecificationImpl.setName(string);
        importPackageSpecificationImpl.setVersionRange(versionRange);
        importPackageSpecificationImpl.setBundleSymbolicName(string2);
        importPackageSpecificationImpl.setBundleVersionRange(versionRange2);
        importPackageSpecificationImpl.setDirectives(map);
        importPackageSpecificationImpl.setAttributes(map2);
        importPackageSpecificationImpl.setBundle(bundleDescription);
        return importPackageSpecificationImpl;
    }

    public ImportPackageSpecification createImportPackageSpecification(ImportPackageSpecification importPackageSpecification) {
        ImportPackageSpecificationImpl importPackageSpecificationImpl = new ImportPackageSpecificationImpl();
        importPackageSpecificationImpl.setName(importPackageSpecification.getName());
        importPackageSpecificationImpl.setVersionRange(importPackageSpecification.getVersionRange());
        importPackageSpecificationImpl.setBundleSymbolicName(importPackageSpecification.getBundleSymbolicName());
        importPackageSpecificationImpl.setBundleVersionRange(importPackageSpecification.getBundleVersionRange());
        importPackageSpecificationImpl.setDirectives(importPackageSpecification.getDirectives());
        importPackageSpecificationImpl.setAttributes(importPackageSpecification.getAttributes());
        return importPackageSpecificationImpl;
    }

    public ExportPackageDescription createExportPackageDescription(ExportPackageDescription exportPackageDescription) {
        return this.createExportPackageDescription(exportPackageDescription.getName(), exportPackageDescription.getVersion(), exportPackageDescription.getDirectives(), exportPackageDescription.getAttributes(), exportPackageDescription.isRoot(), null);
    }

    public ExportPackageDescription createExportPackageDescription(String string, Version version, Map map, Map map2, boolean bl, BundleDescription bundleDescription) {
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl();
        exportPackageDescriptionImpl.setName(string);
        exportPackageDescriptionImpl.setVersion(version);
        exportPackageDescriptionImpl.setDirectives(map);
        exportPackageDescriptionImpl.setAttributes(map2);
        exportPackageDescriptionImpl.setRoot(bl);
        exportPackageDescriptionImpl.setExporter(bundleDescription);
        return exportPackageDescriptionImpl;
    }

    public GenericDescription createGenericDescription(String string, String string2, Version version, Map map) {
        Object var6_6;
        GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl();
        genericDescriptionImpl.setName(string);
        genericDescriptionImpl.setType(string2);
        genericDescriptionImpl.setVersion(version);
        Object v0 = var6_6 = map == null ? null : map.remove("version");
        if (var6_6 instanceof Version) {
            genericDescriptionImpl.setVersion(var6_6);
        }
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ((Dictionary)hashtable).put(k, map.get(k));
            }
        }
        genericDescriptionImpl.setAttributes(hashtable);
        return genericDescriptionImpl;
    }

    public GenericSpecification createGenericSpecification(String string, String string2, String string3, boolean bl, boolean bl2) throws InvalidSyntaxException {
        GenericSpecificationImpl genericSpecificationImpl = new GenericSpecificationImpl();
        genericSpecificationImpl.setName(string);
        genericSpecificationImpl.setType(string2);
        genericSpecificationImpl.setMatchingFilter(string3);
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        genericSpecificationImpl.setResolution(n);
        return genericSpecificationImpl;
    }

    public SystemState createSystemState() {
        SystemState systemState = new SystemState();
        systemState.setFactory(this);
        return systemState;
    }

    public State createState() {
        return this.internalCreateState();
    }

    public State createState(boolean bl) {
        StateImpl stateImpl = this.internalCreateState();
        if (bl) {
            stateImpl.setResolver(new ResolverImpl(null, false));
        }
        return stateImpl;
    }

    public State createState(State state) {
        StateImpl stateImpl = this.internalCreateState();
        stateImpl.setTimeStamp(state.getTimeStamp());
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            stateImpl.basicAddBundle(this.createBundleDescription(bundleDescriptionArray[n]));
            ++n;
        }
        stateImpl.setResolved(false);
        stateImpl.setPlatformProperties(state.getPlatformProperties());
        return stateImpl;
    }

    private StateImpl internalCreateState() {
        UserState userState = new UserState();
        userState.setFactory(this);
        return userState;
    }

    public SystemState readSystemState(File file, File file2, boolean bl, long l) throws IOException {
        StateReader stateReader = new StateReader(file, file2, bl);
        SystemState systemState = new SystemState();
        systemState.setReader(stateReader);
        systemState.setFactory(this);
        if (!stateReader.loadState(systemState, l)) {
            return null;
        }
        return systemState;
    }

    public State readState(InputStream inputStream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), new DataInputStream(inputStream), -1L);
    }

    public State readState(DataInputStream dataInputStream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), dataInputStream, -1L);
    }

    public State readState(File file) throws IOException {
        return this.internalReadState(this.internalCreateState(), file, -1L);
    }

    private State internalReadStateDeprecated(StateImpl stateImpl, DataInputStream dataInputStream, long l) throws IOException {
        StateReader stateReader = new StateReader();
        if (!stateReader.loadStateDeprecated(stateImpl, dataInputStream, l)) {
            return null;
        }
        return stateImpl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State internalReadState(StateImpl stateImpl, File file, long l) throws IOException {
        Object object;
        File file2 = new File(file, ".state");
        File file3 = new File(file, ".lazy");
        if (!file2.exists() || !file3.exists()) {
            object = new StorageManager(file, "none", true);
            try {
                ((StorageManager)object).open(true);
                File file4 = ((StorageManager)object).lookup(".state", false);
                File file5 = ((StorageManager)object).lookup(".lazy", false);
                if (file4 != null && file5 != null) {
                    file2 = file4;
                    file3 = file5;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ((StorageManager)object).close();
                throw throwable;
            }
            {
                Object var10_11 = null;
                ((StorageManager)object).close();
            }
        }
        if (!((StateReader)(object = new StateReader(file2, file3, false))).loadState(stateImpl, l)) {
            return null;
        }
        return stateImpl;
    }

    public void writeState(State state, DataOutputStream dataOutputStream) throws IOException {
        this.internalWriteStateDeprecated(state, dataOutputStream);
    }

    public void writeState(State state, File file) throws IOException {
        if (file == null) {
            throw new IOException();
        }
        StateWriter stateWriter = new StateWriter();
        File file2 = new File(file, ".state");
        File file3 = new File(file, ".lazy");
        stateWriter.saveState((StateImpl)state, file2, file3);
    }

    public void writeState(State state, OutputStream outputStream) throws IOException {
        this.internalWriteStateDeprecated(state, new DataOutputStream(outputStream));
    }

    public void writeState(State state, File file, File file2) throws IOException {
        StateWriter stateWriter = new StateWriter();
        stateWriter.saveState((StateImpl)state, file, file2);
    }

    public void internalWriteStateDeprecated(State state, DataOutputStream dataOutputStream) throws IOException {
        if (state.getFactory() != this) {
            throw new IllegalArgumentException();
        }
        StateWriter stateWriter = new StateWriter();
        stateWriter.saveStateDeprecated((StateImpl)state, dataOutputStream);
    }
}

