/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ListView;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.Screen;
import org.eclipse.ercp.swt.samples.eswtdemo.Demo;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MainMenu
implements SelectionListener,
DisposeListener,
ControlListener {
    private ListView list;
    private Vector showCases;
    private Composite parent;
    private boolean hasDirectSelect;
    private Composite background;
    Command commandExit;
    Command commandLaunch;

    public MainMenu(Composite composite, Vector vector) {
        composite.setLayout(null);
        MobileDevice mobileDevice = MobileDevice.getMobileDevice();
        Screen[] screenArray = mobileDevice.getScreens();
        this.hasDirectSelect = screenArray[0].isTouchScreen();
        int n = composite.getSize().x > composite.getSize().y ? 256 : 512;
        this.list = new ListView(composite, 4 | n);
        this.list.setSize(composite.getSize());
        composite.addControlListener((ControlListener)this);
        this.parent = composite;
        this.showCases = vector;
        int n2 = 0;
        while (n2 < vector.size()) {
            ShowCase showCase = (ShowCase)vector.get(n2);
            this.list.add(showCase.getName(), null);
            ++n2;
        }
        this.commandLaunch = new Command((Control)this.list, 2, 3);
        this.commandLaunch.setText(Messages.getString("MainMenu.0"));
        this.commandLaunch.addSelectionListener((SelectionListener)this);
        this.commandLaunch.setDefaultCommand();
        if (!Demo.bWorkbenchMode && composite != composite.getShell()) {
            this.commandExit = new Command((Control)this.list, 7, 2);
            this.commandExit.setText(Messages.getString("MainMenu.1"));
            this.commandExit.setLongLabel(Messages.getString("MainMenu.2"));
            this.commandExit.addSelectionListener((SelectionListener)this);
        }
        this.list.addSelectionListener((SelectionListener)this);
    }

    private void quit() {
        this.commandExit.dispose();
        this.commandLaunch.dispose();
        this.parent.dispose();
    }

    private void launch() {
        if (this.list.getSelectionCount() > 0) {
            this.background = new MyBackground(this.parent);
            this.background.addDisposeListener((DisposeListener)this);
            this.background.setBounds(this.parent.getClientArea());
            this.background.moveAbove(null);
            this.list.setVisible(false);
            int n = this.list.getSelectionIndices()[0];
            ShowCase showCase = (ShowCase)this.showCases.get(n);
            this.parent.getShell().setText(showCase.getName());
            showCase.show(this.background);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (!this.hasDirectSelect || selectionEvent.widget != this.list) {
            if (selectionEvent.widget == this.commandLaunch) {
                this.launch();
            } else if (selectionEvent.widget == this.commandExit) {
                this.quit();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.list) {
            this.launch();
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (disposeEvent.widget == this.background && this.parent.isVisible()) {
            this.parent.getShell().setText(Messages.getString("MainMenu.3"));
            this.list.setVisible(true);
            this.parent.getShell().redraw();
            this.list.forceFocus();
        }
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        if (!this.list.isDisposed()) {
            this.list.setBounds(this.parent.getClientArea());
        }
    }

    private static class MyBackground
    extends Composite
    implements ControlListener {
        public MyBackground(Composite composite) {
            super(composite, 0);
            composite.addControlListener((ControlListener)this);
        }

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            if (!this.isDisposed()) {
                this.setBounds(this.getParent().getClientArea());
            }
        }
    }
}

