/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class CompositeImageDescriptor
extends ImageDescriptor {
    private ImageData imageData;

    protected CompositeImageDescriptor() {
    }

    private static int alloc(RGB[] rGBArray, int n, int n2, int n3) {
        RGB rGB;
        int n4 = 1;
        while (n4 < rGBArray.length && (rGB = rGBArray[n4]) != null) {
            if (rGB.red == n && rGB.green == n2 && rGB.blue == n3) {
                return n4;
            }
            ++n4;
        }
        if (n4 < rGBArray.length - 1) {
            rGBArray[n4] = new RGB(n, n2, n3);
            return n4;
        }
        return 0;
    }

    protected abstract void drawCompositeImage(int var1, int var2);

    protected final void drawImage(ImageData imageData, int n, int n2) {
        RGB[] rGBArray = this.imageData.getRGBs();
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            ImageData imageData2 = imageData.getTransparencyMask();
            int n3 = 0;
            while (n3 < imageData.height) {
                int n4 = 0;
                while (n4 < imageData.width) {
                    if (imageData2.getPixel(n4, n3) != 0) {
                        int n5 = n4 + n;
                        int n6 = n3 + n2;
                        if (n5 >= 0 && n5 < this.imageData.width && n6 >= 0 && n6 < this.imageData.height) {
                            int n7 = imageData.getPixel(n4, n3);
                            int n8 = n7 & paletteData.redMask;
                            n8 = paletteData.redShift < 0 ? n8 >>> -paletteData.redShift : n8 << paletteData.redShift;
                            int n9 = n7 & paletteData.greenMask;
                            n9 = paletteData.greenShift < 0 ? n9 >>> -paletteData.greenShift : n9 << paletteData.greenShift;
                            int n10 = n7 & paletteData.blueMask;
                            n10 = paletteData.blueShift < 0 ? n10 >>> -paletteData.blueShift : n10 << paletteData.blueShift;
                            n7 = CompositeImageDescriptor.alloc(rGBArray, n8, n9, n10);
                            this.imageData.setPixel(n5, n6, n7);
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            return;
        }
        int[] nArray = new int[256];
        int n11 = 0;
        while (n11 < nArray.length) {
            nArray[n11] = -1;
            ++n11;
        }
        if (imageData.getTransparencyType() == 2) {
            ImageData imageData3 = imageData.getTransparencyMask();
            int n12 = 0;
            while (n12 < imageData.height) {
                int n13 = 0;
                while (n13 < imageData.width) {
                    if (imageData3.getPixel(n13, n12) != 0) {
                        int n14 = n13 + n;
                        int n15 = n12 + n2;
                        if (n14 >= 0 && n14 < this.imageData.width && n15 >= 0 && n15 < this.imageData.height) {
                            int n16 = imageData.getPixel(n13, n12);
                            int n17 = nArray[n16];
                            if (n17 < 0) {
                                RGB rGB = paletteData.getRGB(n16);
                                nArray[n16] = n17 = CompositeImageDescriptor.alloc(rGBArray, rGB.red, rGB.green, rGB.blue);
                            }
                            this.imageData.setPixel(n14, n15, n17);
                        }
                    }
                    ++n13;
                }
                ++n12;
            }
            return;
        }
        n11 = imageData.transparentPixel;
        int n18 = 0;
        while (n18 < imageData.height) {
            int n19 = 0;
            while (n19 < imageData.width) {
                int n20 = imageData.getPixel(n19, n18);
                if (n11 < 0 || n20 != n11) {
                    int n21 = n19 + n;
                    int n22 = n18 + n2;
                    if (n21 >= 0 && n21 < this.imageData.width && n22 >= 0 && n22 < this.imageData.height) {
                        int n23 = nArray[n20];
                        if (n23 < 0) {
                            RGB rGB = paletteData.getRGB(n20);
                            nArray[n20] = n23 = CompositeImageDescriptor.alloc(rGBArray, rGB.red, rGB.green, rGB.blue);
                        }
                        this.imageData.setPixel(n21, n22, n23);
                    }
                }
                ++n19;
            }
            ++n18;
        }
    }

    public ImageData getImageData() {
        Point point = this.getSize();
        RGB rGB = new RGB(0, 0, 0);
        RGB[] rGBArray = new RGB[256];
        rGBArray[0] = rGB;
        rGBArray[1] = rGB;
        PaletteData paletteData = new PaletteData(rGBArray);
        this.imageData = new ImageData(point.x, point.y, 8, paletteData);
        this.imageData.transparentPixel = 0;
        this.drawCompositeImage(point.x, point.y);
        int n = 0;
        while (n < rGBArray.length) {
            if (rGBArray[n] == null) {
                rGBArray[n] = rGB;
            }
            ++n;
        }
        return this.imageData;
    }

    protected abstract Point getSize();
}

