/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcValue;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Strings;

public class PlcVariable
extends PlcObject {
    public final String name;
    public final PlcType type;
    public final String address;
    public final PlcValue value;

    public PlcVariable(String name, PlcType type) {
        this(name, type, null, null);
    }

    public PlcVariable(String name, PlcType type, String address, PlcValue value) {
        this.name = name;
        this.type = type;
        this.address = address;
        this.value = value;
    }

    public Box toBox() {
        String addrTxt = this.address == null ? "" : Strings.fmt((String)" AT %s", (Object[])new Object[]{this.address});
        String valueTxt = this.value == null ? "" : Strings.fmt((String)" := %s", (Object[])new Object[]{this.value});
        String txt = Strings.fmt((String)"%s%s: %s%s;", (Object[])new Object[]{this.name, addrTxt, this.type, valueTxt});
        return new TextBox(txt);
    }
}

