/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.CoordObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.ListExpression;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.SliceExpression;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ListTypeID
extends CoordObjectTypeID {
    private String className;

    public ListTypeID(TypeID elmTid, CodeGeneratorContext ctxt) {
        super(TypeID.TypeKind.LIST, Lists.list((Object)elmTid));
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("ListType");
            ctxt.addTypeName(this, this.className);
            this.addSelf(ctxt);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        return "list " + ((TypeID)Lists.first((List)this.subTypes)).getTypeText();
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    @Override
    public void assignInitialValue(String name, Type tp, VBox box, CodeGeneratorContext ctxt, JavaFile currentfile) {
        Expression initialLength;
        if (tp == null) {
            initialLength = null;
        } else {
            ListType ltp = (ListType)tp;
            initialLength = ltp.getInitialLength();
            tp = TypeIDCreation.dropTypeReferences(ltp.getElementType());
        }
        if (initialLength == null) {
            String line = Strings.fmt((String)"%s = new %s(chiCoordinator);", (Object[])new Object[]{name, this.className});
            box.add(line);
            return;
        }
        ExpressionBase lenExpr = ExpressionBase.convertExpression(initialLength, ctxt, currentfile);
        box.add(lenExpr.getCode());
        String locVar = ctxt.makeUniqueName("i");
        String line = Strings.fmt((String)"int %s = %s;", (Object[])new Object[]{locVar, lenExpr.getValue()});
        box.add(line);
        line = Strings.fmt((String)"%s = new %s(chiCoordinator, %s);", (Object[])new Object[]{name, this.className, locVar});
        box.add(line);
        line = Strings.fmt((String)"while (%s > 0) {", (Object[])new Object[]{locVar});
        box.add(line);
        VBox vb = new VBox(4);
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String locVal = ctxt.makeUniqueName("val");
        line = Strings.fmt((String)"%s %s;", (Object[])new Object[]{elmTid.getJavaType(), locVal});
        vb.add(line);
        elmTid.assignInitialValue(locVal, tp, vb, ctxt, currentfile);
        line = Strings.fmt((String)"%s.append(%s);", (Object[])new Object[]{name, locVal});
        vb.add(line);
        line = Strings.fmt((String)"%s--;", (Object[])new Object[]{locVar});
        vb.add(line);
        box.add((Box)vb);
        box.add("}");
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof ListExpression) {
            ListExpression le = (ListExpression)expr;
            String lstName = ctxt.makeUniqueName("lst");
            List lines = Lists.list();
            String clsName = this.getJavaClassType();
            String line = Strings.fmt((String)"%s %s = new %s(chiCoordinator, %d);", (Object[])new Object[]{clsName, lstName, clsName, le.getElements().size()});
            lines.add(line);
            for (Expression elm : le.getElements()) {
                ExpressionBase eb = ExpressionBase.convertExpression(elm, ctxt, currentFile);
                lines.addAll(eb.getCode());
                line = Strings.fmt((String)"%s.append(%s);", (Object[])new Object[]{lstName, eb.getValue()});
                lines.add(line);
            }
            return ExpressionBase.makeExpression(lines, lstName, (PositionObject)expr);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression se = (SliceExpression)expr;
            String lstName = ctxt.makeUniqueName("lst");
            List lines = Lists.list();
            String line = this.getJavaClassType();
            line = Strings.fmt((String)"%s %s = new %s(chiCoordinator);", (Object[])new Object[]{line, lstName, line});
            lines.add(line);
            ExpressionBase eb = ExpressionBase.convertExpression(se.getSource(), ctxt, currentFile);
            lines.addAll(eb.getCode());
            String srcName = ctxt.makeUniqueName("src");
            line = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{this.className, srcName, eb.getValue()});
            lines.add(line);
            String stepName = ctxt.makeUniqueName("step");
            if (se.getStep() == null) {
                line = Strings.fmt((String)"int %s = 1;", (Object[])new Object[]{stepName});
                lines.add(line);
            } else {
                eb = ExpressionBase.convertExpression(se.getStep(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                line = Strings.fmt((String)"int %s = %s;", (Object[])new Object[]{stepName, eb.getValue()});
                lines.add(line);
            }
            String startName = ctxt.makeUniqueName("start");
            if (se.getStart() == null) {
                line = Strings.fmt((String)"int %s = (%s >= 0) ? 0 : %s.size()-1;", (Object[])new Object[]{startName, stepName, srcName});
                lines.add(line);
            } else {
                eb = ExpressionBase.convertExpression(se.getStart(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                line = Strings.fmt((String)"int %s = %s;", (Object[])new Object[]{startName, eb.getValue()});
                lines.add(line);
                if (se.getStep() == null) {
                    line = Strings.fmt((String)"if (%s < 0) %s = %s.size() + %s;", (Object[])new Object[]{startName, startName, srcName, startName});
                    lines.add(line);
                }
            }
            String endName = ctxt.makeUniqueName("end");
            if (se.getEnd() == null) {
                line = Strings.fmt((String)"int %s = (%s >= 0) ? %s.size() : -1;", (Object[])new Object[]{endName, stepName, srcName});
                lines.add(line);
            } else {
                eb = ExpressionBase.convertExpression(se.getEnd(), ctxt, currentFile);
                lines.addAll(eb.getCode());
                line = Strings.fmt((String)"int %s = %s;", (Object[])new Object[]{endName, eb.getValue()});
                lines.add(line);
                if (se.getStep() == null) {
                    line = Strings.fmt((String)"if (%s < 0) %s = %s.size() + %s;", (Object[])new Object[]{endName, endName, srcName, endName});
                    lines.add(line);
                }
            }
            String elmType = ((TypeID)Lists.first((List)this.subTypes)).getJavaClassType();
            String iterVar = ctxt.makeUniqueName("iter");
            line = Strings.fmt((String)"Iterator<%s> %s = %s.iterator(%s, %s, %s);", (Object[])new Object[]{elmType, iterVar, srcName, startName, stepName, endName});
            lines.add(line);
            currentFile.addImport("java.util.Iterator", false);
            line = Strings.fmt((String)"while (%s.hasNext()) { %s.append(%s.next()); }", (Object[])new Object[]{iterVar, lstName, iterVar});
            lines.add(line);
            return ExpressionBase.makeExpression(lines, lstName, (PositionObject)expr);
        }
        if (expr instanceof BinaryExpression) {
            String text;
            BinaryExpression binexp = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexp.getLeft(), ctxt, currentFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexp.getRight(), ctxt, currentFile);
            switch (binexp.getOp()) {
                case ADDITION: {
                    text = Strings.fmt((String)"(%s).addList(%s)", (Object[])new Object[]{left.getValue(), right.getValue()});
                    break;
                }
                case SUBTRACTION: {
                    text = Strings.fmt((String)"(%s).subtractList(%s)", (Object[])new Object[]{left.getValue(), right.getValue()});
                    break;
                }
                case PROJECTION: {
                    text = Strings.fmt((String)"(%s).get(%s)", (Object[])new Object[]{left.getValue(), right.getValue()});
                    break;
                }
                case ELEMENT_TEST: {
                    text = Strings.fmt((String)"(%s).contains(%s)", (Object[])new Object[]{right.getValue(), left.getValue()});
                    break;
                }
                default: {
                    Assert.fail((String)("Unimplemented binary list operator " + expr.toString()));
                    return null;
                }
            }
            if (!left.getCode().isEmpty() || !right.getCode().isEmpty()) {
                List lines = Lists.list();
                lines.addAll(left.getCode());
                lines.addAll(right.getCode());
                return new CodeExpression(lines, text, (PositionObject)expr);
            }
            return new SimpleExpression(text, (PositionObject)expr);
        }
        Assert.fail((String)("Implement " + expr.toString() + " in ListTypeID.convertExprNode"));
        return null;
    }

    private void addSelf(CodeGeneratorContext ctxt) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmClassname = elmTid.getJavaClassType();
        String base = "IndexableDeque<" + elmClassname + ">";
        JavaClass cls = new JavaClass("", false, this.className, base, null);
        cls.addImport("org.eclipse.escet.chi.runtime.data.IndexableDeque", false);
        this.addConstructors(cls);
        this.addSizeSupportCode(cls);
        this.addListMethods(cls, ctxt);
        this.addReadWrite(cls);
        if (elmTid.isIntTypeID()) {
            this.addRangeFunctions(cls);
        }
        ctxt.addClass(cls);
    }

    private void addConstructors(JavaClass cls) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmClassname = elmTid.getJavaClassType();
        cls.addVariable("private static final int MAX_SUBTRACTLENGTH = 5;");
        cls.addVariable("private final ChiCoordinator chiCoordinator;");
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        JavaMethod jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator)");
        jm.lines.add("super();");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator, int sz)");
        jm.lines.add("super(sz);");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        boolean elmHasDeepcopy = elmTid.hasDeepCopy();
        jm = new JavaMethod("public " + this.className + "(" + this.className + " orig, boolean deepCopy)");
        jm.lines.add("super(orig.size());");
        jm.lines.add("this.chiCoordinator = orig.chiCoordinator;");
        jm.lines.add("for (%s val: orig) {", new Object[]{elmClassname});
        if (!elmHasDeepcopy) {
            jm.lines.add("    append(val);");
        } else {
            jm.lines.add("    append(deepCopy ? %s : val);", new Object[]{elmTid.getDeepCopyName("val", cls, true)});
        }
        jm.lines.add("}");
        cls.addMethod(jm);
    }

    private void addSizeSupportCode(JavaFile cls) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        JavaMethod jm = new JavaMethod("public " + this.className + " modify(int index, " + elmTypename + " newVal)");
        jm.lines.add(String.valueOf(this.className) + " result = new %s(this, false);", new Object[]{this.className});
        jm.lines.add("result.set(index, newVal);");
        jm.lines.add("return result;");
        cls.addMethod(jm);
    }

    private void addListMethods(JavaFile cls, CodeGeneratorContext ctxt) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        String elmClassname = elmTid.getJavaClassType();
        String elmSimpleValue = elmTid.getSimplestJavaValue();
        JavaMethod jm = new JavaMethod("public " + this.className + " subtractList(" + this.className + " sub)");
        jm.lines.add("int sz = sub.size();");
        jm.lines.add("// No elements to subtract -> trivially finished.");
        jm.lines.add("if (sz == 0) return this;");
        jm.lines.add();
        jm.lines.add("%s result = new %s(chiCoordinator, size() - sz / 2);", new Object[]{this.className, this.className});
        jm.lines.add();
        jm.lines.add("// Only a few elements to subtract.");
        jm.lines.add("if (sz < MAX_SUBTRACTLENGTH) {");
        jm.lines.add("    %s[] elms = new %s[MAX_SUBTRACTLENGTH];", new Object[]{elmClassname, elmClassname});
        jm.lines.add("    sub.copyToArray(elms);");
        jm.lines.add();
        jm.lines.add("    for (%s val: this) {", new Object[]{elmClassname});
        jm.lines.add("        int m = 0;");
        jm.lines.add("        while (m < sz && %s) m++;", new Object[]{elmTid.getUnequal("elms[m]", "val")});
        jm.lines.add("        if (m < sz) {");
        jm.lines.add("            // Found a match, remove the element and continue.");
        jm.lines.add("            sz--;");
        jm.lines.add("            if (m != sz) elms[m] = elms[sz];");
        jm.lines.add("            elms[sz] = %s;", new Object[]{elmSimpleValue});
        jm.lines.add("            continue;");
        jm.lines.add("        }");
        jm.lines.add("        // No match, copy the element.");
        jm.lines.add("        result.append(val);");
        jm.lines.add("    }");
        jm.lines.add("    return result;");
        jm.lines.add("}");
        jm.lines.add();
        jm.lines.add("// Many elements to subtract.");
        jm.lines.add("Map<%s, Integer> counts = new LinkedHashMap<%s, Integer>();", new Object[]{elmClassname, elmClassname});
        jm.lines.add("for (%s val: sub) {", new Object[]{elmClassname});
        jm.lines.add("    Integer cnt = counts.get(val);");
        jm.lines.add("    counts.put(val, ((cnt == null) ? 1 : cnt + 1));");
        jm.lines.add("}");
        jm.lines.add();
        jm.lines.add("for (%s val: this) {", new Object[]{elmClassname});
        jm.lines.add("     Integer cnt = counts.get(val);");
        jm.lines.add("     if (cnt == null || cnt <= 0) {");
        jm.lines.add("        result.append(val);");
        jm.lines.add("    } else {");
        jm.lines.add("        counts.put(val, cnt - 1);");
        jm.lines.add("    }");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("java.util.Map", false);
        cls.addImport("java.util.LinkedHashMap", false);
        jm = new JavaMethod("public " + this.className + " addList(" + this.className + " other)");
        jm.lines.add("if (isEmpty()) return other;");
        jm.lines.add();
        jm.lines.add("int sz = other.size();");
        jm.lines.add("if (sz == 0) return this;");
        jm.lines.add();
        jm.lines.add("%s result = new %s(chiCoordinator, size() + sz);", new Object[]{this.className, this.className});
        jm.lines.add("for (%s val: this) {", new Object[]{elmClassname});
        jm.lines.add("    result.append(val);");
        jm.lines.add("}");
        jm.lines.add("for (%s val: other) {", new Object[]{elmClassname});
        jm.lines.add("    result.append(val);");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        List fields = Lists.list((Object[])new String[]{"value", "list"});
        List tids = Lists.list((Object[])new TypeID[]{elmTid, this});
        TypeID tupleTid = TypeIDCreation.createTupleTypeID(fields, tids, ctxt);
        String tupName = tupleTid.getJavaClassType();
        jm = new JavaMethod("public " + tupName + " pop()");
        jm.lines.add(String.valueOf(tupName) + " res = new %s(chiCoordinator);", new Object[]{tupName});
        jm.lines.add("res.var1 = new %s(this, false);", new Object[]{this.className});
        jm.lines.add("res.var0 = res.var1.removeHead();");
        jm.lines.add("return res;");
        cls.addMethod(jm);
        List subs = Lists.list((Object[])new TypeID[]{elmTid, elmTid, TypeIDCreation.makeBooleanTypeID()});
        TypeID predTid = TypeIDCreation.makeFunctionTypeID(subs, ctxt);
        String predClassName = predTid.getJavaClassType();
        jm = new JavaMethod("public static " + this.className + " insert(" + this.className + " lst, " + elmTypename + " elm, " + predClassName + " pred)");
        jm.lines.add("lst = new %s(lst, false);", new Object[]{this.className});
        jm.lines.add("lst.insert(elm, pred);");
        jm.lines.add("return lst;");
        cls.addMethod(jm);
        jm = new JavaMethod("public static " + this.className + " sort(" + this.className + " lst, " + predClassName + " pred)");
        jm.lines.add("lst = new %s(lst, false);", new Object[]{this.className});
        jm.lines.add("try {");
        jm.lines.add("    lst.sort(pred);");
        jm.lines.add("} catch (IllegalArgumentException e) {");
        jm.lines.add("    throw new ChiSimulatorException(\"Sort predicate function does not define a proper element order.\", e);");
        jm.lines.add("}");
        jm.lines.add("return lst;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        jm = new JavaMethod("public static " + this.className + " removeElement(" + this.className + " lst, int idx)");
        jm.lines.add("lst = new %s(lst, false);", new Object[]{this.className});
        jm.lines.add("lst.remove(idx);");
        jm.lines.add("return lst;");
        cls.addMethod(jm);
        String smallestText = null;
        String biggestText = null;
        if (elmTid.kind == TypeID.TypeKind.INT || elmTid.kind == TypeID.TypeKind.REAL) {
            smallestText = "result > value";
            biggestText = "result < value";
        } else if (elmTid.kind == TypeID.TypeKind.STRING) {
            smallestText = "result.compareTo(value) > 0";
            biggestText = "result.compareTo(value) < 0";
        }
        if (smallestText != null) {
            jm = new JavaMethod("public " + elmTypename + " getMinimum()");
            jm.lines.add("%s result = null;", new Object[]{elmClassname});
            jm.lines.add("for (%s value: this) {", new Object[]{elmClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{smallestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a smallest value in an empty list.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
        if (biggestText != null) {
            jm = new JavaMethod("public " + elmTypename + " getMaximum()");
            jm.lines.add("%s result = null;", new Object[]{elmClassname});
            jm.lines.add("for (%s value: this) {", new Object[]{elmClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{biggestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a biggest value in an empty list.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
    }

    private void addReadWrite(JavaFile cls) {
        if (!this.isPrintable()) {
            return;
        }
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        String elmClassname = elmTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public static " + this.className + " read(ChiCoordinator chiCoordinator, ChiFileHandle stream)");
        jm.lines.add("%s result = new %s(chiCoordinator);", new Object[]{this.className, this.className});
        jm.lines.add();
        jm.lines.add("stream.expectCharacter('[');");
        jm.lines.add("for (;;) {");
        jm.lines.add("    %s elm = %s;", new Object[]{elmTypename, elmTid.getReadName("stream", cls)});
        jm.lines.add("    result.append(elm);");
        jm.lines.add("    int ch = stream.expectCharacter(',', ']');");
        jm.lines.add("    if (ch == ']') break;");
        jm.lines.add("    if (ch == ',') continue;");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public void write(ChiFileHandle stream)");
        jm.lines.add("stream.write(\"[\");");
        jm.lines.add("boolean first = true;");
        jm.lines.add("for (%s val: this) {", new Object[]{elmClassname});
        jm.lines.add("    if (!first) stream.write(\", \");");
        jm.lines.add("    first = false;");
        jm.lines.add("    " + elmTid.getWriteName("stream", "val", cls));
        jm.lines.add("}");
        jm.lines.add("stream.write(\"]\");");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        jm = new JavaMethod("public String toString()");
        jm.lines.add("ChiWriteMemoryFile mem = new ChiWriteMemoryFile();");
        jm.lines.add("write(mem);");
        jm.lines.add("return mem.getData();");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile", false);
    }

    private void addRangeFunctions(JavaFile cls) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        Assert.check((boolean)elmTid.isIntTypeID());
        String line = "public static " + this.className + " range(ChiCoordinator chiCoordinator, int end)";
        JavaMethod jm = new JavaMethod(line);
        jm.lines.add("return range(chiCoordinator, 0, end);");
        cls.addMethod(jm);
        line = "public static " + this.className + " range(ChiCoordinator chiCoordinator, int start, int end)";
        jm = new JavaMethod(line);
        jm.lines.add("return range(chiCoordinator, start, end, 1);");
        cls.addMethod(jm);
        line = "public static " + this.className + " range(ChiCoordinator chiCoordinator, int start, int end, int step)";
        jm = new JavaMethod(line);
        jm.lines.add("if (step == 0) {");
        jm.lines.add("    throw new ChiSimulatorException(\"Step size must be non-zero for range.\");");
        jm.lines.add("}");
        jm.lines.add();
        jm.lines.add("int length = 0;");
        jm.lines.add("if (step > 0) {");
        jm.lines.add("    if (end > start) length = (end - start + step - 1) / step;");
        jm.lines.add("} else {");
        jm.lines.add("    if (end < start) length = (end - start + step - 1) / step;");
        jm.lines.add("}");
        jm.lines.add("%s res = new %s(chiCoordinator, length);", new Object[]{this.className, this.className});
        jm.lines.add();
        jm.lines.add("if (step > 0) {");
        jm.lines.add("    while (start < end) {");
        jm.lines.add("        res.append(start);");
        jm.lines.add("        start += step;");
        jm.lines.add("    }");
        jm.lines.add("} else {");
        jm.lines.add("    while (start > end) {");
        jm.lines.add("        res.append(start);");
        jm.lines.add("        start += step;");
        jm.lines.add("    }");
        jm.lines.add("}");
        jm.lines.add("return res;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
    }
}

