/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Strings;

public abstract class TypeID {
    public final boolean needsCoordinator;
    public final TypeKind kind;
    public final List<TypeID> subTypes;
    private int hash;

    public TypeID(boolean needsCoordinator, TypeKind kind) {
        this(needsCoordinator, kind, Collections.EMPTY_LIST);
    }

    public TypeID(boolean needsCoordinator, TypeKind kind, List<TypeID> subTypes) {
        this.needsCoordinator = needsCoordinator;
        this.kind = kind;
        this.subTypes = subTypes;
        this.hash = this.computeHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeID)) {
            return false;
        }
        TypeID other = (TypeID)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return this.subTypes.equals(other.subTypes);
    }

    public int hashCode() {
        return this.hash;
    }

    private int computeHashCode() {
        int value = this.kind.hashCode();
        int n = 2;
        for (TypeID ti : this.subTypes) {
            value ^= n * ti.hashCode();
            ++n;
        }
        return value;
    }

    public abstract String getTypeText();

    public abstract String getJavaType();

    public abstract String getJavaClassType();

    public abstract boolean hasDeepCopy();

    public abstract String getDeepCopyName(String var1, JavaFile var2, boolean var3);

    public final boolean isPrintable() {
        if (!this.kind.printable) {
            return false;
        }
        for (TypeID tid : this.subTypes) {
            if (tid.isPrintable()) continue;
            return false;
        }
        return true;
    }

    public abstract String getReadName(String var1, JavaFile var2);

    public abstract String getWriteName(String var1, String var2, JavaFile var3);

    public abstract String getHashCodeName(String var1, JavaFile var2);

    public abstract String getToString(String var1, JavaFile var2);

    public abstract String getEqual(String var1, String var2);

    public abstract String getUnequal(String var1, String var2);

    protected abstract String getEmptyValue(JavaFile var1);

    public void assignInitialValue(String name, Type tp, VBox box, CodeGeneratorContext ctxt, JavaFile javaFile) {
        String line = Strings.fmt((String)"%s = %s;", (Object[])new Object[]{name, this.getEmptyValue(javaFile)});
        box.add(line);
    }

    public abstract String getSimplestJavaValue();

    public abstract ExpressionBase convertExprNode(Expression var1, CodeGeneratorContext var2, JavaFile var3);

    public final boolean isIntTypeID() {
        return this.kind == TypeKind.INT;
    }

    public static enum TypeKind {
        DICTIONARY(true),
        TIMER(false),
        FILE(false),
        ENUM(true),
        SET(true),
        BOOL(true),
        DISTRIBUTION(false),
        INT(true),
        STRING(true),
        REAL(true),
        INSTANCE(false),
        CHANNEL(false),
        SYNCHRONIZATION(false),
        PROCESS(false),
        FUNCTION(false),
        TUPLE(true),
        MATRIX(true),
        LIST(true);

        public final boolean printable;

        private TypeKind(boolean printable) {
            this.printable = printable;
        }
    }
}

