/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.interpreter;

import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.interpreter.ToolDefInterpreterApp;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;

public class ExecContext {
    public final ToolDefInterpreterApp interpreter;
    private final ExecContext parent;
    private Map<PositionObject, Object> valuation = null;

    public ExecContext(ToolDefInterpreterApp interpreter) {
        this.interpreter = interpreter;
        this.parent = null;
    }

    public ExecContext(ExecContext parent) {
        Assert.notNull((Object)parent);
        Assert.notNull((Object)((Object)parent.interpreter));
        this.interpreter = parent.interpreter;
        this.parent = parent;
    }

    public boolean isTerminationRequested() {
        return this.interpreter.isTerminationRequested();
    }

    public void addVariable(Variable var, Object value) {
        if (this.valuation == null) {
            this.valuation = Maps.map();
        }
        Assert.check((!this.valuation.containsKey(var) ? 1 : 0) != 0);
        this.valuation.put((PositionObject)var, value);
    }

    public void addToolParam(ToolParameter param, Object value) {
        if (this.valuation == null) {
            this.valuation = Maps.map();
        }
        Assert.check((!this.valuation.containsKey(param) ? 1 : 0) != 0);
        this.valuation.put((PositionObject)param, value);
    }

    public Object getValue(PositionObject obj) {
        if (this.valuation != null && this.valuation.containsKey(obj)) {
            return this.valuation.get(obj);
        }
        if (this.parent != null) {
            return this.parent.getValue(obj);
        }
        throw new RuntimeException("Variable or tool parameter not found: " + obj);
    }

    public void updateValue(PositionObject obj, Object value) {
        if (this.valuation != null && this.valuation.containsKey(obj)) {
            this.valuation.put(obj, value);
            return;
        }
        if (this.parent != null) {
            this.parent.updateValue(obj, value);
            return;
        }
        throw new RuntimeException("Variable or tool parameter not found: " + obj);
    }
}

