/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public abstract class IoFunctions {
    public static int readInt(ChiFileHandle input) {
        input.skipWhitespace();
        int kar = input.read();
        boolean seenNegate = false;
        while (kar == 43 || kar == 45) {
            if (kar == 45) {
                seenNegate = !seenNegate;
            }
            input.markStream();
            kar = input.read();
        }
        int value = 0;
        boolean seenDigit = false;
        while (kar >= 48 && kar <= 57) {
            value = value * 10 + kar - 48;
            seenDigit = true;
            input.markStream();
            kar = input.read();
        }
        input.resetStream();
        if (!seenDigit) {
            String msg = "Expected integer number but found no digits while reading input.";
            throw new ChiSimulatorException(msg);
        }
        return seenNegate ? -value : value;
    }

    public static void writeInt(ChiFileHandle output, int value) {
        output.write(String.valueOf(value));
    }

    public static boolean readBool(ChiFileHandle input) {
        input.skipWhitespace();
        input.markStream(5);
        int kar = input.read();
        if (kar == 116) {
            if (input.read() == 114 && input.read() == 117 && input.read() == 101) {
                return true;
            }
        } else if (kar == 102 && input.read() == 97 && input.read() == 108 && input.read() == 115 && input.read() == 101) {
            return false;
        }
        input.resetStream();
        String msg = "Expected boolean literal (true or false) but found other text while reading input.";
        throw new ChiSimulatorException(msg);
    }

    public static void writeBool(ChiFileHandle output, boolean value) {
        output.write(String.valueOf(value));
    }

    public static double readReal(ChiFileHandle input) {
        input.skipWhitespace();
        int state = 1;
        String txt = "";
        block12: while (true) {
            if (state == 3 || state == 4 || state == 7 || state == 8 || state == 10) {
                input.markStream();
            }
            int k = input.read();
            switch (state) {
                case 1: {
                    if (k == 48) {
                        state = 3;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k == 43 || k == 45) {
                        state = 2;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k < 49 || k > 57) break block12;
                    state = 4;
                    txt = String.valueOf(txt) + Character.toString((char)k);
                    continue block12;
                }
                case 2: {
                    if (k == 48) {
                        state = 3;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k < 49 || k > 57) break block12;
                    state = 4;
                    txt = String.valueOf(txt) + Character.toString((char)k);
                    continue block12;
                }
                case 3: {
                    if (k == 46) {
                        state = 5;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k == 69 || k == 101) {
                        state = 6;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    input.resetStream();
                    return Double.parseDouble(txt);
                }
                case 4: {
                    if (k >= 48 && k <= 57) {
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k == 46) {
                        state = 5;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k == 69 || k == 101) {
                        state = 6;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    input.resetStream();
                    return Double.parseDouble(txt);
                }
                case 5: {
                    if (k < 48 || k > 57) break block12;
                    state = 7;
                    txt = String.valueOf(txt) + Character.toString((char)k);
                    continue block12;
                }
                case 6: {
                    if (k == 43 || k == 45) {
                        state = 9;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k == 48) {
                        state = 10;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k < 49 || k > 57) break block12;
                    state = 8;
                    txt = String.valueOf(txt) + Character.toString((char)k);
                    continue block12;
                }
                case 7: {
                    if (k == 69 || k == 101) {
                        state = 6;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k >= 48 && k <= 57) {
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    input.resetStream();
                    return Double.parseDouble(txt);
                }
                case 8: {
                    if (k >= 48 && k <= 57) {
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    input.resetStream();
                    return Double.parseDouble(txt);
                }
                case 9: {
                    if (k >= 49 && k <= 57) {
                        state = 8;
                        txt = String.valueOf(txt) + Character.toString((char)k);
                        continue block12;
                    }
                    if (k != 48) break block12;
                    state = 10;
                    txt = String.valueOf(txt) + Character.toString((char)k);
                    continue block12;
                }
                case 10: {
                    input.resetStream();
                    return Double.parseDouble(txt);
                }
                default: {
                    Assert.fail((String)"Unexpected state reached in readReal.");
                }
            }
            break;
        }
        String msg = "Expected a real number but did not find one while reading input.";
        throw new ChiSimulatorException(msg);
    }

    public static void writeReal(ChiFileHandle output, double value) {
        output.write(Strings.fmt((String)"%s", (Object[])new Object[]{value}));
    }

    public static String readString(ChiFileHandle input) {
        int state = 1;
        String txt = "";
        while (true) {
            if (state == 3) {
                input.markStream();
            }
            int k = input.read();
            if (state == 1 && (k == 32 || k == 9 || k == 13 || k == 10)) continue;
            if (state == 1 && k == 34) {
                state = 2;
                continue;
            }
            if (state == 1) {
                state = 3;
                txt = String.valueOf(txt) + Character.toString((char)k);
                continue;
            }
            if (state == 2 && k == 92) {
                state = 4;
                continue;
            }
            if (state == 2 && k == 34) {
                return txt;
            }
            if (state == 2 && k != -1) {
                txt = String.valueOf(txt) + Character.toString((char)k);
                continue;
            }
            if (state == 3 && k != -1 && k != 32 && k != 9 && k != 13 && k != 10) {
                txt = String.valueOf(txt) + Character.toString((char)k);
                continue;
            }
            if (state != 4) break;
            if (k == 92 || k == 34) {
                state = 2;
                txt = String.valueOf(txt) + Character.toString((char)k);
                continue;
            }
            if (k == 116) {
                state = 2;
                txt = String.valueOf(txt) + "\t";
                continue;
            }
            if (k != 110) break;
            state = 2;
            txt = String.valueOf(txt) + "\n";
        }
        if (state == 2) {
            String msg = "Encountered end-of-file while reading a string literal, perhaps a closing quote is missing.";
            throw new ChiSimulatorException(msg);
        }
        if (state != 3) {
            String msg = "Missing string literal but found something else while reading input.";
            throw new ChiSimulatorException(msg);
        }
        input.resetStream();
        return txt;
    }

    public static void writeString(ChiFileHandle output, String value) {
        output.write(value);
    }
}

