/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.position.common;

import java.util.Objects;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionFactory;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PositionUtils {
    private PositionUtils() {
    }

    public static Position createDummy(String location) {
        return PositionUtils.createDummy(location, null);
    }

    public static Position createDummy(String location, String src) {
        Position pos = PositionFactory.eINSTANCE.createPosition();
        pos.setSource(src);
        pos.setLocation(location);
        pos.setStartLine(1);
        pos.setEndLine(1);
        pos.setStartColumn(1);
        pos.setEndColumn(1);
        pos.setStartOffset(0);
        pos.setEndOffset(0);
        return pos;
    }

    public static Position copyPosition(PositionObject obj) {
        return PositionUtils.copyPosition(obj.getPosition());
    }

    public static Position copyPosition(Position pos) {
        if (pos == null) {
            return pos;
        }
        Position pos2 = PositionFactory.eINSTANCE.createPosition();
        pos2.setSource(pos.getSource());
        pos2.setLocation(pos.getLocation());
        pos2.setStartLine(pos.getStartLine());
        pos2.setEndLine(pos.getEndLine());
        pos2.setStartColumn(pos.getStartColumn());
        pos2.setEndColumn(pos.getEndColumn());
        pos2.setStartOffset(pos.getStartOffset());
        pos2.setEndOffset(pos.getEndOffset());
        return pos2;
    }

    public static String pos2str(PositionObject obj) {
        Position pos = obj.getPosition();
        if (pos == null) {
            return "<no-position-available>";
        }
        return PositionUtils.pos2str(pos);
    }

    public static String pos2str(Position position) {
        StringBuilder txt = new StringBuilder();
        if (position.getSource() != null) {
            txt.append(position.getSource());
        }
        if (position.getStartLine() == position.getEndLine()) {
            txt.append(Strings.fmt((String)"line %d", (Object[])new Object[]{position.getStartLine()}));
            if (position.getStartColumn() == position.getEndColumn()) {
                txt.append(Strings.fmt((String)", column %d", (Object[])new Object[]{position.getStartColumn()}));
            } else {
                txt.append(Strings.fmt((String)", columns %d .. %d", (Object[])new Object[]{position.getStartColumn(), position.getEndColumn()}));
            }
        } else {
            txt.append(Strings.fmt((String)"line %d column %d .. line %d column %d", (Object[])new Object[]{position.getStartLine(), position.getStartColumn(), position.getEndLine(), position.getEndColumn()}));
        }
        return txt.toString();
    }

    public static Position mergePositions(Position p1, Position p2) {
        Assert.notNull((Object)p1);
        Assert.notNull((Object)p2);
        Assert.check((p1.getSource() == null == (p2.getSource() == null) ? 1 : 0) != 0);
        if (p1.getSource() != null && p2.getSource() != null) {
            Assert.check((boolean)p1.getSource().equals(p2.getSource()));
        }
        Assert.check((boolean)p1.getLocation().equals(p2.getLocation()));
        Position p = PositionFactory.eINSTANCE.createPosition();
        p.setSource(p1.getSource());
        p.setLocation(p1.getLocation());
        if (p1.getStartOffset() < p2.getStartOffset()) {
            p.setStartOffset(p1.getStartOffset());
            p.setStartLine(p1.getStartLine());
            p.setStartColumn(p1.getStartColumn());
        } else {
            p.setStartOffset(p2.getStartOffset());
            p.setStartLine(p2.getStartLine());
            p.setStartColumn(p2.getStartColumn());
        }
        if (p1.getEndOffset() > p2.getEndOffset()) {
            p.setEndOffset(p1.getEndOffset());
            p.setEndLine(p1.getEndLine());
            p.setEndColumn(p1.getEndColumn());
        } else {
            p.setEndOffset(p2.getEndOffset());
            p.setEndLine(p2.getEndLine());
            p.setEndColumn(p2.getEndColumn());
        }
        return p;
    }

    public static boolean equalPositions(Position p1, Position p2) {
        return Objects.equals(p1.getSource(), p2.getSource()) && p1.getLocation().equals(p2.getLocation()) && p1.getStartOffset() == p2.getStartOffset() && p1.getStartLine() == p2.getStartLine() && p1.getStartColumn() == p2.getStartColumn() && p1.getEndOffset() == p2.getEndOffset() && p1.getEndLine() == p2.getEndLine() && p1.getEndColumn() == p2.getEndColumn();
    }

    public static int hashPosition(Position position) {
        String src = position.getSource();
        return (src == null ? 0 : src.hashCode()) ^ position.getLocation().hashCode() ^ position.getStartOffset() ^ position.getStartLine() ^ position.getStartColumn() ^ position.getEndOffset() * 17 ^ position.getEndLine() * 17 ^ position.getEndColumn() * 17;
    }

    public static int length(Position position) {
        return position.getEndOffset() - position.getStartOffset() + 1;
    }

    public static Position getSubRange(Position orig, int offset, int length) {
        Assert.check((orig.getStartLine() == orig.getEndLine() ? 1 : 0) != 0);
        int origLength = PositionUtils.length(orig);
        Assert.check((offset >= 0 ? 1 : 0) != 0);
        Assert.check((offset < origLength ? 1 : 0) != 0);
        Assert.check((1 <= length ? 1 : 0) != 0);
        Assert.check((length <= origLength - offset ? 1 : 0) != 0);
        Position rslt = PositionUtils.copyPosition(orig);
        rslt.setStartOffset(rslt.getStartOffset() + offset);
        rslt.setEndOffset(rslt.getStartOffset() + length - 1);
        rslt.setStartColumn(rslt.getStartColumn() + offset);
        rslt.setEndColumn(rslt.getStartColumn() + length - 1);
        return rslt;
    }
}

