/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ProjectionExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.TupleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AssignmentStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.BreakStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ContinueStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ElifStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ExitStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ReturnStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Statement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.TupleAddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.VariableAddressableDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.ExprsChecker;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.ToolInvokeChecker;
import org.eclipse.escet.tooldef.typechecker.TypeHints;
import org.eclipse.escet.tooldef.typechecker.TypesChecker;

public class StatementsChecker {
    private StatementsChecker() {
    }

    public static void tcheck(List<Statement> stats, CheckerContext ctxt) {
        try {
            for (Statement stat : stats) {
                StatementsChecker.tcheck(stat, ctxt);
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public static void tcheck(Statement stat, CheckerContext ctxt) {
        if (stat instanceof AssignmentStatement) {
            StatementsChecker.tcheck((AssignmentStatement)stat, ctxt);
        } else if (stat instanceof BreakStatement) {
            StatementsChecker.tcheck((BreakStatement)stat, ctxt);
        } else if (stat instanceof ContinueStatement) {
            StatementsChecker.tcheck((ContinueStatement)stat, ctxt);
        } else if (stat instanceof ExitStatement) {
            StatementsChecker.tcheck((ExitStatement)stat, ctxt);
        } else if (stat instanceof ForStatement) {
            StatementsChecker.tcheck((ForStatement)stat, ctxt);
        } else if (stat instanceof IfStatement) {
            StatementsChecker.tcheck((IfStatement)stat, ctxt);
        } else if (stat instanceof ReturnStatement) {
            StatementsChecker.tcheck((ReturnStatement)stat, ctxt);
        } else if (stat instanceof ToolInvokeStatement) {
            StatementsChecker.tcheck((ToolInvokeStatement)stat, ctxt);
        } else if (stat instanceof Variable) {
            StatementsChecker.tcheck((Variable)stat, ctxt);
        } else if (stat instanceof WhileStatement) {
            StatementsChecker.tcheck((WhileStatement)stat, ctxt);
        } else {
            throw new RuntimeException("Unknown statement: " + stat);
        }
    }

    private static void tcheck(AssignmentStatement stat, CheckerContext ctxt) {
        for (Expression addr : stat.getAddressables()) {
            ExprsChecker.tcheck(addr, ctxt, TypeHints.NO_HINTS);
        }
        Map addrMap = Maps.map();
        for (Expression addr : stat.getAddressables()) {
            StatementsChecker.tcheckAddr(addr, ctxt, addrMap);
        }
        List addrTypes = Lists.listc((int)stat.getAddressables().size());
        for (Expression addr : stat.getAddressables()) {
            addrTypes.add(ToolDefTypeUtils.normalizeType((ToolDefType)addr.getType()));
        }
        ToolDefType addrType = ToolDefTypeUtils.makeTupleType((List)addrTypes);
        TypeHints[] hints = new TypeHints[stat.getValues().size()];
        int i = 0;
        while (i < hints.length) {
            hints[i] = new TypeHints();
            ++i;
        }
        if (stat.getValues().size() == 1) {
            hints[0].add(addrType);
        } else if (addrType instanceof TupleType) {
            EList types = ((TupleType)addrType).getFields();
            int cnt = Math.min(types.size(), stat.getValues().size());
            int i2 = 0;
            while (i2 < cnt) {
                hints[i2].add((ToolDefType)types.get(i2));
                ++i2;
            }
        }
        i = 0;
        while (i < stat.getValues().size()) {
            Expression value = (Expression)stat.getValues().get(i);
            ExprsChecker.tcheck(value, ctxt, hints[i]);
            ++i;
        }
        ToolDefType valueType = ToolDefTypeUtils.makeTupleTypeFromValues((List)stat.getValues());
        if (!ToolDefTypeUtils.isSubType((ToolDefType)valueType, (ToolDefType)addrType)) {
            ctxt.addProblem(Message.ASGN_TYPE_VALUE_MISMATCH, stat.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)valueType), ToolDefTextUtils.typeToStr((ToolDefType)addrType));
        }
    }

    private static void tcheckAddr(Expression addr, CheckerContext ctxt, Map<PositionObject, Position> addrMap) {
        Variable var;
        if (addr instanceof TupleExpression) {
            TupleExpression taddr = (TupleExpression)addr;
            for (Expression elem : taddr.getElements()) {
                StatementsChecker.tcheckAddr(elem, ctxt, addrMap);
            }
            return;
        }
        List projs = Lists.list();
        while (addr instanceof ProjectionExpression) {
            ProjectionExpression proj = (ProjectionExpression)addr;
            projs.add(proj);
            addr = proj.getChild();
        }
        if (addr instanceof VariableExpression) {
            var = ((VariableExpression)addr).getVariable();
        } else if (addr instanceof ToolParamExpression) {
            var = ((ToolParamExpression)addr).getParam();
        } else {
            PositionObject obj = ToolDefTypeUtils.getRefObjFromRef((Expression)addr);
            ctxt.addProblem(Message.ASGN_NON_ASSIGNABLE, addr.getPosition(), ToolDefTextUtils.getAbsDescr((PositionObject)obj));
            throw new SemanticException();
        }
        PositionObject ancestor = (PositionObject)addr.eContainer();
        while (ancestor instanceof ProjectionExpression) {
            ProjectionExpression proj = (ProjectionExpression)ancestor;
            ToolDefType type = proj.getChild().getType();
            if ((type = ToolDefTypeUtils.normalizeType((ToolDefType)type)) instanceof StringType) {
                ctxt.addProblem(Message.ASGN_STRING_PROJ, ancestor.getPosition(), ToolDefTextUtils.getAbsDescr((PositionObject)var));
            }
            ancestor = (PositionObject)ancestor.eContainer();
        }
        Position prevAddrPos = addrMap.get(var);
        if (prevAddrPos == null) {
            addrMap.put((PositionObject)var, addr.getPosition());
        } else {
            ctxt.addProblem(Message.ASGN_DUPL_VAR, prevAddrPos, ToolDefTextUtils.getAbsDescr((PositionObject)var));
            ctxt.addProblem(Message.ASGN_DUPL_VAR, addr.getPosition(), ToolDefTextUtils.getAbsDescr((PositionObject)var));
        }
    }

    private static void tcheck(BreakStatement stat, CheckerContext ctxt) {
        boolean inLoop = false;
        EObject ancestor = stat.eContainer();
        while (!(ancestor instanceof Script) && !(ancestor instanceof Tool)) {
            if (ancestor instanceof WhileStatement || ancestor instanceof ForStatement) {
                inLoop = true;
                break;
            }
            ancestor = ancestor.eContainer();
        }
        if (!inLoop) {
            ctxt.addProblem(Message.NOT_IN_LOOP, stat.getPosition(), "break");
        }
    }

    private static void tcheck(ContinueStatement stat, CheckerContext ctxt) {
        boolean inLoop = false;
        EObject ancestor = stat.eContainer();
        while (!(ancestor instanceof Script) && !(ancestor instanceof Tool)) {
            if (ancestor instanceof WhileStatement || ancestor instanceof ForStatement) {
                inLoop = true;
                break;
            }
            ancestor = ancestor.eContainer();
        }
        if (!inLoop) {
            ctxt.addProblem(Message.NOT_IN_LOOP, stat.getPosition(), "continue");
        }
    }

    private static void tcheck(ExitStatement stat, CheckerContext ctxt) {
        if (stat.getExitCode() != null) {
            ExprsChecker.tcheck(stat.getExitCode(), ctxt, TypesChecker.NON_NULLABLE_INT_HINT);
            Expression cond = stat.getExitCode();
            ToolDefType type = cond.getType();
            if (!ToolDefTypeUtils.isSubType((ToolDefType)type, (ToolDefType)TypesChecker.NON_NULLABLE_INT_TYPE)) {
                ctxt.addProblem(Message.EXIT_CODE_NON_INT, cond.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)type));
            }
        }
    }

    private static void tcheck(ForStatement stat, CheckerContext ctxt) {
        ToolDefType addrType;
        ExprsChecker.tcheck(stat.getSource(), ctxt, TypeHints.NO_HINTS);
        Expression source = stat.getSource();
        ToolDefType sourceType = source.getType();
        sourceType = ToolDefTypeUtils.normalizeType((ToolDefType)sourceType);
        if (sourceType.isNullable()) {
            ctxt.addProblem(Message.FOR_SOURCE_NULL, source.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)sourceType));
            throw new SemanticException();
        }
        if (!(sourceType instanceof ListType || sourceType instanceof MapType || sourceType instanceof SetType)) {
            ctxt.addProblem(Message.FOR_SOURCE_TYPE, source.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)sourceType));
            throw new SemanticException();
        }
        if (sourceType instanceof ListType) {
            addrType = ((ListType)sourceType).getElemType();
        } else if (sourceType instanceof MapType) {
            MapType mtype = (MapType)sourceType;
            ToolDefType ktype = mtype.getKeyType();
            ToolDefType vtype = mtype.getValueType();
            addrType = ToolDefTypeUtils.makeTupleType((List)Lists.list((Object[])new ToolDefType[]{(ToolDefType)EMFHelper.deepclone((EObject)ktype), (ToolDefType)EMFHelper.deepclone((EObject)vtype)}));
        } else if (sourceType instanceof SetType) {
            addrType = ((SetType)sourceType).getElemType();
        } else {
            throw new RuntimeException("Unknown src type: " + sourceType);
        }
        CheckerContext bodyCtxt = new CheckerContext(ctxt, (PositionObject)stat);
        Position addrPos = ((AddressableDecl)Lists.first((List)stat.getAddressables())).getPosition();
        StatementsChecker.tcheck((List<AddressableDecl>)stat.getAddressables(), addrType, addrPos, bodyCtxt);
        StatementsChecker.tcheck((List<Statement>)stat.getStatements(), bodyCtxt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tcheck(List<AddressableDecl> addrs, ToolDefType type, Position position, CheckerContext ctxt) {
        if (addrs.size() == 1) {
            AddressableDecl addr = (AddressableDecl)Lists.first(addrs);
            if (addr instanceof TupleAddressableDecl) {
                EList elems = ((TupleAddressableDecl)addr).getElements();
                StatementsChecker.tcheck((List<AddressableDecl>)elems, type, addr.getPosition(), ctxt);
                return;
            } else {
                if (!(addr instanceof VariableAddressableDecl)) throw new RuntimeException("Unknown addressable decl: " + addr);
                Variable var = ((VariableAddressableDecl)addr).getVariable();
                var.setType((ToolDefType)EMFHelper.deepclone((EObject)type));
                ctxt.addDecl((PositionObject)var);
            }
            return;
        } else {
            if (!((type = ToolDefTypeUtils.normalizeType((ToolDefType)type)) instanceof TupleType)) {
                ctxt.addProblem(Message.FOR_ADDRS_TOO_MANY, position, Strings.str((Object)addrs.size()), ToolDefTextUtils.typeToStr((ToolDefType)type));
                throw new SemanticException();
            }
            TupleType ttype = (TupleType)type;
            if (addrs.size() != ttype.getFields().size()) {
                ctxt.addProblem(Message.FOR_ADDRS_CNT, position, Strings.str((Object)addrs.size()), Strings.str((Object)ttype.getFields().size()), ToolDefTextUtils.typeToStr((ToolDefType)type));
                throw new SemanticException();
            }
            int i = 0;
            while (i < addrs.size()) {
                AddressableDecl addr = addrs.get(i);
                StatementsChecker.tcheck(Lists.list((Object)addr), (ToolDefType)ttype.getFields().get(i), addr.getPosition(), ctxt);
                ++i;
            }
        }
    }

    private static void tcheck(IfStatement stat, CheckerContext ctxt) {
        ExprsChecker.tcheck(stat.getCondition(), ctxt, TypesChecker.NON_NULLABLE_BOOL_HINT);
        Expression cond = stat.getCondition();
        ToolDefType type = cond.getType();
        if (!ToolDefTypeUtils.isSubType((ToolDefType)type, (ToolDefType)TypesChecker.NON_NULLABLE_BOOL_TYPE)) {
            ctxt.addProblem(Message.COND_NON_BOOL, cond.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)type));
        }
        for (ElifStatement elif : stat.getElifs()) {
            ExprsChecker.tcheck(elif.getCondition(), ctxt, TypesChecker.NON_NULLABLE_BOOL_HINT);
            cond = elif.getCondition();
            type = cond.getType();
            if (ToolDefTypeUtils.isSubType((ToolDefType)type, (ToolDefType)TypesChecker.NON_NULLABLE_BOOL_TYPE)) continue;
            ctxt.addProblem(Message.COND_NON_BOOL, cond.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)type));
        }
        StatementsChecker.tcheck((List<Statement>)stat.getThens(), new CheckerContext(ctxt, (PositionObject)stat));
        for (ElifStatement elif : stat.getElifs()) {
            StatementsChecker.tcheck((List<Statement>)elif.getThens(), new CheckerContext(ctxt, (PositionObject)stat));
        }
        StatementsChecker.tcheck((List<Statement>)stat.getElses(), new CheckerContext(ctxt, (PositionObject)stat));
    }

    private static void tcheck(ReturnStatement stat, CheckerContext ctxt) {
        Tool tool = null;
        EObject ancestor = stat.eContainer();
        while (!(ancestor instanceof Script)) {
            if (ancestor instanceof Tool) {
                tool = (Tool)ancestor;
                break;
            }
            ancestor = ancestor.eContainer();
        }
        if (tool == null) {
            ctxt.addProblem(Message.NOT_IN_TOOL, stat.getPosition(), new String[0]);
            return;
        }
        if (stat.getValues().isEmpty() && tool.getReturnTypes().isEmpty()) {
            return;
        }
        if (!stat.getValues().isEmpty() && tool.getReturnTypes().isEmpty()) {
            ctxt.addProblem(Message.RETURN_NO_TYPES, stat.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)tool));
            return;
        }
        if (stat.getValues().isEmpty() && !tool.getReturnTypes().isEmpty()) {
            ctxt.addProblem(Message.RETURN_NO_VALUES, stat.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)tool));
            return;
        }
        ToolDefType retType = ToolDefTypeUtils.makeTupleType((List)EMFHelper.deepclone((List)tool.getReturnTypes()));
        int valueCnt = stat.getValues().size();
        TypeHints[] valueHints = new TypeHints[valueCnt];
        if (stat.getValues().size() == 1) {
            valueHints[0] = new TypeHints();
            valueHints[0].add(retType);
        } else {
            int i = 0;
            while (i < valueCnt) {
                valueHints[i] = new TypeHints();
                ++i;
            }
            if (retType instanceof TupleType) {
                EList fields = ((TupleType)retType).getFields();
                int cnt = Math.min(valueCnt, fields.size());
                int i2 = 0;
                while (i2 < cnt) {
                    valueHints[i2].add((ToolDefType)fields.get(i2));
                    ++i2;
                }
            }
        }
        int i = 0;
        while (i < valueCnt) {
            ExprsChecker.tcheck((Expression)stat.getValues().get(i), ctxt, valueHints[i]);
            ++i;
        }
        ToolDefType valueType = ToolDefTypeUtils.makeTupleTypeFromValues((List)stat.getValues());
        if (!ToolDefTypeUtils.isSubType((ToolDefType)valueType, (ToolDefType)retType)) {
            ctxt.addProblem(Message.RETURN_VALUE_TYPE, stat.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)valueType), ToolDefTextUtils.getAbsName((PositionObject)tool), ToolDefTextUtils.typeToStr((ToolDefType)retType));
        }
    }

    private static void tcheck(ToolInvokeStatement stat, CheckerContext ctxt) {
        ToolInvokeChecker.tcheck(stat.getInvocation(), ctxt, TypeHints.NO_HINTS, false);
    }

    private static void tcheck(Variable var, CheckerContext ctxt) {
        TypesChecker.tcheck(var.getType(), ctxt);
        ToolDefType varType = var.getType();
        if (var.getValue() == null) {
            if (!ToolDefTypeUtils.hasDefaultValue((ToolDefType)var.getType())) {
                ctxt.addProblem(Message.VAR_NO_INITIAL_VALUE, varType.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)var), ToolDefTextUtils.typeToStr((ToolDefType)var.getType()));
            }
        } else {
            TypeHints hints = new TypeHints();
            hints.add(var.getType());
            ExprsChecker.tcheck(var.getValue(), ctxt, hints);
            Expression value = var.getValue();
            ToolDefType valueType = value.getType();
            if (!ToolDefTypeUtils.isSubType((ToolDefType)valueType, (ToolDefType)varType)) {
                ctxt.addProblem(Message.VAR_VALUE_TYPE, value.getPosition(), ToolDefTextUtils.getAbsName((PositionObject)var), ToolDefTextUtils.typeToStr((ToolDefType)valueType), ToolDefTextUtils.typeToStr((ToolDefType)varType));
            }
        }
        ctxt.addDecl((PositionObject)var);
    }

    private static void tcheck(WhileStatement stat, CheckerContext ctxt) {
        ExprsChecker.tcheck(stat.getCondition(), ctxt, TypesChecker.NON_NULLABLE_BOOL_HINT);
        Expression cond = stat.getCondition();
        ToolDefType type = cond.getType();
        if (!ToolDefTypeUtils.isSubType((ToolDefType)type, (ToolDefType)TypesChecker.NON_NULLABLE_BOOL_TYPE)) {
            ctxt.addProblem(Message.COND_NON_BOOL, cond.getPosition(), ToolDefTextUtils.typeToStr((ToolDefType)type));
        }
        StatementsChecker.tcheck((List<Statement>)stat.getStatements(), new CheckerContext(ctxt, (PositionObject)stat));
    }
}

