/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.MultiClassLoader;
import org.eclipse.escet.common.java.UncachedUrlClassLoader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public abstract class ClassLoaderObtainer {
    public ClassLoader getClassLoader(String name) {
        IWorkspaceRoot root;
        IProject proj;
        if (!Platform.isRunning()) {
            return ClassLoader.getSystemClassLoader();
        }
        if (name == null) {
            return ClassLoader.getSystemClassLoader();
        }
        if (PlatformUI.isWorkbenchRunning() && Path.ROOT.isValidSegment(name) && (proj = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(name)).exists() && proj.isAccessible()) {
            return this.getPdeClassLoader(proj);
        }
        return this.getOsgiClassLoader(name);
    }

    private ClassLoader getPdeClassLoader(IProject proj) {
        IPluginModelBase plugin = PluginRegistry.findModel((IProject)proj);
        if (plugin == null) {
            this.errNotPluginProj(proj.getName());
            return null;
        }
        BundleDescription descr = plugin.getBundleDescription();
        if (descr == null) {
            this.errPluginClassicFormat(proj.getName());
            return null;
        }
        List reqsLoaders = Lists.list();
        BundleSpecification[] bundleSpecificationArray = descr.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification reqBundle = bundleSpecificationArray[n2];
            String reqName = reqBundle.getName();
            ClassLoader reqLoader = this.getClassLoader(reqName);
            reqsLoaders.add(reqLoader);
            ++n2;
        }
        ClassLoader reqsLoader = reqsLoaders.isEmpty() ? ClassLoader.getSystemClassLoader() : new MultiClassLoader(reqsLoaders);
        return this.getJdtClassLoader(proj, reqsLoader);
    }

    protected abstract void errNotPluginProj(String var1);

    protected abstract void errPluginClassicFormat(String var1);

    private ClassLoader getJdtClassLoader(IProject proj, ClassLoader parent) {
        String[] cp;
        IJavaProject jproj = JavaCore.create((IProject)proj);
        try {
            cp = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)jproj);
        }
        catch (CoreException ex) {
            this.errComputeClassPath(proj.getName(), ex);
            return null;
        }
        List urlList = Lists.list();
        int i = 0;
        while (i < cp.length) {
            URL url;
            Path path = new Path(cp[i]);
            try {
                url = path.toFile().toURI().toURL();
            }
            catch (MalformedURLException ex) {
                this.errMalforumedUrl(proj.getName(), ex);
                return null;
            }
            urlList.add(url);
            ++i;
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        try {
            return new UncachedUrlClassLoader(urls, parent);
        }
        catch (UncachedUrlClassLoader.OpenUrlException ex) {
            this.errOpenUrl(proj.getName(), ex);
            return null;
        }
    }

    protected abstract void errComputeClassPath(String var1, CoreException var2);

    protected abstract void errMalforumedUrl(String var1, MalformedURLException var2);

    protected abstract void errOpenUrl(String var1, UncachedUrlClassLoader.OpenUrlException var2);

    private ClassLoader getOsgiClassLoader(String name) {
        boolean stateOk;
        Bundle bundle = Platform.getBundle((String)name);
        if (bundle == null) {
            this.errNotFound(name);
            return null;
        }
        int state = bundle.getState();
        boolean bl = stateOk = state == 4 || state == 8 || state == 32;
        if (!stateOk) {
            this.errWrongState(name, bundle, state);
            return null;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            this.errNoWiring(name, bundle);
            return null;
        }
        ClassLoader classLoader = bundleWiring.getClassLoader();
        if (classLoader == null) {
            this.errNoClassLoader(name, bundle);
            return null;
        }
        return classLoader;
    }

    protected abstract void errNotFound(String var1);

    protected abstract void errWrongState(String var1, Bundle var2, int var3);

    protected void errNoWiring(String name, Bundle bundle) {
        this.errNoClassLoader(name, bundle);
    }

    protected abstract void errNoClassLoader(String var1, Bundle var2);
}

