/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;

public final class InsertDelta<T>
extends AbstractDelta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.INSERT, original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verifyChunk(target);
        int position = this.getSource().getPosition();
        List lines = this.getTarget().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getTarget().getPosition();
        int size = this.getTarget().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getTarget().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new InsertDelta<T>(original, revised);
    }
}

