/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class OptionGroup<T>
extends Composite {
    private final Option<T> option;
    protected final Group group = new Group((Composite)this, 0);
    protected final Label descrLabel;

    public OptionGroup(Composite page, Option option) {
        super(page, 0);
        this.option = option;
        this.descrLabel = new Label((Composite)this.group, 64);
        this.initGroup();
        this.setToValue(Options.hasValue(option) ? Options.get(option) : option.getDefault());
    }

    private void initGroup() {
        String cmdLineForOption;
        this.setLayout((Layout)new FillLayout());
        if (this.option.getCmdLong().equals("*")) {
            cmdLineForOption = " (remaining command line arguments)";
        } else {
            cmdLineForOption = " (--" + this.option.getCmdLong();
            if (this.option.getCmdShort() != null) {
                cmdLineForOption = String.valueOf(cmdLineForOption) + " or -" + this.option.getCmdShort();
            }
            cmdLineForOption = String.valueOf(cmdLineForOption) + ")";
        }
        this.group.setText(" " + this.option.getName() + cmdLineForOption + " ");
        FormLayout grpLayout = new FormLayout();
        grpLayout.marginWidth = 8;
        grpLayout.marginHeight = 8;
        grpLayout.spacing = 8;
        this.group.setLayout((Layout)grpLayout);
        this.descrLabel.setText(this.getDescription());
        FormData descrData = new FormData();
        descrData.top = new FormAttachment(0, 0);
        descrData.left = new FormAttachment(0, 0);
        descrData.right = new FormAttachment(100, 0);
        this.descrLabel.setLayoutData((Object)descrData);
        this.addComponents(this.group);
        this.group.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = OptionGroup.this.group.getBounds();
                Control[] controlArray = OptionGroup.this.group.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c == OptionGroup.this.descrLabel) {
                        Object layoutData = c.getLayoutData();
                        Assert.check((boolean)(layoutData instanceof FormData));
                        FormData grpData = (FormData)c.getLayoutData();
                        grpData.width = bounds.width - 24;
                    }
                    ++n2;
                }
                OptionGroup.this.group.getShell().layout();
            }
        });
    }

    protected void layoutVertical(Control[] components) {
        Label previous = this.descrLabel;
        Control[] controlArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Control component = controlArray[n2];
            FormData grpData = new FormData();
            grpData.left = new FormAttachment(0, 0);
            grpData.right = new FormAttachment(100, 0);
            grpData.top = new FormAttachment((Control)previous, 0);
            component.setLayoutData((Object)grpData);
            previous = component;
            ++n2;
        }
    }

    protected void layoutGeneric(Object[] components, int indent) {
        Label vprevious = this.descrLabel;
        boolean vprevIndented = false;
        Object[] objectArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Object vcomponent = objectArray[n2];
            if (vcomponent instanceof Control) {
                Control component = (Control)vcomponent;
                FormData grpData = new FormData();
                grpData.left = new FormAttachment(0, 0);
                grpData.right = new FormAttachment(100, 0);
                grpData.top = new FormAttachment((Control)vprevious, 0);
                component.setLayoutData((Object)grpData);
                vprevious = component;
                vprevIndented = false;
            } else if (vcomponent instanceof Control[]) {
                Control[] hcomponents = (Control[])vcomponent;
                Assert.check((hcomponents.length >= 1 ? 1 : 0) != 0);
                Control hprevious = null;
                Control[] controlArray = hcomponents;
                int n3 = hcomponents.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control component = controlArray[n4];
                    FormData grpData = new FormData();
                    FormAttachment formAttachment = grpData.left = hprevious == null ? new FormAttachment(0, indent) : new FormAttachment(hprevious, 0);
                    grpData.top = hprevious == null ? (vprevIndented ? new FormAttachment((Control)vprevious, 8) : new FormAttachment((Control)vprevious, 0)) : new FormAttachment(hprevious, 0, 0x1000000);
                    component.setLayoutData((Object)grpData);
                    hprevious = component;
                    ++n4;
                }
                FormData lastData = (FormData)hprevious.getLayoutData();
                lastData.right = new FormAttachment(100, 0);
                vprevious = hcomponents[0];
                vprevIndented = true;
            } else {
                throw new IllegalArgumentException("Invalid components format: " + vcomponent);
            }
            ++n2;
        }
    }

    protected void layoutGeneric(Object[] components) {
        this.layoutGeneric(components, 32);
    }

    protected abstract void addComponents(Group var1);

    public abstract String getDescription();

    public abstract void setToValue(T var1);

    public abstract String[] getCmdLine();
}

