/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.services.IServiceLocator;

public class ActionBars
extends SubActionBars {
    private ToolBarManager toolbarManager;
    private IMenuManager menuManager;
    private MPart part;

    public ActionBars(IActionBars parent, IServiceLocator serviceLocator, MPart part) {
        super(parent, serviceLocator);
        this.part = part;
    }

    @Override
    public IMenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
        }
        return this.menuManager;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        if (this.toolbarManager == null) {
            this.toolbarManager = new ToolBarManager(8519744);
        }
        return this.toolbarManager;
    }

    @Override
    public void updateActionBars() {
        Object renderer;
        MUIElement parent;
        this.getStatusLineManager().update(false);
        this.getMenuManager().update(false);
        if (this.toolbarManager != null) {
            Object renderer2;
            ToolBar tbCtrl = this.toolbarManager.getControl();
            if (tbCtrl == null || tbCtrl.isDisposed()) {
                this.part.getContext();
            } else {
                this.toolbarManager.update(true);
                if (!tbCtrl.isDisposed()) {
                    Control packParent = this.getPackParent((Control)tbCtrl);
                    packParent.pack();
                    if (packParent.getParent() instanceof CTabFolder) {
                        packParent.getParent().layout(true);
                    }
                }
            }
            MToolBar toolbar = this.part.getToolbar();
            if (toolbar != null && (renderer2 = toolbar.getRenderer()) instanceof ToolBarManagerRenderer) {
                ((ToolBarManagerRenderer)renderer2).reconcileManagerToModel((IToolBarManager)this.toolbarManager, toolbar);
            }
        }
        if ((parent = this.getParentModel()) != null && this.isOnTop() && (renderer = parent.getRenderer()) instanceof StackRenderer) {
            StackRenderer stackRenderer = (StackRenderer)renderer;
            CTabFolder folder = (CTabFolder)parent.getWidget();
            stackRenderer.adjustTopRight(folder);
        }
        super.updateActionBars();
    }

    private MUIElement getParentModel() {
        MElementContainer parent = this.part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = this.part.getCurSharedRef();
            return placeholder == null ? null : placeholder.getParent();
        }
        return parent;
    }

    private boolean isOnTop() {
        MUIElement parentModel = this.getParentModel();
        if (parentModel.getRenderer() instanceof StackRenderer) {
            MPartStack stack = (MPartStack)parentModel;
            if (stack.getSelectedElement() == this.part) {
                return true;
            }
            if (stack.getSelectedElement() instanceof MPlaceholder) {
                MPlaceholder ph = (MPlaceholder)stack.getSelectedElement();
                return ph.getRef() == this.part;
            }
        }
        return true;
    }

    private Control getPackParent(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent instanceof CTabFolder) {
                Control topRight = ((CTabFolder)parent).getTopRight();
                if (topRight == null) break;
                return topRight;
            }
            parent = parent.getParent();
        }
        return control.getParent();
    }

    boolean isSelected(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            if (placeholder == null) {
                return false;
            }
            parent = placeholder.getParent();
            return parent instanceof MGenericStack ? parent.getSelectedElement() == placeholder : parent != null;
        }
        return !(parent instanceof MGenericStack) || parent.getSelectedElement() == part;
    }

    @Override
    public void dispose() {
        this.menuManager.dispose();
        if (this.toolbarManager != null) {
            this.toolbarManager.dispose();
            this.toolbarManager.removeAll();
        }
        super.dispose();
    }
}

