/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.generator.parser.GrammarItem;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;

public class LookaheadItem {
    public final GrammarItem item;
    public final Set<Terminal> lookaheads;

    public LookaheadItem(GrammarItem item, Set<Terminal> lookaheads) {
        this.item = item;
        this.lookaheads = lookaheads;
    }

    public int hashCode() {
        return LookaheadItem.class.hashCode() ^ this.item.hashCode() ^ this.lookaheads.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LookaheadItem)) {
            return false;
        }
        LookaheadItem other = (LookaheadItem)obj;
        return this.item.equals(other.item) && this.lookaheads.equals(other.lookaheads);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        StringBuilder rslt = new StringBuilder();
        if (!simple) {
            rslt.append("[");
        }
        rslt.append(this.item.nonterminal.name.toString());
        rslt.append(" :");
        int i = 0;
        while (i < this.item.rule.symbols.size()) {
            if (i == this.item.progress) {
                rslt.append(" .");
            }
            rslt.append(" " + ((ParserRulePart)this.item.rule.symbols.get((int)i)).name);
            ++i;
        }
        if (this.item.isAfter()) {
            rslt.append(" .");
        }
        if (!simple) {
            rslt.append(",");
        }
        rslt.append(" ");
        List lookaheadTxts = Lists.list();
        for (Terminal terminal : this.lookaheads) {
            String terminalName = terminal.name;
            if (terminalName == null && terminal.isEof()) {
                terminalName = "\u00b6";
            }
            Assert.notNull((Object)terminalName);
            lookaheadTxts.add(terminalName);
        }
        Collections.sort(lookaheadTxts, Strings.SORTER);
        rslt.append("{");
        rslt.append(StringUtils.join((Collection)lookaheadTxts, (String)", "));
        rslt.append("}");
        if (!simple) {
            rslt.append("]");
        }
        return rslt.toString();
    }
}

