/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.expressions;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.OutputPosition;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.MatrixTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BinaryOperators;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.CastExpression;
import org.eclipse.escet.chi.metamodel.chi.ConstantReference;
import org.eclipse.escet.chi.metamodel.chi.DistributionType;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FunctionReference;
import org.eclipse.escet.chi.metamodel.chi.FunctionType;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelReference;
import org.eclipse.escet.chi.metamodel.chi.ModelType;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessReference;
import org.eclipse.escet.chi.metamodel.chi.ProcessType;
import org.eclipse.escet.chi.metamodel.chi.ReadCallExpression;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctions;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TimerType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.chi.metamodel.chi.UnaryOperators;
import org.eclipse.escet.chi.metamodel.chi.VariableReference;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class ExpressionBase
extends OutputPosition {
    public ExpressionBase(PositionObject chiobj) {
        super(chiobj);
    }

    public abstract List<String> getCode();

    public abstract String getValue(boolean var1);

    public String getValue() {
        return this.getValue(false);
    }

    public static ExpressionBase makeExpression(List<String> code, String value, PositionObject position) {
        if (code == null || code.isEmpty()) {
            return new SimpleExpression(value, position);
        }
        return new CodeExpression(code, value, position);
    }

    public static ExpressionBase convertExpression(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        UnaryExpression unexpr;
        while (expr instanceof ConstantReference) {
            ConstantReference cr = (ConstantReference)expr;
            expr = cr.getConstant().getValue();
        }
        if (expr instanceof VariableReference) {
            VariableReference varRef = (VariableReference)expr;
            String value = ctxt.getDefinition((PositionObject)varRef.getVariable());
            return new SimpleExpression(value, (PositionObject)varRef);
        }
        if (expr instanceof CallExpression) {
            CallExpression ce = (CallExpression)expr;
            if (ce.getFunction() instanceof StdLibFunctionReference) {
                return ExpressionBase.convertStdlibFuncApplication(ce, ctxt, currentFile);
            }
            if (ce.getFunction() instanceof FunctionReference) {
                return ExpressionBase.convertUserFuncApplication(ce, ctxt, currentFile);
            }
            if (ce.getFunction().getType() instanceof FunctionType) {
                return ExpressionBase.convertComputedFuncApplication(ce, ctxt, currentFile);
            }
            if (ce.getFunction().getType() instanceof ProcessType) {
                return ExpressionBase.convertProcessApplication(ce, ctxt, currentFile);
            }
            Assert.check((boolean)(ce.getFunction().getType() instanceof ModelType));
            return ExpressionBase.convertSubSimulation(ce, ctxt, currentFile);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bin = (BinaryExpression)expr;
            if (bin.getOp().equals((Object)BinaryOperators.PROJECTION)) {
                TypeID tid = TypeIDCreation.createTypeID(bin.getLeft().getType(), ctxt);
                return tid.convertExprNode(expr, ctxt, currentFile);
            }
            if (bin.getOp().equals((Object)BinaryOperators.SUBSET) || bin.getOp().equals((Object)BinaryOperators.ELEMENT_TEST)) {
                TypeID tid = TypeIDCreation.createTypeID(bin.getRight().getType(), ctxt);
                return tid.convertExprNode(expr, ctxt, currentFile);
            }
        }
        if (expr instanceof UnaryExpression && (unexpr = (UnaryExpression)expr).getOp().equals((Object)UnaryOperators.SAMPLE)) {
            return ExpressionBase.convertSampleExpression(unexpr, ctxt, currentFile);
        }
        if (expr instanceof CastExpression) {
            return ExpressionBase.convertCastExpression((CastExpression)expr, ctxt, currentFile);
        }
        if (expr instanceof ReadCallExpression) {
            ReadCallExpression rce = (ReadCallExpression)expr;
            return ExpressionBase.convertReadCallExpression(rce, ctxt, currentFile);
        }
        TypeID tid = TypeIDCreation.createTypeID(expr.getType(), ctxt);
        return tid.convertExprNode(expr, ctxt, currentFile);
    }

    private static ExpressionBase convertReadCallExpression(ReadCallExpression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        String fileValue;
        List lines = Lists.list();
        if (expr.getFile() == null) {
            fileValue = "chiCoordinator.getStdin()";
        } else {
            ExpressionBase fileExpr = ExpressionBase.convertExpression(expr.getFile(), ctxt, currentFile);
            lines.addAll(fileExpr.getCode());
            fileValue = fileExpr.getValue();
        }
        TypeID tid = TypeIDCreation.createTypeID(expr.getLoadType(), ctxt);
        String line = tid.getReadName(fileValue, currentFile);
        return ExpressionBase.makeExpression(lines, line, (PositionObject)expr);
    }

    private static ExpressionBase convertCastExpression(CastExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        ExpressionBase child = ExpressionBase.convertExpression(ce.getExpression(), ctxt, currentFile);
        Type chTp = CheckType.dropReferences((Type)ce.getExpression().getType());
        Type resTp = CheckType.dropReferences((Type)ce.getCastType());
        if (chTp instanceof BoolType) {
            Assert.check((boolean)(resTp instanceof StringType));
            String line = Strings.fmt((String)"(%s) ? \"true\" : \"false\"", (Object[])new Object[]{child.getValue()});
            return ExpressionBase.makeExpression(child.getCode(), line, (PositionObject)ce);
        }
        if (chTp instanceof IntType) {
            if (resTp instanceof StringType) {
                String line = Strings.fmt((String)"String.valueOf(%s)", (Object[])new Object[]{child.getValue()});
                return ExpressionBase.makeExpression(child.getCode(), line, (PositionObject)ce);
            }
            if (resTp instanceof RealType) {
                String line = Strings.fmt((String)"(double)(%s)", (Object[])new Object[]{child.getValue()});
                return ExpressionBase.makeExpression(child.getCode(), line, (PositionObject)ce);
            }
        } else if (chTp instanceof RealType) {
            if (resTp instanceof StringType) {
                String line = Strings.fmt((String)"String.valueOf(%s)", (Object[])new Object[]{child.getValue()});
                return ExpressionBase.makeExpression(child.getCode(), line, (PositionObject)ce);
            }
            if (resTp instanceof TimerType) {
                List lines = Lists.list();
                lines.addAll(child.getCode());
                String tim = ctxt.makeUniqueName("timer");
                String line = Strings.fmt((String)"Timer %s = new Timer(chiCoordinator, chiCoordinator.getCurrentTime() + (%s));", (Object[])new Object[]{tim, child.getValue()});
                lines.add(line);
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.Timer", false);
                return ExpressionBase.makeExpression(lines, tim, (PositionObject)ce);
            }
        } else {
            if (chTp instanceof StringType) {
                List lines = Lists.list();
                lines.addAll(child.getCode());
                String mem = ctxt.makeUniqueName("mem");
                lines.add("ChiReadMemoryFile " + mem + " = new ChiReadMemoryFile(" + child.getValue() + ");");
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.io.ChiReadMemoryFile", false);
                TypeID tid = TypeIDCreation.createTypeID(resTp, ctxt);
                String var = ctxt.makeUniqueName("var");
                String line = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tid.getJavaType(), var, tid.getReadName(mem, currentFile)});
                lines.add(line);
                return ExpressionBase.makeExpression(lines, var, (PositionObject)ce);
            }
            if (chTp instanceof TimerType) {
                Assert.check((boolean)(resTp instanceof RealType));
                String line = Strings.fmt((String)"(%s).getRemaining()", (Object[])new Object[]{child.getValue()});
                return ExpressionBase.makeExpression(child.getCode(), line, (PositionObject)ce);
            }
            if (chTp instanceof ListType) {
                if (resTp instanceof SetType) {
                    SetType setType = (SetType)resTp;
                    TypeID setTid = TypeIDCreation.createTypeID(resTp, ctxt);
                    String setVar = ctxt.makeUniqueName("set");
                    TypeID listTid = TypeIDCreation.createTypeID(chTp, ctxt);
                    String listVar = ctxt.makeUniqueName("list");
                    List lines = Lists.list();
                    lines.addAll(child.getCode());
                    String line = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{listTid.getJavaType(), listVar, child.getValue()});
                    lines.add(line);
                    line = Strings.fmt((String)"%s %s = new %s(chiCoordinator, %s.size());", (Object[])new Object[]{setTid.getJavaType(), setVar, setTid.getJavaClassType(), listVar});
                    lines.add(line);
                    TypeID elmTid = TypeIDCreation.createTypeID(setType.getElementType(), ctxt);
                    line = Strings.fmt((String)"for (%s x: %s) %s.add(x);", (Object[])new Object[]{elmTid.getJavaType(), listVar, setVar});
                    lines.add(line);
                    return ExpressionBase.makeExpression(lines, setVar, (PositionObject)ce);
                }
                Assert.check((boolean)(resTp instanceof MatrixType));
                MatrixType mType = (MatrixType)resTp;
                TypeID tid = TypeIDCreation.createTypeID(resTp, ctxt);
                String matClass = tid.getJavaClassType();
                currentFile.addImport(matClass, false);
                matClass = matClass.substring(matClass.lastIndexOf(46) + 1);
                String var = ctxt.makeUniqueName("mat");
                List lines = Lists.list();
                lines.addAll(child.getCode());
                String line = Strings.fmt((String)"%s %s = new %s(%d, %d);", (Object[])new Object[]{matClass, var, matClass, MatrixTypeID.getValue(mType.getRowSize()), MatrixTypeID.getValue(mType.getColumnSize())});
                lines.add(line);
                line = Strings.fmt((String)"%s.loadList(%s);", (Object[])new Object[]{var, child.getValue()});
                lines.add(line);
                return ExpressionBase.makeExpression(lines, var, (PositionObject)ce);
            }
        }
        Assert.fail((String)"Unexpected type of child of cast expression found");
        return null;
    }

    private static ExpressionBase convertComputedFuncApplication(CallExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        ExpressionBase fnc = ExpressionBase.convertExpression(ce.getFunction(), ctxt, currentFile);
        List lines = Lists.list();
        lines.addAll(fnc.getCode());
        String argText = "positionStack";
        for (Expression arg : ce.getArguments()) {
            ExpressionBase exprBase = ExpressionBase.convertExpression(arg, ctxt, currentFile);
            lines.addAll(exprBase.getCode());
            if (!argText.isEmpty()) {
                argText = String.valueOf(argText) + ", ";
            }
            argText = String.valueOf(argText) + exprBase.getValue();
        }
        String text = Strings.fmt((String)"%s.compute(%s)", (Object[])new Object[]{fnc.getValue(), argText});
        return ExpressionBase.makeExpression(lines, text, (PositionObject)ce);
    }

    private static ExpressionBase convertProcessApplication(CallExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        String pName;
        List lines = Lists.list();
        if (ce.getFunction() instanceof ProcessReference) {
            ProcessDeclaration pd = ((ProcessReference)ce.getFunction()).getProcess();
            pName = "new " + ctxt.getDefinition((PositionObject)pd);
        } else {
            ExpressionBase fnc = ExpressionBase.convertExpression(ce.getFunction(), ctxt, currentFile);
            lines.addAll(fnc.getCode());
            pName = String.valueOf(fnc.getValue()) + ".create";
        }
        String argText = "spec, chiCoordinator";
        for (Expression arg : ce.getArguments()) {
            ExpressionBase exprBase = ExpressionBase.convertExpression(arg, ctxt, currentFile);
            lines.addAll(exprBase.getCode());
            argText = String.valueOf(argText) + ", " + exprBase.getValue();
        }
        String text = Strings.fmt((String)"%s(%s)", (Object[])new Object[]{pName, argText});
        return ExpressionBase.makeExpression(lines, text, (PositionObject)ce);
    }

    private static ExpressionBase convertSubSimulation(CallExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        List lines = Lists.list();
        String argText = "spec, chiCoordinator";
        for (Expression arg : ce.getArguments()) {
            ExpressionBase code = ExpressionBase.convertExpression(arg, ctxt, currentFile);
            lines.addAll(code.getCode());
            argText = String.valueOf(argText) + ", " + code.getValue();
        }
        Assert.check((boolean)(ce.getFunction() instanceof ModelReference));
        ModelDeclaration md = ((ModelReference)ce.getFunction()).getModel();
        String modelVar = ctxt.makeUniqueName("mdl");
        String line = Strings.fmt((String)"BaseProcess %s = new %s(%s);", (Object[])new Object[]{modelVar, ctxt.getDefinition((PositionObject)md), argText});
        lines.add(line);
        String resVar = ctxt.makeUniqueName("rslt");
        line = Strings.fmt((String)"Object %s = chiCoordinator.runSubSimulation(%s);", (Object[])new Object[]{resVar, modelVar});
        lines.add(line);
        TypeID tid = TypeIDCreation.createTypeID(md.getReturnType(), ctxt);
        line = "((" + tid.getJavaClassType() + ")" + resVar + ")";
        return new CodeExpression(lines, line, (PositionObject)ce);
    }

    private static ExpressionBase convertUserFuncApplication(CallExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        FunctionReference fr = (FunctionReference)ce.getFunction();
        String funcName = ctxt.getDefinition((PositionObject)fr.getFunction());
        List lines = Lists.list();
        String argText = "positionStack";
        for (Expression arg : ce.getArguments()) {
            ExpressionBase exprBase = ExpressionBase.convertExpression(arg, ctxt, currentFile);
            lines.addAll(exprBase.getCode());
            if (!argText.isEmpty()) {
                argText = String.valueOf(argText) + ", ";
            }
            argText = String.valueOf(argText) + exprBase.getValue();
        }
        String text = Strings.fmt((String)"spec.instance%s.compute(%s)", (Object[])new Object[]{funcName, argText});
        return ExpressionBase.makeExpression(lines, text, (PositionObject)ce);
    }

    private static ExpressionBase convertStdlibFuncApplication(CallExpression ce, CodeGeneratorContext ctxt, JavaFile currentFile) {
        String FAST_MATH = "org.apache.commons.math3.util.FastMath";
        StdLibFunctionReference sref = (StdLibFunctionReference)ce.getFunction();
        List argExprs = Lists.list();
        String text = "";
        for (Expression arg : ce.getArguments()) {
            ExpressionBase eb = ExpressionBase.convertExpression(arg, ctxt, currentFile);
            if (!text.isEmpty()) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + eb.getValue();
            argExprs.add(eb);
        }
        List lines = Lists.list();
        for (ExpressionBase exprBase : argExprs) {
            lines.addAll(exprBase.getCode());
        }
        switch (sref.getFunction()) {
            case ABS: {
                text = Strings.fmt((String)"Math.abs(%s)", (Object[])new Object[]{text});
                break;
            }
            case ACOS: {
                text = Strings.fmt((String)"acos(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.acos", true);
                break;
            }
            case ACOSH: {
                text = Strings.fmt((String)"acosh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.acosh", true);
                break;
            }
            case ASIN: {
                text = Strings.fmt((String)"asin(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.asin", true);
                break;
            }
            case ASINH: {
                text = Strings.fmt((String)"asinh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.asinh", true);
                break;
            }
            case ATAN: {
                text = Strings.fmt((String)"atan(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.atan", true);
                break;
            }
            case ATANH: {
                text = Strings.fmt((String)"atanh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.atanh", true);
                break;
            }
            case CBRT: {
                text = Strings.fmt((String)"cbrt(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.cbrt", true);
                break;
            }
            case CEIL: {
                text = Strings.fmt((String)"(int)ceil(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.ceil", true);
                break;
            }
            case COS: {
                text = Strings.fmt((String)"cos(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.cos", true);
                break;
            }
            case COSH: {
                text = Strings.fmt((String)"cosh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.cosh", true);
                break;
            }
            case DICT_KEYS: {
                text = Strings.fmt((String)"(%s).getKeyList()", (Object[])new Object[]{text});
                break;
            }
            case DICT_VALUES: {
                text = Strings.fmt((String)"(%s).getValueList()", (Object[])new Object[]{text});
                break;
            }
            case EMPTY: {
                text = Strings.fmt((String)"(%s).isEmpty()", (Object[])new Object[]{text});
                break;
            }
            case ENUMERATE: {
                Assert.check((ce.getArguments().size() == 1 ? 1 : 0) != 0);
                TypeID tid = TypeIDCreation.createTypeID(((Expression)ce.getArguments().get(0)).getType(), ctxt);
                text = String.valueOf(ExpressionBase.getEnumerateMethod(tid, ctxt)) + "(chiCoordinator, " + text + ")";
                break;
            }
            case EXP: {
                text = Strings.fmt((String)"Math.exp(%s)", (Object[])new Object[]{text});
                break;
            }
            case FINISHED: {
                text = Strings.fmt((String)"(%s).isFinished()", (Object[])new Object[]{text});
                break;
            }
            case FLOOR: {
                text = Strings.fmt((String)"(int)Math.floor(%s)", (Object[])new Object[]{text});
                break;
            }
            case INSERT: {
                TypeID tid = TypeIDCreation.createTypeID(((Expression)ce.getArguments().get(0)).getType(), ctxt);
                text = Strings.fmt((String)"%s.insert(%s)", (Object[])new Object[]{tid.getJavaClassType(), text});
                break;
            }
            case SORT: {
                TypeID tid = TypeIDCreation.createTypeID(((Expression)ce.getArguments().get(0)).getType(), ctxt);
                text = Strings.fmt((String)"%s.sort(%s)", (Object[])new Object[]{tid.getJavaClassType(), text});
                break;
            }
            case SIZE: {
                String funcName = "size";
                Type tp = CheckType.dropReferences((Type)((Expression)ce.getArguments().get(0)).getType());
                if (tp instanceof StringType) {
                    funcName = "length";
                }
                text = Strings.fmt((String)"(%s).%s()", (Object[])new Object[]{text, funcName});
                break;
            }
            case LN: {
                text = Strings.fmt((String)"log(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.log", true);
                break;
            }
            case LOG: {
                text = Strings.fmt((String)"log10(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.log10", true);
                break;
            }
            case MAX: 
            case MIN: {
                if (ce.getArguments().size() == 1) {
                    String fnName = sref.getFunction() == StdLibFunctions.MIN ? "getMinimum" : "getMaximum";
                    text = Strings.fmt((String)"(%s).%s()", (Object[])new Object[]{text, fnName});
                    break;
                }
                if (ce.getArguments().size() >= 2) {
                    Type resType = CheckType.dropReferences((Type)ce.getType());
                    TypeID resTid = TypeIDCreation.createTypeID(resType, ctxt);
                    String resVar = ctxt.makeUniqueName("res");
                    String tempVar = ctxt.makeUniqueName("tmp");
                    String line = Strings.fmt((String)"%s %s, %s;", (Object[])new Object[]{resTid.getJavaType(), resVar, tempVar});
                    lines.add(line);
                    String cmpOp = sref.getFunction() == StdLibFunctions.MIN ? "<" : ">";
                    String cmpLine = resType instanceof StringType ? Strings.fmt((String)"%s = %s.compareTo(%s) %s 0 ? %s : %s;", (Object[])new Object[]{resVar, resVar, tempVar, cmpOp, resVar, tempVar}) : Strings.fmt((String)"%s = %s %s %s ? %s : %s;", (Object[])new Object[]{resVar, resVar, cmpOp, tempVar, resVar, tempVar});
                    boolean first = true;
                    for (ExpressionBase arg : argExprs) {
                        if (first) {
                            line = Strings.fmt((String)"%s = %s;", (Object[])new Object[]{resVar, arg.getValue(true)});
                            lines.add(line);
                            first = false;
                            continue;
                        }
                        line = Strings.fmt((String)"%s = %s;", (Object[])new Object[]{tempVar, arg.getValue(true)});
                        lines.add(line);
                        lines.add(cmpLine);
                    }
                    text = resVar;
                    break;
                }
                Assert.fail((String)"Not expecting to get here for MIN/MAX");
                break;
            }
            case OPEN: {
                text = Strings.fmt((String)"chiCoordinator.openFile(%s, \"text\")", (Object[])new Object[]{text});
                break;
            }
            case POP: {
                text = Strings.fmt((String)"(%s).pop()", (Object[])new Object[]{text});
                break;
            }
            case RANGE: {
                TypeID tid = TypeIDCreation.makeIntTypeID();
                tid = TypeIDCreation.makeListTypeID(tid, ctxt);
                text = Strings.fmt((String)"%s.range(chiCoordinator, %s)", (Object[])new Object[]{tid.getJavaClassType(), text});
                break;
            }
            case ROUND: {
                text = Strings.fmt((String)"(int)round(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.round", true);
                break;
            }
            case SIGN: {
                text = Strings.fmt((String)"(int)signum(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.signum", true);
                break;
            }
            case SIN: {
                text = Strings.fmt((String)"sin(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.sin", true);
                break;
            }
            case SINH: {
                text = Strings.fmt((String)"sinh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.sinh", true);
                break;
            }
            case SQRT: {
                text = Strings.fmt((String)"sqrt(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.sqrt", true);
                break;
            }
            case TAN: {
                text = Strings.fmt((String)"tan(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.tan", true);
                break;
            }
            case TANH: {
                text = Strings.fmt((String)"tanh(%s)", (Object[])new Object[]{text});
                currentFile.addImport("org.apache.commons.math3.util.FastMath.tanh", true);
                break;
            }
            case READY: {
                text = Strings.fmt((String)"(%s).isReady()", (Object[])new Object[]{text});
                break;
            }
            case DELETE: {
                TypeID tid = TypeIDCreation.createTypeID(((Expression)ce.getArguments().get(0)).getType(), ctxt);
                text = Strings.fmt((String)"%s.removeElement(%s)", (Object[])new Object[]{tid.getJavaClassType(), text});
                break;
            }
            case BERNOULLI: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.BernoulliDistribution", false);
                text = Strings.fmt((String)"new BernoulliDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case BETA: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.BetaDistribution", false);
                text = Strings.fmt((String)"new BetaDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case BINOMIAL: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.BinomialDistribution", false);
                text = Strings.fmt((String)"new BinomialDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case CONSTANT: {
                String name;
                Type etp = CheckType.dropReferences((Type)ce.getType());
                Assert.check((boolean)(etp instanceof DistributionType));
                DistributionType dt = (DistributionType)etp;
                etp = CheckType.dropReferences((Type)dt.getResultType());
                if (etp instanceof BoolType) {
                    name = "BooleanConstantDistribution";
                } else if (etp instanceof IntType) {
                    name = "IntegerConstantDistribution";
                } else if (etp instanceof RealType) {
                    name = "DoubleConstantDistribution";
                } else {
                    Assert.fail((String)"Unexpected elmtype of a constant distr");
                    name = "NOT_REACHED";
                }
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random." + name, false);
                text = Strings.fmt((String)"new %s(chiCoordinator, %s)", (Object[])new Object[]{name, text});
                break;
            }
            case EOF: {
                text = Strings.fmt((String)"chiCoordinator.checkEof(%s)", (Object[])new Object[]{text});
                break;
            }
            case EOL: {
                text = Strings.fmt((String)"chiCoordinator.checkEol(%s)", (Object[])new Object[]{text});
                break;
            }
            case NEWLINES: {
                text = Strings.fmt((String)"chiCoordinator.getNewlines(%s)", (Object[])new Object[]{text});
                break;
            }
            case ERLANG: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.ErlangDistribution", false);
                text = Strings.fmt((String)"new ErlangDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case EXPONENTIAL: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.ExponentialDistribution", false);
                text = Strings.fmt((String)"new ExponentialDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case GAMMA: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.GammaDistribution", false);
                text = Strings.fmt((String)"new GammaDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case GEOMETRIC: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.GeometricDistribution", false);
                text = Strings.fmt((String)"new GeometricDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case LOG_NORMAL: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.LogNormalDistribution", false);
                text = Strings.fmt((String)"new LogNormalDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case NORMAL: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.NormalDistribution", false);
                text = Strings.fmt((String)"new NormalDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case POISSON: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.PoissonDistribution", false);
                text = Strings.fmt((String)"new PoissonDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case RANDOM: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.RandomDistribution", false);
                Assert.check((boolean)text.isEmpty());
                text = "new RandomDistribution(chiCoordinator)";
                break;
            }
            case TRIANGLE: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.TriangleDistribution", false);
                text = Strings.fmt((String)"new TriangleDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
                break;
            }
            case UNIFORM: {
                String name;
                Type etp = CheckType.dropReferences((Type)ce.getType());
                Assert.check((boolean)(etp instanceof DistributionType));
                DistributionType dt = (DistributionType)etp;
                etp = CheckType.dropReferences((Type)dt.getResultType());
                if (etp instanceof IntType) {
                    name = "IntegerUniformDistribution";
                } else if (etp instanceof RealType) {
                    name = "DoubleUniformDistribution";
                } else {
                    Assert.fail((String)"Unexpected element type of a uniform distribution");
                    name = "NOT_REACHED";
                }
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random." + name, false);
                text = Strings.fmt((String)"new %s(chiCoordinator, %s)", (Object[])new Object[]{name, text});
                break;
            }
            case WEIBULL: {
                currentFile.addImport("org.eclipse.escet.chi.runtime.data.random.WeibullDistribution", false);
                text = Strings.fmt((String)"new WeibullDistribution(chiCoordinator, %s)", (Object[])new Object[]{text});
            }
        }
        return ExpressionBase.makeExpression(lines, text, (PositionObject)ce);
    }

    private static ExpressionBase convertSampleExpression(UnaryExpression unexpr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        ExpressionBase chExpr = ExpressionBase.convertExpression(unexpr.getChild(), ctxt, currentFile);
        String val = Strings.fmt((String)"(%s).sample()", (Object[])new Object[]{chExpr.getValue()});
        return ExpressionBase.makeExpression(chExpr.getCode(), val, (PositionObject)unexpr);
    }

    public static String getEnumerateMethod(TypeID tid, CodeGeneratorContext ctxt) {
        TypeID elmTid;
        List names;
        String fullMethodName = ctxt.getEnumerateName(tid);
        if (fullMethodName != null) {
            return fullMethodName;
        }
        String clsName = ctxt.makeUniqueName("Enumerate");
        fullMethodName = String.valueOf(clsName) + ".enumerate";
        ctxt.addEnumerateName(tid, fullMethodName);
        switch (tid.kind) {
            case DICTIONARY: {
                names = Lists.list((Object[])new String[]{"key", "value"});
                Assert.check((tid.subTypes.size() == 2 ? 1 : 0) != 0);
                elmTid = TypeIDCreation.createTupleTypeID(names, tid.subTypes, ctxt);
                break;
            }
            case SET: 
            case LIST: {
                elmTid = tid.subTypes.get(0);
                break;
            }
            default: {
                Assert.fail((String)"Unknown type of enumerate source");
                return null;
            }
        }
        names = Lists.list((Object[])new String[]{"index", "value"});
        List tids = Lists.list((Object[])new TypeID[]{TypeIDCreation.makeIntTypeID(), elmTid});
        TypeID tupTid = TypeIDCreation.createTupleTypeID(names, tids, ctxt);
        TypeID retTid = TypeIDCreation.makeListTypeID(tupTid, ctxt);
        JavaClass jc = new JavaClass(null, false, clsName, null, null);
        ctxt.addClass(jc);
        String retClassname = retTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public static", retClassname, "enumerate", "ChiCoordinator chiCoordinator, " + tid.getJavaType() + " source", null);
        jc.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm.lines.add("%s result = new %s(chiCoordinator);", new Object[]{retClassname, retClassname});
        jm.lines.add("int i = 0;");
        jm.lines.add("for (%s elm: source) {", new Object[]{elmTid.getJavaClassType()});
        String tupClsName = tupTid.getJavaClassType();
        jm.lines.add("    %s tup = new %s(chiCoordinator);", new Object[]{tupClsName, tupClsName});
        jm.lines.add("    tup.var0 = i;");
        jm.lines.add("    tup.var1 = elm;");
        jm.lines.add("    result.append(tup);");
        jm.lines.add("    i++;");
        jm.lines.add("}");
        jm.lines.add("return result;");
        jc.addMethod(jm);
        return fullMethodName;
    }
}

