/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.statements.seq.Seq;
import org.eclipse.escet.chi.metamodel.chi.ReturnStatement;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MultiLineTextBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SeqReturn
extends Seq {
    public final ReturnReason reason;
    public final ExpressionBase value;
    public final int caseNumber;

    protected SeqReturn(PositionObject position, ReturnReason reason, ExpressionBase value, int caseNumber) {
        super(position);
        this.reason = reason;
        this.value = value;
        this.caseNumber = caseNumber;
    }

    public static SeqReturn finishProcess(PositionObject chiObject) {
        return new SeqReturn(chiObject, ReturnReason.PROC_FINISH, null, -1);
    }

    public static SeqReturn jumpToCase(int caseNumber, PositionObject position) {
        return new SeqReturn(position, ReturnReason.PROC_GOTO, null, caseNumber);
    }

    public static SeqReturn selectBlock(PositionObject position) {
        return new SeqReturn(position, ReturnReason.PROC_BLOCKS, null, 0);
    }

    public static SeqReturn funcReturn(ExpressionBase val, ReturnStatement stat) {
        return new SeqReturn((PositionObject)stat, ReturnReason.FUNC_RETURN, val, -1);
    }

    @Override
    public Box boxify() {
        switch (this.reason) {
            case PROC_GOTO: {
                return SeqReturn.generateGoto(this.caseNumber);
            }
            case PROC_FINISH: {
                return new TextBox("return RunResult.FINISHED;");
            }
            case FUNC_RETURN: {
                VBox vb = new VBox(0);
                this.setCurrentPositionStatement(vb);
                if (!this.value.getCode().isEmpty()) {
                    vb.add((Box)new MultiLineTextBox(this.value.getCode()));
                }
                vb.add("if (ALWAYS) {");
                vb.add("    if (positionStack != null) positionStack.remove(positionStack.size()-1);");
                vb.add("    return " + this.value.getValue() + ";");
                vb.add("}");
                return vb;
            }
            case PROC_BLOCKS: {
                return new TextBox("return RunResult.BLOCKED;");
            }
        }
        Assert.fail((String)"Unknown type of return.");
        return null;
    }

    public static Box generateGoto(int dest) {
        String line = Strings.fmt((String)"chiProgramCounter = %d; if (ALWAYS) break;", (Object[])new Object[]{dest});
        return new TextBox(line);
    }

    private static enum ReturnReason {
        FUNC_RETURN,
        PROC_GOTO,
        PROC_FINISH,
        PROC_BLOCKS;

    }
}

