/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq.assignment;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentNode;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.ChainedAsgNode;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class TupleProjection
extends ChainedAsgNode {
    public final TupleType tupleType;
    public final FieldReference field;

    public TupleProjection(TupleType tupleType, FieldReference field, AssignmentNode child) {
        super(child);
        this.tupleType = tupleType;
        this.field = field;
    }

    @Override
    public boolean performsFullAssignment() {
        return false;
    }

    @Override
    public void saveUsedValues(boolean oneAssignment, Set<VariableDeclaration> assigneds, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        this.child.saveUsedValues(oneAssignment, assigneds, ctxt, currentClass, lines);
    }

    @Override
    public void assignValue(String lhsVar, List<Integer> rhsIndices, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        int fieldIndex = this.tupleType.getFields().indexOf((Object)this.field.getField());
        Assert.check((fieldIndex >= 0 ? 1 : 0) != 0, (String)"Cannot find tuple field.");
        TypeID varTid = TypeIDCreation.createTypeID(this.field.getType(), ctxt);
        String tmpVar = ctxt.makeUniqueName("tmp");
        if (this.child.performsFullAssignment()) {
            lines.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{varTid.getJavaType(), tmpVar}));
        } else {
            lines.add(Strings.fmt((String)"%s %s = %s.var%d;", (Object[])new Object[]{varTid.getJavaType(), tmpVar, lhsVar, fieldIndex}));
        }
        this.child.assignValue(tmpVar, rhsIndices, ctxt, currentClass, lines);
        TypeID tupTid = TypeIDCreation.createTypeID((Type)this.tupleType, ctxt);
        lines.add(Strings.fmt((String)"%s = %s;", (Object[])new Object[]{lhsVar, tupTid.getDeepCopyName(lhsVar, currentClass, false)}));
        lines.add(Strings.fmt((String)"%s.var%d = %s;", (Object[])new Object[]{lhsVar, fieldIndex, tmpVar}));
    }
}

