/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.tokens.AIdentifier;
import org.eclipse.escet.cif.parser.ast.types.ABoolType;
import org.eclipse.escet.cif.parser.ast.types.ACifType;
import org.eclipse.escet.cif.parser.ast.types.ADictType;
import org.eclipse.escet.cif.parser.ast.types.ADistType;
import org.eclipse.escet.cif.parser.ast.types.AField;
import org.eclipse.escet.cif.parser.ast.types.AFuncType;
import org.eclipse.escet.cif.parser.ast.types.AIntType;
import org.eclipse.escet.cif.parser.ast.types.AListType;
import org.eclipse.escet.cif.parser.ast.types.ANamedType;
import org.eclipse.escet.cif.parser.ast.types.ARealType;
import org.eclipse.escet.cif.parser.ast.types.ASetType;
import org.eclipse.escet.cif.parser.ast.types.AStringType;
import org.eclipse.escet.cif.parser.ast.types.ATupleType;
import org.eclipse.escet.cif.parser.ast.types.AVoidType;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifTypesTypeChecker {
    private CifTypesTypeChecker() {
    }

    public static CifType transCifType(ACifType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        if (type instanceof ABoolType) {
            BoolType rslt = CifConstructors.newBoolType();
            rslt.setPosition(type.position);
            return rslt;
        }
        if (type instanceof AIntType) {
            return CifTypesTypeChecker.transIntType((AIntType)type, scope, tchecker);
        }
        if (type instanceof ARealType) {
            RealType rslt = CifConstructors.newRealType();
            rslt.setPosition(type.position);
            return rslt;
        }
        if (type instanceof AStringType) {
            StringType rslt = CifConstructors.newStringType();
            rslt.setPosition(type.position);
            return rslt;
        }
        if (type instanceof AListType) {
            return CifTypesTypeChecker.transListType((AListType)type, scope, tchecker);
        }
        if (type instanceof ASetType) {
            return CifTypesTypeChecker.transSetType((ASetType)type, scope, tchecker);
        }
        if (type instanceof AFuncType) {
            return CifTypesTypeChecker.transFuncType((AFuncType)type, scope, tchecker);
        }
        if (type instanceof ADictType) {
            return CifTypesTypeChecker.transDictType((ADictType)type, scope, tchecker);
        }
        if (type instanceof ATupleType) {
            return CifTypesTypeChecker.transTupleType((ATupleType)type, scope, tchecker);
        }
        if (type instanceof ADistType) {
            return CifTypesTypeChecker.transDistType((ADistType)type, scope, tchecker);
        }
        if (type instanceof ANamedType) {
            return CifTypesTypeChecker.transNamedType((ANamedType)type, scope, tchecker);
        }
        if (type instanceof AVoidType) {
            VoidType rslt = CifConstructors.newVoidType();
            rslt.setPosition(type.position);
            return rslt;
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    private static IntType transIntType(AIntType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        int upper;
        int lower;
        if (type.range == null) {
            IntType rslt = CifConstructors.newIntType();
            rslt.setPosition(type.position);
            return rslt;
        }
        Expression lowerExpr = CifExprsTypeChecker.transExpression(type.range.lower, (CifType)CifExprsTypeChecker.INT_TYPE_HINT, scope, null, tchecker);
        Expression upperExpr = CifExprsTypeChecker.transExpression(type.range.upper, (CifType)CifExprsTypeChecker.INT_TYPE_HINT, scope, null, tchecker);
        CifType lowerType = CifTypeUtils.normalizeType((CifType)lowerExpr.getType());
        CifType upperType = CifTypeUtils.normalizeType((CifType)upperExpr.getType());
        if (!(lowerType instanceof IntType)) {
            tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NON_INT, lowerExpr.getPosition(), "lower", "an integer");
            throw new SemanticException();
        }
        if (!(upperType instanceof IntType)) {
            tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NON_INT, upperExpr.getPosition(), "upper", "an integer");
            throw new SemanticException();
        }
        CifExprsTypeChecker.checkStaticEvaluable(lowerExpr, tchecker);
        CifExprsTypeChecker.checkStaticEvaluable(upperExpr, tchecker);
        try {
            lower = (Integer)CifEvalUtils.eval((Expression)lowerExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
            throw new SemanticException();
        }
        try {
            upper = (Integer)CifEvalUtils.eval((Expression)upperExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
            throw new SemanticException();
        }
        if (lower > upper) {
            tchecker.addProblem(ErrMsg.EMPTY_TYPE_RANGE, type.position, "integer", Numbers.formatNumber((int)lower), Numbers.formatNumber((int)upper));
            throw new SemanticException();
        }
        IntType rslt = CifConstructors.newIntType();
        rslt.setPosition(type.position);
        rslt.setLower(Integer.valueOf(lower));
        rslt.setUpper(Integer.valueOf(upper));
        return rslt;
    }

    private static ListType transListType(AListType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        CifType etype;
        ListType rslt = CifConstructors.newListType();
        rslt.setPosition(type.position);
        if (type.range != null) {
            int lower;
            Expression lowerExpr = CifExprsTypeChecker.transExpression(type.range.lower, (CifType)CifExprsTypeChecker.INT_TYPE_HINT, scope, null, tchecker);
            CifType lowerType = CifTypeUtils.normalizeType((CifType)lowerExpr.getType());
            if (!(lowerType instanceof IntType)) {
                tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NON_INT, lowerExpr.getPosition(), "lower", "a list");
                throw new SemanticException();
            }
            CifExprsTypeChecker.checkStaticEvaluable(lowerExpr, tchecker);
            try {
                lower = (Integer)CifEvalUtils.eval((Expression)lowerExpr, (boolean)false);
            }
            catch (CifEvalException e) {
                tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                throw new SemanticException();
            }
            if (lower < 0) {
                tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NEG, lowerExpr.getPosition(), "lower", Numbers.formatNumber((int)lower), "a list");
                throw new SemanticException();
            }
            boolean hasUpper = false;
            int upper = 0;
            if (type.range.upper != null) {
                hasUpper = true;
                Expression upperExpr = CifExprsTypeChecker.transExpression(type.range.upper, (CifType)CifExprsTypeChecker.INT_TYPE_HINT, scope, null, tchecker);
                CifType upperType = CifTypeUtils.normalizeType((CifType)upperExpr.getType());
                if (!(upperType instanceof IntType)) {
                    tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NON_INT, upperExpr.getPosition(), "upper", "a list");
                    throw new SemanticException();
                }
                CifExprsTypeChecker.checkStaticEvaluable(upperExpr, tchecker);
                try {
                    upper = (Integer)CifEvalUtils.eval((Expression)upperExpr, (boolean)false);
                }
                catch (CifEvalException e) {
                    tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                    throw new SemanticException();
                }
                if (upper < 0) {
                    tchecker.addProblem(ErrMsg.TYPE_RANGE_BOUND_NEG, upperExpr.getPosition(), "upper", Numbers.formatNumber((int)upper), "a list");
                    throw new SemanticException();
                }
            }
            if (hasUpper && lower > upper) {
                tchecker.addProblem(ErrMsg.EMPTY_TYPE_RANGE, type.position, "list", Numbers.formatNumber((int)lower), Numbers.formatNumber((int)upper));
                throw new SemanticException();
            }
            rslt.setLower(Integer.valueOf(lower));
            rslt.setUpper(Integer.valueOf(hasUpper ? upper : lower));
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)(etype = CifTypesTypeChecker.transCifType(type.elementType, scope, tchecker)))) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, etype.getPosition(), CifTextUtils.typeToStr((CifType)etype), "elements of lists");
            throw new SemanticException();
        }
        rslt.setElementType(etype);
        return rslt;
    }

    private static SetType transSetType(ASetType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        CifType etype = CifTypesTypeChecker.transCifType(type.elementType, scope, tchecker);
        if (!CifTypeUtils.supportsValueEquality((CifType)etype)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, etype.getPosition(), CifTextUtils.typeToStr((CifType)etype), "elements of sets");
            throw new SemanticException();
        }
        SetType stype = CifConstructors.newSetType();
        stype.setPosition(type.position);
        stype.setElementType(etype);
        return stype;
    }

    private static FuncType transFuncType(AFuncType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        CifType rtype = CifTypesTypeChecker.transCifType(type.returnType, scope, tchecker);
        if (CifTypeUtils.hasComponentLikeType((CifType)rtype)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, rtype.getPosition(), CifTextUtils.typeToStr((CifType)rtype), "return values of functions");
            throw new SemanticException();
        }
        List ptypes = Lists.list();
        for (ACifType paramType : type.paramTypes) {
            CifType ptype = CifTypesTypeChecker.transCifType(paramType, scope, tchecker);
            if (CifTypeUtils.hasComponentLikeType((CifType)ptype)) {
                tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, ptype.getPosition(), CifTextUtils.typeToStr((CifType)ptype), "parameters of functions");
                throw new SemanticException();
            }
            ptypes.add(ptype);
        }
        FuncType ftype = CifConstructors.newFuncType();
        ftype.setPosition(type.position);
        ftype.setReturnType(rtype);
        ftype.getParamTypes().addAll((Collection)ptypes);
        return ftype;
    }

    private static DictType transDictType(ADictType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        CifType ktype = CifTypesTypeChecker.transCifType(type.keyType, scope, tchecker);
        if (!CifTypeUtils.supportsValueEquality((CifType)ktype)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, ktype.getPosition(), CifTextUtils.typeToStr((CifType)ktype), "keys of dictionaries");
            throw new SemanticException();
        }
        CifType vtype = CifTypesTypeChecker.transCifType(type.valueType, scope, tchecker);
        if (CifTypeUtils.hasComponentLikeType((CifType)vtype)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, vtype.getPosition(), CifTextUtils.typeToStr((CifType)vtype), "values of dictionaries");
            throw new SemanticException();
        }
        DictType dtype = CifConstructors.newDictType();
        dtype.setPosition(type.position);
        dtype.setKeyType(ktype);
        dtype.setValueType(vtype);
        return dtype;
    }

    private static TupleType transTupleType(ATupleType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        List fields = Lists.list();
        Map fieldMap = Maps.map();
        for (AField afield : type.fields) {
            CifType ftype = CifTypesTypeChecker.transCifType(afield.type, scope, tchecker);
            if (CifTypeUtils.hasComponentLikeType((CifType)ftype)) {
                tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, ftype.getPosition(), CifTextUtils.typeToStr((CifType)ftype), "fields of tuples");
                throw new SemanticException();
            }
            for (AIdentifier id : afield.names) {
                Field field = CifConstructors.newField();
                field.setName(id.id);
                field.setPosition(id.position);
                field.setType((CifType)EMFHelper.deepclone((EObject)ftype));
                fields.add(field);
                Position prevPos = (Position)fieldMap.get(id.id);
                if (prevPos != null) {
                    tchecker.addProblem(ErrMsg.DUPLICATE_FIELD_NAME, prevPos, id.id);
                    tchecker.addProblem(ErrMsg.DUPLICATE_FIELD_NAME, id.position, id.id);
                    throw new SemanticException();
                }
                fieldMap.put(id.id, id.position);
            }
        }
        Assert.check((!fields.isEmpty() ? 1 : 0) != 0);
        if (fields.size() == 1) {
            tchecker.addProblem(ErrMsg.TUPLE_TYPE_ONE_FIELD, type.position, new String[0]);
            throw new SemanticException();
        }
        TupleType ttype = CifConstructors.newTupleType();
        ttype.setPosition(type.position);
        ttype.getFields().addAll((Collection)fields);
        return ttype;
    }

    private static DistType transDistType(ADistType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        CifType stype = CifTypesTypeChecker.transCifType(type.sampleType, scope, tchecker);
        CifType nstype = CifTypeUtils.normalizeType((CifType)stype);
        if (nstype instanceof BoolType || nstype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)nstype)) || nstype instanceof RealType) {
            DistType dtype = CifConstructors.newDistType();
            dtype.setPosition(type.position);
            dtype.setSampleType(stype);
            return dtype;
        }
        tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, stype.getPosition(), CifTextUtils.typeToStr((CifType)stype), "samples of distributions");
        throw new SemanticException();
    }

    private static CifType transNamedType(ANamedType type, SymbolScope<?> scope, CifTypeChecker tchecker) {
        SymbolTableEntry entry = scope.resolve(type.position, type.name.name, tchecker);
        if (!(entry instanceof EnumDeclWrap || entry instanceof TypeDeclWrap || entry instanceof AutDefScope || entry instanceof GroupDefScope)) {
            tchecker.addProblem(ErrMsg.INVALID_TYPE_REF, type.position, entry.getAbsName());
            throw new SemanticException();
        }
        entry.tcheckForUse();
        return scope.resolveAsType(type.name.name, type.position, "", tchecker);
    }
}

