/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.chi.runtime.data.DefinitionKind;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class SimulationResult {
    public final DefinitionKind kind;
    public final boolean usedRandom;
    public final long seed;
    public final ExitReason exitReason;
    public final double endTime;
    public final Object exitValue;

    public SimulationResult(DefinitionKind kind, boolean usedRandom, long seed, ExitReason exitReason, double endTime, Object exitValue) {
        Assert.check((exitReason != null ? 1 : 0) != 0);
        this.kind = kind;
        this.usedRandom = usedRandom;
        this.seed = seed;
        this.exitReason = exitReason;
        this.endTime = endTime;
        this.exitValue = exitValue;
    }

    public String getInfo(boolean seedProvided) {
        String msg = "";
        if (this.kind.equals((Object)DefinitionKind.MODEL)) {
            switch (this.exitReason) {
                case ABORTED: {
                    msg = Strings.fmt((String)"Simulation aborted at time %.2f", (Object[])new Object[]{this.endTime});
                    break;
                }
                case ERROR: {
                    msg = Strings.fmt((String)"Simulation runtime error at time %.2f", (Object[])new Object[]{this.endTime});
                    break;
                }
                case DEADLOCKED: {
                    msg = Strings.fmt((String)"Deadlock detected at time %.2f", (Object[])new Object[]{this.endTime});
                    break;
                }
                case FINISHED: {
                    msg = Strings.fmt((String)"All processes finished at time %.2f", (Object[])new Object[]{this.endTime});
                    break;
                }
                case EXITED: {
                    msg = Strings.fmt((String)"Simulation performed exit at time %.2f", (Object[])new Object[]{this.endTime});
                    break;
                }
                default: {
                    Assert.fail((String)"Unexpected fail reason.");
                }
            }
            if (this.usedRandom) {
                msg = String.valueOf(msg) + Strings.fmt((String)" (initial seed was %d)", (Object[])new Object[]{this.seed});
            } else if (seedProvided) {
                msg = String.valueOf(msg) + Strings.fmt((String)" (seed %d was not used)", (Object[])new Object[]{this.seed});
            }
            msg = String.valueOf(msg) + ".";
        } else {
            Assert.check((boolean)this.kind.equals((Object)DefinitionKind.XPER));
            if (this.usedRandom) {
                msg = Strings.fmt((String)"initial seed was %d.", (Object[])new Object[]{this.seed});
            } else if (seedProvided) {
                msg = Strings.fmt((String)"seed %d was not used.", (Object[])new Object[]{this.seed});
            }
            msg = this.exitReason.equals((Object)ExitReason.ABORTED) ? Strings.fmt((String)"Simulation was aborted (%s)", (Object[])new Object[]{msg}) : StringUtils.capitalize((String)msg);
        }
        if (this.exitValue != null) {
            if (!msg.isEmpty()) {
                msg = String.valueOf(msg) + "\n";
            }
            msg = String.valueOf(msg) + "Simulation ended with exit value " + this.exitValue.toString() + ".";
        }
        return msg;
    }

    public static enum ExitReason {
        ABORTED,
        DEADLOCKED,
        ERROR,
        EXITED,
        FINISHED;

    }
}

