/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.perspective;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ESCETPerspectiveEnabler
implements IStartup {
    public void earlyStartup() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String pref = store.getString("org.eclipse.escet.perspective.enabled");
        boolean alreadyEnabled = pref.equals("true");
        if (alreadyEnabled) {
            return;
        }
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ESCETPerspectiveEnabler.this.activatePerspective("org.eclipse.escet.perspective.ESCETPerspective");
            }
        });
        store.setValue("org.eclipse.escet.perspective.enabled", "true");
    }

    private void activatePerspective(String perspectiveId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
        if (registry == null) {
            return;
        }
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(perspectiveId);
        if (perspective == null) {
            return;
        }
        page.setPerspective(perspective);
    }
}

