/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.StateLessObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FunctionTypeID
extends StateLessObjectTypeID {
    private String className;

    public FunctionTypeID(List<TypeID> args, CodeGeneratorContext ctxt) {
        super(false, TypeID.TypeKind.FUNCTION, args);
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("FunctionType");
            ctxt.addTypeName(this, this.className);
            this.addSelf(ctxt);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        String txt = "func " + ((TypeID)Lists.last((List)this.subTypes)).getTypeText() + "(";
        int i = 0;
        while (i < this.subTypes.size() - 1) {
            if (i > 0) {
                txt = String.valueOf(txt) + ", ";
            }
            txt = String.valueOf(txt) + ((TypeID)this.subTypes.get(i)).getTypeText();
            ++i;
        }
        return String.valueOf(txt) + ")";
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    @Override
    public String getSimplestJavaValue() {
        return "null";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentfile) {
        if (expr instanceof StdLibFunctionReference) {
            Assert.fail((String)"Implement stdlib FunctionTypeID.convertExprNode()");
        } else if (expr instanceof FunctionReference) {
            FunctionReference fref = (FunctionReference)expr;
            String jName = ctxt.getDefinition((PositionObject)fref.getFunction());
            return new SimpleExpression("spec.instance" + jName, (PositionObject)expr);
        }
        Assert.fail((String)("Implement convertExprNode(" + expr.toString() + ") of FunctionTypeID"));
        return null;
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return "new " + this.getJavaClassType() + "(spec, chiCoordinator)";
    }

    private void addSelf(CodeGeneratorContext ctxt) {
        JavaMethod cM = null;
        String imports = null;
        List ifaces = null;
        if (this.subTypes.size() == 3 && ((TypeID)this.subTypes.get((int)2)).kind.equals((Object)TypeID.TypeKind.BOOL) && ((TypeID)this.subTypes.get(0)).equals(this.subTypes.get(1))) {
            String jc = ((TypeID)this.subTypes.get(0)).getJavaClassType();
            int idx = jc.lastIndexOf(46);
            if (idx != -1) {
                imports = jc;
                jc = jc.substring(idx + 1);
            }
            cM = new JavaMethod("public int compare(" + jc + " x, " + jc + " y)");
            cM.lines.add("if (!compute(null, x, y)) return 1;");
            cM.lines.add("if (!compute(null, y, x)) return -1;");
            cM.lines.add("return 0;");
            ifaces = Lists.list((Object)("Comparator<" + jc + ">"));
        }
        JavaClass cls = ctxt.addJavaClass(this.className, false, null, ifaces);
        if (imports != null) {
            cls.addImport(imports, false);
        }
        String args = String.valueOf(ctxt.specName) + " spec, ChiCoordinator chiCoordinator";
        JavaMethod jm = new JavaMethod("public " + this.className + "(" + args + ")");
        jm.lines.add("this.spec = spec;");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        cls.addVariable(String.valueOf(ctxt.specName) + " spec;");
        cls.addVariable("ChiCoordinator chiCoordinator;");
        String posdata = "org.eclipse.escet.chi.runtime.data.PositionData";
        posdata = posdata.substring(posdata.lastIndexOf(46) + 1);
        String argsString = "List<" + posdata + "> positionStack";
        cls.addImport("java.util.List", false);
        cls.addImport("org.eclipse.escet.chi.runtime.data.PositionData", false);
        int i = 0;
        while (i < this.subTypes.size() - 1) {
            if (!argsString.isEmpty()) {
                argsString = String.valueOf(argsString) + ", ";
            }
            argsString = String.valueOf(argsString) + Strings.fmt((String)"%s arg%d", (Object[])new Object[]{((TypeID)this.subTypes.get(i)).getJavaType(), i});
            ++i;
        }
        JavaMethod runMethod = new JavaMethod("public", ((TypeID)this.subTypes.get(i)).getJavaType(), "compute", argsString, null);
        runMethod.lines.add("throw new ChiSimulatorException(\"Trying to call a function through an uninitialized function variable.\");");
        cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        cls.addMethod(runMethod);
        if (cM != null) {
            cls.addMethod(cM);
            cls.addImport("java.util.Comparator", false);
        }
    }
}

