/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.CoordObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.SetExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SetTypeID
extends CoordObjectTypeID {
    private String className;

    public SetTypeID(TypeID elmTid, CodeGeneratorContext ctxt) {
        super(TypeID.TypeKind.SET, Lists.list((Object)elmTid));
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("SetType");
            ctxt.addTypeName(this, this.className);
            this.addSelf(ctxt);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        return "set " + ((TypeID)Lists.first((List)this.subTypes)).getTypeText();
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof SetExpression) {
            SetExpression le = (SetExpression)expr;
            String setName = ctxt.makeUniqueName("set");
            List lines = Lists.list();
            String clsName = this.getJavaClassType();
            String line = Strings.fmt((String)"%s %s = new %s(chiCoordinator, %d);", (Object[])new Object[]{clsName, setName, clsName, le.getElements().size()});
            lines.add(line);
            for (Expression elm : le.getElements()) {
                ExpressionBase eb = ExpressionBase.convertExpression(elm, ctxt, currentFile);
                lines.addAll(eb.getCode());
                line = Strings.fmt((String)"%s.add(%s);", (Object[])new Object[]{setName, eb.getValue()});
                lines.add(line);
            }
            return ExpressionBase.makeExpression(lines, setName, (PositionObject)expr);
        }
        if (expr instanceof BinaryExpression) {
            String text;
            BinaryExpression binexp = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexp.getLeft(), ctxt, currentFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexp.getRight(), ctxt, currentFile);
            switch (binexp.getOp()) {
                case ADDITION: {
                    text = Strings.fmt((String)"%s.unionSet((%s), (%s))", (Object[])new Object[]{this.className, left.getValue(), right.getValue()});
                    break;
                }
                case SUBTRACTION: {
                    text = Strings.fmt((String)"%s.subtractSet((%s), (%s))", (Object[])new Object[]{this.className, left.getValue(), right.getValue()});
                    break;
                }
                case MULTIPLICATION: {
                    text = Strings.fmt((String)"%s.intersectSet((%s), (%s))", (Object[])new Object[]{this.className, left.getValue(), right.getValue()});
                    break;
                }
                case ELEMENT_TEST: {
                    text = Strings.fmt((String)"(%s).contains(%s)", (Object[])new Object[]{right.getValue(), left.getValue()});
                    break;
                }
                case SUBSET: {
                    text = Strings.fmt((String)"(%s).containsAll(%s)", (Object[])new Object[]{right.getValue(), left.getValue()});
                    break;
                }
                default: {
                    Assert.fail((String)("Unimplemented binary set operator " + expr.toString()));
                    return null;
                }
            }
            if (!left.getCode().isEmpty() || !right.getCode().isEmpty()) {
                List lines = Lists.list();
                lines.addAll(left.getCode());
                lines.addAll(right.getCode());
                return new CodeExpression(lines, text, (PositionObject)expr);
            }
            return new SimpleExpression(text, (PositionObject)expr);
        }
        Assert.fail((String)("Implement " + expr.toString() + " in SetTypeID.convertExprNode"));
        return null;
    }

    private void addSelf(CodeGeneratorContext ctxt) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmClassname = elmTid.getJavaClassType();
        String iface = "LinkedHashSet<" + elmClassname + ">";
        JavaClass cls = new JavaClass("", false, this.className, iface, null);
        cls.addImport("java.util.LinkedHashSet", false);
        cls.addVariable("private final ChiCoordinator chiCoordinator;");
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        this.addConstructors(cls, ctxt);
        this.addSetFunctions(cls);
        this.addReadWrite(cls);
        ctxt.addClass(cls);
    }

    private void addConstructors(JavaFile cls, CodeGeneratorContext ctxt) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        String elmClassname = elmTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator)");
        jm.lines.add("this(chiCoordinator, 0);");
        cls.addMethod(jm);
        jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator, int size)");
        jm.lines.add("super(size);");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        boolean elmHasDeepcopy = elmTid.hasDeepCopy();
        jm = new JavaMethod("public " + this.className + "(" + this.className + " orig, boolean deepCopy)");
        jm.lines.add("super(orig.size());");
        jm.lines.add("this.chiCoordinator = orig.chiCoordinator;");
        if (!elmHasDeepcopy) {
            jm.lines.add("addAll(orig);");
        } else {
            String deepCopy = elmTid.getDeepCopyName("val", cls, true);
            jm.lines.add("if (!deepCopy) {");
            jm.lines.add("   addAll(orig);");
            jm.lines.add("} else {");
            jm.lines.add("    for (%s val: orig) {", new Object[]{elmTypename});
            jm.lines.add("        add(%s);", new Object[]{deepCopy});
            jm.lines.add("    }");
            jm.lines.add("}");
        }
        cls.addMethod(jm);
        List fields = Lists.list((Object[])new String[]{"value", "set"});
        List tids = Lists.list((Object[])new TypeID[]{elmTid, this});
        TypeID tupleTid = TypeIDCreation.createTupleTypeID(fields, tids, ctxt);
        String tupName = tupleTid.getJavaClassType();
        jm = new JavaMethod("public " + tupName + " pop()");
        jm.lines.add("if (isEmpty()) throw new ChiSimulatorException(\"Cannot pop value from an empty set.\");");
        jm.lines.add("%s res = new %s(chiCoordinator);", new Object[]{tupName, tupName});
        jm.lines.add("res.var1 = new %s(this, false);", new Object[]{this.className});
        jm.lines.add("Iterator<%s> iter = res.var1.iterator();", new Object[]{elmClassname});
        jm.lines.add("res.var0 = iter.next();");
        jm.lines.add("iter.remove();");
        jm.lines.add("return res;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        cls.addImport("java.util.Iterator", false);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public static " + this.className + " removeElement(" + this.className + " set, " + elmTypename + " value)");
        jm.lines.add(String.valueOf(this.className) + " res = new %s(set, false);", new Object[]{this.className});
        jm.lines.add("if (res.remove(value)) return res;");
        jm.lines.add("return set;");
        cls.addMethod(jm);
    }

    private void addSetFunctions(JavaFile cls) {
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        String elmClassname = elmTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public static " + this.className + " unionSet(" + this.className + " left, " + this.className + " right)");
        jm.lines.add("%s result = new %s(left.chiCoordinator, left.size() + right.size());", new Object[]{this.className, this.className});
        jm.lines.add("result.addAll(left);");
        jm.lines.add("result.addAll(right);");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        jm = new JavaMethod("public static " + this.className + " subtractSet(" + this.className + " left, " + this.className + " right)");
        jm.lines.add("// Construct a result with an optimistic size.");
        jm.lines.add("%s result = new %s(left.chiCoordinator, left.size());", new Object[]{this.className, this.className});
        jm.lines.add();
        jm.lines.add("for (%s val: left) {", new Object[]{elmTypename});
        jm.lines.add("    if (!right.contains(val)) result.add(val);");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public static " + this.className + " intersectSet(" + this.className + " left, " + this.className + " right)");
        jm.lines.add("%s result;", new Object[]{this.className});
        jm.lines.add("int sz = left.size();");
        jm.lines.add("if (sz > right.size()) {");
        jm.lines.add("    sz = right.size();");
        jm.lines.add("    result = new %s(left.chiCoordinator, sz);", new Object[]{this.className});
        jm.lines.add("    for (%s val: right) {", new Object[]{elmTypename});
        jm.lines.add("        if (left.contains(val)) result.add(val);");
        jm.lines.add("    }");
        jm.lines.add("} else {");
        jm.lines.add("    result = new %s(left.chiCoordinator, sz);", new Object[]{this.className});
        jm.lines.add("    for (%s val: left) {", new Object[]{elmTypename});
        jm.lines.add("        if (right.contains(val)) result.add(val);");
        jm.lines.add("    }");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        String smallestText = null;
        String biggestText = null;
        if (elmTid.kind == TypeID.TypeKind.INT || elmTid.kind == TypeID.TypeKind.REAL) {
            smallestText = "result > value";
            biggestText = "result < value";
        } else if (elmTid.kind == TypeID.TypeKind.STRING) {
            smallestText = "result.compareTo(value) > 0";
            biggestText = "result.compareTo(value) < 0";
        }
        if (smallestText != null) {
            jm = new JavaMethod("public " + elmTypename + " getMinimum()");
            jm.lines.add("%s result = null;", new Object[]{elmClassname});
            jm.lines.add("for (%s value: this) {", new Object[]{elmClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{smallestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a smallest value in an empty set.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
        if (biggestText != null) {
            jm = new JavaMethod("public " + elmTypename + " getMaximum()");
            jm.lines.add("%s result = null;", new Object[]{elmClassname});
            jm.lines.add("for (%s value: this) {", new Object[]{elmClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{biggestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a biggest value in an empty set.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
    }

    private void addReadWrite(JavaFile cls) {
        if (!this.isPrintable()) {
            return;
        }
        TypeID elmTid = (TypeID)Lists.first((List)this.subTypes);
        String elmTypename = elmTid.getJavaType();
        String elmClassname = elmTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public static " + this.className + " read(ChiCoordinator chiCoordinator, ChiFileHandle stream)");
        jm.lines.add(String.valueOf(this.className) + " result = new %s(chiCoordinator);", new Object[]{this.className});
        jm.lines.add();
        jm.lines.add("stream.expectCharacter('{');");
        jm.lines.add("for (;;) {");
        jm.lines.add("    %s elm = %s;", new Object[]{elmTypename, elmTid.getReadName("stream", cls)});
        jm.lines.add("    result.add(elm);");
        jm.lines.add("    int ch = stream.expectCharacter(',', '}');");
        jm.lines.add("    if (ch == '}') break;");
        jm.lines.add("    if (ch == ',') continue;");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public void write(ChiFileHandle stream)");
        jm.lines.add("stream.write(\"{\");");
        jm.lines.add("boolean first = true;");
        jm.lines.add("for (%s val: this) {", new Object[]{elmClassname});
        jm.lines.add("    if (!first) stream.write(\", \");");
        jm.lines.add("    first = false;");
        jm.lines.add("    " + elmTid.getWriteName("stream", "val", cls));
        jm.lines.add("}");
        jm.lines.add("stream.write(\"}\");");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        jm = new JavaMethod("public String toString()");
        jm.lines.add("ChiWriteMemoryFile mem = new ChiWriteMemoryFile();");
        jm.lines.add("write(mem);");
        jm.lines.add("return mem.getData();");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile", false);
    }
}

