/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;
import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.escet.setext.texteditorbase.GenericSourceViewerConfiguration;
import org.eclipse.escet.setext.texteditorbase.GenericTextEditorFolding;
import org.eclipse.escet.setext.texteditorbase.scanners.GenericPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class GenericTextEditor<T1, T2>
extends TextEditor
implements IDocumentListener,
IPartListener {
    private static final boolean DEBUG_TIMING = false;
    private static final boolean DEBUG_SCANNER = false;
    private static final boolean DEBUG_PARSER = false;
    private static final String PRESENTATION_ACTION_SET_ID = "org.eclipse.ui.edit.text.actionSet.presentation";
    public final String singleLineCommentChars;
    public static final boolean CONTINUOUS_VALIDATION = true;
    private final ColorManager colorManager;
    private final GenericPartitionScanner scanner;
    private final Class<? extends Parser<T1>> parserClass;
    private final Class<? extends TypeChecker<T1, T2>> typeCheckerClass;
    private final String syntaxProblemMarkerId;
    private final String semanticProblemMarkerId;
    private final GenericTextEditorFolding folding = new GenericTextEditorFolding(this);
    private IFileEditorInput input;
    protected final Object validationLock = new Object();
    protected final AtomicInteger validationCount = new AtomicInteger(0);

    public GenericTextEditor(GenericPartitionScanner scanner, GenericSourceViewerConfiguration viewerConfig, Class<? extends Parser<T1>> parserClass, Class<? extends TypeChecker<T1, T2>> typeCheckerClass, String syntaxProblemMarkerId, String semanticProblemMarkerId, String singleLineCommentChars) {
        this.scanner = scanner;
        this.parserClass = parserClass;
        this.typeCheckerClass = typeCheckerClass;
        this.syntaxProblemMarkerId = syntaxProblemMarkerId;
        this.semanticProblemMarkerId = semanticProblemMarkerId;
        this.singleLineCommentChars = singleLineCommentChars;
        this.colorManager = new ColorManager();
        viewerConfig.setColorManager(this.colorManager);
        viewerConfig.setPartitionScanner(scanner);
        viewerConfig.setPreferenceStore(this.getPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)viewerConfig);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IWorkbenchPage page = site.getPage();
        page.showActionSet(PRESENTATION_ACTION_SET_ID);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        if (this.input != null) {
            Assert.check((boolean)(newInput instanceof IFileEditorInput));
            IFileEditorInput newFileInput = (IFileEditorInput)newInput;
            String newFileName = newFileInput.getName();
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editor = registry.getDefaultEditor(newFileName);
            String curEditorId = this.getEditorSite().getId();
            String newEditorId = editor.getId();
            boolean sameEditor = curEditorId.equals(newEditorId);
            if (!sameEditor) {
                IFile newFile = newFileInput.getFile();
                try {
                    newFile.deleteMarkers(null, true, 0);
                }
                catch (CoreException ex) {
                    String msg = "Failed to delete problem markers.";
                    throw new RuntimeException(msg, ex);
                }
            }
            this.close(true);
            this.folding.save(newFileInput);
            this.getSite().getPage().openEditor(newInput, editor.getId());
            return;
        }
        super.doSetInput(newInput);
        IDocument document = this.getDocumentProvider().getDocument((Object)newInput);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)this.scanner, this.scanner.getTypes());
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        Assert.notNull((Object)newInput);
        if (!(newInput instanceof IFileEditorInput)) {
            String loc = newInput instanceof FileStoreEditorInput ? ((FileStoreEditorInput)newInput).getURI().toString() : newInput.getName();
            String title = Strings.fmt((String)"Could not open an editor for \"%s\": it is not a file, the file is not on a local file system, or the file is not part of any workspace project.", (Object[])new Object[]{loc});
            String pluginName = ((Object)((Object)this)).getClass().getName();
            Status status = new Status(4, pluginName, title);
            throw new CoreException((IStatus)status);
        }
        this.input = (IFileEditorInput)newInput;
        this.getDocumentProvider().getDocument((Object)newInput).addDocumentListener((IDocumentListener)this);
        this.folding.load();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.folding.createPartControl(this.getSourceViewer(), this.getAnnotationAccess(), this.getSharedColors());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.stripTrailingWhitespace();
        this.addNewLineAtEof();
        super.doSave(progressMonitor);
    }

    public void doSaveAs() {
        this.stripTrailingWhitespace();
        this.addNewLineAtEof();
        super.doSaveAs();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        DelayedValidate t = new DelayedValidate(this.validationCount.incrementAndGet());
        t.setName(Strings.fmt((String)"%s-DelayedValidateThread-%d", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), t.getId()}));
        t.start();
    }

    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        this.validate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(boolean acquireLock) {
        if (acquireLock) {
            Object object = this.validationLock;
            synchronized (object) {
                this.validate(false);
                return;
            }
        }
        try {
            this.validateInternal();
        }
        catch (Throwable ex) {
            String title = "Validation crashed. Please report this to the Eclipse ESCET development team.";
            String pluginName = ((Object)((Object)this)).getClass().getName();
            Status status = new Status(4, pluginName, 0, title, ex);
            int style = 3;
            StatusManager.getManager().handle((IStatus)status, style);
        }
    }

    private void validateInternal() {
        Assert.notNull((Object)this.input);
        long startTime = System.nanoTime();
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        final IDocument document = docProvider.getDocument((Object)this.input);
        if (document == null) {
            return;
        }
        IFile file = this.input.getFile();
        if (!file.exists()) {
            return;
        }
        final Display display = this.getSite().getShell().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        final String[] text = new String[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                text[0] = document.get();
            }
        });
        try {
            file.deleteMarkers(this.syntaxProblemMarkerId, true, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            file.deleteMarkers(this.semanticProblemMarkerId, true, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IPath fileLocation = file.getLocation();
        if (fileLocation == null) {
            return;
        }
        String absPath = fileLocation.toOSString();
        Object parseRslt = null;
        if (this.parserClass != null) {
            Parser<T1> parser;
            block35: {
                try {
                    parser = this.parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                parser.foldRanges = Lists.list();
                DebugMode debugMode = DebugMode.getDebugMode((boolean)false, (boolean)false);
                if (debugMode != DebugMode.NONE) {
                    AppEnv.registerSimple();
                    Options.set(OutputModeOption.class, (Object)OutputMode.NORMAL);
                }
                try {
                    try {
                        parseRslt = parser.parseString(text[0], absPath, debugMode);
                    }
                    catch (SyntaxException ex) {
                        this.addMarker(document, file, ex.getPosition(), ex.getMessage(), this.syntaxProblemMarkerId, 2);
                        if (debugMode != DebugMode.NONE) {
                            AppEnv.unregisterApplication();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (debugMode != DebugMode.NONE) {
                        AppEnv.unregisterApplication();
                    }
                    throw throwable;
                }
                if (debugMode != DebugMode.NONE) {
                    AppEnv.unregisterApplication();
                }
            }
            if (parseRslt != null) {
                this.folding.fixFolds(parser.foldRanges, text[0]);
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        GenericTextEditor.this.folding.updateFolds(parser.foldRanges, text[0]);
                    }
                });
            }
        }
        TypeChecker<T1, T2> tchecker = null;
        try {
            if (parseRslt != null && this.typeCheckerClass != null) {
                tchecker = this.typeCheckerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + this.typeCheckerClass, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + this.typeCheckerClass, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + this.typeCheckerClass, e);
        }
        if (tchecker != null) {
            tchecker.setSourceFilePath(absPath);
            tchecker.typeCheck(parseRslt);
            for (SemanticProblem problem : tchecker.getProblems()) {
                int severity;
                switch (problem.severity) {
                    case WARNING: {
                        severity = 1;
                        break;
                    }
                    case ERROR: {
                        severity = 2;
                        break;
                    }
                    default: {
                        String msg = "Unknown severity: " + problem.severity;
                        throw new RuntimeException(msg);
                    }
                }
                this.addMarker(document, file, problem.position, problem.message, this.semanticProblemMarkerId, severity);
            }
        }
    }

    private void addMarker(IDocument document, IFile file, Position position, String msg, String markerId, int severity) {
        int start = position.getStartOffset();
        int end = position.getEndOffset() + 1;
        if (end >= document.getLength()) {
            Assert.check((start >= 0 ? 1 : 0) != 0);
            end = document.getLength();
            if (start >= end) {
                start = end - 1;
            }
            if (start < 0) {
                start = 0;
                end = 1;
            }
        }
        Assert.check((start < end ? 1 : 0) != 0);
        Map map = Maps.map();
        map.put("lineNumber", position.getStartLine());
        map.put("message", msg);
        map.put("location", Strings.fmt((String)"line %d, column %d", (Object[])new Object[]{position.getStartLine(), position.getStartColumn()}));
        map.put("severity", severity);
        map.put("charStart", start);
        map.put("charEnd", end);
        try {
            MarkerUtilities.createMarker((IResource)file, (Map)map, (String)markerId);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void stripTrailingWhitespace() {
        Assert.notNull((Object)this.input);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        int offset = 0;
        String searchPattern = "[ \t]+$";
        while (offset < document.getLength()) {
            IRegion region;
            try {
                region = adapter.find(offset, searchPattern, true, false, false, true);
            }
            catch (BadLocationException ex) {
                String msg = "Strip trailing whitespace find failure.";
                throw new RuntimeException(msg, ex);
            }
            if (region == null) break;
            try {
                adapter.replace("", false);
            }
            catch (BadLocationException ex) {
                String msg = "Strip trailing whitespace replace failure.";
                throw new RuntimeException(msg, ex);
            }
            offset = region.getOffset();
        }
    }

    protected void addNewLineAtEof() {
        String nlChars;
        Assert.notNull((Object)this.input);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        int size = document.getLength();
        if (size == 0) {
            return;
        }
        String lastLine = null;
        int lineCount = document.getNumberOfLines();
        try {
            int lastOffset = document.getLineOffset(lineCount - 1);
            int lastLength = document.getLineLength(lineCount - 1);
            lastLine = document.get(lastOffset, lastLength);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (lastLine.isEmpty()) {
            return;
        }
        try {
            nlChars = document.getLineDelimiter(0);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (nlChars == null) {
            nlChars = Strings.NL;
        }
        try {
            document.replace(size - lastLine.length(), lastLine.length(), String.valueOf(lastLine) + nlChars);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part != this) {
            return;
        }
        this.validate(true);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part != this) {
            return;
        }
        IPartService ps = this.getSite().getWorkbenchWindow().getPartService();
        ps.removePartListener((IPartListener)this);
        this.folding.save(this.input);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private class DelayedValidate
    extends Thread {
        private final int cnt;

        public DelayedValidate(int cnt) {
            this.cnt = cnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected thread interrupt.", e);
            }
            Object object = GenericTextEditor.this.validationLock;
            synchronized (object) {
                if (GenericTextEditor.this.validationCount.get() != this.cnt) {
                    return;
                }
                GenericTextEditor.this.validate(false);
            }
        }
    }
}

