/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.interpreter;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.interpreter.ExecContext;
import org.eclipse.escet.tooldef.interpreter.ToolDefExec;
import org.eclipse.escet.tooldef.interpreter.ToolDefReturnValue;
import org.eclipse.escet.tooldef.metamodel.tooldef.JavaTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.BoolExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.CastExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.DoubleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ListExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapEntry;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NullExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NumberExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ProjectionExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SetExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SliceExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.StringExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolArgument;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.TupleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.runtime.ExitException;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefMap;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefSet;
import org.eclipse.escet.tooldef.runtime.ToolDefTuple;

public class ToolDefEval {
    private ToolDefEval() {
    }

    public static Object eval(Expression expr, ExecContext ctxt) {
        if (expr instanceof BoolExpression) {
            BoolExpression bexpr = (BoolExpression)expr;
            return bexpr.isValue();
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            Object child = ToolDefEval.eval(cexpr.getChild(), ctxt);
            ToolDefType castType = cexpr.getType();
            try {
                return ToolDefEval.evalCast(child, castType);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Can't cast value \"%s\" to type \"%s\".", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)child), ToolDefTextUtils.typeToStr((ToolDefType)castType)});
                if (ex.getMessage() == null) {
                    throw new ToolDefException(msg);
                }
                throw new ToolDefException(msg, (Throwable)ex);
            }
        }
        if (expr instanceof DoubleExpression) {
            DoubleExpression dexpr = (DoubleExpression)expr;
            return Double.parseDouble(dexpr.getValue());
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            ToolDefList rslt = new ToolDefList(lexpr.getElements().size());
            for (Expression elem : lexpr.getElements()) {
                rslt.add(ToolDefEval.eval(elem, ctxt));
            }
            return rslt;
        }
        if (expr instanceof MapExpression) {
            MapExpression mexpr = (MapExpression)expr;
            ToolDefMap rslt = new ToolDefMap(mexpr.getEntries().size());
            for (MapEntry entry : mexpr.getEntries()) {
                Object key = ToolDefEval.eval(entry.getKey(), ctxt);
                Object value = ToolDefEval.eval(entry.getValue(), ctxt);
                rslt.put(key, value);
            }
            return rslt;
        }
        if (expr instanceof NullExpression) {
            return null;
        }
        if (expr instanceof NumberExpression) {
            NumberExpression nexpr = (NumberExpression)expr;
            long value = Long.parseLong(nexpr.getValue());
            if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
                return (int)value;
            }
            return value;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            Object child = ToolDefEval.eval(pexpr.getChild(), ctxt);
            Object idx = ToolDefEval.eval(pexpr.getIndex(), ctxt);
            if (child instanceof String) {
                String str = (String)child;
                int normalizedIdx = (Integer)idx;
                if (normalizedIdx < 0) {
                    normalizedIdx = str.length() + normalizedIdx;
                }
                if (normalizedIdx < 0 || normalizedIdx >= str.length()) {
                    String msg = Strings.fmt((String)"Index out of bounds: %s[%s].", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)str), ToolDefRuntimeUtils.valueToStr((Object)idx)});
                    throw new ToolDefException(msg);
                }
                return str.substring(normalizedIdx, normalizedIdx + 1);
            }
            if (child instanceof ToolDefList) {
                ToolDefList list = (ToolDefList)child;
                int normalizedIdx = (Integer)idx;
                if (normalizedIdx < 0) {
                    normalizedIdx = list.size() + normalizedIdx;
                }
                if (normalizedIdx < 0 || normalizedIdx >= list.size()) {
                    String msg = Strings.fmt((String)"Index out of bounds: %s[%s].", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)list), ToolDefRuntimeUtils.valueToStr((Object)idx)});
                    throw new ToolDefException(msg);
                }
                return list.get(normalizedIdx);
            }
            if (child instanceof ToolDefMap) {
                ToolDefMap map = (ToolDefMap)child;
                if (!map.containsKey(idx)) {
                    String msg = Strings.fmt((String)"Key not found: %s[%s].", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr((Object)map), ToolDefRuntimeUtils.valueToStr((Object)idx)});
                    throw new ToolDefException(msg);
                }
                return map.get(idx);
            }
            if (child instanceof ToolDefTuple) {
                ToolDefTuple tuple = (ToolDefTuple)child;
                return tuple.getValue(((Integer)idx).intValue());
            }
            throw new RuntimeException("Unexpected proj child: " + child);
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            ToolDefSet rslt = new ToolDefSet(sexpr.getElements().size());
            for (Expression elem : sexpr.getElements()) {
                rslt.add(ToolDefEval.eval(elem, ctxt));
            }
            return rslt;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            Object child = ToolDefEval.eval(sexpr.getChild(), ctxt);
            Object begin = null;
            Object end = null;
            if (sexpr.getBegin() != null) {
                begin = ToolDefEval.eval(sexpr.getBegin(), ctxt);
            }
            if (sexpr.getEnd() != null) {
                end = ToolDefEval.eval(sexpr.getEnd(), ctxt);
            }
            if (child instanceof String) {
                int e;
                String str = (String)child;
                Integer beginIndex = (Integer)begin;
                Integer endIndex = (Integer)end;
                int len = str.length();
                int b = beginIndex == null ? 0 : beginIndex;
                int n = e = endIndex == null ? len : endIndex;
                if (b < 0) {
                    b = len + b;
                }
                if (e < 0) {
                    e = len + e;
                }
                if (b < 0) {
                    b = 0;
                }
                if (e < 0) {
                    e = 0;
                }
                if (b > len) {
                    b = len;
                }
                if (e > len) {
                    e = len;
                }
                if (b > e) {
                    b = e;
                }
                return str.substring(b, e);
            }
            if (child instanceof ToolDefList) {
                int e;
                ToolDefList lst = (ToolDefList)child;
                Integer beginIndex = (Integer)begin;
                Integer endIndex = (Integer)end;
                int len = lst.size();
                int b = beginIndex == null ? 0 : beginIndex;
                int n = e = endIndex == null ? len : endIndex;
                if (b < 0) {
                    b = len + b;
                }
                if (e < 0) {
                    e = len + e;
                }
                if (b < 0) {
                    b = 0;
                }
                if (e < 0) {
                    e = 0;
                }
                if (b > len) {
                    b = len;
                }
                if (e > len) {
                    e = len;
                }
                if (b > e) {
                    b = e;
                }
                return lst.subList(b, e);
            }
            throw new RuntimeException("Unexpected slice child: " + child);
        }
        if (expr instanceof StringExpression) {
            StringExpression sexpr = (StringExpression)expr;
            return sexpr.getValue();
        }
        if (expr instanceof ToolInvokeExpression) {
            return ToolDefEval.eval((ToolInvokeExpression)expr, ctxt);
        }
        if (expr instanceof ToolParamExpression) {
            ToolParamExpression tpexpr = (ToolParamExpression)expr;
            return ctxt.getValue((PositionObject)tpexpr.getParam());
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            ToolDefList elems = new ToolDefList(texpr.getElements().size());
            for (Expression elem : texpr.getElements()) {
                elems.add(ToolDefEval.eval(elem, ctxt));
            }
            return ToolDefRuntimeUtils.makeTuple((List)elems);
        }
        if (expr instanceof VariableExpression) {
            VariableExpression vexpr = (VariableExpression)expr;
            return ctxt.getValue((PositionObject)vexpr.getVariable());
        }
        throw new RuntimeException("Unknown/unsupported expr: " + expr);
    }

    private static Object evalCast(Object value, ToolDefType type) {
        type = ToolDefTypeUtils.normalizeType((ToolDefType)type);
        if (value == null) {
            if (type instanceof TypeParamRef) {
                return null;
            }
            if (type.isNullable()) {
                return null;
            }
            String msg = "Can't cast \"null\" to a non-nullable type.";
            throw new ToolDefException(msg);
        }
        if (value instanceof String && type instanceof BoolType) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            throw new ToolDefException("Text is not a boolean value.");
        }
        if (value instanceof String && type instanceof IntType) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException ex) {
                String msg = "Text is not an integer value, or is outside the range of the \"int\" type.";
                throw new ToolDefException(msg);
            }
        }
        if (value instanceof String && type instanceof LongType) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException ex) {
                String msg = "Text is not a long value, or is outside the the range of the \"long\" type.";
                throw new ToolDefException(msg);
            }
        }
        if (value instanceof String && type instanceof DoubleType) {
            try {
                double rslt = Double.parseDouble((String)value);
                if (Double.isNaN(rslt)) {
                    throw new ToolDefException("Text is not a number.");
                }
                if (Double.isInfinite(rslt)) {
                    throw new ToolDefException("Text is an infinite number.");
                }
                if (rslt == -0.0) {
                    rslt = 0.0;
                }
                return rslt;
            }
            catch (NumberFormatException ex) {
                String msg = "Text is not a double value, or is outside the the range of the \"double\" type.";
                throw new ToolDefException(msg);
            }
        }
        if (type instanceof BoolType) {
            if (value instanceof Boolean) {
                return (boolean)((Boolean)value);
            }
            throw new ToolDefException(null);
        }
        if (type instanceof IntType) {
            if (value instanceof Integer) {
                return (int)((Integer)value);
            }
            if (value instanceof Long) {
                long l = (Long)value;
                if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                String msg = "The value is outside of the \"int\" type range.";
                throw new ToolDefException(msg);
            }
            if (value instanceof Double) {
                double d = (Double)value;
                int i = (int)d;
                double d2 = i;
                if (Double.valueOf(d).equals(d2)) {
                    return i;
                }
                String msg = "The value is outside of the \"int\" type range.";
                throw new ToolDefException(msg);
            }
            throw new ToolDefException(null);
        }
        if (type instanceof LongType) {
            if (value instanceof Integer) {
                int i = (Integer)value;
                return (long)i;
            }
            if (value instanceof Long) {
                return (long)((Long)value);
            }
            if (value instanceof Double) {
                double d = (Double)value;
                long l = (long)d;
                double d2 = l;
                if (Double.valueOf(d).equals(d2)) {
                    return l;
                }
                String msg = "The value is outside of the \"long\" type range.";
                throw new ToolDefException(msg);
            }
            throw new ToolDefException(null);
        }
        if (type instanceof DoubleType) {
            if (value instanceof Integer) {
                int i = (Integer)value;
                return (double)i;
            }
            if (value instanceof Long) {
                long l = (Long)value;
                return (double)l;
            }
            if (value instanceof Double) {
                return (double)((Double)value);
            }
            throw new ToolDefException(null);
        }
        if (type instanceof StringType) {
            if (value instanceof String) {
                return value;
            }
            throw new ToolDefException(null);
        }
        if (type instanceof ObjectType) {
            return value;
        }
        if (type instanceof ListType) {
            if (!(value instanceof ToolDefList)) {
                throw new ToolDefException(null);
            }
            ToolDefList list = (ToolDefList)value;
            List rslt = null;
            ToolDefType elemType = ((ListType)type).getElemType();
            int i = 0;
            while (i < list.size()) {
                Object newElem;
                Object elem = list.get(i);
                if (elem != (newElem = ToolDefEval.evalCast(elem, elemType))) {
                    if (rslt == null) {
                        rslt = new ToolDefList((Collection)list);
                    }
                    rslt.set(i, newElem);
                }
                ++i;
            }
            return rslt == null ? list : rslt;
        }
        if (type instanceof SetType) {
            if (!(value instanceof ToolDefSet)) {
                throw new ToolDefException(null);
            }
            ToolDefSet set = (ToolDefSet)value;
            ToolDefSet rslt = new ToolDefSet(set.size());
            ToolDefType elemType = ((SetType)type).getElemType();
            for (Object elem : set) {
                Object newElem = ToolDefEval.evalCast(elem, elemType);
                rslt.add(newElem);
            }
            Assert.check((rslt.size() == set.size() ? 1 : 0) != 0);
            return rslt;
        }
        if (type instanceof MapType) {
            if (!(value instanceof ToolDefMap)) {
                throw new ToolDefException(null);
            }
            ToolDefMap map = (ToolDefMap)value;
            ToolDefMap rslt = new ToolDefMap(map.size());
            ToolDefType keyType = ((MapType)type).getKeyType();
            ToolDefType valueType = ((MapType)type).getValueType();
            for (Map.Entry entry : map.entrySet()) {
                Object newKey = ToolDefEval.evalCast(entry.getKey(), keyType);
                Object newValue = ToolDefEval.evalCast(entry.getValue(), valueType);
                rslt.put(newKey, newValue);
            }
            Assert.check((rslt.size() == map.size() ? 1 : 0) != 0);
            return rslt;
        }
        if (type instanceof TupleType) {
            if (!(value instanceof ToolDefTuple)) {
                throw new ToolDefException(null);
            }
            ToolDefTuple tuple = (ToolDefTuple)value;
            List values = ToolDefRuntimeUtils.unpackTuple((ToolDefTuple)tuple);
            EList types = ((TupleType)type).getFields();
            if (values.size() != types.size()) {
                throw new ToolDefException(null);
            }
            int i = 0;
            while (i < values.size()) {
                Object newValue = ToolDefEval.evalCast(values.get(i), (ToolDefType)types.get(i));
                values.set(i, newValue);
                ++i;
            }
            return ToolDefRuntimeUtils.makeTuple((List)values);
        }
        if (type instanceof TypeParamRef) {
            return value;
        }
        throw new RuntimeException("Unknown/unsupported type: " + type);
    }

    private static Object eval(ToolInvokeExpression invoke, ExecContext ctxt) {
        Object rslt;
        block24: {
            Object value;
            ToolRef toolRef = invoke.getTool();
            Tool tool = toolRef.getTool();
            if (toolRef.isBuiltin() && (tool.getName().equals("and") || tool.getName().equals("or"))) {
                ToolDefType t = ((ToolArgument)invoke.getArguments().get(0)).getValue().getType();
                if ((t = ToolDefTypeUtils.normalizeType((ToolDefType)t)) instanceof BoolType) {
                    return ToolDefEval.evalShortCircuit(invoke, ctxt);
                }
            }
            int paramCnt = tool.getParameters().size();
            boolean[] specified = new boolean[paramCnt];
            Object[] args = new Object[paramCnt];
            int posIdx = 0;
            int i = 0;
            while (i < invoke.getArguments().size()) {
                ToolArgument arg = (ToolArgument)invoke.getArguments().get(i);
                try {
                    value = ToolDefEval.eval(arg.getValue(), ctxt);
                }
                catch (ToolDefException ex) {
                    String argTxt = arg.getName() == null ? Numbers.toOrdinal((int)(i + 1)) : "\"" + arg.getName() + "\"";
                    String msg = Strings.fmt((String)"Failed to evaluate %s argument for invocation of %s.", (Object[])new Object[]{argTxt, ToolDefTextUtils.getAbsDescr((ToolRef)toolRef)});
                    throw new ToolDefException(msg, (Throwable)ex);
                }
                if (ctxt.isTerminationRequested()) {
                    throw new ExitException(0);
                }
                if (arg.getName() == null) {
                    specified[posIdx] = true;
                    if (((ToolParameter)tool.getParameters().get(posIdx)).isVariadic()) {
                        if (args[posIdx] == null) {
                            args[posIdx] = new ToolDefList();
                        }
                        List lst = (List)args[posIdx];
                        lst.add(value);
                    } else {
                        args[posIdx] = value;
                        ++posIdx;
                    }
                } else {
                    boolean found = false;
                    int j = 0;
                    while (j < paramCnt) {
                        if (((ToolParameter)tool.getParameters().get(j)).getName().equals(arg.getName())) {
                            found = true;
                            specified[j] = true;
                            args[j] = value;
                            break;
                        }
                        ++j;
                    }
                    Assert.check((boolean)found);
                }
                ++i;
            }
            i = 0;
            while (i < paramCnt) {
                if (!specified[i]) {
                    ToolParameter param = (ToolParameter)tool.getParameters().get(i);
                    if (param.isVariadic()) {
                        args[i] = new ToolDefList();
                    } else {
                        try {
                            value = ToolDefEval.eval(param.getValue(), ctxt);
                        }
                        catch (ToolDefException ex) {
                            String msg = Strings.fmt((String)"Failed to evaluate default value for the \"%s\" parameter of %s.", (Object[])new Object[]{param.getName(), ToolDefTextUtils.getAbsDescr((ToolRef)toolRef)});
                            throw new ToolDefException(msg, (Throwable)ex);
                        }
                        args[i] = value;
                        if (ctxt.isTerminationRequested()) {
                            throw new ExitException(0);
                        }
                    }
                }
                ++i;
            }
            try {
                if (tool instanceof ToolDefTool) {
                    rslt = ToolDefEval.eval((ToolDefTool)tool, toolRef.isBuiltin(), args, ctxt);
                    break block24;
                }
                if (tool instanceof JavaTool) {
                    rslt = ToolDefEval.eval((JavaTool)tool, args, invoke.getType(), ctxt);
                    break block24;
                }
                throw new RuntimeException("Unknown tool: " + tool);
            }
            catch (ToolDefException ex) {
                String msg = Strings.fmt((String)"Failed to execute %s.", (Object[])new Object[]{ToolDefTextUtils.getAbsDescr((ToolRef)toolRef)});
                throw new ToolDefException(msg, (Throwable)ex);
            }
        }
        return rslt;
    }

    private static Object evalShortCircuit(ToolInvokeExpression invoke, ExecContext ctxt) {
        boolean value;
        ToolRef toolRef = invoke.getTool();
        Tool tool = toolRef.getTool();
        Assert.check((invoke.getArguments().size() == 2 ? 1 : 0) != 0);
        Assert.check((tool.getParameters().size() == 2 ? 1 : 0) != 0);
        try {
            value = (Boolean)ToolDefEval.eval(((ToolArgument)invoke.getArguments().get(0)).getValue(), ctxt);
        }
        catch (ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to evaluate 1st argument for %s.", (Object[])new Object[]{ToolDefTextUtils.getAbsDescr((ToolRef)toolRef)});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        if (tool.getName().equals("and")) {
            if (!value) {
                return false;
            }
        } else if (tool.getName().equals("or")) {
            if (value) {
                return true;
            }
        } else {
            throw new RuntimeException("Unexpected tool: " + tool.getName());
        }
        try {
            value = (Boolean)ToolDefEval.eval(((ToolArgument)invoke.getArguments().get(1)).getValue(), ctxt);
        }
        catch (ToolDefException ex) {
            String msg = Strings.fmt((String)"Failed to evaluate 2nd argument for %s.", (Object[])new Object[]{ToolDefTextUtils.getAbsDescr((ToolRef)toolRef)});
            throw new ToolDefException(msg, (Throwable)ex);
        }
        return value;
    }

    private static Object eval(ToolDefTool tool, boolean builtin, Object[] args, ExecContext ctxt) {
        ExecContext toolCtxt = new ExecContext(ctxt.interpreter);
        int i = 0;
        while (i < args.length) {
            ToolParameter param = (ToolParameter)tool.getParameters().get(i);
            Object arg = args[i];
            toolCtxt.addToolParam(param, arg);
            ++i;
        }
        List body = Lists.cast((List)tool.getStatements());
        if (ctxt.isTerminationRequested()) {
            throw new ExitException(0);
        }
        ToolDefReturnValue retValue = ToolDefExec.execute(body, toolCtxt);
        if (retValue == null) {
            if (tool.getReturnTypes().isEmpty()) {
                return null;
            }
            String msg = "Execution of the tool did not encounter a \"return\" or \"exit\" statement.";
            throw new ToolDefException(msg);
        }
        return retValue.value;
    }

    private static Object eval(JavaTool tool, Object[] args, ToolDefType resultType, ExecContext ctxt) {
        boolean hasReturnType;
        Object rslt;
        Method method = tool.getMethod();
        if (method.isVarArgs()) {
            Object array;
            List list = (List)args[args.length - 1];
            args[args.length - 1] = array = ToolDefEval.varargListToArray(method, list);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        if (ctxt.isTerminationRequested()) {
            throw new ExitException(0);
        }
        try {
            rslt = method.invoke(null, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Java method invoke failed.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Java method invoke failed.", ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof ToolDefException) {
                throw (ToolDefException)ex.getCause();
            }
            if (ex.getCause() instanceof ExitException) {
                throw (ExitException)ex.getCause();
            }
            throw new RuntimeException("Java method invoke failed.", ex);
        }
        if (ctxt.isTerminationRequested()) {
            throw new ExitException(0);
        }
        boolean bl = hasReturnType = !tool.getReturnTypes().isEmpty();
        if (hasReturnType) {
            try {
                rslt = ToolDefEval.normalizeJavaReturnValue(rslt, resultType);
            }
            catch (RuntimeException ex) {
                String rsltTxt;
                try {
                    rsltTxt = rslt == null ? "null" : rslt.toString();
                }
                catch (Exception ignoreEx) {
                    String msg = Strings.fmt((String)"Java method result doesn't fit in type \"%s\".", (Object[])new Object[]{ToolDefTextUtils.typeToStr((ToolDefType)resultType)});
                    throw new RuntimeException(msg, ex);
                }
                String msg = Strings.fmt((String)"Java method result %s doesn't fit in type \"%s\".", (Object[])new Object[]{rsltTxt, ToolDefTextUtils.typeToStr((ToolDefType)resultType)});
                throw new RuntimeException(msg, ex);
            }
        }
        return rslt;
    }

    private static Object varargListToArray(Method method, List<Object> values) {
        Class elemType;
        Type[] paramTypes = method.getGenericParameterTypes();
        Type lastType = paramTypes[paramTypes.length - 1];
        if (lastType instanceof Class) {
            Class cls = (Class)lastType;
            Assert.check((boolean)cls.isArray());
            elemType = cls.getComponentType();
        } else if (lastType instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)lastType;
            Type genElemType = gat.getGenericComponentType();
            ParameterizedType ptElemType = (ParameterizedType)genElemType;
            elemType = (Class)ptElemType.getRawType();
        } else {
            throw new RuntimeException("Unknown array type: " + lastType);
        }
        Object rslt = Array.newInstance(elemType, values.size());
        int i = 0;
        while (i < values.size()) {
            Array.set(rslt, i, values.get(i));
            ++i;
        }
        return rslt;
    }

    private static Object normalizeJavaReturnValue(Object value, ToolDefType type) {
        type = ToolDefTypeUtils.normalizeType((ToolDefType)type);
        if (value == null) {
            if (type instanceof TypeParamRef) {
                return null;
            }
            if (type.isNullable()) {
                return null;
            }
            throw new RuntimeException("not nullable");
        }
        if (type instanceof BoolType) {
            if (value instanceof Boolean) {
                return value;
            }
            throw new RuntimeException("not bool");
        }
        if (type instanceof IntType) {
            if (value instanceof Integer) {
                return value;
            }
            throw new RuntimeException("not int");
        }
        if (type instanceof LongType) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Long) {
                return value;
            }
            throw new RuntimeException("not long");
        }
        if (type instanceof DoubleType) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Double) {
                double d = (Double)value;
                if (Double.isNaN(d)) {
                    throw new RuntimeException("NaN");
                }
                if (Double.isInfinite(d)) {
                    throw new RuntimeException("inf");
                }
                return d == -0.0 ? 0.0 : d;
            }
            throw new RuntimeException("not double");
        }
        if (type instanceof StringType) {
            if (value instanceof String) {
                return value;
            }
            throw new RuntimeException("not string");
        }
        if (type instanceof ObjectType) {
            return value;
        }
        if (type instanceof ListType) {
            if (!(value instanceof ToolDefList)) {
                throw new RuntimeException("not list");
            }
            ToolDefList list = (ToolDefList)value;
            List rslt = null;
            ToolDefType elemType = ((ListType)type).getElemType();
            int i = 0;
            while (i < list.size()) {
                Object newElem;
                Object elem = list.get(i);
                if (elem != (newElem = ToolDefEval.normalizeJavaReturnValue(elem, elemType))) {
                    if (rslt == null) {
                        rslt = new ToolDefList((Collection)list);
                    }
                    rslt.set(i, newElem);
                }
                ++i;
            }
            return rslt == null ? list : rslt;
        }
        if (type instanceof SetType) {
            if (!(value instanceof ToolDefSet)) {
                throw new RuntimeException("not set");
            }
            ToolDefSet set = (ToolDefSet)value;
            ToolDefSet rslt = new ToolDefSet(set.size());
            ToolDefType elemType = ((SetType)type).getElemType();
            for (Object elem : set) {
                Object newElem = ToolDefEval.normalizeJavaReturnValue(elem, elemType);
                rslt.add(newElem);
            }
            Assert.check((rslt.size() == set.size() ? 1 : 0) != 0);
            return rslt;
        }
        if (type instanceof MapType) {
            if (!(value instanceof ToolDefMap)) {
                throw new RuntimeException("not map");
            }
            ToolDefMap map = (ToolDefMap)value;
            ToolDefMap rslt = new ToolDefMap(map.size());
            ToolDefType keyType = ((MapType)type).getKeyType();
            ToolDefType valueType = ((MapType)type).getValueType();
            for (Map.Entry entry : map.entrySet()) {
                Object newKey = ToolDefEval.normalizeJavaReturnValue(entry.getKey(), keyType);
                Object newValue = ToolDefEval.normalizeJavaReturnValue(entry.getValue(), valueType);
                rslt.put(newKey, newValue);
            }
            Assert.check((rslt.size() == map.size() ? 1 : 0) != 0);
            return rslt;
        }
        if (type instanceof TupleType) {
            if (!(value instanceof ToolDefTuple)) {
                throw new RuntimeException("not tuple");
            }
            ToolDefTuple tuple = (ToolDefTuple)value;
            List values = ToolDefRuntimeUtils.unpackTuple((ToolDefTuple)tuple);
            EList types = ((TupleType)type).getFields();
            if (values.size() != types.size()) {
                throw new RuntimeException("different tuple sizes");
            }
            int i = 0;
            while (i < values.size()) {
                Object newValue = ToolDefEval.normalizeJavaReturnValue(values.get(i), (ToolDefType)types.get(i));
                values.set(i, newValue);
                ++i;
            }
            return ToolDefRuntimeUtils.makeTuple((List)values);
        }
        if (type instanceof TypeParamRef) {
            return value;
        }
        throw new RuntimeException("Unknown/unsupported type: " + type);
    }
}

