/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.position.metamodel.position.impl.PositionObjectImpl;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeRef;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.SymbolKind;
import org.eclipse.escet.tooldef.typechecker.ToolDefTypeChecker;

public class CheckerContext
extends PositionObjectImpl {
    public final ToolDefTypeChecker tchecker;
    private final CheckerContext parent;
    private final PositionObject scope;
    private Map<String, List<PositionObject>> objects = Maps.map();
    private Set<PositionObject> referred = Sets.set();

    public CheckerContext(ToolDefTypeChecker tchecker, Script script) {
        this.tchecker = tchecker;
        this.parent = null;
        this.scope = script;
    }

    public CheckerContext(CheckerContext parent, PositionObject scope) {
        this.tchecker = parent.tchecker;
        this.parent = parent;
        this.scope = scope;
    }

    public Position getPosition() {
        return this.scope.getPosition();
    }

    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    public PositionObject getScope() {
        return this.scope;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public CheckerContext getRoot() {
        CheckerContext root = this;
        while (!root.isRoot()) {
            root = root.parent;
        }
        Assert.notNull((Object)((Object)root));
        return root;
    }

    public void addProblem(Message msg, Position position, String ... args) {
        if (position == null || !position.getLocation().equals(this.tchecker.getSourceFilePath())) {
            String inMsg = String.valueOf(msg.severity.toString()) + ": " + msg.format(args);
            RuntimeException inner = new RuntimeException(inMsg);
            String exMsg = position == null ? "Missing position info" : "Position info wrong file";
            exMsg = String.valueOf(exMsg) + ", or built-in library error.";
            throw new RuntimeException(exMsg, inner);
        }
        this.tchecker.addProblem(msg.format(args), msg.severity, position);
    }

    public void addDecl(PositionObject obj) {
        String name;
        List others;
        PositionObject wrappedObj = obj;
        if (wrappedObj instanceof CheckerContext) {
            obj = ((CheckerContext)wrappedObj).getScope();
        }
        if ((others = this.objects.get(name = ToolDefTextUtils.getName((PositionObject)obj))) == null) {
            others = Lists.list();
            this.objects.put(name, others);
        }
        SymbolKind objKind = CheckerContext.getSymbolKind(obj);
        for (PositionObject other : others) {
            PositionObject wrappedOther = other;
            if (wrappedOther instanceof CheckerContext) {
                other = ((CheckerContext)wrappedOther).getScope();
            }
            SymbolKind otherKind = CheckerContext.getSymbolKind(other);
            if (objKind == SymbolKind.TOOL && otherKind == SymbolKind.TOOL) {
                this.checkToolOverloads(obj, other);
                continue;
            }
            this.addProblem(Message.DUPL_NAME, wrappedObj.getPosition(), name, ToolDefTextUtils.getDescr((PositionObject)obj), ToolDefTextUtils.getDescr((PositionObject)other), ToolDefTextUtils.getAbsDescr((PositionObject)this.scope));
            this.addProblem(Message.DUPL_NAME, wrappedOther.getPosition(), name, ToolDefTextUtils.getDescr((PositionObject)other), ToolDefTextUtils.getDescr((PositionObject)obj), ToolDefTextUtils.getAbsDescr((PositionObject)this.scope));
            throw new SemanticException();
        }
        others.add(wrappedObj);
    }

    private void checkToolOverloads(PositionObject obj1, PositionObject obj2) {
        Tool tool1 = (Tool)obj1;
        Tool tool2 = (Tool)obj2;
        EList params1 = tool1.getParameters();
        EList params2 = tool2.getParameters();
        if (params1.size() != params2.size()) {
            return;
        }
        int i = 0;
        while (i < params1.size()) {
            ToolParameter param1 = (ToolParameter)params1.get(i);
            ToolParameter param2 = (ToolParameter)params2.get(i);
            if (param1.isVariadic() != param2.isVariadic()) {
                return;
            }
            if (ToolDefTypeUtils.areDistinguishableTypes((ToolDefType)param1.getType(), (ToolDefType)param2.getType())) {
                return;
            }
            ++i;
        }
        this.addProblem(Message.TOOL_DUPL_OVERLOAD, obj1.getPosition(), ToolDefTextUtils.getAbsDescr((PositionObject)obj1), ToolDefTextUtils.getAbsDescr((PositionObject)obj2));
        this.addProblem(Message.TOOL_DUPL_OVERLOAD, obj2.getPosition(), ToolDefTextUtils.getAbsDescr((PositionObject)obj1), ToolDefTextUtils.getAbsDescr((PositionObject)obj2));
        throw new SemanticException();
    }

    public List<PositionObject> getObjects(String name) {
        List rslts = this.objects.get(name);
        if (rslts != null) {
            rslts = Lists.copy(rslts);
            int i = 0;
            while (i < rslts.size()) {
                PositionObject rslt = (PositionObject)rslts.get(i);
                if (rslt instanceof CheckerContext) {
                    rslts.set(i, ((CheckerContext)rslt).getScope());
                }
                ++i;
            }
        }
        return rslts;
    }

    public List<PositionObject> getImportableObjects() {
        List rslt = Lists.list();
        for (Map.Entry<String, List<PositionObject>> entry : this.objects.entrySet()) {
            for (PositionObject obj : entry.getValue()) {
                if (obj instanceof Tool) {
                    rslt.add(obj);
                }
                if (!(obj instanceof TypeDecl)) continue;
                rslt.add(obj);
            }
        }
        return rslt;
    }

    public List<ToolRef> resolveBuiltin(String name, Position position) {
        List<PositionObject> tools = this.tchecker.builtins.get(name);
        List rslts = Lists.listc((int)tools.size());
        for (PositionObject tool : tools) {
            Assert.check((boolean)(tool instanceof Tool));
            rslts.add(ToolDefConstructors.newToolRef((Boolean)true, (String)name, (Position)((Position)EMFHelper.deepclone((EObject)position)), (Tool)((Tool)tool)));
        }
        return rslts;
    }

    public ToolDefType resolveType(String name, Position position) {
        List<PositionObject> resolveds = this.resolve(name, position, this, true);
        TypeRef rslt = null;
        for (PositionObject resolved : resolveds) {
            if (resolved instanceof TypeDecl) {
                Assert.check((rslt == null ? 1 : 0) != 0);
                rslt = ToolDefConstructors.newTypeRef((Boolean)false, (Position)((Position)EMFHelper.deepclone((EObject)position)), (TypeDecl)((TypeDecl)resolved));
                continue;
            }
            if (resolved instanceof TypeParam) {
                Assert.check((rslt == null ? 1 : 0) != 0);
                rslt = ToolDefConstructors.newTypeParamRef((Boolean)false, (Position)((Position)EMFHelper.deepclone((EObject)position)), (TypeParam)((TypeParam)resolved));
                continue;
            }
            this.addProblem(Message.INVALID_REF, position, name, "type", ToolDefTextUtils.getAbsDescr((PositionObject)resolved), CheckerContext.getSymbolKind(resolved).toString(), "type");
            throw new SemanticException();
        }
        Assert.notNull(rslt);
        return rslt;
    }

    public Expression resolveValue(String name, Position position) {
        List<PositionObject> resolveds = this.resolve(name, position, this, false);
        VariableExpression rslt = null;
        for (PositionObject resolved : resolveds) {
            if (resolved instanceof Variable) {
                Assert.check((rslt == null ? 1 : 0) != 0);
                Variable var = (Variable)resolved;
                rslt = ToolDefConstructors.newVariableExpression((Position)((Position)EMFHelper.deepclone((EObject)position)), (ToolDefType)((ToolDefType)EMFHelper.deepclone((EObject)var.getType())), (Variable)var);
                continue;
            }
            if (resolved instanceof ToolParameter) {
                Assert.check((rslt == null ? 1 : 0) != 0);
                ToolParameter param = (ToolParameter)resolved;
                rslt = ToolDefConstructors.newToolParamExpression((ToolParameter)param, (Position)((Position)EMFHelper.deepclone((EObject)position)), (ToolDefType)((ToolDefType)EMFHelper.deepclone((EObject)param.getType())));
                continue;
            }
            this.addProblem(Message.INVALID_REF, position, name, "value", ToolDefTextUtils.getAbsDescr((PositionObject)resolved), CheckerContext.getSymbolKind(resolved).toString(), "value");
            throw new SemanticException();
        }
        Assert.notNull(rslt);
        return rslt;
    }

    public List<ToolRef> resolveTool(String name, Position position) {
        List<PositionObject> resolveds = this.resolve(name, position, this, true);
        List rslts = Lists.listc((int)resolveds.size());
        for (PositionObject resolved : resolveds) {
            if (resolved instanceof Tool) {
                rslts.add(ToolDefConstructors.newToolRef((Boolean)false, (String)name, (Position)((Position)EMFHelper.deepclone((EObject)position)), (Tool)((Tool)resolved)));
                continue;
            }
            this.addProblem(Message.INVALID_REF, position, name, "tool", ToolDefTextUtils.getAbsDescr((PositionObject)resolved), CheckerContext.getSymbolKind(resolved).toString(), "tool");
            throw new SemanticException();
        }
        return rslts;
    }

    /*
     * Unable to fully structure code
     */
    private List<PositionObject> resolve(String name, Position position, CheckerContext ctxt, boolean allowEscapeTool) {
        curIdx = 0;
        dotIdx = name.indexOf(46, curIdx);
        if (dotIdx == -1) {
            dotIdx = name.length();
        }
        id = name.substring(curIdx, dotIdx);
        rslts = null;
        resolveCtxt = this;
        while (true) {
            if ((rslts = resolveCtxt.objects.get(id)) != null) {
                for (PositionObject rslt : rslts) {
                    resolveCtxt.referred.add(rslt);
                }
            } else {
                if (allowEscapeTool || !(resolveCtxt.getScope() instanceof Tool)) continue;
                ctxt.addProblem(Message.RESOLVE_NOT_FOUND, position, new String[]{id, ToolDefTextUtils.getAbsDescr((PositionObject)this.scope), ""});
                throw new SemanticException();
                if ((resolveCtxt = resolveCtxt.parent) != null) continue;
            }
            if (true) ** GOTO lbl52
            break;
        }
        ctxt.addProblem(Message.RESOLVE_NOT_FOUND, position, new String[]{id, ToolDefTextUtils.getAbsDescr((PositionObject)this.scope), this.isRoot() != false ? "" : " or at a higher level"});
        throw new SemanticException();
        do {
            if ((dotIdx = name.indexOf(46, curIdx = dotIdx + 1)) == -1) {
                dotIdx = name.length();
            }
            id = name.substring(curIdx, dotIdx);
            if (rslts.size() == 1) {
                rslt = (PositionObject)Lists.first(rslts);
                if (!(rslt instanceof CheckerContext)) {
                    ctxt.addProblem(Message.RESOLVE_VIA_NON_SCRIPT, position, new String[]{name.substring(curIdx), ToolDefTextUtils.getAbsDescr((PositionObject)rslt)});
                    throw new SemanticException();
                }
            } else {
                Assert.check((boolean)(rslts.size() > 1));
                kind = null;
                for (PositionObject rslt : rslts) {
                    rsltKind = CheckerContext.getSymbolKind(rslt);
                    if (kind == null) {
                        kind = rsltKind;
                        continue;
                    }
                    Assert.check((boolean)(kind == rsltKind));
                }
                ctxt.addProblem(Message.RESOLVE_VIA_NON_SCRIPT, position, new String[]{name.substring(curIdx), ToolDefTextUtils.getAbsDescr((PositionObject)((PositionObject)Lists.first(rslts)))});
                throw new SemanticException();
            }
            viaCtxt = (CheckerContext)Lists.first(rslts);
            rslts = viaCtxt.objects.get(id);
            if (rslts == null) {
                ctxt.addProblem(Message.RESOLVE_NOT_FOUND, position, new String[]{id, ToolDefTextUtils.getAbsDescr((PositionObject)viaCtxt.scope), ""});
                throw new SemanticException();
            }
            for (PositionObject rslt : rslts) {
                this.referred.add(rslt);
            }
lbl52:
            // 2 sources

        } while (dotIdx < name.length());
        i = 0;
        while (i < rslts.size()) {
            rslt = rslts.get(i);
            if (rslt instanceof CheckerContext) {
                rslts.set(i, ((CheckerContext)rslt).scope);
            }
            ++i;
        }
        Assert.check((boolean)(rslts.isEmpty() == false));
        return rslts;
    }

    public static SymbolKind getSymbolKind(PositionObject obj) {
        if (obj instanceof Script) {
            return SymbolKind.SCOPE;
        }
        if (obj instanceof ForStatement) {
            return SymbolKind.SCOPE;
        }
        if (obj instanceof IfStatement) {
            return SymbolKind.SCOPE;
        }
        if (obj instanceof WhileStatement) {
            return SymbolKind.SCOPE;
        }
        if (obj instanceof Tool) {
            return SymbolKind.TOOL;
        }
        if (obj instanceof TypeDecl) {
            return SymbolKind.TYPE;
        }
        if (obj instanceof TypeParam) {
            return SymbolKind.TYPE;
        }
        if (obj instanceof ToolParameter) {
            return SymbolKind.VALUE;
        }
        if (obj instanceof Variable) {
            return SymbolKind.VALUE;
        }
        throw new RuntimeException("Unexpected obj: " + obj);
    }

    public void checkUnused() {
        for (Map.Entry<String, List<PositionObject>> entry : this.objects.entrySet()) {
            for (PositionObject obj : entry.getValue()) {
                if (obj instanceof Tool || obj instanceof TypeDecl || this.referred.contains(obj)) continue;
                if (obj instanceof CheckerContext) {
                    obj = ((CheckerContext)obj).getScope();
                }
                this.addProblem(Message.UNUSED_DECL, obj.getPosition(), StringUtils.capitalize((String)ToolDefTextUtils.getAbsDescr((PositionObject)obj)));
            }
        }
    }
}

