/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.io.InputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.eclipse.escet.setext.runtime.Token;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefValidationUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.Declaration;
import org.eclipse.escet.tooldef.metamodel.tooldef.Import;
import org.eclipse.escet.tooldef.metamodel.tooldef.JavaImport;
import org.eclipse.escet.tooldef.metamodel.tooldef.JavaTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefImport;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.parser.ToolDefParser;
import org.eclipse.escet.tooldef.runtime.ToolDefTupleNary;
import org.eclipse.escet.tooldef.runtime.ToolDefTuplePair;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.ImportClassLoaderObtainer;
import org.eclipse.escet.tooldef.typechecker.ImportCycleException;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.eclipse.escet.tooldef.typechecker.ToolDefTypeChecker;

public class ImportsChecker {
    private ImportsChecker() {
    }

    public static void tcheck(Import imp, CheckerContext ctxt) {
        if (imp instanceof ToolDefImport) {
            ImportsChecker.tcheck((ToolDefImport)imp, ctxt);
        } else if (imp instanceof JavaImport) {
            ImportsChecker.tcheck((JavaImport)imp, ctxt);
        } else {
            throw new RuntimeException("Unknown import: " + imp);
        }
    }

    private static void tcheck(ToolDefImport imp, CheckerContext ctxt) {
        Position importPos = imp.getAsName() != null ? imp.getAsName().position : (imp.getOrigName() == null ? imp.getPosition() : imp.getOrigName().position);
        CheckerContext impCtxt = ImportsChecker.getScript(imp, ctxt);
        if (imp.getOrigName() == null) {
            String name = null;
            if (imp.getAsName() != null) {
                name = imp.getAsName().text;
            }
            if (name == null) {
                name = imp.getSource().text;
                if (name.startsWith("lib:")) {
                    name = name.substring("lib:".length());
                } else {
                    int idx = Math.max(name.lastIndexOf(92), name.lastIndexOf(47));
                    if (idx != -1) {
                        name = name.substring(idx + 1);
                    }
                    if ((idx = name.lastIndexOf(46)) != -1) {
                        name = name.substring(0, idx);
                    }
                }
                if (!ToolDefValidationUtils.isValidIdentifier((String)name)) {
                    ctxt.addProblem(Message.IMPORT_FILE_INVALID_NAME, imp.getSource().position, name, imp.getSource().text);
                    throw new SemanticException();
                }
            }
            Script newScript = ToolDefConstructors.newScript(null, (String)name, (Position)((Position)EMFHelper.deepclone((EObject)importPos)));
            Script rootScript = (Script)ctxt.getRoot().getScope();
            rootScript.getDeclarations().add((Object)newScript);
            CheckerContext newCtxt = new CheckerContext(ctxt, (PositionObject)newScript);
            Script impScript = (Script)impCtxt.getScope();
            Assert.check((impScript.getName() == null ? 1 : 0) != 0);
            for (PositionObject impObj : impCtxt.getImportableObjects()) {
                PositionObject newObj = (PositionObject)EMFHelper.deepclone((EObject)impObj);
                newScript.getDeclarations().add((Object)((Declaration)newObj));
                try {
                    newCtxt.addDecl(newObj);
                }
                catch (SemanticException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ctxt.addDecl((PositionObject)newCtxt);
        } else {
            List<PositionObject> objs = imp.getOrigName().text.equals("*") ? impCtxt.getImportableObjects() : impCtxt.getObjects(imp.getOrigName().text);
            if (objs == null) {
                Assert.check((!imp.getOrigName().text.equals("*") ? 1 : 0) != 0);
                ctxt.addProblem(Message.IMPORT_FILE_OBJ_NOT_FOUND, imp.getOrigName().position, imp.getOrigName().text);
                return;
            }
            if (objs.isEmpty()) {
                Assert.check((boolean)imp.getOrigName().text.equals("*"));
                ctxt.addProblem(Message.IMPORT_FILE_NO_IMPORTABLE_OBJS, imp.getOrigName().position, new String[0]);
                return;
            }
            for (PositionObject obj : objs) {
                if (obj instanceof Tool || obj instanceof TypeDecl) continue;
                ctxt.addProblem(Message.IMPORT_FILE_OBJ_UNSUPPORTED, imp.getOrigName().position, ToolDefTextUtils.getAbsDescr((PositionObject)obj));
                throw new SemanticException();
            }
            Script dummyScript = ToolDefConstructors.newScript();
            int i = 0;
            while (i < objs.size()) {
                PositionObject obj = objs.get(i);
                obj = (PositionObject)EMFHelper.deepclone((EObject)obj);
                dummyScript.getDeclarations().add((Object)((Declaration)obj));
                objs.set(i, obj);
                obj.setPosition((Position)EMFHelper.deepclone((EObject)importPos));
                if (imp.getAsName() != null) {
                    if (obj instanceof Tool) {
                        ((Tool)obj).setName(imp.getAsName().text);
                    } else if (obj instanceof TypeDecl) {
                        ((TypeDecl)obj).setName(imp.getAsName().text);
                    } else {
                        throw new RuntimeException("Unexpected obj: " + obj);
                    }
                }
                ++i;
            }
            for (PositionObject obj : objs) {
                ctxt.addDecl(obj);
            }
        }
    }

    public static CheckerContext getScript(ToolDefImport imp, CheckerContext ctxt) {
        String[][] impCycle;
        Script script;
        String absSrcRef;
        boolean DEBUG = false;
        if (ctxt.tchecker.scripts == null) {
            ctxt.tchecker.scripts = Maps.map();
        }
        String relSrcRef = imp.getSource().text;
        Position sourcePos = imp.getSource().position;
        try {
            absSrcRef = ctxt.tchecker.resolveImport(relSrcRef, sourcePos, ctxt);
            CheckerContext impCtxt = ctxt.tchecker.scripts.get(absSrcRef);
            if (impCtxt != null) {
                return impCtxt;
            }
            if (absSrcRef.startsWith("tooldef://")) {
                ImportClassLoaderObtainer clObtainer;
                ClassLoader classLoader;
                InputStream stream;
                Object pluginPath;
                String path = absSrcRef.substring("tooldef://".length());
                int slashIdx = path.indexOf(47);
                String pluginName = slashIdx == -1 ? "" : path.substring(0, slashIdx);
                Object object = pluginPath = slashIdx == -1 ? path : path.substring(slashIdx + 1);
                if (pluginName.isEmpty()) {
                    pluginName = null;
                }
                if ((stream = (classLoader = (clObtainer = new ImportClassLoaderObtainer(sourcePos, ctxt, "ToolDef script")).getClassLoader(pluginName)).getResourceAsStream((String)pluginPath)) == null) {
                    ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
                    String loaderTxt = classLoader == sysLoader ? "on the system class path" : Strings.fmt((String)"in plug-in (OSGi bundle or Eclipse project) \"%s\"", (Object[])new Object[]{pluginName});
                    ctxt.addProblem(Message.IMPORT_FILE_RESOURCE_NOT_FOUND, sourcePos, new String[]{pluginPath, loaderTxt});
                    throw new SemanticException();
                }
                ToolDefParser parser = new ToolDefParser();
                String src = Strings.fmt((String)"ToolDef library \"%s\": ", (Object[])new Object[]{relSrcRef});
                script = (Script)parser.parseStream(stream, absSrcRef, src);
            } else {
                ToolDefParser parser = new ToolDefParser();
                script = (Script)parser.parseFile(absSrcRef, relSrcRef);
            }
        }
        catch (InvalidInputException e) {
            ctxt.addProblem(Message.IMPORT_FILE_NOT_FOUND, sourcePos, relSrcRef);
            throw new SemanticException();
        }
        catch (InputOutputException e) {
            ctxt.addProblem(Message.IMPORT_FILE_IO_ERROR, sourcePos, relSrcRef);
            throw new SemanticException();
        }
        catch (SyntaxException e) {
            ctxt.addProblem(Message.IMPORT_FILE_SYNTAX_ERROR, sourcePos, relSrcRef);
            throw new SemanticException();
        }
        String[][] curCycle = ctxt.tchecker.importCycle;
        if (curCycle == null) {
            impCycle = new String[][]{{ctxt.tchecker.getSourceFilePath(), ctxt.tchecker.getSourceFileName()}, {absSrcRef, relSrcRef}};
        } else {
            impCycle = new String[curCycle.length + 1][2];
            System.arraycopy(curCycle, 0, impCycle, 0, curCycle.length);
            impCycle[impCycle.length - 1][0] = absSrcRef;
            impCycle[impCycle.length - 1][1] = relSrcRef;
        }
        ToolDefTypeChecker newChecker = new ToolDefTypeChecker();
        newChecker.setSourceFilePath(absSrcRef);
        try {
            newChecker.builtins = ctxt.tchecker.builtins;
            newChecker.scripts = ctxt.tchecker.scripts;
            newChecker.importCycle = impCycle;
            ImportsChecker.detectImportCycle(newChecker);
            newChecker.typeCheck(script);
        }
        catch (ImportCycleException e) {
            if (!e.absSrcRef.equals(ctxt.tchecker.getSourceFilePath())) {
                throw e;
            }
            ctxt.addProblem(Message.IMPORT_FILE_CYCLE, sourcePos, e.cycleTxt);
            throw new SemanticException();
        }
        if (newChecker.hasError()) {
            for (SemanticProblem problem : newChecker.getProblems()) {
                if (problem.severity == SemanticProblemSeverity.WARNING) continue;
                ctxt.addProblem(Message.IMPORT_FILE_SEMANTIC_ERROR, sourcePos, relSrcRef, problem.message);
            }
            throw new SemanticException();
        }
        CheckerContext rootCtxt = newChecker.rootCtxt;
        Assert.notNull((Object)((Object)rootCtxt));
        Assert.notNull((Object)script);
        CheckerContext prevCtxt = ctxt.tchecker.scripts.put(absSrcRef, rootCtxt);
        Assert.check((prevCtxt == null ? 1 : 0) != 0);
        return rootCtxt;
    }

    private static void detectImportCycle(ToolDefTypeChecker tchecker) {
        String[][] cycle = tchecker.importCycle;
        Assert.notNull((Object)cycle);
        String tcheckerAbsRef = cycle[cycle.length - 1][0];
        Assert.check((boolean)tcheckerAbsRef.equals(tchecker.getSourceFilePath()));
        int i = 0;
        while (i < cycle.length - 1) {
            if (cycle[i][0].equals(tcheckerAbsRef)) {
                StringBuilder txt = new StringBuilder();
                int j = i + 1;
                while (j < cycle.length) {
                    if (txt.length() > 0) {
                        txt.append(" -> ");
                    }
                    txt.append("\"" + cycle[j][1] + "\"");
                    ++j;
                }
                throw new ImportCycleException(tcheckerAbsRef, txt.toString());
            }
            ++i;
        }
    }

    private static void tcheck(JavaImport imp, CheckerContext ctxt) {
        Class<?> cls;
        String pluginName = imp.getPluginName() == null ? null : imp.getPluginName().text;
        Position pluginPos = imp.getPluginName() == null ? null : imp.getPluginName().position;
        ImportClassLoaderObtainer clObtainer = new ImportClassLoaderObtainer(pluginPos, ctxt, "Java code");
        ClassLoader classLoader = clObtainer.getClassLoader(pluginName);
        String methodAbsName = imp.getMethodName().text;
        int dotIdx = methodAbsName.lastIndexOf(46);
        String classAbsName = dotIdx == -1 ? "" : methodAbsName.substring(0, dotIdx);
        String methodName = dotIdx == -1 ? methodAbsName : methodAbsName.substring(dotIdx + 1);
        try {
            cls = classLoader.loadClass(classAbsName);
        }
        catch (ClassNotFoundException ex) {
            ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
            String loaderTxt = classLoader == sysLoader ? "on the system class path" : Strings.fmt((String)"in plug-in (OSGi bundle or Eclipse project) \"%s\"", (Object[])new Object[]{pluginName});
            ctxt.addProblem(Message.IMPORT_JAVA_CLASS_NOT_FOUND, imp.getMethodName().position, classAbsName, loaderTxt);
            throw new SemanticException();
        }
        Assert.notNull(cls);
        Method[] declaredMethods = cls.getDeclaredMethods();
        int matchingNameCnt = 0;
        List methods = Lists.list();
        Method[] methodArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                ++matchingNameCnt;
                if (Modifier.isStatic(method.getModifiers())) {
                    methods.add(method);
                }
            }
            ++n2;
        }
        if (methods.isEmpty()) {
            ctxt.addProblem(Message.IMPORT_JAVA_METHOD_NOT_FOUND, imp.getMethodName().position, matchingNameCnt == 0 ? "" : "static ", methodName, classAbsName);
            throw new SemanticException();
        }
        Script dummyScript = ToolDefConstructors.newScript();
        Token ctxtToken = imp.getAsName();
        if (ctxtToken == null) {
            ctxtToken = imp.getMethodName();
        }
        for (Method method : methods) {
            JavaTool tool = ImportsChecker.convertJavaMethod(imp, method, ctxt);
            dummyScript.getDeclarations().add((Object)tool);
            ctxt.addDecl((PositionObject)tool);
        }
    }

    private static JavaTool convertJavaMethod(JavaImport imp, Method method, CheckerContext ctxt) {
        String methodName = imp.getMethodName().text;
        int dotIdx = methodName.lastIndexOf(46);
        if (dotIdx != -1) {
            methodName = methodName.substring(dotIdx + 1);
        }
        String toolName = methodName;
        if (imp.getAsName() != null) {
            toolName = imp.getAsName().text;
        }
        Position toolPos = imp.getMethodName().position;
        if (imp.getAsName() != null) {
            toolPos = imp.getAsName().position;
        }
        TypeVariable<Method>[] javaTypeParams = method.getTypeParameters();
        List typeParams = Lists.listc((int)javaTypeParams.length);
        Map typeParamMap = Maps.mapc((int)javaTypeParams.length);
        TypeVariable<Method>[] typeVariableArray = javaTypeParams;
        int n = javaTypeParams.length;
        int n2 = 0;
        while (n2 < n) {
            boolean boundOk;
            TypeVariable<Method> javaTypeParam = typeVariableArray[n2];
            boolean bl = boundOk = javaTypeParam.getBounds().length == 0 || javaTypeParam.getBounds().length == 1 && javaTypeParam.getBounds()[0] == Object.class;
            if (!boundOk) {
                ctxt.addProblem(Message.IMPORT_JAVA_TYPE_PARAM_BOUNDED, toolPos, imp.getMethodName().text, javaTypeParam.getName());
                throw new SemanticException();
            }
            TypeParam typeParam = ToolDefConstructors.newTypeParam((String)javaTypeParam.getName(), null);
            typeParams.add(typeParam);
            TypeParam prev = typeParamMap.put(javaTypeParam, typeParam);
            Assert.check((prev == null ? 1 : 0) != 0);
            ++n2;
        }
        ToolDefType retType = ImportsChecker.convertJavaType(method.getGenericReturnType(), "return", toolPos, typeParamMap, ctxt, false, true);
        Parameter[] javaParams = method.getParameters();
        List params = Lists.listc((int)javaParams.length);
        int i = 0;
        while (i < javaParams.length) {
            Parameter javaParam = javaParams[i];
            params.add(ImportsChecker.convertJavaParam(i, javaParam, toolPos, typeParamMap, ctxt));
            ++i;
        }
        String pluginName = imp.getPluginName() == null ? null : imp.getPluginName().text;
        return ToolDefConstructors.newJavaTool((Method)method, (String)imp.getMethodName().text, (String)toolName, (List)params, (String)pluginName, (Position)((Position)EMFHelper.deepclone((EObject)toolPos)), (List)(retType == null ? null : Lists.list((Object)retType)), (List)typeParams);
    }

    private static ToolDefType convertJavaType(Type type, String useText, Position pos, Map<TypeVariable<Method>, TypeParam> typeParamMap, CheckerContext ctxt, boolean isVariadic, boolean isReturn) {
        if (type instanceof WildcardType) {
            ctxt.addProblem(Message.IMPORT_JAVA_TYPE_WILDCARD, pos, useText);
            throw new SemanticException();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            TypeParam typeParam = typeParamMap.get(typeVar);
            Assert.notNull((Object)typeParam);
            return ToolDefConstructors.newTypeParamRef((Boolean)false, null, (TypeParam)typeParam);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] javaArgTypes = pType.getActualTypeArguments();
            List argTypes = Lists.listc((int)javaArgTypes.length);
            Type[] typeArray = javaArgTypes;
            int n = javaArgTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type javaArgType = typeArray[n2];
                argTypes.add(ImportsChecker.convertJavaType(javaArgType, useText, pos, typeParamMap, ctxt, false, false));
                ++n2;
            }
            Type rawType = pType.getRawType();
            if (rawType == List.class) {
                Assert.check((argTypes.size() == 1 ? 1 : 0) != 0);
                return ToolDefConstructors.newListType((ToolDefType)((ToolDefType)argTypes.get(0)), (Boolean)true, null);
            }
            if (rawType == Set.class) {
                Assert.check((argTypes.size() == 1 ? 1 : 0) != 0);
                return ToolDefConstructors.newSetType((ToolDefType)((ToolDefType)argTypes.get(0)), (Boolean)true, null);
            }
            if (rawType == Map.class) {
                Assert.check((argTypes.size() == 2 ? 1 : 0) != 0);
                return ToolDefConstructors.newMapType((ToolDefType)((ToolDefType)argTypes.get(0)), (Boolean)true, null, (ToolDefType)((ToolDefType)argTypes.get(1)));
            }
            if (rawType == ToolDefTuplePair.class) {
                Assert.check((argTypes.size() == 2 ? 1 : 0) != 0);
                return ToolDefConstructors.newTupleType((List)argTypes, (Boolean)true, null);
            }
            if (rawType == ToolDefTupleNary.class) {
                Assert.check((argTypes.size() == 2 ? 1 : 0) != 0);
                ToolDefType prefixType = (ToolDefType)argTypes.get(0);
                ToolDefType remainderType = (ToolDefType)argTypes.get(1);
                List fieldTypes = Lists.list();
                fieldTypes.add(prefixType);
                Assert.check((boolean)(remainderType instanceof TupleType));
                fieldTypes.addAll(((TupleType)remainderType).getFields());
                return ToolDefConstructors.newTupleType((List)fieldTypes, (Boolean)true, null);
            }
            ctxt.addProblem(Message.IMPORT_JAVA_TYPE_UNSUPPORTED, pos, rawType.toString(), useText);
            throw new SemanticException();
        }
        if (type instanceof GenericArrayType) {
            if (isVariadic) {
                GenericArrayType gaType = (GenericArrayType)type;
                Type componentType = gaType.getGenericComponentType();
                ToolDefType elemType = ImportsChecker.convertJavaType(componentType, useText, pos, typeParamMap, ctxt, false, false);
                return ToolDefConstructors.newListType((ToolDefType)elemType, (Boolean)false, null);
            }
            ctxt.addProblem(Message.IMPORT_JAVA_TYPE_ARRAY, pos, useText);
            throw new SemanticException();
        }
        if (type instanceof Class) {
            if (type == Boolean.TYPE) {
                return ToolDefConstructors.newBoolType((Boolean)false, null);
            }
            if (type == Boolean.class) {
                return ToolDefConstructors.newBoolType((Boolean)true, null);
            }
            if (type == Integer.TYPE) {
                return ToolDefConstructors.newIntType((Boolean)false, null);
            }
            if (type == Integer.class) {
                return ToolDefConstructors.newIntType((Boolean)true, null);
            }
            if (type == Long.TYPE) {
                return ToolDefConstructors.newLongType((Boolean)false, null);
            }
            if (type == Long.class) {
                return ToolDefConstructors.newLongType((Boolean)true, null);
            }
            if (type == Double.TYPE) {
                return ToolDefConstructors.newDoubleType((Boolean)false, null);
            }
            if (type == Double.class) {
                return ToolDefConstructors.newDoubleType((Boolean)true, null);
            }
            if (type == String.class) {
                return ToolDefConstructors.newStringType((Boolean)true, null);
            }
            if (type == Object.class) {
                return ToolDefConstructors.newObjectType((Boolean)true, null);
            }
            if (type == Void.TYPE && isReturn) {
                return null;
            }
            if (type == List.class || type == Set.class || type == Map.class || type == ToolDefTuplePair.class || type == ToolDefTupleNary.class) {
                ctxt.addProblem(Message.IMPORT_JAVA_TYPE_NON_GENERIC, pos, type.toString(), useText);
                throw new SemanticException();
            }
            if (((Class)type).isArray()) {
                if (isVariadic) {
                    Class cls = (Class)type;
                    Class<?> componentCls = cls.getComponentType();
                    ToolDefType elemType = ImportsChecker.convertJavaType(componentCls, useText, pos, typeParamMap, ctxt, false, false);
                    return ToolDefConstructors.newListType((ToolDefType)elemType, (Boolean)false, null);
                }
                ctxt.addProblem(Message.IMPORT_JAVA_TYPE_ARRAY, pos, useText);
                throw new SemanticException();
            }
            ctxt.addProblem(Message.IMPORT_JAVA_TYPE_UNSUPPORTED, pos, type.toString(), useText);
            throw new SemanticException();
        }
        throw new RuntimeException("Unknown Java type: " + type);
    }

    private static ToolParameter convertJavaParam(int idx, Parameter param, Position pos, Map<TypeVariable<Method>, TypeParam> typeParamMap, CheckerContext ctxt) {
        String name = param.getName();
        Type javaType = param.getParameterizedType();
        boolean variadic = param.isVarArgs();
        ToolDefType type = ImportsChecker.convertJavaType(javaType, "parameter", pos, typeParamMap, ctxt, variadic, false);
        Assert.notNull((Object)type);
        return ToolDefConstructors.newToolParameter((String)name, (Position)((Position)EMFHelper.deepclone((EObject)pos)), (ToolDefType)type, null, (Boolean)variadic);
    }
}

