/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public enum Message {
    ASGN_NON_ASSIGNABLE("Cannot assign a new value to %s.", SemanticProblemSeverity.ERROR),
    ASGN_DUPL_VAR("Duplicate assignment to %s in a single multi-assignment.", SemanticProblemSeverity.ERROR),
    ASGN_STRING_PROJ("Cannot assign a part of %s, as partial updates of \"string\" typed variables are not supported.", SemanticProblemSeverity.ERROR),
    ASGN_TYPE_VALUE_MISMATCH("The type \"%s\" of the value of the assignment is incompatible with type \"%s\" of the addressable.", SemanticProblemSeverity.ERROR),
    COND_NON_BOOL("Condition must be of type \"bool\", but is of type \"%s\".", SemanticProblemSeverity.ERROR),
    DUPL_NAME("Duplicate name \"%s\" for %s and %s in %s.", SemanticProblemSeverity.ERROR),
    EXIT_CODE_NON_INT("Exit code must be of type \"int\", but is of type \"%s\".", SemanticProblemSeverity.ERROR),
    EXPR_UNKNOWN_TYPE("Cannot determine the type of expression \"%s\". Please use a cast expression to explicitly specify the type.", SemanticProblemSeverity.ERROR),
    FMT_PAT_DECODE_ERR("%s", SemanticProblemSeverity.ERROR),
    FMT_PAT_IDX_OVERFLOW("Invalid format specifier: the explicit index causes integer overflow.", SemanticProblemSeverity.ERROR),
    FMT_PAT_IDX_OUT_OF_RANGE("Invalid format specifier: the %s value is used, which does not exist.", SemanticProblemSeverity.ERROR),
    FMT_PAT_WRONG_TYPE("Invalid \"%%%s\" format specifier: a value of type \"%s\" is required, but the %s value of type \"%s\" is used.", SemanticProblemSeverity.ERROR),
    FMT_PAT_UNUSED_VALUE("The %s value is not used in the format pattern.", SemanticProblemSeverity.WARNING),
    FOR_ADDRS_CNT("Found %s addressables, but expected 1 or %s addressables (for type \"%s\").", SemanticProblemSeverity.ERROR),
    FOR_ADDRS_TOO_MANY("Found %s addressables, but expected only a single one (for type \"%s\").", SemanticProblemSeverity.ERROR),
    FOR_SOURCE_TYPE("Cannot iterate over a value of type \"%s\", as a list, set, or map type is expected.", SemanticProblemSeverity.ERROR),
    FOR_SOURCE_NULL("Cannot iterate over a value of type \"%s\", as a non-nullable type is expected.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_CYCLE("Import cycle detected: %s.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_INVALID_NAME("Import name \"%s\", derived from \"%s\" is not a valid ToolDef identifier.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_IO_ERROR("Imported ToolDef script \"%s\" could not be read.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_NO_IMPORTABLE_OBJS("No tools or type declarations found in imported ToolDef script.", SemanticProblemSeverity.WARNING),
    IMPORT_FILE_NOT_FOUND("Imported ToolDef script \"%s\" could not be found, is a directory, or for some other reason could not be opened for reading.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_OBJ_NOT_FOUND("Cannot find a declaration with name \"%s\" in the imported ToolDef script.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_OBJ_UNSUPPORTED("Cannot import %s from the imported ToolDef script, as only tools and type declarations can be imported.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_RESOURCE_NOT_FOUND("Imported ToolDef script \"%s\" could not be found %s.", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_SEMANTIC_ERROR("Imported ToolDef script \"%s\" has an error: %s", SemanticProblemSeverity.ERROR),
    IMPORT_FILE_SYNTAX_ERROR("Imported ToolDef script \"%s\" has a syntax error.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_CLASS_NOT_FOUND("Cannot load Java class \"%s\" as the class could not be found %s.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_METHOD_NOT_FOUND("Cannot find a %smethod named \"%s\" in class \"%s\".", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_TYPE_ARRAY("Unsupported use of a Java array type in a %s type of a Java method.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_TYPE_NON_GENERIC("Unsupported non-generic use of Java type \"%s\" in a %s type of a Java method.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_TYPE_PARAM_BOUNDED("Java method \"%s\" is not supported, as its type parameter \"%s\" is bounded.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_TYPE_UNSUPPORTED("Unsupported use of Java type \"%s\" in a %s type of a Java method.", SemanticProblemSeverity.ERROR),
    IMPORT_JAVA_TYPE_WILDCARD("Unsupported use of a Java wildcard type in a %s type of a Java method.", SemanticProblemSeverity.ERROR),
    IMPORT_LIB_DUPL("Multiple libraries with name \"%s\" found, in plug-ins (OSGi bundles) \"%s\" and \"%s\".", SemanticProblemSeverity.ERROR),
    IMPORT_LIB_NOT_FOUND("Cannot find a library with name \"%s\".", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_NOT_PLUGIN("Cannot load %s from plug-in (Eclipse project) \"%s\", as the project is not a plug-in project, or it contains a manifest file that is malformed or missing vital information.", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_CLASSIC_FORMAT("Cannot load %s from plug-in (Eclipse project) \"%s\", as the plug-in project is in a classic format (does not use the new OSGi bundle layout).", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_NO_JAVA_NATURE("Cannot load %s from plug-in (Eclipse project) \"%s\", as the class path of the project could not be computed. The plug-in may not have a Java nature. Cause: %s", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_MALFORMED_URL("Cannot load %s from plug-in (Eclipse project) \"%s\", as an URL from the project's class path is malformed. Cause: %s", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_OPEN_URL("Cannot load %s from plug-in (Eclipse project) \"%s\", as URL \"%s\" from the project's class path could not be opened. Cause: %s", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_ADAPT("Cannot load %s from plug-in (OSGi bundle) \"%s\", as a class loader could not be obtained for the plug-in.", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_NOT_FOUND("Cannot find a plug-in (OSGi bundle or Eclipse project) with name \"%s\".", SemanticProblemSeverity.ERROR),
    IMPORT_PLUGIN_STATE("Cannot load %s from plug-in (OSGi bundle) \"%s\", as the plug-in is in a wrong state (%s), as it should be in state RESOLVED, STARTING, or ACTIVE.", SemanticProblemSeverity.ERROR),
    INVALID_CAST("Cannot cast from type \"%s\" to type \"%s\".", SemanticProblemSeverity.ERROR),
    INVALID_REF("Could not resolve \"%s\" as a %s (it resolves to %s, a %s rather than a %s).", SemanticProblemSeverity.ERROR),
    INVOKE_DUPL_NAMED_ARG("Duplicated named argument \"%s\".", SemanticProblemSeverity.ERROR),
    INVOKE_NO_MATCH("Cannot invoke tool \"%s\" (%s overload%s) for the given arguments: %s.", SemanticProblemSeverity.ERROR),
    INVOKE_POS_ARG_AFTER_NAMED_ARG("Positional argument may not follow named argument \"%s\".", SemanticProblemSeverity.ERROR),
    NOT_IN_LOOP("A \"%s\" statement can only be used inside a loop (\"for\" or \"while\" statement).", SemanticProblemSeverity.ERROR),
    NOT_IN_TOOL("A \"return\" statement can only be used inside a tool definition.", SemanticProblemSeverity.ERROR),
    PROJ_CHILD_TYPE("Cannot project a value of type \"%s\".", SemanticProblemSeverity.ERROR),
    PROJ_INDEX_TYPE("Cannot project a value of type \"%s\", with an index value of type \"%s\", as an index value of type \"%s\" is expected.", SemanticProblemSeverity.ERROR),
    PROJ_TUPLE_BOUND("Cannot project a tuple of type \"%s\", with index %s, as the index is out of bounds.", SemanticProblemSeverity.ERROR),
    PROJ_TUPLE_NON_LIT("Can only project a tuple with an integer number literal.", SemanticProblemSeverity.ERROR),
    RESOLVE_NOT_FOUND("Could not find a declaration with name \"%s\" in %s%s.", SemanticProblemSeverity.ERROR),
    RESOLVE_VIA_NON_SCRIPT("Could not resolve \"%s\" via %s, as the latter is not a imported script.", SemanticProblemSeverity.ERROR),
    RETURN_NO_TYPES("Cannot return values from tool \"%s\" as the tool has no return types.", SemanticProblemSeverity.ERROR),
    RETURN_NO_VALUES("Tool \"%s\" has return types, but no values to return are given.", SemanticProblemSeverity.ERROR),
    RETURN_VALUE_TYPE("Cannot return values of type \"%s\", as tool \"%s\" expects values of type \"%s\".", SemanticProblemSeverity.ERROR),
    SLICE_CHILD_TYPE("Cannot slice a value of type \"%s\".", SemanticProblemSeverity.ERROR),
    SLICE_IDX_NON_INT("Slice %s index must be of type \"int\" but is of type \"%s\".", SemanticProblemSeverity.ERROR),
    STAT_UNREACHABLE("Unreachable statement.", SemanticProblemSeverity.WARNING),
    TOOL_DUPL_OVERLOAD("Duplicate tool overload for %s and %s.", SemanticProblemSeverity.ERROR),
    TOOL_PARAM_ORDER("Mandatory tool parameter \"%s\" may not follow a variadic or optional tool parameter.", SemanticProblemSeverity.ERROR),
    TOOL_PARAM_VALUE_TYPE("The default value of tool parameter \"%s\" is of type \"%s\", which doesn't fit in the type \"%s\" of the parameter.", SemanticProblemSeverity.ERROR),
    TOOL_PARAM_VARIADIC_OPTIONAL("Tool parameter \"%s\" may not be both variadic and optional.", SemanticProblemSeverity.ERROR),
    TOOL_MULTIPLE_VARIADIC("Tool \"%s\" has multiple variadic parameters.", SemanticProblemSeverity.ERROR),
    TOOL_RETURN_MISSING("No execution of tool \"%s\" can reach a \"return\" or \"exit\" statement.", SemanticProblemSeverity.ERROR),
    UNUSED_DECL("%s is not used.", SemanticProblemSeverity.WARNING),
    VALUE_OVERFLOW("%s value overflow (%s > 2^63 - 1).", SemanticProblemSeverity.ERROR),
    VAR_NO_INITIAL_VALUE("Variable \"%s\" is of type \"%s\", which does not have a default value.", SemanticProblemSeverity.ERROR),
    VAR_VALUE_TYPE("The value of variable \"%s\" is of type \"%s\", which doesn't fit in the type \"%s\" of the variable.", SemanticProblemSeverity.ERROR);

    private final String text;
    public final SemanticProblemSeverity severity;
    private int count = -1;

    private Message(String text, SemanticProblemSeverity severity) {
        this.text = text;
        this.severity = severity;
    }

    private int getArgcount() {
        int argCount = 0;
        int index = 0;
        while ((index = this.text.indexOf("%s", index)) != -1) {
            ++argCount;
            index += 2;
        }
        return argCount;
    }

    public String format(String ... args) {
        if (this.count < 0) {
            this.count = this.getArgcount();
        }
        Assert.check((args.length == this.count ? 1 : 0) != 0);
        return Strings.fmt((String)this.text, (Object[])args);
    }
}

