/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.ProcModelFuncXperGenerator;
import org.eclipse.escet.chi.codegen.ProcessTypeDefinition;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ConstantDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Specification;
import org.eclipse.escet.chi.metamodel.chi.TypeDeclaration;
import org.eclipse.escet.chi.metamodel.chi.XperDeclaration;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class JavaCodeGenerator {
    public static CodeGeneratorContext transCodeGen(String inPath, Specification spec) {
        String chiName = "Specification";
        CodeGeneratorContext ctxt = new CodeGeneratorContext(chiName);
        JavaClass javaSpec = ctxt.addJavaClass(chiName, false, "ChiSpecification", null);
        javaSpec.addImport("org.eclipse.escet.chi.runtime.ChiSpecification", false);
        List startups = Lists.list();
        List descriptions = Lists.list();
        ctxt.openScope(CodeGeneratorContext.ActiveScope.GLOBALS);
        for (Declaration decl : spec.getDeclarations()) {
            String name;
            if (decl instanceof ConstantDeclaration) continue;
            if (decl instanceof EnumDeclaration) {
                EnumDeclaration ed = (EnumDeclaration)decl;
                TypeIDCreation.createEnumTypeID(ed, ctxt);
                continue;
            }
            if (decl instanceof TypeDeclaration) continue;
            if (decl instanceof XperDeclaration) {
                name = "ChiXper" + decl.getName();
            } else if (decl instanceof ModelDeclaration) {
                name = "ChiModel" + decl.getName();
            } else if (decl instanceof ProcessDeclaration) {
                name = "ChiProcess" + decl.getName();
            } else if (decl instanceof FunctionDeclaration) {
                name = "ChiFunction" + decl.getName();
            } else {
                Assert.fail((String)"Unknown type of declaration encountered.");
                continue;
            }
            name = ctxt.makeUniqueName(name);
            ctxt.addDefinition((PositionObject)decl, name);
        }
        ProcModelFuncXperGenerator.addSpecFunctionInstances(javaSpec, (List<Declaration>)spec.getDeclarations(), ctxt);
        ProcessTypeDefinition.addProcessTypes((List<Declaration>)spec.getDeclarations(), javaSpec, ctxt);
        for (Declaration decl : spec.getDeclarations()) {
            Box desc;
            Box startup;
            if (decl instanceof ConstantDeclaration || decl instanceof EnumDeclaration || decl instanceof TypeDeclaration) continue;
            if (decl instanceof ModelDeclaration) {
                ModelDeclaration md = (ModelDeclaration)decl;
                ProcModelFuncXperGenerator.transProcModelXperDeclaration((BehaviourDeclaration)md, ctxt);
                startup = ProcModelFuncXperGenerator.addStartup((BehaviourDeclaration)md, javaSpec, ctxt);
                startups.add(startup);
                desc = ProcModelFuncXperGenerator.addStartupDescription((BehaviourDeclaration)md, javaSpec, ctxt);
                descriptions.add(desc);
                continue;
            }
            if (decl instanceof XperDeclaration) {
                XperDeclaration xd = (XperDeclaration)decl;
                ProcModelFuncXperGenerator.transProcModelXperDeclaration((BehaviourDeclaration)xd, ctxt);
                startup = ProcModelFuncXperGenerator.addStartup((BehaviourDeclaration)xd, javaSpec, ctxt);
                startups.add(startup);
                desc = ProcModelFuncXperGenerator.addStartupDescription((BehaviourDeclaration)xd, javaSpec, ctxt);
                descriptions.add(desc);
                continue;
            }
            if (decl instanceof ProcessDeclaration) {
                ProcessDeclaration pd = (ProcessDeclaration)decl;
                ProcModelFuncXperGenerator.transProcModelXperDeclaration((BehaviourDeclaration)pd, ctxt);
                continue;
            }
            if (decl instanceof FunctionDeclaration) {
                FunctionDeclaration td = (FunctionDeclaration)decl;
                ProcModelFuncXperGenerator.transFunctionDeclaration(td, ctxt);
                continue;
            }
            Assert.fail((String)"Unknown type of declaration encountered.");
        }
        ctxt.generateProcessTypes();
        JavaMethod method = new JavaMethod("public", "StartupDescription[]", "getStartups", "", null);
        method.lines.add("return new StartupDescription[] {");
        method.lines.indent();
        for (Box desc : descriptions) {
            method.lines.add(desc);
        }
        method.lines.dedent();
        method.lines.add("};");
        javaSpec.addMethod(method);
        int longestName = 0;
        for (Declaration decl : spec.getDeclarations()) {
            int nameLength;
            if (!(decl instanceof ModelDeclaration) && !(decl instanceof XperDeclaration) || (nameLength = decl.getName().length()) <= longestName) continue;
            longestName = nameLength;
        }
        method = new JavaMethod("public", "BaseProcess", "startStartup", "ChiCoordinator chiCoordinator, String arg", null);
        javaSpec.addImport("org.eclipse.escet.chi.runtime.data.BaseProcess", false);
        javaSpec.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        if (longestName > 0) {
            method.lines.add("ChiReadMemoryFile handle = new ChiReadMemoryFile(arg);");
            javaSpec.addImport("org.eclipse.escet.chi.runtime.data.io.ChiReadMemoryFile", false);
            method.lines.add("handle.skipWhitespace();");
            method.lines.add("handle.markStream(%d);", new Object[]{longestName + 2});
            for (Box start : startups) {
                method.lines.add(start);
            }
        } else {
            Assert.check((boolean)startups.isEmpty());
        }
        method.lines.add("throw new ChiSimulatorException(\"Unrecognized command line.\");");
        javaSpec.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        javaSpec.addMethod(method);
        method = new JavaMethod("public static", "void", "main", "String[] cmdArgs", null);
        method.lines.add(Strings.fmt((String)"%s app = new %s(null);", (Object[])new Object[]{"SimulatorApplication", "SimulatorApplication"}));
        method.lines.add("String[] args = new String[cmdArgs.length + 1];");
        method.lines.add("System.arraycopy(cmdArgs, 0, args, 1, cmdArgs.length);");
        method.lines.add("args[0] = \"--run-specification-class=" + chiName + "\";");
        method.lines.add("int ret = app.run(args);");
        method.lines.add("System.exit(ret);");
        javaSpec.addImport("org.eclipse.escet.chi.simulator.SimulatorApplication", false);
        javaSpec.addMethod(method);
        ctxt.closeScope();
        return ctxt;
    }
}

