/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.OutputPosition;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.AssignmentConversions;
import org.eclipse.escet.chi.codegen.statements.seq.SeqCode;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.ForStatement;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctions;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.Unwind;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class ForLoopConversion {
    private static ExpressionBase convertRange(Expression source, CodeGeneratorContext ctxt, JavaFile currentClass) {
        ExpressionBase incr;
        ExpressionBase cond;
        ExpressionBase init;
        if (!(source instanceof CallExpression)) {
            return null;
        }
        CallExpression ce = (CallExpression)source;
        if (!(ce.getFunction() instanceof StdLibFunctionReference)) {
            return null;
        }
        StdLibFunctionReference slibref = (StdLibFunctionReference)ce.getFunction();
        if (slibref.getFunction() != StdLibFunctions.RANGE) {
            return null;
        }
        if (ce.getArguments().size() == 1) {
            init = new SimpleExpression("0", (PositionObject)source);
            cond = ExpressionBase.convertExpression((Expression)ce.getArguments().get(0), ctxt, currentClass);
            incr = new SimpleExpression("1", (PositionObject)source);
        } else if (ce.getArguments().size() == 2) {
            init = ExpressionBase.convertExpression((Expression)ce.getArguments().get(0), ctxt, currentClass);
            cond = ExpressionBase.convertExpression((Expression)ce.getArguments().get(1), ctxt, currentClass);
            incr = new SimpleExpression("1", (PositionObject)source);
        } else if (ce.getArguments().size() == 3) {
            init = ExpressionBase.convertExpression((Expression)ce.getArguments().get(0), ctxt, currentClass);
            cond = ExpressionBase.convertExpression((Expression)ce.getArguments().get(1), ctxt, currentClass);
            incr = ExpressionBase.convertExpression((Expression)ce.getArguments().get(2), ctxt, currentClass);
        } else {
            return null;
        }
        List lines = Lists.list();
        lines.addAll(init.getCode());
        lines.addAll(cond.getCode());
        lines.addAll(incr.getCode());
        String line = OutputPosition.genCurrentPositionStatement((PositionObject)source);
        if (line != null) {
            lines.add(line);
        }
        currentClass.addImport("org.eclipse.escet.common.java.RangeIterator", false);
        line = Strings.fmt((String)"new RangeIterator(%s, %s, %s)", (Object[])new Object[]{init.getValue(), cond.getValue(), incr.getValue()});
        return ExpressionBase.makeExpression(lines, line, (PositionObject)source);
    }

    private static ForLoopSeqResult convertGeneral(ExpressionBase iterVal, List<VariableDeclaration> vars, PositionObject chiobj, CodeGeneratorContext ctxt, JavaFile currentClass) {
        String iterVarName = ctxt.getDefinition(chiobj);
        String line = Strings.fmt((String)"%s = %s", (Object[])new Object[]{iterVarName, iterVal.getValue()});
        ExpressionBase init = ExpressionBase.makeExpression(iterVal.getCode(), line, iterVal.position);
        ExpressionBase cond = ExpressionBase.makeExpression(null, String.valueOf(iterVarName) + ".hasNext()", chiobj);
        SeqCode code = new SeqCode(null, chiobj);
        Expression lhs = ForLoopConversion.constructLhsVars(vars);
        TypeID tid = TypeIDCreation.createTypeID(lhs.getType(), ctxt);
        String valName = ctxt.makeUniqueName("val");
        code.lines.add(Strings.fmt((String)"%s %s = %s.next();", (Object[])new Object[]{tid.getJavaType(), valName, iterVarName}));
        code.lines.addAll(AssignmentConversions.convertAssignment(lhs, valName, lhs.getType(), ctxt, currentClass));
        List seqs = Lists.list();
        seqs.add(code);
        return new ForLoopSeqResult(init, cond, null, code);
    }

    public static ForLoopSeqResult convertForLoop(PositionObject chiobj, CodeGeneratorContext ctxt, JavaFile currentClass) {
        Unwind unw;
        if (chiobj instanceof ForStatement) {
            ForStatement fs = (ForStatement)chiobj;
            Assert.check((fs.getUnwinds().size() == 1 ? 1 : 0) != 0);
            unw = (Unwind)Lists.first((List)fs.getUnwinds());
        } else {
            Assert.check((boolean)(chiobj instanceof Unwind));
            unw = (Unwind)chiobj;
        }
        Expression source = unw.getSource();
        EList vars = unw.getVariables();
        ExpressionBase iterVal = ForLoopConversion.convertRange(source, ctxt, currentClass);
        if (iterVal == null) {
            ExpressionBase lstVar = ExpressionBase.convertExpression(source, ctxt, currentClass);
            String line = Strings.fmt((String)"%s.iterator()", (Object[])new Object[]{lstVar.getValue()});
            iterVal = ExpressionBase.makeExpression(lstVar.getCode(), line, lstVar.position);
        }
        return ForLoopConversion.convertGeneral(iterVal, (List<VariableDeclaration>)vars, chiobj, ctxt, currentClass);
    }

    public static TypeID getElementType(Type containerType, CodeGeneratorContext ctxt) {
        if (containerType instanceof ListType) {
            ListType lt = (ListType)containerType;
            return TypeIDCreation.createTypeID(lt.getElementType(), ctxt);
        }
        if (containerType instanceof SetType) {
            SetType st = (SetType)containerType;
            return TypeIDCreation.createTypeID(st.getElementType(), ctxt);
        }
        Assert.check((boolean)(containerType instanceof DictType));
        DictType dt = (DictType)containerType;
        List names = Lists.list((Object[])new String[]{"key", "value"});
        List tids = Lists.list((Object[])new TypeID[]{TypeIDCreation.createTypeID(dt.getKeyType(), ctxt), TypeIDCreation.createTypeID(dt.getValueType(), ctxt)});
        return TypeIDCreation.createTupleTypeID(names, tids, ctxt);
    }

    private static Expression constructLhsVars(List<VariableDeclaration> vds) {
        if (vds.size() == 1) {
            VariableDeclaration vd = vds.get(0);
            Position pos = PositionUtils.copyPosition((PositionObject)vd);
            Type tp = CheckType.copyType((Type)vd.getType());
            return ChiConstructors.newVariableReference((Position)pos, (Type)tp, (VariableDeclaration)vd);
        }
        List tfs = Lists.list();
        List vrs = Lists.list();
        for (VariableDeclaration vd : vds) {
            Type tp = CheckType.copyType((Type)vd.getType());
            TupleField tf = ChiConstructors.newTupleField((String)"", (Position)PositionUtils.copyPosition((PositionObject)vd), (Type)tp);
            tfs.add(tf);
            tp = CheckType.copyType((Type)vd.getType());
            vrs.add(ChiConstructors.newVariableReference((Position)PositionUtils.copyPosition((PositionObject)vd), (Type)tp, (VariableDeclaration)vd));
        }
        TupleType lhsType = ChiConstructors.newTupleType((List)tfs, null);
        TupleExpression te = ChiConstructors.newTupleExpression((List)vrs, null, (Type)lhsType);
        return te;
    }

    public static class ForLoopSeqResult {
        public final ExpressionBase loopInit;
        public final ExpressionBase loopCond;
        public final ExpressionBase loopIncr;
        public final SeqCode varInit;

        public ForLoopSeqResult(ExpressionBase loopInit, ExpressionBase loopCond, ExpressionBase loopIncr, SeqCode varInit) {
            this.loopInit = loopInit;
            this.loopCond = loopCond;
            this.loopIncr = loopIncr;
            this.varInit = varInit;
        }
    }
}

