/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.switchcases;

import java.util.List;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.statements.seq.Seq;
import org.eclipse.escet.chi.codegen.statements.seq.SeqBox;
import org.eclipse.escet.chi.codegen.statements.seq.SeqBreak;
import org.eclipse.escet.chi.codegen.statements.seq.SeqCode;
import org.eclipse.escet.chi.codegen.statements.seq.SeqContinue;
import org.eclipse.escet.chi.codegen.statements.seq.SeqExit;
import org.eclipse.escet.chi.codegen.statements.seq.SeqForLoop;
import org.eclipse.escet.chi.codegen.statements.seq.SeqIfElse;
import org.eclipse.escet.chi.codegen.statements.seq.SeqList;
import org.eclipse.escet.chi.codegen.statements.seq.SeqReturn;
import org.eclipse.escet.chi.codegen.statements.seq.SeqSelect;
import org.eclipse.escet.chi.codegen.statements.seq.SeqWhile;
import org.eclipse.escet.chi.codegen.statements.switchcases.SeqCase;
import org.eclipse.escet.chi.codegen.statements.switchcases.SeqCaseCollection;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SwitchCases {
    private int number = -1;
    private List<String> neededImports = Lists.list();
    private SeqCaseCollection collection = null;

    private void addNeededImport(String importPath) {
        if (!this.neededImports.contains(importPath)) {
            this.neededImports.add(importPath);
        }
    }

    public SeqCase makeCase(List<Seq> seqs) {
        ++this.number;
        return this.makeCase(seqs, this.number);
    }

    public SeqCase makeCase(List<Seq> seqs, int caseNumber) {
        if (seqs == null) {
            seqs = Lists.list();
        }
        for (Seq s : seqs) {
            Assert.notNull((Object)s);
        }
        SeqCase cs = new SeqCase(caseNumber, seqs);
        return cs;
    }

    public void convertBody(List<Seq> seqs, BehaviourDeclaration bd) {
        SwitchCases.checkNotNull(seqs);
        this.number = SwitchCases.findMaxCreateCode(seqs, -1);
        List endSeqs = Lists.list();
        endSeqs.add(SeqReturn.finishProcess((PositionObject)bd));
        SeqCase endCase = this.makeCase(endSeqs);
        SeqCaseCollection scc = new SeqCaseCollection(endCase, endCase.caseNumber);
        this.collection = SwitchCases.convertBody(seqs, scc, this);
    }

    private static void checkNotNull(List<Seq> seqs) {
        for (Seq s : seqs) {
            if (s instanceof SeqBreak || s instanceof SeqCode || s instanceof SeqBox || s instanceof SeqContinue) continue;
            if (s instanceof SeqForLoop) {
                SeqForLoop seqFor = (SeqForLoop)s;
                SwitchCases.checkNotNull(seqFor.childStats.seqs);
                continue;
            }
            if (s instanceof SeqIfElse) {
                SeqIfElse ifElse = (SeqIfElse)s;
                SwitchCases.checkNotNull(ifElse.ifChilds.seqs);
                if (ifElse.elseChilds == null) continue;
                SwitchCases.checkNotNull(ifElse.elseChilds.seqs);
                continue;
            }
            if (s instanceof SeqReturn) continue;
            if (s instanceof SeqSelect) {
                SeqSelect sel = (SeqSelect)s;
                for (SeqSelect.SelectAlternative a : sel.alternatives) {
                    SwitchCases.checkNotNull(a.createCode);
                    if (a.code == null) continue;
                    SwitchCases.checkNotNull(a.code.seqs);
                }
                continue;
            }
            if (s instanceof SeqExit) continue;
            if (s instanceof SeqWhile) {
                SeqWhile wseq = (SeqWhile)s;
                SwitchCases.checkNotNull(wseq.childs.seqs);
                continue;
            }
            Assert.fail((String)("Unknown sequential language statement " + s.toString() + " encountered."));
        }
    }

    private static int findMaxCreateCode(List<Seq> seqs, int num) {
        for (Seq s : seqs) {
            Seq ss;
            if (s instanceof SeqSelect) {
                ss = (SeqSelect)s;
                for (SeqSelect.SelectAlternative sa : ss.alternatives) {
                    if (sa.number > num) {
                        num = sa.number;
                    }
                    if (sa.code == null) continue;
                    num = SwitchCases.findMaxCreateCode(sa.code.seqs, num);
                }
                continue;
            }
            if (s instanceof SeqForLoop) {
                ss = (SeqForLoop)s;
                num = SwitchCases.findMaxCreateCode(((SeqForLoop)ss).childStats.seqs, num);
                continue;
            }
            if (s instanceof SeqIfElse) {
                SeqIfElse sie = (SeqIfElse)s;
                num = SwitchCases.findMaxCreateCode(sie.ifChilds.seqs, num);
                if (sie.elseChilds == null) continue;
                num = SwitchCases.findMaxCreateCode(sie.elseChilds.seqs, num);
                continue;
            }
            if (!(s instanceof SeqWhile)) continue;
            ss = (SeqWhile)s;
            num = SwitchCases.findMaxCreateCode(((SeqWhile)ss).childs.seqs, num);
        }
        return num;
    }

    public Box boxify() {
        VBox outerBox = new VBox(0);
        outerBox.add("if (chiChoice == null) {");
        VBox choiceBox = new VBox(4);
        choiceBox.add(Strings.fmt((String)"chiProgramCounter = %d;", (Object[])new Object[]{this.collection.entry}));
        outerBox.add((Box)choiceBox);
        outerBox.add("} else {");
        choiceBox = new VBox(4);
        choiceBox.add("chiChoice.setVariables();");
        choiceBox.add("chiProgramCounter = chiChoice.getChoice();");
        outerBox.add((Box)choiceBox);
        outerBox.add("}");
        outerBox.add("if (positionStack.size() != 1) throw new ChiSimulatorException(\"Unexpected length of the position stack.\");");
        outerBox.add("for (;;) {");
        VBox forBox = new VBox(4);
        forBox.add("chiCoordinator.testTerminating();");
        forBox.add("switch (chiProgramCounter) {");
        for (SeqCase sc : this.collection.cases) {
            VBox caseBox = new VBox(4);
            caseBox.add(Strings.fmt((String)"case %d: {", (Object[])new Object[]{sc.caseNumber}));
            VBox vb = new VBox(4);
            vb.add(sc.boxify());
            caseBox.add((Box)vb);
            caseBox.add("}");
            forBox.add((Box)caseBox);
        }
        VBox caseBox = new VBox(4);
        caseBox.add("default: throw new ChiSimulatorException(\"Unknown process fragment \" + String.valueOf(chiProgramCounter) + \" encountered.\");");
        forBox.add((Box)caseBox);
        forBox.add("}");
        outerBox.add((Box)forBox);
        outerBox.add("}");
        return outerBox;
    }

    public List<String> getNeededImport() {
        return this.neededImports;
    }

    public static SeqCaseCollection convertBody(List<Seq> seqs, SeqCaseCollection otherCases, SwitchCases scs) {
        SeqCase start = scs.makeCase(null);
        return SwitchCases.convertSeqs(start, seqs, otherCases, scs);
    }

    private static SeqCaseCollection convertSeqs(SeqCase prefix, List<Seq> seqs, SeqCaseCollection otherCases, SwitchCases scs) {
        int i = 0;
        while (i < seqs.size() && SwitchCases.needsSplit(seqs.get(i)) == SplitReason.NOT_NEEDED) {
            prefix.statements.add(seqs.get(i));
            ++i;
        }
        if (i == seqs.size()) {
            SeqReturn jump = SeqReturn.jumpToCase(otherCases.entry, null);
            prefix.statements.add(jump);
            List result = Lists.concat((Object)prefix, otherCases.cases);
            return new SeqCaseCollection(result, prefix.caseNumber);
        }
        otherCases = SwitchCases.convertBody(seqs.subList(i + 1, seqs.size()), otherCases, scs);
        if (seqs.get(i) instanceof SeqForLoop) {
            SeqForLoop seq = (SeqForLoop)seqs.get(i);
            return SwitchCases.splitForLoop(prefix, seq, otherCases, scs);
        }
        if (seqs.get(i) instanceof SeqIfElse) {
            SeqIfElse seq = (SeqIfElse)seqs.get(i);
            return SwitchCases.splitIfElse(prefix, seq, otherCases, scs);
        }
        if (seqs.get(i) instanceof SeqSelect) {
            SeqSelect seq = (SeqSelect)seqs.get(i);
            return SwitchCases.splitSelect(prefix, seq, otherCases, scs);
        }
        if (seqs.get(i) instanceof SeqWhile) {
            SeqWhile seq = (SeqWhile)seqs.get(i);
            return SwitchCases.splitWhile(prefix, seq, otherCases, scs);
        }
        Assert.fail((String)("Encountered unrecognized statement to split:" + seqs.get(i).toString()));
        return null;
    }

    private static SeqCaseCollection splitForLoop(SeqCase prefix, SeqForLoop seq, SeqCaseCollection otherCases, SwitchCases scs) {
        SeqCode initStat = new SeqCode(null, null);
        if (seq.init != null) {
            seq.init.setCurrentPositionStatement(initStat.lines);
            initStat.lines.addAll(seq.init.getCode());
            initStat.lines.add(String.valueOf(seq.init.getValue()) + ";");
        }
        prefix.statements.add(initStat);
        SeqCase condTest = scs.makeCase(null);
        if (seq.endCondition != null) {
            condTest.statements.add(SwitchCases.makeIfGoto(true, seq.endCondition, otherCases.entry, seq.position));
        }
        SeqCase incr = scs.makeCase(null);
        SeqCode incrStat = new SeqCode(null, null);
        if (seq.increment != null) {
            seq.increment.setCurrentPositionStatement(incrStat.lines);
            incrStat.lines.addAll(seq.increment.getCode());
            incrStat.lines.add(String.valueOf(seq.increment.getValue()) + ";");
        }
        incr.statements.add(incrStat);
        incr.statements.add(SeqReturn.jumpToCase(condTest.caseNumber, seq.position));
        SwitchCases.replaceBreakContinue(otherCases.entry, condTest.caseNumber, seq.childStats);
        otherCases = new SeqCaseCollection(Lists.concat((Object)incr, otherCases.cases), incr.caseNumber);
        otherCases = SwitchCases.convertSeqs(condTest, seq.childStats.seqs, otherCases, scs);
        prefix.statements.add(SeqReturn.jumpToCase(otherCases.entry, seq.position));
        return new SeqCaseCollection(Lists.concat((Object)prefix, otherCases.cases), prefix.caseNumber);
    }

    private static SeqCaseCollection splitIfElse(SeqCase prefix, SeqIfElse seq, SeqCaseCollection otherCases, SwitchCases scs) {
        if (seq.elseChilds == null) {
            prefix.statements.add(SwitchCases.makeIfGoto(true, seq.condition, otherCases.entry, seq.position));
            return SwitchCases.convertSeqs(prefix, seq.ifChilds.seqs, otherCases, scs);
        }
        SeqCaseCollection elseBranch = SwitchCases.convertBody(seq.elseChilds.seqs, otherCases, scs);
        SeqCaseCollection ifDest = new SeqCaseCollection(elseBranch.cases, otherCases.entry);
        otherCases = SwitchCases.convertBody(seq.ifChilds.seqs, ifDest, scs);
        prefix.statements.add(SwitchCases.makeIfGoto(false, seq.condition, otherCases.entry, seq.position));
        prefix.statements.add(SeqReturn.jumpToCase(elseBranch.entry, seq.position));
        return new SeqCaseCollection(Lists.concat((Object)prefix, otherCases.cases), prefix.caseNumber);
    }

    private static SeqCaseCollection splitSelect(SeqCase prefix, SeqSelect seq, SeqCaseCollection otherCases, SwitchCases scs) {
        List<SeqCase> swCases = otherCases.cases;
        int jumpTarget = otherCases.entry;
        List lines = Lists.list();
        lines.add("selectList.clear();");
        prefix.statements.add(new SeqCode(lines, null));
        int i = seq.alternatives.size() - 1;
        while (i >= 0) {
            SeqSelect.SelectAlternative alt = seq.alternatives.get(i);
            Assert.check((SwitchCases.needsSplit(alt.createCode) == SplitReason.NOT_NEEDED ? 1 : 0) != 0);
            prefix.statements.addAll(alt.createCode);
            SeqCase start = scs.makeCase(null, alt.number);
            if (alt.code == null) {
                start.statements.add(SeqReturn.jumpToCase(jumpTarget, null));
                swCases = Lists.concat((Object)start, swCases);
            } else {
                SeqCaseCollection scc = new SeqCaseCollection(swCases, jumpTarget);
                scc = SwitchCases.convertSeqs(start, alt.code.seqs, scc, scs);
                swCases = scc.cases;
            }
            --i;
        }
        lines = Lists.list();
        lines.add("setSelect(selectList);");
        prefix.statements.add(new SeqCode(lines, null));
        prefix.statements.add(SeqReturn.selectBlock(seq.position));
        return new SeqCaseCollection(Lists.concat((Object)prefix, swCases), prefix.caseNumber);
    }

    private static Seq makeIfGoto(boolean invert, ExpressionBase cond, int jumpTarget, PositionObject position) {
        List ifStats = Lists.list();
        if (invert) {
            cond = ExpressionBase.makeExpression(cond.getCode(), "!(" + cond.getValue() + ")", position);
        }
        ifStats.add(SeqReturn.jumpToCase(jumpTarget, position));
        return new SeqIfElse(cond, new SeqList(ifStats), null, null);
    }

    private static SeqCaseCollection splitWhile(SeqCase prefix, SeqWhile seq, SeqCaseCollection otherCases, SwitchCases scs) {
        SeqCase condTest = scs.makeCase(null);
        condTest.statements.add(SwitchCases.makeIfGoto(true, seq.condition, otherCases.entry, seq.position));
        SwitchCases.replaceBreakContinue(otherCases.entry, condTest.caseNumber, seq.childs);
        otherCases = new SeqCaseCollection(otherCases.cases, condTest.caseNumber);
        prefix.statements.add(SeqReturn.jumpToCase(condTest.caseNumber, null));
        otherCases = SwitchCases.convertSeqs(condTest, seq.childs.seqs, otherCases, scs);
        return new SeqCaseCollection(Lists.concat((Object)prefix, otherCases.cases), prefix.caseNumber);
    }

    private static SplitReason needsSplit(List<Seq> seqList) {
        SplitReason r = SplitReason.NOT_NEEDED;
        for (Seq seq : seqList) {
            if (!(r = SplitReason.max(r, SwitchCases.needsSplit(seq))).isMaxRelevant()) continue;
            return r;
        }
        return r;
    }

    private static SplitReason needsSplit(Seq seq) {
        if (seq instanceof SeqBreak) {
            SeqBreak sb = (SeqBreak)seq;
            return sb.hasDestination() ? SplitReason.NOT_NEEDED : SplitReason.USES_BREAK;
        }
        if (seq instanceof SeqCode) {
            return SplitReason.NOT_NEEDED;
        }
        if (seq instanceof SeqBox) {
            return SplitReason.NOT_NEEDED;
        }
        if (seq instanceof SeqContinue) {
            return SplitReason.NOT_NEEDED;
        }
        if (seq instanceof SeqForLoop) {
            SeqForLoop seqFor = (SeqForLoop)seq;
            return SwitchCases.needsSplit(seqFor.childStats.seqs);
        }
        if (seq instanceof SeqIfElse) {
            SeqIfElse ifElse = (SeqIfElse)seq;
            SplitReason r = SwitchCases.needsSplit(ifElse.ifChilds.seqs);
            if (r.isMaxRelevant()) {
                return r;
            }
            if (ifElse.elseChilds != null) {
                r = SplitReason.max(r, SwitchCases.needsSplit(ifElse.elseChilds.seqs));
            }
            return r;
        }
        if (seq instanceof SeqReturn) {
            return SplitReason.NOT_NEEDED;
        }
        if (seq instanceof SeqSelect) {
            return SplitReason.BLOCKS;
        }
        if (seq instanceof SeqExit) {
            return SplitReason.NOT_NEEDED;
        }
        if (seq instanceof SeqWhile) {
            SeqWhile wseq = (SeqWhile)seq;
            return SwitchCases.needsSplit(wseq.childs.seqs);
        }
        Assert.fail((String)("Unknown sequential language statement " + seq.toString() + " encountered."));
        return SplitReason.NOT_NEEDED;
    }

    private static void replaceBreakContinue(Integer breakDest, Integer continueDest, SeqList seqs) {
        for (Seq s : seqs.seqs) {
            if (breakDest != null && s instanceof SeqBreak) {
                SeqBreak brk = (SeqBreak)s;
                brk.setDestination(breakDest);
                continue;
            }
            if (continueDest != null && s instanceof SeqContinue) {
                SeqContinue cont = (SeqContinue)s;
                cont.setDestination(continueDest);
                continue;
            }
            if (s instanceof SeqIfElse) {
                SeqIfElse sie = (SeqIfElse)s;
                SwitchCases.replaceBreakContinue(breakDest, continueDest, sie.ifChilds);
                if (sie.elseChilds == null) continue;
                SwitchCases.replaceBreakContinue(breakDest, continueDest, sie.elseChilds);
                continue;
            }
            if (!(s instanceof SeqSelect)) continue;
            SeqSelect ss = (SeqSelect)s;
            for (SeqSelect.SelectAlternative sa : ss.alternatives) {
                if (sa.code == null) continue;
                SwitchCases.replaceBreakContinue(breakDest, continueDest, sa.code);
            }
        }
    }

    public static enum SplitReason {
        NOT_NEEDED,
        USES_BREAK,
        BLOCKS;


        public static SplitReason max(SplitReason r1, SplitReason r2) {
            if (r1 == BLOCKS || r2 == BLOCKS) {
                return BLOCKS;
            }
            if (r1 == USES_BREAK || r2 == USES_BREAK) {
                return USES_BREAK;
            }
            return NOT_NEEDED;
        }

        public boolean isMaxRelevant() {
            return this.equals((Object)BLOCKS);
        }
    }
}

