/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.OutputPosition;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.CoordObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictionaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictionaryPair;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DictionaryTypeID
extends CoordObjectTypeID {
    private String className;

    public DictionaryTypeID(TypeID keyType, TypeID valueType, CodeGeneratorContext ctxt) {
        super(TypeID.TypeKind.DICTIONARY, Lists.list((Object[])new TypeID[]{keyType, valueType}));
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("DictType");
            ctxt.addTypeName(this, this.className);
            this.addSelf(ctxt);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        return Strings.fmt((String)"dict(%s : %s)", (Object[])new Object[]{((TypeID)this.subTypes.get(0)).getTypeText(), ((TypeID)this.subTypes.get(1)).getTypeText()});
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentfile) {
        if (expr instanceof DictionaryExpression) {
            List lines = Lists.list();
            DictionaryExpression de = (DictionaryExpression)expr;
            String dest = ctxt.makeUniqueName("dict");
            String line = Strings.fmt((String)"%s %s = new %s(chiCoordinator, %d);", (Object[])new Object[]{this.className, dest, this.className, de.getPairs().size()});
            lines.add(line);
            for (DictionaryPair dp : de.getPairs()) {
                ExpressionBase ke = ExpressionBase.convertExpression(dp.getKey(), ctxt, currentfile);
                ExpressionBase ve = ExpressionBase.convertExpression(dp.getValue(), ctxt, currentfile);
                lines.addAll(ke.getCode());
                lines.addAll(ve.getCode());
                line = Strings.fmt((String)"%s.put(%s, %s);", (Object[])new Object[]{dest, ke.getValue(), ve.getValue()});
                lines.add(line);
            }
            line = OutputPosition.genCurrentPositionStatement((PositionObject)expr);
            if (line != null) {
                lines.add(line);
            }
            line = Strings.fmt((String)"if (%s.size() != %d) throw new ChiSimulatorException(\"Literal dictionary has \" + String.valueOf(%d - %s.size()) + \" duplicate key(s).\");", (Object[])new Object[]{dest, de.getPairs().size(), de.getPairs().size(), dest});
            lines.add(line);
            currentfile.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
            return ExpressionBase.makeExpression(lines, dest, null);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binexp = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexp.getLeft(), ctxt, currentfile);
            ExpressionBase right = ExpressionBase.convertExpression(binexp.getRight(), ctxt, currentfile);
            switch (binexp.getOp()) {
                case ADDITION: {
                    List lines = Lists.list();
                    String dest = ctxt.makeUniqueName("dict");
                    String text = Strings.fmt((String)"%s %s = new %s(%s, false);", (Object[])new Object[]{this.className, dest, this.className, left.getValue()});
                    lines.addAll(left.getCode());
                    lines.add(text);
                    lines.addAll(right.getCode());
                    text = Strings.fmt((String)"%s.putAll(%s);", (Object[])new Object[]{dest, right.getValue()});
                    lines.add(text);
                    return ExpressionBase.makeExpression(lines, dest, null);
                }
                case PROJECTION: {
                    List lines = Lists.list();
                    String dest = ctxt.makeUniqueName("value");
                    lines.addAll(left.getCode());
                    lines.addAll(right.getCode());
                    String rhsVar = ctxt.makeUniqueName("right");
                    String text = Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{((TypeID)this.subTypes.get(0)).getJavaType(), rhsVar, right.getValue()});
                    lines.add(text);
                    text = Strings.fmt((String)"%s %s = (%s).get(%s);", (Object[])new Object[]{((TypeID)this.subTypes.get(1)).getJavaClassType(), dest, left.getValue(), rhsVar});
                    lines.add(text);
                    text = OutputPosition.genCurrentPositionStatement((PositionObject)expr);
                    if (text != null) {
                        lines.add(text);
                    }
                    if (((TypeID)this.subTypes.get(0)).isPrintable()) {
                        text = "throw new ChiSimulatorException(\"Key \\\"\" + " + ((TypeID)this.subTypes.get(0)).getToString(rhsVar, currentfile) + " + \"\\\" does not exist in the dictionary.\");";
                        lines.add("if (" + dest + " == null) {");
                        lines.add("    " + text);
                        lines.add("}");
                    } else {
                        text = "if (" + dest + " == null) throw new " + "ChiSimulatorException(\"Key does not exist in the dictionary.\");";
                        lines.add(text);
                    }
                    currentfile.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
                    return ExpressionBase.makeExpression(lines, dest, null);
                }
                case SUBTRACTION: {
                    List lines = Lists.list();
                    String dest = ctxt.makeUniqueName("dict");
                    String text = Strings.fmt((String)"%s %s = new %s(%s, false);", (Object[])new Object[]{this.className, dest, this.className, left.getValue()});
                    lines.addAll(left.getCode());
                    lines.add(text);
                    lines.addAll(right.getCode());
                    text = OutputPosition.genCurrentPositionStatement((PositionObject)expr);
                    if (text != null) {
                        lines.add(text);
                    }
                    text = Strings.fmt((String)"%s.removeAll(%s);", (Object[])new Object[]{dest, right.getValue()});
                    lines.add(text);
                    return ExpressionBase.makeExpression(lines, dest, null);
                }
                case ELEMENT_TEST: {
                    List lines = Lists.list();
                    lines.addAll(left.getCode());
                    lines.addAll(right.getCode());
                    String text = OutputPosition.genCurrentPositionStatement((PositionObject)expr);
                    if (text != null) {
                        lines.add(text);
                    }
                    text = Strings.fmt((String)"(%s).containsKey(%s)", (Object[])new Object[]{right.getValue(), left.getValue()});
                    return ExpressionBase.makeExpression(lines, text, null);
                }
            }
            Assert.fail((String)("Unimplemented binary dictionary operator " + expr.toString()));
            return null;
        }
        Assert.fail((String)("Implement " + expr.toString() + " in DictionaryTypeID.convertExprNode"));
        return null;
    }

    private TypeID getItemType(CodeGeneratorContext ctxt) {
        List names = Lists.list((Object[])new String[]{"key", "value"});
        Assert.check((this.subTypes.size() == 2 ? 1 : 0) != 0);
        return TypeIDCreation.createTupleTypeID(names, this.subTypes, ctxt);
    }

    private void addSelf(CodeGeneratorContext ctxt) {
        TypeID keyTid = (TypeID)this.subTypes.get(0);
        String keyClassname = keyTid.getJavaClassType();
        TypeID valTid = (TypeID)this.subTypes.get(1);
        String valClassname = valTid.getJavaClassType();
        TypeID itemTid = this.getItemType(ctxt);
        String itemClsName = itemTid.getJavaClassType();
        String baseCls = "LinkedHashMap<" + keyClassname + ", " + valClassname + ">";
        List ifaces = Lists.list((Object)("Iterable<" + itemClsName + ">"));
        JavaClass cls = new JavaClass("", false, this.className, baseCls, ifaces);
        cls.addImport("java.util.LinkedHashMap", false);
        cls.addVariable("private final ChiCoordinator chiCoordinator;");
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        this.addConstructors(cls, ctxt);
        this.addDictMethods(cls, ctxt);
        this.addReadWrite(cls);
        this.addIterator(cls, ctxt);
        ctxt.addClass(cls);
    }

    private void addConstructors(JavaFile cls, CodeGeneratorContext ctxt) {
        TypeID keyTid = (TypeID)this.subTypes.get(0);
        TypeID valTid = (TypeID)this.subTypes.get(1);
        String keyClassname = keyTid.getJavaClassType();
        String valueClassname = valTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator)");
        jm.lines.add("this(chiCoordinator, 0);");
        cls.addMethod(jm);
        jm = new JavaMethod("public " + this.className + "(ChiCoordinator chiCoordinator, int size)");
        jm.lines.add("super(size);");
        jm.lines.add("this.chiCoordinator = chiCoordinator;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        boolean hasDeepcopy = keyTid.hasDeepCopy() || valTid.hasDeepCopy();
        jm = new JavaMethod("public " + this.className + "(" + this.className + " orig, boolean deepCopy)");
        jm.lines.add("super(orig.size());");
        jm.lines.add("this.chiCoordinator = orig.chiCoordinator;");
        if (!hasDeepcopy) {
            jm.lines.add("putAll(orig);");
        } else {
            String keyCopy = "e.getKey()";
            String valCopy = "e.getValue()";
            if (keyTid.hasDeepCopy()) {
                keyCopy = keyTid.getDeepCopyName(keyCopy, cls, true);
            }
            if (valTid.hasDeepCopy()) {
                valCopy = valTid.getDeepCopyName(valCopy, cls, true);
            }
            jm.lines.add("if (!deepCopy) {");
            jm.lines.add("   putAll(orig);");
            jm.lines.add("} else {");
            jm.lines.add("    for (Map.Entry<%s, %s> e: orig.entrySet()) {", new Object[]{keyClassname, valueClassname});
            jm.lines.add("        put(%s, %s);", new Object[]{keyCopy, valCopy});
            jm.lines.add("    }");
            jm.lines.add("}");
        }
        cls.addMethod(jm);
    }

    private void addDictMethods(JavaFile cls, CodeGeneratorContext ctxt) {
        TypeID keyTid = (TypeID)Lists.first((List)this.subTypes);
        TypeID valueTid = (TypeID)this.subTypes.get(1);
        String keyTypename = keyTid.getJavaType();
        String keyClassname = keyTid.getJavaClassType();
        String valueTypename = valueTid.getJavaType();
        String valueClassname = valueTid.getJavaClassType();
        List fields = Lists.list((Object[])new String[]{"key", "value", "dict"});
        List tids = Lists.list((Object[])new TypeID[]{keyTid, valueTid, this});
        TypeID tupleTid = TypeIDCreation.createTupleTypeID(fields, tids, ctxt);
        String tupName = tupleTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public " + tupName + " pop()");
        jm.lines.add("if (isEmpty()) throw new ChiSimulatorException(\"Cannot pop value from an empty dictionary.\");");
        jm.lines.add("%s res = new %s(chiCoordinator);", new Object[]{tupName, tupName});
        jm.lines.add("res.var2 = new %s(this, false);", new Object[]{this.className});
        jm.lines.add("Iterator<Map.Entry<%s, %s>> iter = res.var2.entrySet().iterator();", new Object[]{keyClassname, valueClassname});
        jm.lines.add("Map.Entry<%s, %s> entry = iter.next();", new Object[]{keyClassname, valueClassname});
        jm.lines.add("res.var0 = entry.getKey();");
        jm.lines.add("res.var1 = entry.getValue();");
        jm.lines.add("iter.remove();");
        jm.lines.add("return res;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        cls.addImport("java.util.Iterator", false);
        cls.addImport("java.util.Map", false);
        jm = new JavaMethod("public static " + this.className + " removeElement(" + this.className + " dict, " + keyTypename + " value)");
        jm.lines.add("%s res = new %s(dict, false);", new Object[]{this.className, this.className});
        jm.lines.add("if (res.remove(value) != null) return res;");
        jm.lines.add("return dict;");
        cls.addMethod(jm);
        String smallestText = null;
        String biggestText = null;
        if (keyTid.kind == TypeID.TypeKind.INT || keyTid.kind == TypeID.TypeKind.REAL) {
            smallestText = "result > value";
            biggestText = "result < value";
        } else if (keyTid.kind == TypeID.TypeKind.STRING) {
            smallestText = "result.compareTo(value) > 0";
            biggestText = "result.compareTo(value) < 0";
        }
        if (smallestText != null) {
            jm = new JavaMethod("public " + keyTypename + " getMinimum()");
            jm.lines.add("%s result = null;", new Object[]{keyClassname});
            jm.lines.add("for (%s value: this.keySet()) {", new Object[]{keyClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{smallestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a smallest value in an empty dictionary.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
        if (biggestText != null) {
            jm = new JavaMethod("public " + keyTypename + " getMaximum()");
            jm.lines.add("%s result = null;", new Object[]{keyClassname});
            jm.lines.add("for (%s value: this.keySet()) {", new Object[]{keyClassname});
            jm.lines.add("    if (result == null || %s) result = value;", new Object[]{biggestText});
            jm.lines.add("}");
            jm.lines.add("if (result == null) throw new ChiSimulatorException(\"Cannot find a biggest value in an empty dictionary.\");");
            jm.lines.add("return result;");
            cls.addMethod(jm);
            cls.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
        jm = new JavaMethod("public " + this.className + " modify(" + keyTypename + " key, " + valueTypename + " value)");
        jm.lines.add("%s result = new %s(this, false);", new Object[]{this.className, this.className});
        jm.lines.add("result.put(key, value);");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        jm = new JavaMethod("public void removeAll(" + this.className + " d)");
        jm.lines.add("for (Map.Entry<%s, %s> e: d.entrySet()) {", new Object[]{keyClassname, valueClassname});
        jm.lines.add("    remove(e.getKey());");
        jm.lines.add("}");
        cls.addMethod(jm);
        TypeID tid = TypeIDCreation.makeSetTypeID(keyTid, ctxt);
        String containerName = tid.getJavaClassType();
        jm = new JavaMethod("public void removeAll(" + containerName + " s)");
        jm.lines.add("for (%s e: s) {", new Object[]{keyClassname});
        jm.lines.add("    remove(e);");
        jm.lines.add("}");
        cls.addMethod(jm);
        tid = TypeIDCreation.makeListTypeID(keyTid, ctxt);
        containerName = tid.getJavaClassType();
        jm = new JavaMethod("public void removeAll(" + containerName + " s)");
        jm.lines.add("for (%s e: s) {", new Object[]{keyClassname});
        jm.lines.add("    remove(e);");
        jm.lines.add("}");
        cls.addMethod(jm);
        TypeID lstTid = TypeIDCreation.makeListTypeID(keyTid, ctxt);
        String lstClassname = lstTid.getJavaClassType();
        jm = new JavaMethod("public " + lstClassname + " getKeyList()");
        jm.lines.add("%s result = new %s(chiCoordinator, this.size());", new Object[]{lstClassname, lstClassname});
        jm.lines.add("for (Map.Entry<%s, %s> e: this.entrySet()) {", new Object[]{keyClassname, valueClassname});
        jm.lines.add("    result.append(e.getKey());");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        lstTid = TypeIDCreation.makeListTypeID(valueTid, ctxt);
        lstClassname = lstTid.getJavaClassType();
        jm = new JavaMethod("public " + lstClassname + " getValueList()");
        jm.lines.add("%s result = new %s(chiCoordinator, this.size());", new Object[]{lstClassname, lstClassname});
        jm.lines.add("for (Map.Entry<%s, %s> e: this.entrySet()) {", new Object[]{keyClassname, valueClassname});
        jm.lines.add("    result.append(e.getValue());");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
    }

    private void addReadWrite(JavaFile cls) {
        if (!this.isPrintable()) {
            return;
        }
        TypeID keyTid = (TypeID)this.subTypes.get(0);
        TypeID valTid = (TypeID)this.subTypes.get(1);
        String keyClassname = keyTid.getJavaClassType();
        String valueClassname = valTid.getJavaClassType();
        JavaMethod jm = new JavaMethod("public static " + this.className + " read(ChiCoordinator chiCoordinator, ChiFileHandle stream)");
        String rdKey = Strings.fmt((String)"%s key = %s;", (Object[])new Object[]{keyClassname, keyTid.getReadName("stream", cls)});
        String rdVal = Strings.fmt((String)"%s val = %s;", (Object[])new Object[]{valueClassname, valTid.getReadName("stream", cls)});
        jm.lines.add(String.valueOf(this.className) + " result = new " + this.className + "(chiCoordinator);");
        jm.lines.add();
        jm.lines.add("stream.expectCharacter('{');");
        jm.lines.add("for (;;) {");
        jm.lines.add("    " + rdKey);
        jm.lines.add("stream.expectCharacter(':');");
        jm.lines.add("    " + rdVal);
        jm.lines.add("    result.put(key, val);");
        jm.lines.add("    int ch = stream.expectCharacter(',', '}');");
        jm.lines.add("    if (ch == '}') break;");
        jm.lines.add("    if (ch == ',') continue;");
        jm.lines.add("}");
        jm.lines.add("return result;");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        cls.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        jm = new JavaMethod("public void write(ChiFileHandle stream)");
        jm.lines.add("stream.write(\"{\");");
        jm.lines.add("boolean first = true;");
        jm.lines.add("for (Map.Entry<%s, %s> e: this.entrySet()) {", new Object[]{keyClassname, valueClassname});
        jm.lines.add("    if (!first) stream.write(\", \");");
        jm.lines.add("    first = false;");
        jm.lines.add("    " + keyTid.getWriteName("stream", "e.getKey()", cls));
        jm.lines.add("    stream.write(\" : \");");
        jm.lines.add("    " + valTid.getWriteName("stream", "e.getValue()", cls));
        jm.lines.add("}");
        jm.lines.add("stream.write(\"}\");");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiFileHandle", false);
        cls.addImport("java.util.Map", false);
        jm = new JavaMethod("public String toString()");
        jm.lines.add("ChiWriteMemoryFile mem = new ChiWriteMemoryFile();");
        jm.lines.add("write(mem);");
        jm.lines.add("return mem.getData();");
        cls.addMethod(jm);
        cls.addImport("org.eclipse.escet.chi.runtime.data.io.ChiWriteMemoryFile", false);
    }

    private void addIterator(JavaFile cls, CodeGeneratorContext ctxt) {
        TypeID keyTid = (TypeID)this.subTypes.get(0);
        TypeID valTid = (TypeID)this.subTypes.get(1);
        String keyClassname = keyTid.getJavaClassType();
        String valueClassname = valTid.getJavaClassType();
        String iterClsName = ctxt.makeUniqueName("DictIter");
        String itemClsName = this.getItemType(ctxt).getJavaClassType();
        String mapEntriesType = Strings.fmt((String)"Map.Entry<%s, %s>", (Object[])new Object[]{keyClassname, valueClassname});
        JavaMethod jm = new JavaMethod("class " + iterClsName + " implements Iterator<" + itemClsName + ">");
        jm.lines.add("private Iterator<%s> iter;", new Object[]{mapEntriesType});
        jm.lines.add();
        jm.lines.add("public %s(Set<%s> entries) {", new Object[]{iterClsName, mapEntriesType});
        jm.lines.add("    iter = entries.iterator();");
        jm.lines.add("}");
        jm.lines.add();
        jm.lines.add("public boolean hasNext() { return iter.hasNext(); }");
        jm.lines.add("public void remove() { iter.remove(); }");
        jm.lines.add();
        jm.lines.add("public %s next() {", new Object[]{itemClsName});
        jm.lines.add("    %s tup = new %s(chiCoordinator);", new Object[]{itemClsName, itemClsName});
        jm.lines.add("    %s entry = iter.next();", new Object[]{mapEntriesType});
        jm.lines.add("    tup.var0 = entry.getKey();");
        jm.lines.add("    tup.var1 = entry.getValue();");
        jm.lines.add("    return tup;");
        jm.lines.add("}");
        cls.addMethod(jm);
        cls.addImport("java.util.Set", false);
        jm = new JavaMethod("public " + iterClsName + " iterator()");
        jm.lines.add("return new %s(this.entrySet());", new Object[]{iterClsName});
        cls.addMethod(jm);
    }
}

