/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.ChiSvgOutput;
import org.eclipse.escet.chi.runtime.SelectChoice;
import org.eclipse.escet.chi.runtime.SelectDelay;
import org.eclipse.escet.chi.runtime.SimulationResult;
import org.eclipse.escet.chi.runtime.SimulationState;
import org.eclipse.escet.chi.runtime.TerminatedException;
import org.eclipse.escet.chi.runtime.data.BaseProcess;
import org.eclipse.escet.chi.runtime.data.Channel;
import org.eclipse.escet.chi.runtime.data.CoreProcess;
import org.eclipse.escet.chi.runtime.data.PositionData;
import org.eclipse.escet.chi.runtime.data.Timer;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.chi.runtime.data.random.IntegerUniformDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.removablelist.RemovableElement;
import org.eclipse.escet.common.java.removablelist.RemovableList;

public class SimulationData {
    private final Application<?> app;
    private final ChiCoordinator coord;
    public SimulationState simState = SimulationState.STARTING;
    public final SimulationData parentSim;
    private double simulationTime = 0.0;
    private TreeSet<Timer> timers = new TreeSet();
    public SimulationResult.ExitReason exitReason = null;
    private BaseProcess currentProcess = null;
    private RemovableList<BaseProcess> readyProcesses = new RemovableList();
    private RemovableList<BaseProcess> blockedProcesses = new RemovableList();
    private RemovableList<Channel> commChoices = new RemovableList();
    private RemovableList<SelectChoice> nocommChoices = new RemovableList();
    private RemovableList<SelectChoice> runChoices = new RemovableList();
    private boolean inspectRunChoices = true;
    private List<SelectChoice> viableSenders = Lists.list();
    private final RandomGenerator selaltGen;
    private Set<ChiFileHandle> openedFiles = Sets.set();
    private ChiSvgOutput svgOutput = null;
    public Object exitValue = null;

    public SimulationData(Application<?> app, ChiCoordinator coord, SimulationData parentSim) {
        this.app = app;
        this.coord = coord;
        this.selaltGen = coord.getFreshGenerator();
        this.parentSim = parentSim;
    }

    public Timer addTimer(Timer t) {
        if (t.endTime <= this.simulationTime) {
            return null;
        }
        if (this.timers.add(t)) {
            return t;
        }
        Timer authTimer = this.timers.floor(t);
        Assert.check((authTimer != null && authTimer != t ? 1 : 0) != 0);
        return authTimer;
    }

    public ChiFileHandle openFile(String path, String operation, String type) {
        if (path.startsWith("SVG:")) {
            if (!operation.equals("w")) {
                String msg = "SVG output must be opened for write-only.";
                throw new ChiSimulatorException(msg);
            }
            Assert.check((boolean)type.equals("text"));
            if (this.svgOutput == null) {
                this.svgOutput = new ChiSvgOutput(this.coord, path);
                this.svgOutput.openCalled();
                return this.svgOutput;
            }
            if (!this.svgOutput.filename.equals(path)) {
                String msg = Strings.fmt((String)"SVG output of file \"%s\" requested, but already opened file \"%s\".", (Object[])new Object[]{path, this.svgOutput.filename});
                throw new ChiSimulatorException(msg);
            }
            this.svgOutput.openCalled();
            return this.svgOutput;
        }
        ChiFileHandle cfh = ChiFileHandle.createFile(path, operation, type);
        if (this.isFileOpened(cfh)) {
            throw new ChiSimulatorException("File \"" + path + "\" is already opened for IO.");
        }
        this.openedFiles.add(cfh);
        return cfh;
    }

    protected boolean isFileOpened(ChiFileHandle handle) {
        if (this.openedFiles.contains(handle)) {
            return true;
        }
        if (this.parentSim == null) {
            return false;
        }
        return this.parentSim.isFileOpened(handle);
    }

    public void closeFiles() {
        for (ChiFileHandle cfh : this.openedFiles) {
            cfh.close();
        }
        if (this.svgOutput != null) {
            this.svgOutput.closeDown();
        }
    }

    public void closeFile(ChiFileHandle handle) {
        handle.close();
        if (handle.isClosed()) {
            this.openedFiles.remove(handle);
        }
    }

    public void setSelect(BaseProcess proc, List<SelectChoice> choices) {
        Assert.check((this.currentProcess == proc ? 1 : 0) != 0);
        this.currentProcess.blockedChoices = choices;
    }

    public void setTerminateAll(Object exitValue, SimulationResult.ExitReason reason) {
        this.exitReason = reason;
        if (this.exitValue == null) {
            this.exitValue = exitValue;
        }
    }

    public void testTerminating() {
        if (this.exitReason == null) {
            if (!this.app.getAppEnvData().isTerminationRequested()) {
                return;
            }
            this.setTerminateAll(null, SimulationResult.ExitReason.ABORTED);
        }
        throw new TerminatedException();
    }

    public void addProcess(BaseProcess newProcess) {
        Assert.check((newProcess != null ? 1 : 0) != 0);
        Assert.check((this.currentProcess == null || this.currentProcess != newProcess ? 1 : 0) != 0);
        int i = 0;
        while (i < this.readyProcesses.size()) {
            Assert.check((this.readyProcesses.get(i) != newProcess ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < this.blockedProcesses.size()) {
            Assert.check((this.blockedProcesses.get(i) != newProcess ? 1 : 0) != 0);
            ++i;
        }
        if (this.exitReason == null) {
            this.readyProcesses.add((RemovableElement)newProcess);
        }
    }

    public double getCurrentTime() {
        return this.simulationTime;
    }

    public boolean endedWithDeadlock() {
        return !this.blockedProcesses.isEmpty();
    }

    private String dumpStackPositions() {
        if (this.currentProcess.positionStack == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int i = this.currentProcess.positionStack.size() - 1;
        while (i >= 0) {
            PositionData pd = this.currentProcess.positionStack.get(i);
            sb.append(first ? "\nat " : "\ncalled from ");
            sb.append(pd.getPosition());
            sb.append(".");
            first = false;
            --i;
        }
        return sb.toString();
    }

    private void executeReadyProcesses() {
        while (true) {
            CoreProcess.RunResult state;
            this.currentProcess = (BaseProcess)this.readyProcesses.poll();
            if (this.currentProcess == null) break;
            Assert.check((this.currentProcess.blockedChoices == null ? 1 : 0) != 0);
            SelectChoice currentChoice = this.currentProcess.readyChoice;
            this.currentProcess.readyChoice = null;
            try {
                state = this.currentProcess.run(currentChoice);
            }
            catch (ChiSimulatorException e) {
                this.setTerminateAll(null, SimulationResult.ExitReason.ERROR);
                String msg = Strings.fmt((String)"Runtime error while executing \"%s\".%s", (Object[])new Object[]{this.currentProcess.name, this.dumpStackPositions()});
                throw new ChiSimulatorException(msg, (Throwable)((Object)e));
            }
            catch (StackOverflowError e) {
                this.setTerminateAll(null, SimulationResult.ExitReason.ERROR);
                String msg = Strings.fmt((String)"Too many nested function invocations while executing \"%s\".%s", (Object[])new Object[]{this.currentProcess.name, this.dumpStackPositions()});
                throw new ChiSimulatorException(msg, e);
            }
            catch (TerminatedException e) {
                state = CoreProcess.RunResult.TERMINATED;
            }
            this.currentProcess.setState(state);
            if (state == CoreProcess.RunResult.BLOCKED) {
                this.blockProcess(this.currentProcess);
                continue;
            }
            Assert.check((state == CoreProcess.RunResult.FINISHED || state == CoreProcess.RunResult.TERMINATED ? 1 : 0) != 0);
            this.currentProcess = null;
            this.inspectRunChoices = true;
            if (this.exitReason != null) break;
        }
    }

    private void blockProcess(BaseProcess proc) {
        this.blockedProcesses.add((RemovableElement)proc);
        Assert.check((proc.blockedChoices != null ? 1 : 0) != 0);
        block11: for (SelectChoice choice : proc.blockedChoices) {
            switch (choice.guardKind) {
                case FALSE: {
                    break;
                }
                case CHILDS: {
                    this.runChoices.add((RemovableElement)choice);
                    this.inspectRunChoices = true;
                    break;
                }
                case TIMER: {
                    SelectDelay delayCh = (SelectDelay)choice;
                    Timer authTimer = delayCh.getTimer().authorativeTimer;
                    if (authTimer != null) {
                        authTimer.choices.add((RemovableElement)delayCh);
                        break;
                    }
                }
                case TRUE: 
                case FUNC: {
                    switch (choice.channelKind) {
                        case NONE: {
                            this.nocommChoices.add((RemovableElement)choice);
                            break;
                        }
                        case RECEIVE: {
                            Channel ch = choice.channel;
                            ch.receivers.add((RemovableElement)choice);
                            if (ch.getListIndex() >= 0 || ch.senders.isEmpty()) continue block11;
                            this.commChoices.add((RemovableElement)ch);
                            break;
                        }
                        case SEND: {
                            Channel ch = choice.channel;
                            ch.senders.add((RemovableElement)choice);
                            if (ch.getListIndex() >= 0 || ch.receivers.isEmpty()) continue block11;
                            this.commChoices.add((RemovableElement)ch);
                            break;
                        }
                        default: {
                            Assert.fail((String)"Unexpected channel kind found.");
                            break;
                        }
                    }
                    continue block11;
                }
                default: {
                    Assert.fail((String)"Encountered unknown guard kind.");
                }
            }
        }
    }

    private int unblockProcess(BaseProcess proc) {
        proc.remove();
        int unblockCount = 0;
        block10: for (SelectChoice choice : proc.blockedChoices) {
            switch (choice.guardKind) {
                case FALSE: {
                    break;
                }
                case TIMER: 
                case CHILDS: {
                    choice.remove();
                    ++unblockCount;
                    break;
                }
                case TRUE: 
                case FUNC: {
                    switch (choice.channelKind) {
                        case NONE: {
                            choice.remove();
                            ++unblockCount;
                            break;
                        }
                        case RECEIVE: {
                            choice.remove();
                            ++unblockCount;
                            Channel ch = choice.channel;
                            if (ch.getListIndex() < 0 || !ch.receivers.isEmpty()) continue block10;
                            ch.remove();
                            break;
                        }
                        case SEND: {
                            choice.remove();
                            ++unblockCount;
                            Channel ch = choice.channel;
                            if (ch.getListIndex() < 0 || !ch.senders.isEmpty()) continue block10;
                            ch.remove();
                            break;
                        }
                        default: {
                            Assert.fail((String)"Unexpected channel kind found.");
                            break;
                        }
                    }
                    continue block10;
                }
                default: {
                    Assert.fail((String)"Encountered unknown guard kind.");
                }
            }
        }
        return unblockCount;
    }

    private boolean awakeTimerChoices(Timer authTimer) {
        int size = authTimer.choices.size();
        switch (size) {
            case 0: {
                return false;
            }
            case 1: {
                SelectChoice choice = (SelectChoice)authTimer.choices.get(0);
                BaseProcess proc = choice.getProcess();
                this.unblockProcess(proc);
                proc.readyChoice = choice;
                proc.blockedChoices = null;
                this.readyProcesses.add((RemovableElement)proc);
                return true;
            }
        }
        List choices = Lists.listc((int)size);
        int idx = IntegerUniformDistribution.drawIntegerUniform(this.selaltGen, 0, size);
        int count = 0;
        while (count < size) {
            choices.add((SelectChoice)authTimer.choices.get(idx));
            if (++idx == size) {
                idx = 0;
            }
            ++count;
        }
        for (SelectChoice choice : choices) {
            BaseProcess proc = choice.getProcess();
            this.unblockProcess(proc);
            proc.readyChoice = choice;
            proc.blockedChoices = null;
            this.readyProcesses.add((RemovableElement)proc);
        }
        return true;
    }

    public void run() {
        block12: {
            this.simState = SimulationState.RUNNING;
            this.exitValue = null;
            try {
                try {
                    while (true) {
                        this.executeReadyProcesses();
                        if (this.exitReason != null) {
                            this.readyProcesses.clear();
                            this.blockedProcesses.clear();
                            this.commChoices.clear();
                            this.nocommChoices.clear();
                            this.runChoices.clear();
                            break block12;
                        }
                        if (this.findNonblocked()) continue;
                        boolean foundReadyProcesses = false;
                        while (!this.timers.isEmpty()) {
                            Timer authTimer = this.timers.pollFirst();
                            boolean expired = authTimer.isReady();
                            if (!expired) {
                                this.simulationTime = authTimer.endTime;
                            }
                            if (this.awakeTimerChoices(authTimer)) {
                                foundReadyProcesses = true;
                                break;
                            }
                            if (expired || !this.findNonblocked()) continue;
                            foundReadyProcesses = true;
                            break;
                        }
                        if (!foundReadyProcesses) break;
                    }
                    this.exitReason = this.endedWithDeadlock() ? SimulationResult.ExitReason.DEADLOCKED : SimulationResult.ExitReason.FINISHED;
                }
                catch (ArithmeticException exc) {
                    String msg = "An arithmetic exception occurred.";
                    throw new ChiSimulatorException(msg, exc);
                }
                catch (InvalidInputException exc) {
                    String msg = "Invalid input was encountered.";
                    throw new ChiSimulatorException(msg, exc);
                }
                catch (TerminatedException exc) {
                    this.closeFiles();
                    this.simState = SimulationState.FINISHED;
                    return;
                }
            }
            finally {
                this.closeFiles();
                this.simState = SimulationState.FINISHED;
            }
        }
        Assert.check((boolean)this.readyProcesses.isEmpty());
    }

    private boolean evalGuard(SelectChoice choice) {
        boolean result;
        if (choice.guardKind == SelectChoice.GuardKind.TRUE) {
            return true;
        }
        try {
            result = choice.getGuard();
        }
        catch (ChiSimulatorException ex) {
            this.setTerminateAll(null, SimulationResult.ExitReason.ERROR);
            String msg = Strings.fmt((String)"Runtime error while executing \"%s\".", (Object[])new Object[]{choice.getProcess().name});
            throw new ChiSimulatorException(msg, (Throwable)((Object)ex));
        }
        return result;
    }

    private void communicate(SelectChoice sendChoice, SelectChoice recvChoice) {
        Object data;
        try {
            data = sendChoice.getSendData();
        }
        catch (ChiSimulatorException ex) {
            this.setTerminateAll(null, SimulationResult.ExitReason.ERROR);
            String msg = Strings.fmt((String)"Runtime error while sending from \"%s\".", (Object[])new Object[]{sendChoice.getProcess().name});
            throw new ChiSimulatorException(msg, (Throwable)((Object)ex));
        }
        try {
            recvChoice.putReceiveData(data);
        }
        catch (ChiSimulatorException ex) {
            this.setTerminateAll(null, SimulationResult.ExitReason.ERROR);
            String msg = Strings.fmt((String)"Runtime error while receiving at \"%s\".", (Object[])new Object[]{sendChoice.getProcess().name});
            throw new ChiSimulatorException(msg, (Throwable)((Object)ex));
        }
    }

    private boolean isGoodChoice(SelectChoice choice) {
        switch (choice.guardKind) {
            case FALSE: 
            case TIMER: 
            case CHILDS: {
                return false;
            }
            case TRUE: 
            case FUNC: {
                switch (choice.channelKind) {
                    case NONE: {
                        return true;
                    }
                    case SEND: {
                        return false;
                    }
                    case RECEIVE: {
                        return choice.channel.getListIndex() >= 0;
                    }
                }
                Assert.fail((String)"Unexpected channel kind found.");
                return false;
            }
        }
        Assert.fail((String)"Unexpected guard kind found.");
        return false;
    }

    private SelectChoice getSearchStartingPoint() {
        int count = 0;
        while (count < 3) {
            BaseProcess proc = this.blockedProcesses.size() == 1 ? (BaseProcess)this.blockedProcesses.get(0) : (BaseProcess)this.blockedProcesses.get(IntegerUniformDistribution.drawIntegerUniform(this.selaltGen, 0, this.blockedProcesses.size()));
            switch (proc.blockedChoices.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    SelectChoice choice = proc.blockedChoices.get(0);
                    if (!this.isGoodChoice(choice)) break;
                    return choice;
                }
                default: {
                    SelectChoice choice = proc.blockedChoices.get(IntegerUniformDistribution.drawIntegerUniform(this.selaltGen, 0, proc.blockedChoices.size()));
                    if (!this.isGoodChoice(choice)) break;
                    return choice;
                }
            }
            ++count;
        }
        return null;
    }

    private boolean searchNocommChoices(int start) {
        int count = 0;
        while (count < this.nocommChoices.size()) {
            SelectChoice choice = (SelectChoice)this.nocommChoices.get(start);
            if (this.evalGuard(choice)) {
                BaseProcess proc = choice.getProcess();
                this.unblockProcess(proc);
                proc.readyChoice = choice;
                proc.blockedChoices = null;
                this.readyProcesses.add((RemovableElement)proc);
                return true;
            }
            if (++start == this.nocommChoices.size()) {
                start = 0;
            }
            ++count;
        }
        return false;
    }

    private SelectChoice buildOther(RemovableList<SelectChoice> allOthers, List<SelectChoice> trueOthers, BaseProcess proc) {
        int start = allOthers.size() == 1 ? 0 : IntegerUniformDistribution.drawIntegerUniform(this.selaltGen, 0, allOthers.size());
        int count = 0;
        while (count < allOthers.size()) {
            SelectChoice other = (SelectChoice)allOthers.get(start);
            if (this.evalGuard(other)) {
                trueOthers.add(other);
                if (other.getProcess() != proc) {
                    return other;
                }
            }
            if (++start == allOthers.size()) {
                start = 0;
            }
            ++count;
        }
        return null;
    }

    private SelectChoice findOther(List<SelectChoice> trueOthers, BaseProcess proc) {
        for (SelectChoice other : trueOthers) {
            if (other.getProcess() == proc) continue;
            return other;
        }
        return null;
    }

    private boolean searchReceiverChoices(int chStart, int recvStart) {
        int chanCount = 0;
        while (chanCount < this.commChoices.size()) {
            Channel chan = (Channel)this.commChoices.get(chStart);
            if (!chan.senders.isEmpty()) {
                boolean hasCachedSenders = false;
                int rcvCnt = 0;
                while (rcvCnt < chan.receivers.size()) {
                    SelectChoice recvChoice = (SelectChoice)chan.receivers.get(recvStart);
                    if (this.evalGuard(recvChoice)) {
                        SelectChoice sendChoice;
                        BaseProcess recvProc = recvChoice.getProcess();
                        if (!hasCachedSenders) {
                            this.viableSenders.clear();
                            sendChoice = this.buildOther(chan.senders, this.viableSenders, recvProc);
                            hasCachedSenders = true;
                        } else {
                            sendChoice = this.findOther(this.viableSenders, recvProc);
                        }
                        if (sendChoice != null) {
                            this.communicate(sendChoice, recvChoice);
                            this.unblockProcess(recvProc);
                            recvProc.readyChoice = recvChoice;
                            recvProc.blockedChoices = null;
                            this.readyProcesses.add((RemovableElement)recvProc);
                            BaseProcess sendProc = sendChoice.getProcess();
                            this.unblockProcess(sendProc);
                            sendProc.readyChoice = sendChoice;
                            sendProc.blockedChoices = null;
                            this.readyProcesses.add((RemovableElement)sendProc);
                            return true;
                        }
                    }
                    if (++recvStart == chan.receivers.size()) {
                        recvStart = 0;
                    }
                    ++rcvCnt;
                }
            }
            recvStart = 0;
            if (++chStart == this.commChoices.size()) {
                chStart = 0;
            }
            ++chanCount;
        }
        return false;
    }

    private boolean searchRunchoices() {
        boolean foundRunnable = false;
        int idx = 0;
        while (idx < this.runChoices.size()) {
            SelectChoice choice = (SelectChoice)this.runChoices.get(idx);
            if (!choice.getGuard()) {
                ++idx;
                continue;
            }
            BaseProcess proc = choice.getProcess();
            if (this.unblockProcess(proc) > 1) {
                idx = 0;
            }
            proc.readyChoice = choice;
            proc.blockedChoices = null;
            this.readyProcesses.add((RemovableElement)proc);
            foundRunnable = true;
        }
        return foundRunnable;
    }

    private boolean findNonblocked() {
        SelectChoice choice;
        if (this.blockedProcesses.isEmpty()) {
            return false;
        }
        if (this.inspectRunChoices) {
            this.inspectRunChoices = false;
            if (this.searchRunchoices()) {
                return true;
            }
        }
        if ((choice = this.getSearchStartingPoint()) == null) {
            return this.searchNocommChoices(0) || this.searchReceiverChoices(0, 0);
        }
        switch (choice.channelKind) {
            case NONE: {
                return this.searchNocommChoices(choice.getListIndex()) || this.searchReceiverChoices(0, 0);
            }
            case RECEIVE: {
                return this.searchReceiverChoices(choice.channel.getListIndex(), choice.getListIndex()) || this.searchNocommChoices(0);
            }
        }
        Assert.fail((String)Strings.fmt((String)"Unexpected channel kind encountered: %s.", (Object[])new Object[]{choice.channelKind}));
        return false;
    }
}

