/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.ChannelOps;
import org.eclipse.escet.chi.metamodel.chi.ChannelType;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.DistributionType;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumTypeReference;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FunctionType;
import org.eclipse.escet.chi.metamodel.chi.InstanceType;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.chi.metamodel.chi.ModelType;
import org.eclipse.escet.chi.metamodel.chi.ProcessType;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TimerType;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.TypeDeclaration;
import org.eclipse.escet.chi.metamodel.chi.TypeReference;
import org.eclipse.escet.chi.metamodel.chi.UnresolvedType;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckExpression;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.TypeSymbolEntry;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public abstract class CheckType {
    public static Type copyType(Type t) {
        return (Type)EMFHelper.deepclone((EObject)t);
    }

    public static List<Type> copyTypes(List<Type> tlist) {
        List newList = Lists.listc((int)tlist.size());
        for (Type t : tlist) {
            newList.add(CheckType.copyType(t));
        }
        return newList;
    }

    public static boolean matchTypeList(List<Type> provs, List<Type> reqs) {
        if (provs.size() != reqs.size()) {
            return false;
        }
        int i = 0;
        while (i < provs.size()) {
            if (!CheckType.matchType(provs.get(i), reqs.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean matchType(Type prov, Type req) {
        ModelType procReq;
        ModelType procProv;
        FunctionType f2;
        FunctionType f1;
        while (true) {
            Assert.check((prov != null ? 1 : 0) != 0);
            Assert.check((req != null ? 1 : 0) != 0);
            Assert.check((!(prov instanceof UnresolvedType) && !(req instanceof UnresolvedType) ? 1 : 0) != 0);
            prov = CheckType.dropReferences(prov);
            req = CheckType.dropReferences(req);
            if (prov == req || prov instanceof VoidType && req instanceof VoidType || prov instanceof FileType && req instanceof FileType || prov instanceof BoolType && req instanceof BoolType || prov instanceof IntType && req instanceof IntType || prov instanceof TimerType && req instanceof TimerType || prov instanceof StringType && req instanceof StringType || prov instanceof RealType && req instanceof RealType || prov instanceof InstanceType && req instanceof InstanceType) {
                return true;
            }
            if (prov instanceof ListType && req instanceof ListType) {
                prov = ((ListType)prov).getElementType();
                req = ((ListType)req).getElementType();
                continue;
            }
            if (prov instanceof SetType && req instanceof SetType) {
                prov = ((SetType)prov).getElementType();
                req = ((SetType)req).getElementType();
                continue;
            }
            if (prov instanceof DistributionType && req instanceof DistributionType) {
                prov = ((DistributionType)prov).getResultType();
                req = ((DistributionType)req).getResultType();
                continue;
            }
            if (prov instanceof ChannelType && req instanceof ChannelType) {
                ChannelType cprov = (ChannelType)prov;
                ChannelType creq = (ChannelType)req;
                switch (creq.getOps()) {
                    case RECEIVE: {
                        if (cprov.getOps() != ChannelOps.SEND) break;
                        return false;
                    }
                    case SEND: {
                        if (cprov.getOps() != ChannelOps.RECEIVE) break;
                        return false;
                    }
                    case SEND_RECEIVE: {
                        if (cprov.getOps() == ChannelOps.SEND_RECEIVE) break;
                        return false;
                    }
                    default: {
                        Assert.fail((String)"Unknown channel direction encountered.");
                    }
                }
                prov = cprov.getElementType();
                req = creq.getElementType();
                continue;
            }
            if (prov instanceof DictType && req instanceof DictType) {
                DictType d1 = (DictType)prov;
                DictType d2 = (DictType)req;
                if (!CheckType.matchType(d1.getKeyType(), d2.getKeyType())) {
                    return false;
                }
                prov = d1.getValueType();
                req = d2.getValueType();
                continue;
            }
            if (!(prov instanceof FunctionType) || !(req instanceof FunctionType)) break;
            f1 = (FunctionType)prov;
            f2 = (FunctionType)req;
            if (!CheckType.matchTypeList((List<Type>)f1.getParameterTypes(), (List<Type>)f2.getParameterTypes())) {
                return false;
            }
            prov = f1.getResultType();
            req = f2.getResultType();
        }
        if (prov instanceof ModelType && req instanceof ModelType) {
            procProv = (ModelType)prov;
            procReq = (ModelType)req;
            if (!CheckType.matchTypeList((List<Type>)procProv.getParameterTypes(), (List<Type>)procReq.getParameterTypes())) {
                return false;
            }
            if (procProv.getExitType() == null && procReq.getExitType() == null) {
                return true;
            }
            if (procProv.getExitType() == null || procReq.getExitType() == null) {
                return false;
            }
            return CheckType.matchType(procProv.getExitType(), procReq.getExitType());
        }
        if (prov instanceof ProcessType && req instanceof ProcessType) {
            procProv = (ProcessType)prov;
            procReq = (ProcessType)req;
            if (!CheckType.matchTypeList((List<Type>)procProv.getParameterTypes(), (List<Type>)procReq.getParameterTypes())) {
                return false;
            }
            if (procProv.getExitType() == null && procReq.getExitType() == null) {
                return true;
            }
            if (procProv.getExitType() == null || procReq.getExitType() == null) {
                return false;
            }
            return CheckType.matchType(procProv.getExitType(), procReq.getExitType());
        }
        if (prov instanceof TupleType && req instanceof TupleType) {
            f1 = ((TupleType)prov).getFields();
            f2 = ((TupleType)req).getFields();
            if (f1.size() != f2.size()) {
                return false;
            }
            int i = 0;
            while (i < f1.size()) {
                if (!CheckType.matchType(((TupleField)f1.get(i)).getType(), ((TupleField)f2.get(i)).getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (prov instanceof MatrixType && req instanceof MatrixType) {
            MatrixType m1 = (MatrixType)prov;
            MatrixType m2 = (MatrixType)req;
            if (CheckExpression.evalExpression(m1.getColumnSize(), null) != CheckExpression.evalExpression(m2.getColumnSize(), null)) {
                return false;
            }
            return CheckExpression.evalExpression(m1.getRowSize(), null) == CheckExpression.evalExpression(m2.getRowSize(), null);
        }
        if (prov instanceof EnumTypeReference && req instanceof EnumTypeReference) {
            EnumTypeReference ert1 = (EnumTypeReference)prov;
            EnumTypeReference ert2 = (EnumTypeReference)req;
            return ert1.getType() == ert2.getType();
        }
        return false;
    }

    private static List<Type> smallestTypeList(List<Type> tl1, List<Type> tl2) {
        if (tl1.size() != tl2.size()) {
            return null;
        }
        List resList = Lists.listc((int)tl1.size());
        int i = 0;
        while (i < tl1.size()) {
            Type t = CheckType.smallestType(tl1.get(i), tl2.get(i));
            if (t == null) {
                return null;
            }
            resList.add(t);
            ++i;
        }
        return resList;
    }

    public static Type smallestType(Type t1, Type t2) {
        Assert.check((t1 != null ? 1 : 0) != 0);
        Assert.check((t2 != null ? 1 : 0) != 0);
        t1 = CheckType.dropReferences(t1);
        t2 = CheckType.dropReferences(t2);
        if (t1 instanceof VoidType && t2 instanceof VoidType) {
            return ChiConstructors.newVoidType(null);
        }
        if (t1 instanceof FileType && t2 instanceof FileType) {
            return ChiConstructors.newFileType(null);
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return ChiConstructors.newBoolType(null);
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return ChiConstructors.newIntType(null);
        }
        if (t1 instanceof TimerType && t2 instanceof TimerType) {
            return ChiConstructors.newTimerType(null);
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return ChiConstructors.newStringType(null);
        }
        if (t1 instanceof RealType && t2 instanceof RealType) {
            return ChiConstructors.newRealType(null);
        }
        if (t1 instanceof InstanceType && t2 instanceof InstanceType) {
            return ChiConstructors.newInstanceType(null);
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType x1 = (ListType)t1;
            ListType x2 = (ListType)t2;
            t1 = CheckType.smallestType(x1.getElementType(), x2.getElementType());
            if (t1 == null) {
                return null;
            }
            return ChiConstructors.newListType((Type)t1, null, null);
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType x1 = (SetType)t1;
            SetType x2 = (SetType)t2;
            t1 = CheckType.smallestType(x1.getElementType(), x2.getElementType());
            if (t1 == null) {
                return null;
            }
            return ChiConstructors.newSetType((Type)t1, null);
        }
        if (t1 instanceof DistributionType && t2 instanceof DistributionType) {
            DistributionType x1 = (DistributionType)t1;
            DistributionType x2 = (DistributionType)t2;
            t1 = CheckType.smallestType(x1.getResultType(), x2.getResultType());
            if (t1 == null) {
                return null;
            }
            return ChiConstructors.newDistributionType(null, (Type)t1);
        }
        if (t1 instanceof ChannelType && t2 instanceof ChannelType) {
            ChannelType ct1 = (ChannelType)t1;
            ChannelType ct2 = (ChannelType)t2;
            t1 = CheckType.smallestType(ct1.getElementType(), ct2.getElementType());
            if (t1 == null) {
                return null;
            }
            ChannelOps op1 = ct1.getOps();
            ChannelOps op2 = ct2.getOps();
            if (op1 == ChannelOps.SEND_RECEIVE) {
                return ChiConstructors.newChannelType((Type)t1, (ChannelOps)op2, null);
            }
            if (op2 == ChannelOps.SEND_RECEIVE) {
                return ChiConstructors.newChannelType((Type)t1, (ChannelOps)op1, null);
            }
            if (op1.equals((Object)op2)) {
                return ChiConstructors.newChannelType((Type)t1, (ChannelOps)op1, null);
            }
            return null;
        }
        if (t1 instanceof DictType && t2 instanceof DictType) {
            DictType d1 = (DictType)t1;
            DictType d2 = (DictType)t2;
            t1 = CheckType.smallestType(d1.getKeyType(), d2.getKeyType());
            t2 = CheckType.smallestType(d1.getValueType(), d2.getValueType());
            if (t1 == null || t2 == null) {
                return null;
            }
            return ChiConstructors.newDictType((Type)t1, null, (Type)t2);
        }
        if (t1 instanceof FunctionType && t2 instanceof FunctionType) {
            FunctionType f1 = (FunctionType)t1;
            FunctionType f2 = (FunctionType)t2;
            List<Type> pl = CheckType.smallestTypeList((List<Type>)f1.getParameterTypes(), (List<Type>)f2.getParameterTypes());
            t1 = CheckType.smallestType(f1.getResultType(), f2.getResultType());
            if (pl == null || t1 == null) {
                return null;
            }
            return ChiConstructors.newFunctionType(pl, null, (Type)t1);
        }
        if (t1 instanceof ProcessType && t2 instanceof ProcessType) {
            ProcessType pt1 = (ProcessType)t1;
            ProcessType pt2 = (ProcessType)t2;
            List<Type> pl = CheckType.smallestTypeList((List<Type>)pt1.getParameterTypes(), (List<Type>)pt2.getParameterTypes());
            if (pl == null) {
                return null;
            }
            if (pt1.getExitType() == null && pt2.getExitType() == null) {
                return ChiConstructors.newProcessType(null, pl, null);
            }
            if (pt1.getExitType() == null || pt2.getExitType() == null) {
                return null;
            }
            Type rtp = CheckType.smallestType(pt1.getExitType(), pt2.getExitType());
            if (rtp == null) {
                return null;
            }
            return ChiConstructors.newProcessType((Type)rtp, pl, null);
        }
        if (t1 instanceof ModelType && t2 instanceof ModelType) {
            ModelType pt1 = (ModelType)t1;
            ModelType pt2 = (ModelType)t2;
            List<Type> pl = CheckType.smallestTypeList((List<Type>)pt1.getParameterTypes(), (List<Type>)pt2.getParameterTypes());
            if (pl == null) {
                return null;
            }
            if (pt1.getExitType() == null && pt2.getExitType() == null) {
                return ChiConstructors.newModelType(null, pl, null);
            }
            if (pt1.getExitType() == null || pt2.getExitType() == null) {
                return null;
            }
            Type rtp = CheckType.smallestType(pt1.getExitType(), pt2.getExitType());
            if (rtp == null) {
                return null;
            }
            return ChiConstructors.newModelType((Type)rtp, pl, null);
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList f1 = ((TupleType)t1).getFields();
            EList f2 = ((TupleType)t2).getFields();
            if (f1.size() != f2.size()) {
                return null;
            }
            List resFields = Lists.list();
            int i = 0;
            while (i < f1.size()) {
                Type t = CheckType.smallestType(((TupleField)f1.get(i)).getType(), ((TupleField)f2.get(i)).getType());
                if (t == null) {
                    return null;
                }
                resFields.add(ChiConstructors.newTupleField(null, null, (Type)t));
                ++i;
            }
            return ChiConstructors.newTupleType((List)resFields, null);
        }
        if (t1 instanceof MatrixType && t2 instanceof MatrixType) {
            int r2;
            int c2;
            MatrixType m1 = (MatrixType)t1;
            MatrixType m2 = (MatrixType)t2;
            int c1 = CheckExpression.evalExpression(m1.getColumnSize(), null);
            if (c1 != (c2 = CheckExpression.evalExpression(m2.getColumnSize(), null))) {
                return null;
            }
            int r1 = CheckExpression.evalExpression(m1.getRowSize(), null);
            if (r1 != (r2 = CheckExpression.evalExpression(m2.getRowSize(), null))) {
                return null;
            }
            IntNumber c = ChiConstructors.newIntNumber(null, (Type)ChiConstructors.newIntType(), (String)Integer.toString(c1));
            IntNumber r = ChiConstructors.newIntNumber(null, (Type)ChiConstructors.newIntType(), (String)Integer.toString(r1));
            return ChiConstructors.newMatrixType((Expression)c, null, (Expression)r);
        }
        if (t1 instanceof EnumTypeReference && t2 instanceof EnumTypeReference) {
            EnumTypeReference ert1 = (EnumTypeReference)t1;
            EnumTypeReference ert2 = (EnumTypeReference)t2;
            if (ert1.getType() != ert2.getType()) {
                return null;
            }
            return ChiConstructors.newEnumTypeReference(null, (EnumDeclaration)ert1.getType());
        }
        return null;
    }

    public static Type dropReferences(Type t) {
        while (true) {
            Assert.check((t != null ? 1 : 0) != 0);
            if (!(t instanceof TypeReference)) break;
            t = ((TypeReference)t).getType().getType();
        }
        return t;
    }

    public static boolean isNumericType(Type t) {
        return (t = CheckType.dropReferences(t)) instanceof IntType || t instanceof RealType;
    }

    public static Type newBoolDist() {
        return ChiConstructors.newDistributionType(null, (Type)ChiConstructors.newBoolType());
    }

    public static Type newIntDist() {
        return ChiConstructors.newDistributionType(null, (Type)ChiConstructors.newIntType());
    }

    public static Type newRealDist() {
        return ChiConstructors.newDistributionType(null, (Type)ChiConstructors.newRealType());
    }

    public static List<Type> tlist(Type ... elems) {
        List rslt = Lists.listc((int)elems.length);
        Type[] typeArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            Type elem = typeArray[n2];
            rslt.add(elem);
            ++n2;
        }
        return rslt;
    }

    public static TupleType tuplet(Type ... elems) {
        List rslt = Lists.listc((int)elems.length);
        Type[] typeArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            Type elem = typeArray[n2];
            rslt.add(ChiConstructors.newTupleField((String)"", null, (Type)elem));
            ++n2;
        }
        return ChiConstructors.newTupleType((List)rslt, null);
    }

    public static Type transNonvoidType(Type t, CheckContext ctxt) {
        ctxt = ctxt.add(CheckContext.ContextItem.NO_VOID);
        return CheckType.transType(t, ctxt);
    }

    public static Type transType(Type t, CheckContext ctxt) {
        if (t instanceof DictType) {
            return CheckType.transDictType((DictType)t, ctxt);
        }
        if (t instanceof VoidType) {
            return CheckType.transVoidType((VoidType)t, ctxt);
        }
        if (t instanceof FileType) {
            return CheckType.transFileType((FileType)t);
        }
        if (t instanceof SetType) {
            return CheckType.transSetType((SetType)t, ctxt);
        }
        if (t instanceof BoolType) {
            return CheckType.transBoolType((BoolType)t);
        }
        if (t instanceof DistributionType) {
            return CheckType.transDistributionType((DistributionType)t, ctxt);
        }
        if (t instanceof IntType) {
            return CheckType.transIntType((IntType)t);
        }
        if (t instanceof TimerType) {
            return CheckType.transTimerType((TimerType)t);
        }
        if (t instanceof StringType) {
            return CheckType.transStringType((StringType)t);
        }
        if (t instanceof RealType) {
            return CheckType.transRealType((RealType)t);
        }
        if (t instanceof InstanceType) {
            return CheckType.transInstanceType((InstanceType)t);
        }
        if (t instanceof ChannelType) {
            return CheckType.transChannelType((ChannelType)t, ctxt);
        }
        if (t instanceof UnresolvedType) {
            return CheckType.transUnresolvedType((UnresolvedType)t, ctxt);
        }
        if (t instanceof FunctionType) {
            return CheckType.transFunctionType((FunctionType)t, ctxt);
        }
        if (t instanceof ProcessType) {
            return CheckType.transProcessType((ProcessType)t, ctxt);
        }
        if (t instanceof ModelType) {
            return CheckType.transModelType((ModelType)t, ctxt);
        }
        if (t instanceof TupleType) {
            return CheckType.transTupleType((TupleType)t, ctxt);
        }
        if (t instanceof MatrixType) {
            return CheckType.transMatrixType((MatrixType)t, ctxt);
        }
        if (t instanceof ListType) {
            return CheckType.transListType((ListType)t, ctxt);
        }
        Assert.fail((String)"Unknown type encountered.");
        return null;
    }

    private static Type transDictType(DictType t, CheckContext ctxt) {
        Type kt = CheckType.transNonvoidType(t.getKeyType(), ctxt);
        boolean cond = !(CheckType.dropReferences(kt) instanceof TimerType);
        ctxt.checkThrowError(cond, Message.DICT_OF_TIMERS, t.getPosition(), new String[0]);
        Type vt = CheckType.transNonvoidType(t.getValueType(), ctxt);
        return ChiConstructors.newDictType((Type)kt, (Position)PositionUtils.copyPosition((PositionObject)t), (Type)vt);
    }

    private static Type transVoidType(VoidType t, CheckContext ctxt) {
        if (ctxt.contains(CheckContext.ContextItem.NO_VOID)) {
            ctxt.throwError(Message.VOID_NOT_ALLOWED, t.getPosition(), new String[0]);
        }
        return ChiConstructors.newVoidType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transFileType(FileType t) {
        return ChiConstructors.newFileType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transSetType(SetType t, CheckContext ctxt) {
        Type et = CheckType.transNonvoidType(t.getElementType(), ctxt);
        boolean cond = !(CheckType.dropReferences(et) instanceof TimerType);
        ctxt.checkThrowError(cond, Message.SET_OF_TIMERS, t.getPosition(), new String[0]);
        return ChiConstructors.newSetType((Type)et, (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transBoolType(BoolType t) {
        return ChiConstructors.newBoolType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transDistributionType(DistributionType t, CheckContext ctxt) {
        Type et = CheckType.transNonvoidType(t.getResultType(), ctxt);
        Type et2 = CheckType.dropReferences(et);
        boolean cond = et2 instanceof BoolType || et2 instanceof IntType || et2 instanceof RealType;
        ctxt.checkThrowError(cond, Message.WRONG_DIST_TYPE, et.getPosition(), CheckType.toString(et2));
        return ChiConstructors.newDistributionType((Position)PositionUtils.copyPosition((PositionObject)t), (Type)et);
    }

    private static Type transIntType(IntType t) {
        return ChiConstructors.newIntType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transTimerType(TimerType t) {
        return ChiConstructors.newTimerType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transStringType(StringType t) {
        return ChiConstructors.newStringType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transRealType(RealType t) {
        return ChiConstructors.newRealType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transInstanceType(InstanceType t) {
        return ChiConstructors.newInstanceType((Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transChannelType(ChannelType t, CheckContext ctxt) {
        ctxt = ctxt.remove(CheckContext.ContextItem.NO_VOID);
        Type elmType = CheckType.transType(t.getElementType(), ctxt);
        return ChiConstructors.newChannelType((Type)elmType, (ChannelOps)t.getOps(), (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transUnresolvedType(UnresolvedType t, CheckContext ctxt) {
        SymbolEntry se = ctxt.getSymbol(t.getName());
        if (se != null) {
            se.fullTypeCheck();
            se.setUsed();
        }
        if (se instanceof TypeSymbolEntry) {
            TypeSymbolEntry tse = (TypeSymbolEntry)se;
            TypeDeclaration td = tse.getTypeDeclaration();
            if (td != null) {
                Type tp;
                if (ctxt.contains(CheckContext.ContextItem.NO_VOID) && (tp = CheckType.dropReferences(td.getType())) instanceof VoidType) {
                    ctxt.throwError(Message.VOID_NOT_ALLOWED, t.getPosition(), new String[0]);
                }
                return ChiConstructors.newTypeReference((Position)PositionUtils.copyPosition((PositionObject)t), (TypeDeclaration)td);
            }
            EnumDeclaration ed = tse.getEnumTypeDeclaration();
            if (ed != null) {
                return ChiConstructors.newEnumTypeReference((Position)PositionUtils.copyPosition((PositionObject)t), (EnumDeclaration)ed);
            }
        }
        ctxt.throwError(Message.NO_TYPE_NAME, t.getPosition(), t.getName());
        return null;
    }

    private static Type transProcessType(ProcessType t, CheckContext ctxt) {
        List pt = Lists.list();
        for (Type tp : t.getParameterTypes()) {
            pt.add(CheckType.transNonvoidType(tp, ctxt));
        }
        Type rType = t.getExitType();
        if (rType != null) {
            ctxt = ctxt.remove(CheckContext.ContextItem.NO_VOID);
            rType = CheckType.transType(rType, ctxt);
        }
        return ChiConstructors.newProcessType((Type)rType, (List)pt, (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transModelType(ModelType t, CheckContext ctxt) {
        List pt = Lists.list();
        for (Type tp : t.getParameterTypes()) {
            pt.add(CheckType.transNonvoidType(tp, ctxt));
        }
        Type rType = t.getExitType();
        if (rType != null) {
            ctxt = ctxt.remove(CheckContext.ContextItem.NO_VOID);
            rType = CheckType.transType(rType, ctxt);
        }
        return ChiConstructors.newModelType((Type)rType, (List)pt, (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transFunctionType(FunctionType t, CheckContext ctxt) {
        List pt = Lists.list();
        for (Type tp : t.getParameterTypes()) {
            pt.add(CheckType.transNonvoidType(tp, ctxt));
        }
        Type rt = CheckType.transNonvoidType(t.getResultType(), ctxt);
        return ChiConstructors.newFunctionType((List)pt, (Position)PositionUtils.copyPosition((PositionObject)t), (Type)rt);
    }

    private static Type transTupleType(TupleType t, CheckContext ctxt) {
        ctxt.checkThrowError(t.getFields().size() >= 2, Message.TUPLE_TYPE_WRONG_SIZE, t.getPosition(), new String[0]);
        Map names = Maps.map();
        List tf = Lists.list();
        for (TupleField fld : t.getFields()) {
            String name = fld.getName();
            if (name.isEmpty()) continue;
            if (names.containsKey(name)) {
                ctxt.addError(Message.DUPLICATE_FIELD, fld.getPosition(), name);
                ctxt.addError(Message.DUPLICATE_FIELD, ((TupleField)names.get(name)).getPosition(), name);
                throw new SemanticException();
            }
            names.put(name, fld);
            Type tt = CheckType.transNonvoidType(fld.getType(), ctxt);
            tf.add(ChiConstructors.newTupleField((String)fld.getName(), (Position)PositionUtils.copyPosition((PositionObject)fld), (Type)tt));
        }
        return ChiConstructors.newTupleType((List)tf, (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    private static Type transMatrixType(MatrixType t, CheckContext ctxt) {
        CheckContext exprCtxt = ctxt.add(CheckContext.ContextItem.NO_SAMPLE, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_TIME);
        Expression cs = CheckExpression.transExpression(t.getColumnSize(), exprCtxt);
        boolean cond = cs.getType() instanceof IntType;
        Position pos = cs.getPosition();
        ctxt.checkThrowError(cond, Message.COLUMN_EXPR_WRONG_TYPE, pos, CheckType.toString(cs.getType()));
        int value = CheckExpression.evalExpression(cs, ctxt);
        cond = CheckExpression.evalExpression(cs, ctxt) > 0;
        ctxt.checkThrowError(value > 0, Message.COLUMN_EXPR_WRONG_VALUE, cs.getPosition(), String.valueOf(value));
        Expression rs = CheckExpression.transExpression(t.getRowSize(), exprCtxt);
        cond = rs.getType() instanceof IntType;
        pos = rs.getPosition();
        ctxt.checkThrowError(cond, Message.ROW_EXPR_WRONG_TYPE, pos, CheckType.toString(rs.getType()));
        value = CheckExpression.evalExpression(rs, ctxt);
        ctxt.checkThrowError(value > 0, Message.ROW_EXPR_WRONG_VALUE, rs.getPosition(), String.valueOf(value));
        return ChiConstructors.newMatrixType((Expression)cs, (Position)PositionUtils.copyPosition((PositionObject)t), (Expression)rs);
    }

    private static Type transListType(ListType t, CheckContext ctxt) {
        CheckContext exprCtxt = ctxt.add(CheckContext.ContextItem.NO_SAMPLE, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_TIME);
        Type tp = CheckType.transNonvoidType(t.getElementType(), ctxt);
        Expression length = t.getInitialLength() == null ? null : CheckExpression.transExpression(t.getInitialLength(), exprCtxt);
        return ChiConstructors.newListType((Type)tp, (Expression)length, (Position)PositionUtils.copyPosition((PositionObject)t));
    }

    public static boolean isPrintable(Type tp) {
        if ((tp = CheckType.dropReferences(tp)) instanceof DictType) {
            DictType dt = (DictType)tp;
            return CheckType.isPrintable(dt.getKeyType()) && CheckType.isPrintable(dt.getValueType());
        }
        if (tp instanceof VoidType) {
            return false;
        }
        if (tp instanceof FileType) {
            return false;
        }
        if (tp instanceof SetType) {
            SetType st = (SetType)tp;
            return CheckType.isPrintable(st.getElementType());
        }
        if (tp instanceof BoolType) {
            return true;
        }
        if (tp instanceof DistributionType) {
            return false;
        }
        if (tp instanceof IntType) {
            return true;
        }
        if (tp instanceof TimerType) {
            return false;
        }
        if (tp instanceof StringType) {
            return true;
        }
        if (tp instanceof RealType) {
            return true;
        }
        if (tp instanceof InstanceType) {
            return false;
        }
        if (tp instanceof ChannelType) {
            return false;
        }
        if (tp instanceof FunctionType) {
            return false;
        }
        if (tp instanceof ProcessType) {
            return false;
        }
        if (tp instanceof ModelType) {
            return false;
        }
        if (tp instanceof TupleType) {
            TupleType pp = (TupleType)tp;
            for (TupleField tf : pp.getFields()) {
                if (CheckType.isPrintable(tf.getType())) continue;
                return false;
            }
            return true;
        }
        if (tp instanceof MatrixType) {
            return true;
        }
        if (tp instanceof ListType) {
            ListType lt = (ListType)tp;
            return CheckType.isPrintable(lt.getElementType());
        }
        if (tp instanceof EnumTypeReference) {
            return true;
        }
        Assert.fail((String)("Unexpected type " + tp.toString() + " in isPrintable"));
        return false;
    }

    public static String toString(Type tp) {
        if ((tp = CheckType.dropReferences(tp)) instanceof DictType) {
            DictType dt = (DictType)tp;
            return "dict(" + CheckType.toString(dt.getKeyType()) + " : " + CheckType.toString(dt.getValueType()) + ")";
        }
        if (tp instanceof VoidType) {
            return "void";
        }
        if (tp instanceof FileType) {
            return "file";
        }
        if (tp instanceof SetType) {
            SetType st = (SetType)tp;
            return "set " + CheckType.toString(st.getElementType());
        }
        if (tp instanceof BoolType) {
            return "bool";
        }
        if (tp instanceof DistributionType) {
            DistributionType dt = (DistributionType)tp;
            return "dist " + CheckType.toString(dt.getResultType());
        }
        if (tp instanceof IntType) {
            return "int";
        }
        if (tp instanceof TimerType) {
            return "timer";
        }
        if (tp instanceof StringType) {
            return "string";
        }
        if (tp instanceof RealType) {
            return "real";
        }
        if (tp instanceof InstanceType) {
            return "inst";
        }
        if (tp instanceof ChannelType) {
            ChannelType ct = (ChannelType)tp;
            switch (ct.getOps()) {
                case RECEIVE: {
                    return "chan? " + CheckType.toString(ct.getElementType());
                }
                case SEND: {
                    return "chan! " + CheckType.toString(ct.getElementType());
                }
                case SEND_RECEIVE: {
                    return "chan!? " + CheckType.toString(ct.getElementType());
                }
            }
            Assert.fail((String)"Unexpected channel direction found");
            return null;
        }
        if (tp instanceof FunctionType) {
            FunctionType ft = (FunctionType)tp;
            String str = "";
            for (Type at : ft.getParameterTypes()) {
                str = str.isEmpty() ? "(" : String.valueOf(str) + ", ";
                str = String.valueOf(str) + CheckType.toString(at);
            }
            return "func " + CheckType.toString(ft.getResultType()) + " " + str + ")";
        }
        if (tp instanceof ProcessType) {
            ProcessType pt = (ProcessType)tp;
            String str = "(";
            if (pt.getExitType() != null) {
                str = String.valueOf(CheckType.toString(pt.getExitType())) + " (";
            }
            boolean first = true;
            for (Type at : pt.getParameterTypes()) {
                if (!first) {
                    str = String.valueOf(str) + ", ";
                }
                first = false;
                str = String.valueOf(str) + CheckType.toString(at);
            }
            return "proc " + str + ")";
        }
        if (tp instanceof ModelType) {
            ModelType pt = (ModelType)tp;
            String str = "(";
            if (pt.getExitType() != null) {
                str = String.valueOf(CheckType.toString(pt.getExitType())) + " (";
            }
            boolean first = true;
            for (Type at : pt.getParameterTypes()) {
                if (!first) {
                    str = String.valueOf(str) + ", ";
                }
                first = false;
                str = String.valueOf(str) + CheckType.toString(at);
            }
            return "model " + str + ")";
        }
        if (tp instanceof TupleType) {
            String str = "";
            TupleType pp = (TupleType)tp;
            for (TupleField tf : pp.getFields()) {
                str = str.isEmpty() ? "tuple(" : String.valueOf(str) + ", ";
                str = String.valueOf(str) + CheckType.toString(tf.getType());
            }
            return String.valueOf(str) + ")";
        }
        if (tp instanceof MatrixType) {
            MatrixType mt = (MatrixType)tp;
            return "matrix(" + String.valueOf(CheckExpression.evalExpression(mt.getRowSize(), null)) + ", " + String.valueOf(CheckExpression.evalExpression(mt.getColumnSize(), null)) + ")";
        }
        if (tp instanceof ListType) {
            ListType lt = (ListType)tp;
            return "list " + CheckType.toString(lt.getElementType());
        }
        if (tp instanceof EnumTypeReference) {
            EnumTypeReference etr = (EnumTypeReference)tp;
            return "enum " + etr.getType().getName();
        }
        Assert.fail((String)("Unexpected type " + tp.toString()));
        return null;
    }
}

