/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.EMFPath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimComponentDefInst
extends CifWalker
implements CifToCifTransformation {
    private Set<ComponentDef> elimDefs;
    private boolean foundDefs;
    private Map<ComponentDef, ComplexComponent> cdefMap;
    private Map<ComponentInst, ComplexComponent> instMap;
    private Map<ComponentParameter, Expression> compParamMap;
    private Map<Event, Expression> eventParamMap;
    private Map<Location, Expression> locParamMap;

    @Override
    public void transform(Specification spec) {
        while (true) {
            this.elimDefs = Sets.set();
            this.foundDefs = false;
            this.findCompDefs((Group)spec);
            if (this.elimDefs.isEmpty()) break;
            this.cdefMap = Maps.map();
            this.instMap = Maps.map();
            this.compParamMap = Maps.map();
            this.eventParamMap = Maps.map();
            this.locParamMap = Maps.map();
            this.instantiate((Group)spec);
            this.walkSpecification(spec);
        }
        Assert.check((!this.foundDefs ? 1 : 0) != 0);
    }

    private void findCompDefs(Group group) {
        for (ComponentDef cdef : group.getDefinitions()) {
            this.findCompDefs(cdef);
        }
        for (Component comp : group.getComponents()) {
            if (!(comp instanceof Group)) continue;
            this.findCompDefs((Group)comp);
        }
    }

    private void findCompDefs(ComponentDef cdef) {
        ComplexComponent body = cdef.getBody();
        this.foundDefs = true;
        if (body instanceof Automaton) {
            this.elimDefs.add(cdef);
            return;
        }
        Assert.check((boolean)(body instanceof Group));
        Group group = (Group)body;
        boolean done = true;
        for (ComponentDef cdef2 : group.getDefinitions()) {
            this.findCompDefs(cdef2);
            done = false;
        }
        for (Component comp : group.getComponents()) {
            if (done && comp instanceof ComponentInst) {
                done = false;
            }
            if (!(comp instanceof Group)) continue;
            this.findCompDefs((Group)comp);
        }
        if (done) {
            this.elimDefs.add(cdef);
        }
    }

    private void instantiate(Group group) {
        EList childDefs = group.getDefinitions();
        Iterator childIter = childDefs.iterator();
        while (childIter.hasNext()) {
            ComponentDef cdef = (ComponentDef)childIter.next();
            if (this.elimDefs.contains(cdef)) {
                childIter.remove();
                continue;
            }
            ComplexComponent body = cdef.getBody();
            if (!(body instanceof Group)) continue;
            this.instantiate((Group)body);
        }
        EList childComps = group.getComponents();
        int i = 0;
        while (i < childComps.size()) {
            ComponentInst inst;
            ComponentDef cdef;
            Component comp = (Component)childComps.get(i);
            if (comp instanceof Group) {
                this.instantiate((Group)comp);
            } else if (comp instanceof ComponentInst && this.elimDefs.contains(cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)(inst = (ComponentInst)comp)))) {
                ComplexComponent comp2 = this.instantiate((ComponentInst)comp);
                childComps.set(i, comp2);
            }
            ++i;
        }
    }

    private ComplexComponent instantiate(ComponentInst inst) {
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        cdef = (ComponentDef)EMFHelper.deepclone((EObject)cdef);
        ComplexComponent body = cdef.getBody();
        this.cdefMap.put(cdef, body);
        body.setName(inst.getName());
        this.instMap.put(inst, body);
        EList formals = cdef.getParameters();
        EList actuals = inst.getParameters();
        Assert.check((formals.size() == actuals.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < formals.size()) {
            Parameter formal = (Parameter)formals.get(i);
            Expression actual = (Expression)actuals.get(i);
            if (formal instanceof AlgParameter) {
                AlgVariable var = ((AlgParameter)formal).getVariable();
                body.getDeclarations().add((Object)var);
                var.setValue((Expression)EMFHelper.deepclone((EObject)actual));
            } else if (formal instanceof EventParameter) {
                Event event = ((EventParameter)formal).getEvent();
                this.eventParamMap.put(event, actual);
            } else if (formal instanceof LocationParameter) {
                Location loc = ((LocationParameter)formal).getLocation();
                this.locParamMap.put(loc, actual);
            } else if (formal instanceof ComponentParameter) {
                this.compParamMap.put((ComponentParameter)formal, actual);
            } else {
                throw new RuntimeException("Unknown formal param: " + formal);
            }
            ++i;
        }
        return body;
    }

    protected void postprocessEventExpression(EventExpression evtRef) {
        Expression newRef = this.eventParamMap.get(evtRef.getEvent());
        if (newRef == null) {
            return;
        }
        newRef = (Expression)EMFHelper.deepclone((EObject)newRef);
        EMFHelper.updateParentContainment((EObject)evtRef, (EObject)newRef);
        this.walkExpression(newRef);
    }

    protected void postprocessLocationExpression(LocationExpression locRef) {
        Expression newRef = this.locParamMap.get(locRef.getLocation());
        if (newRef == null) {
            return;
        }
        newRef = (Expression)EMFHelper.deepclone((EObject)newRef);
        EMFHelper.updateParentContainment((EObject)locRef, (EObject)newRef);
        this.walkExpression(newRef);
    }

    protected void postprocessComponentExpression(ComponentExpression compRef) {
        Component c = compRef.getComponent();
        if (!(c instanceof ComponentInst)) {
            return;
        }
        ComplexComponent comp = this.instMap.get(c);
        if (comp == null) {
            return;
        }
        compRef.setComponent((Component)comp);
    }

    protected void postprocessSelfExpression(SelfExpression expr) {
        CifType type = expr.getType();
        if (!(type instanceof ComponentDefType)) {
            return;
        }
        ComponentDef cdef = ((ComponentDefType)type).getDefinition();
        ComplexComponent comp = this.cdefMap.get(cdef);
        if (comp == null) {
            return;
        }
        Assert.check((boolean)(comp instanceof Automaton));
        ComponentType ctype = CifConstructors.newComponentType();
        ctype.setComponent((Component)comp);
        expr.setType((CifType)ctype);
    }

    protected void postprocessComponentType(ComponentType compType) {
        Component c = compType.getComponent();
        if (!(c instanceof ComponentInst)) {
            return;
        }
        ComplexComponent comp = this.instMap.get(c);
        if (comp == null) {
            return;
        }
        compType.setComponent((Component)comp);
    }

    protected void walkCompInstWrapExpression(CompInstWrapExpression wrap) {
        ComplexComponent comp = this.instMap.get(wrap.getInstantiation());
        if (comp == null) {
            super.walkCompInstWrapExpression(wrap);
            return;
        }
        ComponentInst inst = wrap.getInstantiation();
        Expression childRef = wrap.getReference();
        PositionObject refObj = CifScopeUtils.getRefObjFromRef((Expression)childRef);
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        ComplexComponent body = cdef.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, comp);
        if (childRef instanceof ConstantExpression) {
            Constant c = (Constant)newRefObj;
            ((ConstantExpression)childRef).setConstant(c);
        } else if (childRef instanceof DiscVariableExpression) {
            DiscVariable v = (DiscVariable)newRefObj;
            ((DiscVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof AlgVariableExpression) {
            AlgVariable a = (AlgVariable)newRefObj;
            ((AlgVariableExpression)childRef).setVariable(a);
        } else if (childRef instanceof ContVariableExpression) {
            ContVariable v = (ContVariable)newRefObj;
            ((ContVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof LocationExpression) {
            Location l = (Location)newRefObj;
            ((LocationExpression)childRef).setLocation(l);
        } else if (childRef instanceof EnumLiteralExpression) {
            EnumLiteral l = (EnumLiteral)newRefObj;
            ((EnumLiteralExpression)childRef).setLiteral(l);
        } else if (childRef instanceof EventExpression) {
            Event e = (Event)newRefObj;
            ((EventExpression)childRef).setEvent(e);
        } else if (childRef instanceof FunctionExpression) {
            Function f = (Function)newRefObj;
            ((FunctionExpression)childRef).setFunction(f);
        } else if (childRef instanceof InputVariableExpression) {
            InputVariable v = (InputVariable)newRefObj;
            ((InputVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof ComponentExpression) {
            ComponentExpression compRef = (ComponentExpression)childRef;
            Component c = (Component)newRefObj;
            compRef.setComponent(c);
        } else {
            if (childRef instanceof CompInstWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown child ref expr: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
        this.walkCifType(childRef.getType());
    }

    protected void walkCompInstWrapType(CompInstWrapType wrap) {
        TypeDecl refObj;
        ComplexComponent comp = this.instMap.get(wrap.getInstantiation());
        if (comp == null) {
            super.walkCompInstWrapType(wrap);
            return;
        }
        ComponentInst inst = wrap.getInstantiation();
        CifType childRef = wrap.getReference();
        if (childRef instanceof TypeRef) {
            refObj = ((TypeRef)childRef).getType();
        } else if (childRef instanceof EnumType) {
            refObj = ((EnumType)childRef).getEnum();
        } else if (childRef instanceof ComponentType) {
            refObj = ((ComponentType)childRef).getComponent();
        } else {
            if (childRef instanceof ComponentDefType) {
                throw new RuntimeException("Invalid comp def type.");
            }
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Invalid comp inst wrap type.");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Invalid comp param wrap type.");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        ComplexComponent body = cdef.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, comp);
        if (childRef instanceof TypeRef) {
            TypeDecl t = (TypeDecl)newRefObj;
            ((TypeRef)childRef).setType(t);
        } else if (childRef instanceof EnumType) {
            EnumDecl e = (EnumDecl)newRefObj;
            ((EnumType)childRef).setEnum(e);
        } else if (childRef instanceof ComponentType) {
            Component c = (Component)newRefObj;
            ((ComponentType)childRef).setComponent(c);
        } else {
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
    }

    protected void walkCompParamWrapExpression(CompParamWrapExpression wrap) {
        ComplexComponent instComp;
        ComponentInst instArg;
        ComponentDef cdef;
        ComponentParameter param = wrap.getParameter();
        Expression arg = this.compParamMap.get(param);
        if (arg == null) {
            super.walkCompParamWrapExpression(wrap);
            return;
        }
        Expression leafArg = CifTypeUtils.unwrapExpression((Expression)arg);
        Assert.check((boolean)(leafArg instanceof ComponentExpression));
        Component compArg = ((ComponentExpression)leafArg).getComponent();
        if (compArg instanceof ComponentInst && !this.elimDefs.contains(cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)(instArg = (ComponentInst)compArg)))) {
            arg = (Expression)EMFHelper.deepclone((EObject)arg);
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)arg);
            leafArg = CifTypeUtils.unwrapExpression((Expression)arg);
            Assert.check((boolean)(leafArg instanceof ComponentExpression));
            compArg = ((ComponentExpression)leafArg).getComponent();
            Assert.check((boolean)(compArg instanceof ComponentInst));
            CompInstWrapExpression newWrap = CifConstructors.newCompInstWrapExpression();
            newWrap.setInstantiation((ComponentInst)compArg);
            newWrap.setReference(wrap.getReference());
            EMFHelper.updateParentContainment((EObject)leafArg, (EObject)newWrap);
            return;
        }
        Expression childRef = wrap.getReference();
        PositionObject refObj = CifScopeUtils.getRefObjFromRef((Expression)childRef);
        if (compArg instanceof ComponentInst) {
            instComp = this.instMap.get(compArg);
            Assert.notNull((Object)instComp);
        } else {
            instComp = (ComplexComponent)compArg;
        }
        CifType cdefType = wrap.getParameter().getType();
        cdefType = CifTypeUtils.normalizeType((CifType)cdefType);
        Assert.check((boolean)(cdefType instanceof ComponentDefType));
        ComponentDef cdef2 = ((ComponentDefType)cdefType).getDefinition();
        ComplexComponent body = cdef2.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, instComp);
        if (childRef instanceof ConstantExpression) {
            Constant c = (Constant)newRefObj;
            ((ConstantExpression)childRef).setConstant(c);
        } else if (childRef instanceof DiscVariableExpression) {
            DiscVariable v = (DiscVariable)newRefObj;
            ((DiscVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof AlgVariableExpression) {
            AlgVariable a = (AlgVariable)newRefObj;
            ((AlgVariableExpression)childRef).setVariable(a);
        } else if (childRef instanceof ContVariableExpression) {
            ContVariable v = (ContVariable)newRefObj;
            ((ContVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof LocationExpression) {
            Location l = (Location)newRefObj;
            ((LocationExpression)childRef).setLocation(l);
        } else if (childRef instanceof EnumLiteralExpression) {
            EnumLiteral l = (EnumLiteral)newRefObj;
            ((EnumLiteralExpression)childRef).setLiteral(l);
        } else if (childRef instanceof EventExpression) {
            Event e = (Event)newRefObj;
            ((EventExpression)childRef).setEvent(e);
        } else if (childRef instanceof FunctionExpression) {
            Function f = (Function)newRefObj;
            ((FunctionExpression)childRef).setFunction(f);
        } else if (childRef instanceof InputVariableExpression) {
            InputVariable v = (InputVariable)newRefObj;
            ((InputVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof ComponentExpression) {
            ComponentExpression compRef = (ComponentExpression)childRef;
            Component c = (Component)newRefObj;
            compRef.setComponent(c);
        } else {
            if (childRef instanceof CompInstWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref expr: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
        this.walkCifType(childRef.getType());
    }

    protected void walkCompParamWrapType(CompParamWrapType wrap) {
        ComplexComponent instComp;
        TypeDecl refObj;
        ComponentInst instArg;
        ComponentDef cdef;
        ComponentParameter param = wrap.getParameter();
        Expression arg = this.compParamMap.get(param);
        if (arg == null) {
            super.walkCompParamWrapType(wrap);
            return;
        }
        Expression leafArg = CifTypeUtils.unwrapExpression((Expression)arg);
        Assert.check((boolean)(leafArg instanceof ComponentExpression));
        Component compArg = ((ComponentExpression)leafArg).getComponent();
        if (compArg instanceof ComponentInst && !this.elimDefs.contains(cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)(instArg = (ComponentInst)compArg)))) {
            arg = (Expression)EMFHelper.deepclone((EObject)arg);
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)arg);
            leafArg = CifTypeUtils.unwrapExpression((Expression)arg);
            Assert.check((boolean)(leafArg instanceof ComponentExpression));
            compArg = ((ComponentExpression)leafArg).getComponent();
            Assert.check((boolean)(compArg instanceof ComponentInst));
            CompInstWrapType newWrap = CifConstructors.newCompInstWrapType();
            newWrap.setInstantiation((ComponentInst)compArg);
            newWrap.setReference(wrap.getReference());
            EMFHelper.updateParentContainment((EObject)leafArg, (EObject)newWrap);
            return;
        }
        CifType childRef = wrap.getReference();
        if (childRef instanceof TypeRef) {
            refObj = ((TypeRef)childRef).getType();
        } else if (childRef instanceof EnumType) {
            refObj = ((EnumType)childRef).getEnum();
        } else if (childRef instanceof ComponentType) {
            refObj = ((ComponentType)childRef).getComponent();
        } else {
            if (childRef instanceof ComponentDefType) {
                throw new RuntimeException("Invalid comp def type.");
            }
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Invalid comp inst wrap type.");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Invalid comp param wrap type.");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        if (compArg instanceof ComponentInst) {
            instComp = this.instMap.get(compArg);
            Assert.notNull((Object)instComp);
        } else {
            instComp = (ComplexComponent)compArg;
        }
        CifType cdefType = wrap.getParameter().getType();
        cdefType = CifTypeUtils.normalizeType((CifType)cdefType);
        Assert.check((boolean)(cdefType instanceof ComponentDefType));
        ComponentDef cdef2 = ((ComponentDefType)cdefType).getDefinition();
        ComplexComponent body = cdef2.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, instComp);
        if (childRef instanceof TypeRef) {
            TypeDecl t = (TypeDecl)newRefObj;
            ((TypeRef)childRef).setType(t);
        } else if (childRef instanceof EnumType) {
            EnumDecl e = (EnumDecl)newRefObj;
            ((EnumType)childRef).setEnum(e);
        } else if (childRef instanceof ComponentType) {
            Component c = (Component)newRefObj;
            ((ComponentType)childRef).setComponent(c);
        } else {
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
    }

    private Object getNonViaRefObj(EObject refObj, ComplexComponent compDefBody, ComplexComponent compInstBody) {
        Object newRefObj;
        LinkedHashSet<ComplexComponent> otherInstComps = new LinkedHashSet<ComplexComponent>(this.instMap.values());
        otherInstComps.remove(compInstBody);
        EObject curObj = refObj;
        boolean inBody = false;
        boolean inComp = false;
        ComplexComponent otherInstComp = null;
        while (curObj != null) {
            if (curObj == compDefBody) {
                inBody = true;
            }
            if (curObj == compInstBody) {
                inComp = true;
            }
            if (otherInstComps.contains(curObj)) {
                Assert.check((otherInstComp == null ? 1 : 0) != 0);
                otherInstComp = (ComplexComponent)curObj;
            }
            curObj = curObj.eContainer();
        }
        int successes = 0;
        if (inBody) {
            ++successes;
        }
        if (inComp) {
            ++successes;
        }
        if (otherInstComp != null) {
            ++successes;
        }
        Assert.check((successes == 1 ? 1 : 0) != 0);
        if (inBody) {
            EMFPath path = new EMFPath(refObj, null, (EObject)compDefBody);
            newRefObj = path.resolveAgainst((EObject)compInstBody);
        } else if (inComp) {
            newRefObj = refObj;
        } else {
            EMFPath path = new EMFPath(refObj, null, (EObject)otherInstComp);
            newRefObj = path.resolveAgainst((EObject)compInstBody);
        }
        return newRefObj;
    }
}

