/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimLocRefExprs
extends CifWalker
implements CifToCifTransformation,
LocationPointerManager {
    private final String varPrefix;
    private final String enumPrefix;
    private final String litPrefix;
    private final String defaultLocName;
    private final boolean optimized;
    private final boolean considerLocsForRename;
    private final boolean addInitPreds;
    private final Map<DiscVariable, String> absVarNamesMap;
    private final boolean optInits;
    private int phase;
    private Map<Automaton, DiscVariable> autToVarMap = Maps.map();
    private Map<Automaton, EnumDecl> autToEnumMap = Maps.map();

    public ElimLocRefExprs() {
        this("LP_", "LOCS_", "LOC_", true, true, true, null, null, true);
    }

    public ElimLocRefExprs(String varPrefix, String enumPrefix, String litPrefix, boolean considerLocsForRename, boolean addInitPreds, boolean optimized, String defaultLocName, Map<DiscVariable, String> absVarNamesMap, boolean optInits) {
        this.varPrefix = varPrefix;
        this.enumPrefix = enumPrefix;
        this.litPrefix = litPrefix;
        this.considerLocsForRename = considerLocsForRename;
        this.addInitPreds = addInitPreds;
        this.optimized = optimized;
        this.defaultLocName = defaultLocName;
        this.absVarNamesMap = absVarNamesMap;
        this.optInits = optInits;
        Assert.ifAndOnlyIf((boolean)optimized, (defaultLocName == null ? 1 : 0) != 0);
        Assert.check((defaultLocName == null || !defaultLocName.isEmpty() ? 1 : 0) != 0);
    }

    private DiscVariable getLocPointerVar(Automaton aut) {
        DiscVariable var = this.autToVarMap.get(aut);
        if (var == null) {
            EnumDecl enumDecl = this.getLocPointerEnum(aut);
            EnumType enumType = CifConstructors.newEnumType();
            enumType.setEnum(enumDecl);
            var = CifConstructors.newDiscVariable();
            var.setValue(CifConstructors.newVariableValue());
            var.setName(String.valueOf(this.varPrefix) + aut.getName());
            var.setType((CifType)enumType);
            this.autToVarMap.put(aut, var);
            if (this.absVarNamesMap != null) {
                PositionObject autParentScope = CifScopeUtils.getScope((PositionObject)aut);
                String autParentTxt = CifTextUtils.getAbsName((PositionObject)autParentScope, (boolean)false);
                String absName = String.valueOf(autParentTxt) + (autParentTxt.isEmpty() ? "" : ".") + var.getName();
                this.absVarNamesMap.put(var, absName);
            }
        }
        return var;
    }

    private EnumDecl getLocPointerEnum(Automaton aut) {
        EnumDecl enumDecl = this.autToEnumMap.get(aut);
        if (enumDecl == null) {
            enumDecl = CifConstructors.newEnumDecl();
            enumDecl.setName(String.valueOf(this.enumPrefix) + aut.getName());
            EList literals = enumDecl.getLiterals();
            for (Location loc : aut.getLocations()) {
                String name = loc.getName();
                if (name == null) {
                    name = this.defaultLocName;
                }
                Assert.notNull((Object)name);
                EnumLiteral literal = CifConstructors.newEnumLiteral();
                literal.setName(String.valueOf(this.litPrefix) + name);
                literals.add(literal);
            }
            this.autToEnumMap.put(aut, enumDecl);
        }
        return enumDecl;
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating the use of locations in expressions from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.phase = 1;
        if (this.optimized) {
            this.walkSpecification(spec);
        }
        this.phase = 2;
        this.walkSpecification(spec);
    }

    protected void preprocessLocationExpression(LocationExpression locRef) {
        if (this.phase == 1) {
            Location loc = locRef.getLocation();
            Automaton aut = (Automaton)loc.eContainer();
            this.autToVarMap.put(aut, null);
        } else {
            Location loc = locRef.getLocation();
            Automaton aut = (Automaton)loc.eContainer();
            if (this.optimized && !this.autToVarMap.containsKey(aut)) {
                return;
            }
            BinaryExpression pred = this.createEquality(loc);
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)pred);
        }
    }

    protected void preprocessAutomaton(Automaton aut) {
        if (this.phase == 2) {
            if (this.optimized && !this.autToVarMap.containsKey(aut)) {
                return;
            }
            DiscVariable var = this.getLocPointerVar(aut);
            EnumDecl enumDecl = this.getLocPointerEnum(aut);
            this.renameIfNeeded(aut, var, enumDecl);
            aut.getDeclarations().add((Object)var);
            aut.getDeclarations().add((Object)enumDecl);
            this.addInits(aut, var, enumDecl);
            this.addUpdates(aut, var, enumDecl);
        }
    }

    private void renameIfNeeded(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        String name;
        String oldName;
        Set usedNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)aut, null);
        if (!this.considerLocsForRename) {
            for (Location loc : aut.getLocations()) {
                if (loc.getName() == null) continue;
                usedNames.remove(loc.getName());
            }
        }
        Set avoidNames = Sets.setc((int)(aut.getLocations().size() + 2));
        avoidNames.add(var.getName());
        avoidNames.add(enumDecl.getName());
        for (EnumLiteral literal : enumDecl.getLiterals()) {
            avoidNames.add(literal.getName());
        }
        if (usedNames.contains(var.getName())) {
            oldName = var.getName();
            name = CifScopeUtils.getUniqueName((String)var.getName(), (Set)usedNames, (Set)avoidNames);
            var.setName(name);
            OutputProvider.warn((String)"Location pointer variable \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, name});
        }
        usedNames.add(var.getName());
        if (usedNames.contains(enumDecl.getName())) {
            oldName = enumDecl.getName();
            name = CifScopeUtils.getUniqueName((String)enumDecl.getName(), (Set)usedNames, (Set)avoidNames);
            enumDecl.setName(name);
            OutputProvider.warn((String)"Enumeration \"%s\", introduced as the type of location pointer variable \"%s\", is renamed to \"%s\".", (Object[])new Object[]{oldName, var.getName(), name});
        }
        usedNames.add(enumDecl.getName());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            if (usedNames.contains(lit.getName())) {
                String oldName2 = lit.getName();
                String name2 = CifScopeUtils.getUniqueName((String)lit.getName(), (Set)usedNames, (Set)avoidNames);
                lit.setName(name2);
                OutputProvider.warn((String)"Enumeration literal \"%s\", introduced as a value for location pointer variable \"%s\", is renamed to \"%s\".", (Object[])new Object[]{oldName2, var.getName(), name2});
            }
            usedNames.add(lit.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addInits(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        EList initials;
        Location loc;
        EList locs = aut.getLocations();
        int initIdx = -1;
        int idx = 0;
        while (idx < locs.size()) {
            block9: {
                loc = (Location)locs.get(idx);
                initials = loc.getInitials();
                if (!initials.isEmpty() && !CifValueUtils.isTriviallyFalse((List)initials, (boolean)true, (boolean)this.optInits)) {
                    if (!initials.isEmpty() && CifValueUtils.isTriviallyTrue((List)initials, (boolean)true, (boolean)this.optInits)) {
                        if (initIdx == -1) {
                            initIdx = idx;
                            break block9;
                        } else {
                            initIdx = -1;
                            break;
                        }
                    }
                    initIdx = -1;
                    break;
                }
            }
            ++idx;
        }
        if (initIdx != -1) {
            EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(initIdx);
            EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
            litRef.setLiteral(literal);
            litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
            VariableValue value = CifConstructors.newVariableValue();
            value.getValues().add((Object)litRef);
            var.setValue(value);
            return;
        }
        if (!this.addInitPreds) {
            return;
        }
        idx = 0;
        while (idx < locs.size()) {
            loc = (Location)locs.get(idx);
            initials = loc.getInitials();
            if (!initials.isEmpty() && !CifValueUtils.isTriviallyFalse((List)initials, (boolean)true, (boolean)this.optInits)) {
                BinaryExpression pred = this.createEquality(var, enumDecl, idx);
                loc.getInitials().add((Object)pred);
            }
            ++idx;
        }
    }

    private void addUpdates(Automaton aut, DiscVariable var, EnumDecl enumDecl) {
        EList locs = aut.getLocations();
        int idx = 0;
        while (idx < locs.size()) {
            Location loc = (Location)locs.get(idx);
            for (Edge edge : loc.getEdges()) {
                if (edge.getTarget() == null || edge.getTarget() == loc) continue;
                Update asgn = this.createLocUpdate(edge.getTarget());
                edge.getUpdates().add((Object)asgn);
            }
            ++idx;
        }
    }

    private BinaryExpression createEquality(DiscVariable var, EnumDecl enumDecl, int idx) {
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(idx);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral(literal);
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        BinaryExpression pred = CifConstructors.newBinaryExpression();
        pred.setOperator(BinaryOperator.EQUAL);
        pred.setLeft((Expression)varRef);
        pred.setRight((Expression)litRef);
        pred.setType((CifType)CifConstructors.newBoolType());
        return pred;
    }

    public BinaryExpression createEquality(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        DiscVariable var = this.getLocPointerVar(aut);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        int idx = aut.getLocations().indexOf((Object)loc);
        return this.createEquality(var, enumDecl, idx);
    }

    @Override
    public Expression createLocRef(Location loc) {
        return this.createEquality(loc);
    }

    @Override
    public Update createLocUpdate(Location loc) {
        Automaton aut = (Automaton)loc.eContainer();
        DiscVariable var = this.getLocPointerVar(aut);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        int targetIdx = aut.getLocations().indexOf((Object)loc);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral((EnumLiteral)enumDecl.getLiterals().get(targetIdx));
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        Assignment asgn = CifConstructors.newAssignment();
        asgn.setAddressable((Expression)varRef);
        asgn.setValue((Expression)litRef);
        return asgn;
    }

    protected void postprocessSwitchExpression(SwitchExpression switchExpr) {
        if (this.phase == 1) {
            return;
        }
        Expression value = switchExpr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        if (!isAutRef) {
            return;
        }
        ComponentType compType = (ComponentType)value.getType();
        Component comp = compType.getComponent();
        Automaton aut = CifScopeUtils.getAutomaton((Component)comp);
        DiscVariable var = this.getLocPointerVar(aut);
        DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
        varRef.setVariable(var);
        varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EMFHelper.updateParentContainment((EObject)value, (EObject)varRef);
    }

    protected void preprocessSwitchCase(SwitchCase cse) {
        if (this.phase == 1) {
            return;
        }
        Expression key = cse.getKey();
        if (key == null) {
            return;
        }
        SwitchExpression switchExpr = (SwitchExpression)cse.eContainer();
        Expression value = switchExpr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        if (!isAutRef) {
            return;
        }
        if (Lists.last((List)switchExpr.getCases()) == cse) {
            cse.setKey(null);
            return;
        }
        Assert.check((boolean)(key instanceof LocationExpression));
        Location loc = ((LocationExpression)key).getLocation();
        Automaton aut = (Automaton)loc.eContainer();
        int idx = aut.getLocations().indexOf((Object)loc);
        EnumDecl enumDecl = this.getLocPointerEnum(aut);
        EnumLiteral literal = (EnumLiteral)enumDecl.getLiterals().get(idx);
        DiscVariable var = this.getLocPointerVar(aut);
        EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
        litRef.setLiteral(literal);
        litRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        EMFHelper.updateParentContainment((EObject)key, (EObject)litRef);
    }
}

