/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.options;

import org.eclipse.escet.cif.cif2plc.options.PlcOutputType;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class PlcOutputTypeOption
extends EnumOption<PlcOutputType> {
    public PlcOutputTypeOption() {
        super("PLC code output type", "Specifies the PLC code output type. Specify \"plc-open-xml\" for PLCopen XML output (default), \"iec-61131-3\" for IEC 61131-3 output, or \"twincat\" for \"TwinCAT\" output.", Character.valueOf('t'), "output-type", "OTYPE", (Enum)PlcOutputType.PLC_OPEN_XML, true, "Specifies the PLC code output type.");
    }

    protected String getDialogText(PlcOutputType type) {
        switch (type) {
            case PLC_OPEN_XML: {
                return "PLCopen XML";
            }
            case IEC_61131_3: {
                return "IEC 61131-3";
            }
            case TWINCAT: {
                return "TwinCAT";
            }
        }
        throw new RuntimeException("Unknown PLC output type: " + (Object)((Object)type));
    }

    public static PlcOutputType getPlcOutputType() {
        return (PlcOutputType)((Object)Options.get(PlcOutputTypeOption.class));
    }
}

