/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.escet.common.app.framework.PlatformUtils;
import org.eclipse.escet.common.java.UncachedUrlClassLoader;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ClassLoaderObtainer;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.osgi.framework.Bundle;

public class ImportClassLoaderObtainer
extends ClassLoaderObtainer {
    private final Position pos;
    private final CheckerContext ctxt;
    private final String useText;

    public ImportClassLoaderObtainer(Position pos, CheckerContext ctxt, String useText) {
        this.pos = pos;
        this.ctxt = ctxt;
        this.useText = useText;
    }

    protected void errNotPluginProj(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NOT_PLUGIN, this.pos, this.useText, name);
        throw new SemanticException();
    }

    protected void errPluginClassicFormat(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_CLASSIC_FORMAT, this.pos, this.useText, name);
        throw new SemanticException();
    }

    protected void errComputeClassPath(String name, CoreException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NO_JAVA_NATURE, this.pos, this.useText, name, exMsg);
        throw new SemanticException();
    }

    protected void errMalforumedUrl(String name, MalformedURLException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_MALFORMED_URL, this.pos, this.useText, name, exMsg);
        throw new SemanticException();
    }

    protected void errOpenUrl(String name, UncachedUrlClassLoader.OpenUrlException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_OPEN_URL, this.pos, this.useText, name, ex.url.toString(), exMsg);
        throw new SemanticException();
    }

    protected void errNotFound(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NOT_FOUND, this.pos, name);
        throw new SemanticException();
    }

    protected void errWrongState(String name, Bundle bundle, int state) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_STATE, this.pos, this.useText, name, PlatformUtils.getStateName((Bundle)bundle));
        throw new SemanticException();
    }

    protected void errNoClassLoader(String name, Bundle bundle) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_ADAPT, this.pos, this.useText, name);
        throw new SemanticException();
    }
}

