/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq.assignment;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentFunctions;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentNode;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class RhsExpression
implements AssignmentNode {
    private String rhsVar = null;
    private boolean initDone = false;
    public final Expression rhs;

    public RhsExpression(Expression rhs) {
        this.rhs = rhs;
    }

    @Override
    public boolean performsFullAssignment() {
        return true;
    }

    @Override
    public void saveUsedValues(boolean oneAssignment, Set<VariableDeclaration> assigneds, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        boolean needGenerate;
        if (this.initDone) {
            return;
        }
        this.initDone = true;
        boolean bl = needGenerate = !oneAssignment;
        if (!needGenerate) {
            Set useds = Sets.set();
            AssignmentFunctions.expressionCollectVariables(this.rhs, useds);
            boolean bl2 = needGenerate = !Sets.isEmptyIntersection((Set)useds, assigneds);
        }
        if (needGenerate) {
            this.rhsVar = ctxt.makeUniqueName("rhs");
            ExpressionBase v = ExpressionBase.convertExpression(this.rhs, ctxt, currentClass);
            v.setCurrentPositionStatement(lines);
            lines.addAll(v.getCode());
            TypeID tid = TypeIDCreation.createTypeID(this.rhs.getType(), ctxt);
            lines.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tid.getJavaType(), this.rhsVar, v.getValue()}));
        }
    }

    @Override
    public void assignValue(String lhsVar, List<Integer> rhsIndices, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        String valName = this.rhsVar;
        if (valName == null) {
            ExpressionBase v = ExpressionBase.convertExpression(this.rhs, ctxt, currentClass);
            v.setCurrentPositionStatement(lines);
            lines.addAll(v.getCode());
            valName = "(" + v.getValue() + ")";
        }
        lines.add(Strings.fmt((String)"%s = %s;", (Object[])new Object[]{lhsVar, AssignmentFunctions.makeTupleSelection(valName, rhsIndices)}));
    }
}

