/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.simulator.options;

import java.util.List;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class InputFileOption
extends Option<List<String>> {
    public InputFileOption() {
        super("Input file", "The path to the input file.", null, "*", "FILE", true);
    }

    public static String getPath() {
        List files = (List)Options.get(InputFileOption.class);
        return files.isEmpty() ? null : (String)files.get(0);
    }

    public List<String> getDefault() {
        return Lists.list();
    }

    public List<String> parseValue(String optName, String value) {
        return Lists.list((Object)value);
    }

    public void verifyValue(List<String> value) {
        if (value.size() > 1) {
            String msg = "";
            for (String s : value) {
                if (!msg.isEmpty()) {
                    msg = String.valueOf(msg) + ", ";
                }
                msg = String.valueOf(msg) + "\"" + s + "\"";
            }
            msg = Strings.fmt((String)"At most one input file was expected, but %d input files were provided: %s.", (Object[])new Object[]{value.size(), msg});
            throw new InvalidOptionException(msg);
        }
    }

    public String[] getCmdLine(Object value) {
        List files = (List)value;
        return files.toArray(new String[0]);
    }

    public OptionGroup<List<String>> createOptionGroup(Composite page) {
        return new OptionGroup<List<String>>(page, Options.getInstance(InputFileOption.class)){
            Label fileLabel;
            Text fileText;

            protected void addComponents(Group group) {
                this.fileLabel = new Label((Composite)group, 0);
                this.fileLabel.setText("Input file path:");
                this.fileText = new Text((Composite)group, 2052);
                this.layoutGeneric(new Object[]{new Control[]{this.fileLabel, this.fileText}}, 0);
            }

            public String getDescription() {
                return "The input file path.";
            }

            public void setToValue(List<String> value) {
                if (value.size() > 1) {
                    InputFileOption.this.verifyValue(value);
                }
                this.fileText.setText(value.isEmpty() ? "" : (String)Lists.first(value));
            }

            public String[] getCmdLine() {
                String[] stringArray;
                String path = this.fileText.getText();
                if (path.isEmpty()) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = path;
                }
                return stringArray;
            }
        };
    }
}

