/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.typecheck.ChiTypeChecker;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.SymTable;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class CheckContext {
    public final ChiTypeChecker tchk;
    private List<SymbolEntry> busySymbols;
    public final Set<ContextItem> state;
    private final SymTable sym;
    public final Type funcReturnType;
    public final Type exitType;

    public CheckContext(ChiTypeChecker tchk) {
        Assert.notNull((Object)((Object)tchk));
        this.tchk = tchk;
        this.busySymbols = Lists.list();
        this.state = Sets.set();
        this.sym = null;
        this.funcReturnType = null;
        this.exitType = null;
    }

    private CheckContext(ChiTypeChecker tchk, List<SymbolEntry> busySymbols, Set<ContextItem> state, SymTable sym, Type funcReturnType, Type exitType) {
        Assert.notNull((Object)((Object)tchk));
        this.tchk = tchk;
        this.busySymbols = busySymbols;
        this.state = state;
        this.sym = sym;
        this.funcReturnType = funcReturnType;
        this.exitType = exitType;
    }

    public void declareBusy(SymbolEntry se, boolean oldBusy) {
        if (oldBusy) {
            SymbolEntry s;
            int index = this.busySymbols.size() - 1;
            do {
                s = this.busySymbols.get(index);
                this.addError(Message.CYCLE_IN_DECLARATION, s.getPosition(), s.getName());
                --index;
            } while (s != se);
            throw new SemanticException();
        }
        this.busySymbols.add(se);
    }

    public void declareFinished(SymbolEntry se) {
        int lastIndex = this.busySymbols.size() - 1;
        Assert.check((this.busySymbols.get(lastIndex) == se ? 1 : 0) != 0);
        this.busySymbols.remove(lastIndex);
    }

    public boolean contains(ContextItem item) {
        return this.state.contains((Object)item);
    }

    public CheckContext add(ContextItem ... additions) {
        Set items = Sets.copy(this.state);
        ContextItem[] contextItemArray = additions;
        int n = additions.length;
        int n2 = 0;
        while (n2 < n) {
            ContextItem item = contextItemArray[n2];
            items.add(item);
            ++n2;
        }
        return new CheckContext(this.tchk, this.busySymbols, items, this.sym, this.funcReturnType, this.exitType);
    }

    public CheckContext remove(ContextItem ... removals) {
        Set items = Sets.copy(this.state);
        ContextItem[] contextItemArray = removals;
        int n = removals.length;
        int n2 = 0;
        while (n2 < n) {
            ContextItem item = contextItemArray[n2];
            items.remove((Object)item);
            ++n2;
        }
        return new CheckContext(this.tchk, this.busySymbols, items, this.sym, this.funcReturnType, this.exitType);
    }

    public CheckContext newFunctionContext(Type funcReturnType) {
        Assert.check((this.funcReturnType == null ? 1 : 0) != 0);
        return new CheckContext(this.tchk, this.busySymbols, this.state, this.sym, funcReturnType, this.exitType);
    }

    public CheckContext newExitContext(Type exitType) {
        Assert.check((this.exitType == null ? 1 : 0) != 0);
        return new CheckContext(this.tchk, this.busySymbols, this.state, this.sym, this.funcReturnType, exitType);
    }

    public CheckContext newSymbolContext() {
        SymTable sym = new SymTable(this.sym);
        return new CheckContext(this.tchk, this.busySymbols, this.state, sym, this.funcReturnType, this.exitType);
    }

    public void addSymbol(SymbolEntry se) {
        this.sym.addSymbol(se, this);
    }

    public SymbolEntry getSymbol(String name) {
        return this.sym.getSymbol(name);
    }

    public void checkSymbolUsage() {
        this.sym.checkSymbolUsage(this);
    }

    public void checkThrowError(boolean cond, Message msg, Position pos, String ... args) {
        if (cond) {
            return;
        }
        this.throwError(msg, pos, args);
    }

    public void throwError(Message msg, Position pos, String ... args) {
        this.addError(msg, pos, args);
        throw new SemanticException();
    }

    public void addWarning(Message msg, Position pos, String ... args) {
        Assert.check((msg.getSeverity() == SemanticProblemSeverity.WARNING ? 1 : 0) != 0);
        this.tchk.addProblem(msg.format(args), msg.getSeverity(), pos);
    }

    public void addError(Message msg, Position pos, String ... args) {
        Assert.check((msg.getSeverity() == SemanticProblemSeverity.ERROR ? 1 : 0) != 0);
        this.tchk.addProblem(msg.format(args), msg.getSeverity(), pos);
    }

    public static enum ContextItem {
        NO_DELAY,
        NO_SELECT,
        NO_RUN,
        NO_EXIT,
        NO_COMM,
        INSIDE_LOOP,
        NO_TIME,
        NO_READ,
        NO_INPUT,
        NO_CHANNEL,
        NO_REAL_TIMER_CAST,
        NO_SAMPLE,
        NO_VARIABLES,
        NO_PROCESSES,
        NO_MODELS,
        NO_VOID;

    }
}

