/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimStateEvtExclInvs
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating state/event exclusion invariants for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.elimStateEvtExclInvs((ComplexComponent)spec);
    }

    private void elimStateEvtExclInvs(ComplexComponent comp) {
        List invs;
        List<Invariant> compInvs = this.filterInvs((List<Invariant>)comp.getInvariants());
        List locInvs = Lists.list();
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                List<Invariant> invs2 = this.filterInvs((List<Invariant>)loc.getInvariants());
                this.modifyLocInvs(aut, invs2);
                locInvs.addAll(invs2);
            }
        }
        if (!(invs = Lists.concat(compInvs, (List)locInvs)).isEmpty()) {
            List<List<Invariant>> supKindsInvs = this.partitionPerSupKind(invs);
            for (List<Invariant> supKindInvs : supKindsInvs) {
                this.createAutomaton(comp, supKindInvs);
            }
        }
        this.removeInvs((EList<Invariant>)comp.getInvariants());
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                this.removeInvs((EList<Invariant>)loc.getInvariants());
            }
        }
        if (comp instanceof Group) {
            List children = Lists.copy((List)((Group)comp).getComponents());
            for (Component child : children) {
                this.elimStateEvtExclInvs((ComplexComponent)child);
            }
        }
    }

    private List<Invariant> filterInvs(List<Invariant> invs) {
        List filtered = Lists.list();
        for (Invariant inv : invs) {
            if (inv.getInvKind() == InvKind.STATE) continue;
            filtered.add(inv);
        }
        return filtered;
    }

    private void modifyLocInvs(Automaton aut, List<Invariant> invs) {
        if (aut.getLocations().size() == 1) {
            return;
        }
        for (Invariant inv : invs) {
            Location loc = (Location)inv.eContainer();
            Expression locRef = CifGuardUtils.LocRefExprCreator.DEFAULT.create(loc);
            Expression invPred = inv.getPredicate();
            BinaryExpression pred = CifConstructors.newBinaryExpression();
            pred.setOperator(BinaryOperator.IMPLICATION);
            pred.setLeft(locRef);
            pred.setRight(invPred);
            pred.setType((CifType)CifConstructors.newBoolType());
            inv.setPredicate((Expression)pred);
        }
    }

    private List<List<Invariant>> partitionPerSupKind(List<Invariant> invs) {
        Map invMap = Maps.map();
        for (Invariant inv : invs) {
            List kindInvs = (List)invMap.get(inv.getSupKind());
            if (kindInvs == null) {
                kindInvs = Lists.list();
                invMap.put(inv.getSupKind(), kindInvs);
            }
            kindInvs.add(inv);
        }
        return new ArrayList<List<Invariant>>(invMap.values());
    }

    private void createAutomaton(ComplexComponent comp, List<Invariant> invs) {
        List evtInvs;
        Event event;
        String proposedName;
        SupKind supKind = ((Invariant)Lists.first(invs)).getSupKind();
        ComplexComponent parent = comp instanceof Specification ? comp : CifScopeUtils.getScope((PositionObject)comp);
        Group group = (Group)parent;
        String string = proposedName = comp instanceof Specification ? "" : CifTextUtils.getName((PositionObject)comp);
        if (supKind != SupKind.NONE) {
            String txt = supKind.getName().toLowerCase(Locale.US);
            txt = StringUtils.capitalize((String)txt);
            proposedName = String.valueOf(proposedName) + txt;
        }
        String name = proposedName = String.valueOf(proposedName) + "StateEvtExcls";
        Set usedNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)parent, null);
        if (usedNames.contains(name)) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)usedNames, Collections.emptySet());
        }
        Automaton aut = CifConstructors.newAutomaton();
        group.getComponents().add((Object)aut);
        aut.setName(name);
        aut.setKind(supKind);
        Location loc = CifConstructors.newLocation();
        aut.getLocations().add((Object)loc);
        loc.getInitials().add((Object)CifValueUtils.makeTrue());
        loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        Map evtMap = Maps.map();
        for (Invariant invariant : invs) {
            event = ((EventExpression)invariant.getEvent()).getEvent();
            evtInvs = (List)evtMap.get(event);
            if (evtInvs == null) {
                evtInvs = Lists.list();
                evtMap.put(event, evtInvs);
            }
            evtInvs.add(invariant);
        }
        for (Map.Entry entry : evtMap.entrySet()) {
            event = (Event)entry.getKey();
            evtInvs = (List)entry.getValue();
            List guards = Lists.listc((int)evtInvs.size());
            for (Invariant inv : evtInvs) {
                Expression guard = inv.getPredicate();
                if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                    guard = CifValueUtils.makeInverse((Expression)guard);
                }
                Assert.notNull((Object)guard);
                guards.add(guard);
            }
            Edge edge = CifConstructors.newEdge();
            loc.getEdges().add((Object)edge);
            edge.getGuards().addAll((Collection)guards);
            EventExpression evtRef = CifConstructors.newEventExpression();
            evtRef.setEvent(event);
            evtRef.setType((CifType)CifConstructors.newBoolType());
            EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
            edge.getEvents().add((Object)edgeEvent);
            edgeEvent.setEvent((Expression)evtRef);
        }
    }

    private void removeInvs(EList<Invariant> invs) {
        Iterator invsIter = invs.iterator();
        while (invsIter.hasNext()) {
            Invariant inv = (Invariant)invsIter.next();
            if (inv.getInvKind() == InvKind.STATE) continue;
            invsIter.remove();
        }
    }
}

