/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class RefReplace
extends CifWalker
implements CifToCifTransformation {
    private final Map<PositionObject, Expression> refExprReplacements;
    private final Map<Declaration, CifType> refTypeReplacements;
    private final Map<Declaration, Declaration> equationReplacements;
    private boolean replaced;

    public RefReplace(Map<PositionObject, Expression> refExprReplacements, Map<Declaration, CifType> refTypeReplacements, Map<Declaration, Declaration> equationReplacements) {
        this.refExprReplacements = refExprReplacements;
        this.refTypeReplacements = refTypeReplacements;
        this.equationReplacements = equationReplacements;
    }

    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
    }

    public void transform(Expression expr) {
        this.walkExpression(expr);
    }

    public void transform(CifType type) {
        this.walkCifType(type);
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    protected void walkAlgVariableExpression(AlgVariableExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getVariable());
        if (replacement == null) {
            super.walkAlgVariableExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkConstantExpression(ConstantExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getConstant());
        if (replacement == null) {
            super.walkConstantExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkContVariableExpression(ContVariableExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getVariable());
        if (replacement == null) {
            super.walkContVariableExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkDiscVariableExpression(DiscVariableExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getVariable());
        if (replacement == null) {
            super.walkDiscVariableExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkEventExpression(EventExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getEvent());
        if (replacement == null) {
            super.walkEventExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkFunctionExpression(FunctionExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getFunction());
        if (replacement == null) {
            super.walkFunctionExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkInputVariableExpression(InputVariableExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getVariable());
        if (replacement == null) {
            super.walkInputVariableExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkEnumLiteralExpression(EnumLiteralExpression expr) {
        Expression replacement = this.refExprReplacements.get(expr.getLiteral());
        if (replacement == null) {
            super.walkEnumLiteralExpression(expr);
            return;
        }
        replacement = (Expression)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)expr, (EObject)replacement);
        this.replaced = true;
        this.walkExpression(replacement);
    }

    protected void walkTypeRef(TypeRef type) {
        CifType replacement = this.refTypeReplacements.get(type.getType());
        if (replacement == null) {
            super.walkTypeRef(type);
            return;
        }
        replacement = (CifType)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)type, (EObject)replacement);
        this.replaced = true;
        this.walkCifType(replacement);
    }

    protected void walkEnumType(EnumType type) {
        CifType replacement = this.refTypeReplacements.get(type.getEnum());
        if (replacement == null) {
            super.walkEnumType(type);
            return;
        }
        replacement = (CifType)EMFHelper.deepclone((EObject)replacement);
        EMFHelper.updateParentContainment((EObject)type, (EObject)replacement);
        this.replaced = true;
        this.walkCifType(replacement);
    }

    protected void preprocessEquation(Equation eqn) {
        Declaration replacement = this.equationReplacements.get(eqn.getVariable());
        if (replacement == null) {
            return;
        }
        eqn.setVariable(replacement);
        this.replaced = true;
    }

    protected void preprocessComponentDef(ComponentDef cdef) {
        throw new RuntimeException("Comp defs unsupported: " + cdef);
    }

    protected void preprocessCompInstWrapExpression(CompInstWrapExpression expr) {
        throw new RuntimeException("Comp inst wrap expr unupported: " + expr);
    }

    protected void preprocessCompInstWrapType(CompInstWrapType type) {
        throw new RuntimeException("Comp inst wrap type unupported: " + type);
    }

    protected void preprocessCompParamExpression(CompParamExpression expr) {
        throw new RuntimeException("Comp param expr unupported: " + expr);
    }

    protected void preprocessCompParamWrapExpression(CompParamWrapExpression expr) {
        throw new RuntimeException("Comp param wrap expr unupported: " + expr);
    }

    protected void preprocessCompParamWrapType(CompParamWrapType type) {
        throw new RuntimeException("Comp param wrap type unupported: " + type);
    }
}

