/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.options;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class GenerateValueActionsOption
extends StringOption {
    private static final Pattern FILTER_PATTERN = Pattern.compile("[-+]?[a-zA-Z_*][a-zA-Z0-9_*]*(\\.[a-zA-Z_*][a-zA-Z0-9_*]*)*");
    private static final String NAME = "Generate 'value' actions";
    private static final String OPT_DIALOG_DESCR = "Option to specify which variables should get a 'value' action in the generated mCRL2 code. Specify a comma-separated list of variable names. The \"*\" character can be used as wildcard, and indicates zero or more characters. Prefixing a name with a \"+\" adds the variable(s) matching the name, while a \"-\" prefix removes the variable(s) matching the name. If neither a \"+\" nor a \"-\" prefix is given, \"+\" (adding) is assumed. The list of variables is interpreted relative to selecting no variables. That is, if an empty list is specified, no variables get a 'value' action.";
    private static final String DEFAULT_VALUE = "+*";
    private static final String DESCRIPTION = Strings.fmt((String)"%s [DEFAULT=%s]", (Object[])new Object[]{"Option to specify which variables should get a 'value' action in the generated mCRL2 code. Specify a comma-separated list of variable names. The \"*\" character can be used as wildcard, and indicates zero or more characters. Prefixing a name with a \"+\" adds the variable(s) matching the name, while a \"-\" prefix removes the variable(s) matching the name. If neither a \"+\" nor a \"-\" prefix is given, \"+\" (adding) is assumed. The list of variables is interpreted relative to selecting no variables. That is, if an empty list is specified, no variables get a 'value' action.", "+*"});
    private static final boolean EMPTY_AS_NULL = false;
    private static final Character CMD_SHORT = Character.valueOf('r');
    private static final String CMD_LONG = "read-values";
    private static final String CMD_VALUE = "PATTERNS";
    private static final boolean SHOW_IN_DIALOG = true;
    private static final String OPT_DIALOG_LABEL_TEXT = "Generate 'value' actions:";

    public GenerateValueActionsOption() {
        super(NAME, DESCRIPTION, CMD_SHORT, CMD_LONG, CMD_VALUE, DEFAULT_VALUE, false, true, OPT_DIALOG_DESCR, OPT_DIALOG_LABEL_TEXT);
    }

    public static List<OptionPattern> getValueActionsOptionPatterns() {
        String optValue = (String)Options.get(GenerateValueActionsOption.class);
        List resultPatterns = Lists.list();
        String[] valuePatterns = StringUtils.split((String)optValue, (String)",");
        int i = 0;
        while (i < valuePatterns.length) {
            String regex;
            boolean addMatch;
            String s = valuePatterns[i].trim();
            if (!FILTER_PATTERN.matcher(s).matches()) {
                String msg = Strings.fmt((String)"Value actions pattern \"%s\" has invalid syntax.", (Object[])new Object[]{s});
                throw new InvalidOptionException(msg);
            }
            if (s.charAt(0) == '+') {
                addMatch = true;
                regex = s.substring(1);
            } else if (s.charAt(0) == '-') {
                addMatch = false;
                regex = s.substring(1);
            } else {
                addMatch = true;
                regex = s;
            }
            regex = "^" + regex.replace(".", "\\.").replace("*", ".*") + "$";
            resultPatterns.add(new OptionPattern(addMatch, s, regex));
            ++i;
        }
        return resultPatterns;
    }

    public static Set<String> matchNames(Set<String> names) {
        List<OptionPattern> patterns = GenerateValueActionsOption.getValueActionsOptionPatterns();
        if (names.isEmpty()) {
            return names;
        }
        Set matchedNames = Sets.set();
        for (String name : names) {
            boolean added = false;
            for (OptionPattern pat : patterns) {
                boolean matchCausesChange;
                if (!pat.isMatch(name, matchCausesChange = added ^ pat.addMatch)) continue;
                added = pat.addMatch;
            }
            if (!added) continue;
            matchedNames.add(name);
        }
        for (OptionPattern pat : patterns) {
            if (!pat.wasMatched) {
                String msg = Strings.fmt((String)"Value actions option pattern \"%s\" does not match any variable in the specification.", (Object[])new Object[]{pat.originalText});
                OutputProvider.warn((String)msg);
                continue;
            }
            if (pat.causedChange) continue;
            String reason = pat.addMatch ? "Matched variables were already added earlier." : "Matched variables were never added or already removed earlier.";
            String msg = Strings.fmt((String)"Value actions option pattern \"%s\" does not make any change to the selected variables. %s", (Object[])new Object[]{pat.originalText, reason});
            OutputProvider.warn((String)msg);
        }
        return matchedNames;
    }

    public static class OptionPattern {
        public final boolean addMatch;
        public final String originalText;
        public final Pattern pattern;
        public boolean wasMatched;
        public boolean causedChange;

        public OptionPattern(boolean addMatch, String originalText, String patternText) {
            this.addMatch = addMatch;
            this.originalText = originalText;
            this.pattern = Pattern.compile(patternText);
            this.reset();
        }

        public void reset() {
            this.wasMatched = false;
            this.causedChange = false;
        }

        public boolean isMatch(String name, boolean makesChange) {
            boolean match = this.pattern.matcher(name).matches();
            if (match) {
                this.wasMatched = true;
                this.causedChange |= makesChange;
            }
            return match;
        }
    }
}

