/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ExpressionsPackage;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToPlcPreChecker
extends CifWalker {
    private static final EReference FCE_FUNC_REF = ExpressionsPackage.eINSTANCE.getFunctionCallExpression_Function();
    private final List<String> problems = Lists.list();
    private int initLocCount;
    private int autCount;

    public void check(Specification spec) {
        this.walkSpecification(spec);
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF PLC code generator failed due to unsatisfied preconditions:\n - " + StringUtils.join(this.problems, (String)"\n - ");
            throw new UnsupportedException(msg);
        }
    }

    protected void postprocessSpecification(Specification spec) {
        if (this.autCount == 0) {
            String msg = "Unsupported specification: specifications without automata are currently not supported.";
            this.problems.add(msg);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        if (!CifValueUtils.isTriviallyTrue((List)comp.getInitials(), (boolean)true, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: initialization predicates in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
        List invPreds = Lists.listc((int)comp.getInvariants().size());
        for (Invariant inv : comp.getInvariants()) {
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: state invariants in components are currently not supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg);
        }
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        EObject parent = var.eContainer();
        if (!(parent instanceof ComplexComponent)) {
            return;
        }
        VariableValue values = var.getValue();
        if (values != null && values.getValues().size() != 1) {
            String msg = Strings.fmt((String)"Unsupported discrete variable \"%s\": the variable has multiple potential initial values.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            this.problems.add(msg);
        }
    }

    protected void preprocessExternalFunction(ExternalFunction func) {
        String msg = Strings.fmt((String)"Unsupported function \"%s\": external user-defined functions are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessLocation(Location loc) {
        if (loc.isUrgent()) {
            String msg = Strings.fmt((String)"Unsupported %s: urgent locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
        List invPreds = Lists.listc((int)loc.getInvariants().size());
        for (Invariant inv : loc.getInvariants()) {
            invPreds.add(inv.getPredicate());
        }
        if (!CifValueUtils.isTriviallyTrue((List)invPreds, (boolean)false, (boolean)true)) {
            String msg = Strings.fmt((String)"Unsupported %s: state invariants in locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
        boolean initial = false;
        try {
            initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List)loc.getInitials(), (boolean)true, (boolean)true);
        }
        catch (CifEvalException e) {
            String msg = Strings.fmt((String)"Failed to evaluate initialization predicate(s): %s.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)loc.getInitials())});
            this.problems.add(msg);
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.isUrgent()) {
            Location loc = (Location)edge.eContainer();
            String msg = Strings.fmt((String)"Unsupported %s: urgent edges are currently not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    protected void preprocessAutomaton(Automaton aut) {
        this.initLocCount = 0;
        ++this.autCount;
    }

    protected void postprocessAutomaton(Automaton aut) {
        String msg;
        if (this.initLocCount == 0) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata without an initial location are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
        if (this.initLocCount > 1) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata with multiple initial locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
    }

    protected void preprocessFunction(Function func) {
        if (func.getParameters().isEmpty()) {
            String msg = Strings.fmt((String)"Unsupported function \"%s\": the function has no parameters.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
            this.problems.add(msg);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void preprocessAssignmentFuncStatement(AssignmentFuncStatement asgn) {
        block3: {
            addr = asgn.getAddressable();
            try {
                CifAddressableUtils.getRefs((Expression)addr);
                break block3;
            }
            catch (CifAddressableUtils.DuplVarAsgnException ex) {
                parent = asgn.eContainer();
                ** while (!(parent instanceof InternalFunction))
            }
lbl-1000:
            // 1 sources

            {
                parent = parent.eContainer();
                continue;
            }
lbl11:
            // 1 sources

            func = (InternalFunction)parent;
            msg = Strings.fmt((String)"Unsupported function \"%s\": the function has a multi-assignment that assigns multiple (non-overlapping) parts of a single variable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
            this.problems.add(msg);
        }
    }

    protected void preprocessContinueFuncStatement(ContinueFuncStatement cfs) {
        EObject parent = cfs.eContainer();
        while (!(parent instanceof InternalFunction)) {
            parent = parent.eContainer();
        }
        InternalFunction func = (InternalFunction)parent;
        String msg = Strings.fmt((String)"Unsupported function \"%s\": the internal user-defined function contains a \"continue\" statement.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessDictType(DictType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": dictionary types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDistType(DistType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": distribution types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessFuncType(FuncType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": function types are currently not supported. That is, calling functions is supported, but using them as data is not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessListType(ListType type) {
        if (CifTypeUtils.isArrayType((ListType)type)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported type \"%s\": non-array list types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessSetType(SetType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": set types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessStringType(StringType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": string types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void walkCifType(CifType type) {
        EObject parent = type.eContainer();
        if (parent instanceof Expression && !(parent instanceof IfExpression) && !(parent instanceof SwitchExpression)) {
            return;
        }
        super.walkCifType(type);
    }

    protected void preprocessStringExpression(StringExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": string values are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessCastExpression(CastExpression expr) {
        CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (ctype instanceof IntType && rtype instanceof RealType) {
            return;
        }
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)rtype, (RangeCompat)RangeCompat.EQUAL)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": casts from type \"%s\" to type \"%s\" are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)rtype)});
        this.problems.add(msg);
    }

    protected void preprocessUnaryExpression(UnaryExpression expr) {
        UnaryOperator op = expr.getOperator();
        switch (op) {
            case INVERSE: 
            case NEGATE: 
            case PLUS: {
                return;
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": unary operator \"%s\" is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((UnaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessBinaryExpression(BinaryExpression expr) {
        BinaryOperator op = expr.getOperator();
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case MODULUS: 
            case INTEGER_DIVISION: 
            case MULTIPLICATION: 
            case DIVISION: {
                return;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof BoolType)) break;
                return;
            }
            case EQUAL: 
            case UNEQUAL: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof BoolType) && !(ltype instanceof IntType) && !(ltype instanceof RealType) && !(ltype instanceof EnumType)) break;
                return;
            }
            case SUBTRACTION: 
            case ADDITION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (!(ltype instanceof IntType) && !(ltype instanceof RealType)) break;
                return;
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": binary operator \"%s\" is currently not supported, or is not supported for the operands that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((BinaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessProjectionExpression(ProjectionExpression expr) {
        CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        if (ctype instanceof TupleType) {
            return;
        }
        if (ctype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)ctype))) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": projections on anything other than tuples and arrays is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSliceExpression(SliceExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": slicing is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression expr) {
        Expression fexpr = expr.getFunction();
        if (fexpr instanceof FunctionExpression) {
            return;
        }
        if (fexpr instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression lExpr = (StdLibFunctionExpression)fexpr;
            StdLibFunction stdlib = lExpr.getFunction();
            switch (stdlib) {
                case MINIMUM: 
                case MAXIMUM: 
                case POWER: 
                case CBRT: 
                case EXP: 
                case LN: 
                case LOG: 
                case SQRT: 
                case ACOS: 
                case ASIN: 
                case ATAN: 
                case COS: 
                case SIN: 
                case TAN: 
                case ABS: {
                    return;
                }
                case SIGN: 
                case CEIL: 
                case DELETE: 
                case EMPTY: 
                case FLOOR: 
                case POP: 
                case ROUND: 
                case SIZE: 
                case ACOSH: 
                case ASINH: 
                case ATANH: 
                case COSH: 
                case SINH: 
                case TANH: 
                case FORMAT: 
                case SCALE: {
                    break;
                }
            }
            String msg = Strings.fmt((String)"Unsupported expression \"%s\": standard  library function \"%s\" is currently not supported, or is not supported for the arguments that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.functionToStr((StdLibFunction)stdlib)});
            this.problems.add(msg);
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": function calls on anything other than standard library functions and internal user-defined functions is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSetExpression(SetExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": sets are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessDictExpression(DictExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": dictionaries are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionExpression(FunctionExpression expr) {
        if (expr.eContainer() instanceof FunctionCallExpression && expr.eContainmentFeature() == FCE_FUNC_REF) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": the use of functions as values is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }
}

