/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2supremica;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.RemovePositionInfo;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2supremica.CifToSupremicaPreChecker;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.ConstantOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CifToSupremica {
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String SUPREMICA_BASE_NS = "http://waters.sourceforge.net/xsd/base";
    private static final String SUPREMICA_MODULE_NS = "http://waters.sourceforge.net/xsd/module";

    private CifToSupremica() {
    }

    public static Document transform(Specification spec, String moduleName, boolean elimEnums) {
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new CifToSupremicaPreChecker().check(spec);
        CifToSupremica.preprocess(spec, elimEnums);
        CifToSupremica.modifyStateInvariants(spec);
        CifToSupremica.modifyJumping((ComplexComponent)spec);
        Document supremicaDoc = CifToSupremica.createSupremicaXmlDocument();
        Element moduleElem = supremicaDoc.getDocumentElement();
        moduleElem.setAttribute("Name", moduleName);
        List constants = Lists.list();
        CifToSupremica.collectConstants((ComplexComponent)spec, constants);
        if (!constants.isEmpty()) {
            Element constsElem = supremicaDoc.createElement("ConstantAliasList");
            moduleElem.appendChild(constsElem);
            CifToSupremica.addConstants(supremicaDoc, constsElem, constants);
        }
        Element eventsElem = supremicaDoc.createElement("EventDeclList");
        moduleElem.appendChild(eventsElem);
        CifToSupremica.addEvents(supremicaDoc, eventsElem, (ComplexComponent)spec);
        Element acceptElem = supremicaDoc.createElement("EventDecl");
        eventsElem.appendChild(acceptElem);
        acceptElem.setAttribute("Kind", "PROPOSITION");
        acceptElem.setAttribute("Name", ":accepting");
        Map markeds = Maps.map();
        CifToSupremica.collectComponentMarkeds((ComplexComponent)spec, markeds);
        Element compsElem = supremicaDoc.createElement("ComponentList");
        moduleElem.appendChild(compsElem);
        CifToSupremica.addComponents(supremicaDoc, compsElem, (ComplexComponent)spec, markeds);
        if (!compsElem.hasChildNodes()) {
            moduleElem.removeChild(compsElem);
        }
        Assert.check((boolean)markeds.isEmpty());
        return supremicaDoc;
    }

    private static void preprocess(Specification spec, boolean elimEnums) {
        new RemovePositionInfo().transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs().transform(spec);
        new AddDefaultInitialValues().transform(spec);
        new ElimSelf().transform(spec);
        new ElimAlgVariables().transform(spec);
        new ElimLocRefExprs().transform(spec);
        new ElimTypeDecls().transform(spec);
        new ElimMonitors().transform(spec);
        if (elimEnums) {
            new EnumsToInts().transform(spec);
        }
        new SimplifyValues().transform(spec);
        new SimplifyOthers().transform(spec);
    }

    private static Document createSupremicaXmlDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document doc = domImpl.createDocument(SUPREMICA_MODULE_NS, "Module", null);
        doc.setXmlStandalone(true);
        Element root = doc.getDocumentElement();
        root.setAttributeNS(XMLNS_NS, "xmlns:ns2", SUPREMICA_BASE_NS);
        root.setAttributeNS(XMLNS_NS, "xmlns", SUPREMICA_MODULE_NS);
        return doc;
    }

    private static void collectConstants(ComplexComponent comp, List<Constant> constants) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Constant)) continue;
            constants.add((Constant)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.collectConstants((ComplexComponent)child, constants);
            }
        }
    }

    private static void addConstants(Document doc, Element parent, List<Constant> constants) {
        constants = new ConstantOrderer().computeOrder(constants);
        for (Constant constant : constants) {
            Element constElem = doc.createElement("ConstantAlias");
            parent.appendChild(constElem);
            constElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)constant));
            Element exprElem = doc.createElement("ConstantAliasExpression");
            constElem.appendChild(exprElem);
            CifToSupremica.addExpr(doc, exprElem, constant.getValue());
        }
    }

    private static void addEvents(Document doc, Element parent, ComplexComponent comp) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            Event event = (Event)decl;
            CifToSupremica.addEvent(doc, parent, event);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.addEvents(doc, parent, (ComplexComponent)child);
            }
        }
    }

    private static void addEvent(Document doc, Element parent, Event event) {
        Element eventElem = doc.createElement("EventDecl");
        parent.appendChild(eventElem);
        if (event.getControllable().booleanValue()) {
            eventElem.setAttribute("Kind", "CONTROLLABLE");
        } else {
            eventElem.setAttribute("Kind", "UNCONTROLLABLE");
        }
        eventElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)event));
    }

    private static void addComponents(Document doc, Element parent, ComplexComponent comp, Map<DiscVariable, Expression> markeds) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof DiscVariable)) continue;
            CifToSupremica.addVariable(doc, parent, (DiscVariable)decl, markeds);
        }
        if (comp instanceof Automaton) {
            CifToSupremica.addAutomaton(doc, parent, (Automaton)comp);
        } else {
            Assert.check((boolean)(comp instanceof Group));
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.addComponents(doc, parent, (ComplexComponent)child, markeds);
            }
        }
    }

    private static void addVariable(Document doc, Element parent, DiscVariable var, Map<DiscVariable, Expression> markeds) {
        Element varElem = doc.createElement("VariableComponent");
        parent.appendChild(varElem);
        varElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)var));
        Element rangeElem = doc.createElement("VariableRange");
        varElem.appendChild(rangeElem);
        CifToSupremica.addType(doc, rangeElem, var.getType());
        Element initElem = doc.createElement("VariableInitial");
        varElem.appendChild(initElem);
        Element initEqElem = doc.createElement("BinaryExpression");
        initElem.appendChild(initEqElem);
        initEqElem.setAttribute("Operator", "==");
        Element initIdElem = doc.createElement("SimpleIdentifier");
        initEqElem.appendChild(initIdElem);
        initIdElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)var));
        CifToSupremica.addExpr(doc, initEqElem, (Expression)var.getValue().getValues().get(0));
        Expression marked = markeds.remove(var);
        if (marked == null) {
            OutputProvider.warn((String)"None of the values of variable \"%s\" is marked. In Supremica they will implicitly all be marked.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        } else {
            Element markElem = doc.createElement("VariableMarking");
            varElem.appendChild(markElem);
            Element acceptElem = doc.createElement("SimpleIdentifier");
            markElem.appendChild(acceptElem);
            acceptElem.setAttribute("Name", ":accepting");
            Element markEqElem = doc.createElement("BinaryExpression");
            markElem.appendChild(markEqElem);
            markEqElem.setAttribute("Operator", "==");
            Element markIdElem = doc.createElement("SimpleIdentifier");
            markEqElem.appendChild(markIdElem);
            markIdElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)var));
            CifToSupremica.addExpr(doc, markEqElem, marked);
        }
    }

    private static void addAutomaton(Document doc, Element parent, Automaton aut) {
        int count;
        Element compElem = doc.createElement("SimpleComponent");
        parent.appendChild(compElem);
        compElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)aut));
        switch (aut.getKind()) {
            case NONE: {
                throw new RuntimeException("Precond error: kindless aut.");
            }
            case PLANT: {
                compElem.setAttribute("Kind", "PLANT");
                break;
            }
            case REQUIREMENT: {
                compElem.setAttribute("Kind", "SPEC");
                break;
            }
            case SUPERVISOR: {
                compElem.setAttribute("Kind", "SUPERVISOR");
            }
        }
        Alphabet alphabet = aut.getAlphabet();
        Set alphaSet = null;
        if (alphabet != null && (count = alphabet.getEvents().size()) != 0) {
            alphaSet = Sets.setc((int)count);
            for (Expression eventRef : alphabet.getEvents()) {
                alphaSet.add(((EventExpression)eventRef).getEvent());
            }
        }
        Element graphElem = doc.createElement("Graph");
        compElem.appendChild(graphElem);
        graphElem.setAttribute("Deterministic", "false");
        Element nodesElem = doc.createElement("NodeList");
        graphElem.appendChild(nodesElem);
        boolean anyMarked = false;
        Location initLoc = null;
        for (Location loc : aut.getLocations()) {
            boolean marked;
            boolean initial;
            Element nodeElem = doc.createElement("SimpleNode");
            nodesElem.appendChild(nodeElem);
            String name = loc.getName();
            if (name == null) {
                name = "X";
            }
            nodeElem.setAttribute("Name", name);
            try {
                initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List)loc.getInitials(), (boolean)true, (boolean)true);
            }
            catch (CifEvalException e) {
                throw new RuntimeException("Precond error.", e);
            }
            if (initial) {
                Assert.check((initLoc == null ? 1 : 0) != 0);
                initLoc = loc;
                nodeElem.setAttribute("Initial", "true");
            }
            if (loc.getMarkeds().isEmpty()) continue;
            try {
                marked = CifEvalUtils.evalPreds((List)loc.getMarkeds(), (boolean)false, (boolean)true);
            }
            catch (CifEvalException e) {
                throw new RuntimeException("Precond error.", e);
            }
            if (!marked) continue;
            anyMarked = true;
            Element eventsElem = doc.createElement("EventList");
            nodeElem.appendChild(eventsElem);
            Element idElem = doc.createElement("SimpleIdentifier");
            eventsElem.appendChild(idElem);
            idElem.setAttribute("Name", ":accepting");
        }
        if (!anyMarked) {
            OutputProvider.warn((String)"None of the locations of CIF automaton \"%s\" is marked. In Supremica they will implicitly all be marked.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
        }
        Element edgesElem = doc.createElement("EdgeList");
        graphElem.appendChild(edgesElem);
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                Location tgtLoc = edge.getTarget();
                if (tgtLoc == null) {
                    tgtLoc = loc;
                }
                String src = loc.getName();
                String tgt = tgtLoc.getName();
                if (src == null) {
                    src = "X";
                }
                if (tgt == null) {
                    tgt = "X";
                }
                Assert.check((!edge.getEvents().isEmpty() ? 1 : 0) != 0);
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    boolean hasUpdate;
                    Element edgeElem = doc.createElement("Edge");
                    edgesElem.appendChild(edgeElem);
                    edgeElem.setAttribute("Source", src);
                    edgeElem.setAttribute("Target", tgt);
                    EventExpression eventRef = (EventExpression)edgeEvent.getEvent();
                    Event event = eventRef.getEvent();
                    Element lblsElem = doc.createElement("LabelBlock");
                    edgeElem.appendChild(lblsElem);
                    Element lblIdElem = doc.createElement("SimpleIdentifier");
                    lblsElem.appendChild(lblIdElem);
                    lblIdElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)event));
                    if (alphaSet != null) {
                        alphaSet.remove(event);
                    }
                    boolean hasGuard = !edge.getGuards().isEmpty();
                    boolean bl = hasUpdate = !edge.getUpdates().isEmpty();
                    if (!hasGuard && !hasUpdate) continue;
                    Element blockElem = doc.createElement("GuardActionBlock");
                    edgeElem.appendChild(blockElem);
                    if (hasGuard) {
                        Element guardsElem = doc.createElement("Guards");
                        blockElem.appendChild(guardsElem);
                        for (Expression guard : edge.getGuards()) {
                            CifToSupremica.addExpr(doc, guardsElem, guard);
                        }
                    }
                    if (!hasUpdate) continue;
                    Element actsElem = doc.createElement("Actions");
                    blockElem.appendChild(actsElem);
                    for (Update update : edge.getUpdates()) {
                        CifToSupremica.addUpdate(doc, actsElem, update);
                    }
                }
            }
        }
        if (alphaSet != null) {
            if (initLoc == null) {
                throw new AssertionError();
            }
            String locName = initLoc.getName();
            if (locName == null) {
                locName = "X";
            }
            for (Event event : alphaSet) {
                Element edgeElem = doc.createElement("Edge");
                edgesElem.appendChild(edgeElem);
                edgeElem.setAttribute("Source", locName);
                edgeElem.setAttribute("Target", locName);
                Element lblsElem = doc.createElement("LabelBlock");
                edgeElem.appendChild(lblsElem);
                Element lblIdElem = doc.createElement("SimpleIdentifier");
                lblsElem.appendChild(lblIdElem);
                lblIdElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)event));
                Element blockElem = doc.createElement("GuardActionBlock");
                edgeElem.appendChild(blockElem);
                Element guardsElem = doc.createElement("Guards");
                blockElem.appendChild(guardsElem);
                Element guardElem = doc.createElement("IntConstant");
                guardsElem.appendChild(guardElem);
                guardElem.setAttribute("Value", "0");
            }
        }
        if (!edgesElem.hasChildNodes()) {
            graphElem.removeChild(edgesElem);
        }
    }

    private static void addType(Document doc, Element parent, CifType type) {
        if (type instanceof BoolType) {
            Element rangeElem = doc.createElement("BinaryExpression");
            parent.appendChild(rangeElem);
            rangeElem.setAttribute("Operator", "..");
            Element lowerElem = doc.createElement("IntConstant");
            rangeElem.appendChild(lowerElem);
            lowerElem.setAttribute("Value", "0");
            Element upperElem = doc.createElement("IntConstant");
            rangeElem.appendChild(upperElem);
            upperElem.setAttribute("Value", "1");
        } else if (type instanceof IntType) {
            IntType itype = (IntType)type;
            Element rangeElem = doc.createElement("BinaryExpression");
            parent.appendChild(rangeElem);
            rangeElem.setAttribute("Operator", "..");
            Element lowerElem = doc.createElement("IntConstant");
            rangeElem.appendChild(lowerElem);
            lowerElem.setAttribute("Value", Strings.str((Object)itype.getLower()));
            Element upperElem = doc.createElement("IntConstant");
            rangeElem.appendChild(upperElem);
            upperElem.setAttribute("Value", Strings.str((Object)itype.getUpper()));
        } else if (type instanceof EnumType) {
            EnumType etype = (EnumType)type;
            Element enumElem = doc.createElement("EnumSetExpression");
            parent.appendChild(enumElem);
            for (EnumLiteral literal : etype.getEnum().getLiterals()) {
                Element litElem = doc.createElement("SimpleIdentifier");
                enumElem.appendChild(litElem);
                litElem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)literal));
            }
        } else {
            throw new RuntimeException("Precond error: " + type);
        }
    }

    private static void addExpr(Document doc, Element parent, Expression expr) {
        if (expr instanceof BoolExpression) {
            BoolExpression bexpr = (BoolExpression)expr;
            Element elem = doc.createElement("IntConstant");
            parent.appendChild(elem);
            elem.setAttribute("Value", bexpr.isValue() ? "1" : "0");
        } else if (expr instanceof IntExpression) {
            IntExpression iexpr = (IntExpression)expr;
            Element elem = doc.createElement("IntConstant");
            parent.appendChild(elem);
            elem.setAttribute("Value", Strings.str((Object)iexpr.getValue()));
        } else if (expr instanceof ConstantExpression) {
            Constant constant = ((ConstantExpression)expr).getConstant();
            Element elem = doc.createElement("SimpleIdentifier");
            parent.appendChild(elem);
            elem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)constant));
        } else if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            Element elem = doc.createElement("SimpleIdentifier");
            parent.appendChild(elem);
            elem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)var));
        } else if (expr instanceof EnumLiteralExpression) {
            EnumLiteral lit = ((EnumLiteralExpression)expr).getLiteral();
            Element elem = doc.createElement("SimpleIdentifier");
            parent.appendChild(elem);
            elem.setAttribute("Name", CifToSupremica.getSupremicaName((PositionObject)lit));
        } else if (expr instanceof BinaryExpression) {
            String opTxt;
            BinaryExpression bexpr = (BinaryExpression)expr;
            BinaryOperator op = bexpr.getOperator();
            Element elem = doc.createElement("BinaryExpression");
            parent.appendChild(elem);
            switch (op) {
                case BI_CONDITIONAL: {
                    opTxt = "==";
                    break;
                }
                case IMPLICATION: {
                    opTxt = "|";
                    break;
                }
                case CONJUNCTION: {
                    opTxt = "&";
                    break;
                }
                case DISJUNCTION: {
                    opTxt = "|";
                    break;
                }
                case ADDITION: {
                    opTxt = "+";
                    break;
                }
                case SUBTRACTION: {
                    opTxt = "-";
                    break;
                }
                case MULTIPLICATION: {
                    opTxt = "*";
                    break;
                }
                case INTEGER_DIVISION: {
                    opTxt = "/";
                    break;
                }
                case MODULUS: {
                    opTxt = "%";
                    break;
                }
                case EQUAL: {
                    opTxt = "==";
                    break;
                }
                case UNEQUAL: {
                    opTxt = "!=";
                    break;
                }
                case GREATER_EQUAL: {
                    opTxt = ">=";
                    break;
                }
                case GREATER_THAN: {
                    opTxt = ">";
                    break;
                }
                case LESS_EQUAL: {
                    opTxt = "<=";
                    break;
                }
                case LESS_THAN: {
                    opTxt = "<";
                    break;
                }
                default: {
                    throw new RuntimeException("Precond error: " + op);
                }
            }
            elem.setAttribute("Operator", opTxt);
            if (op == BinaryOperator.IMPLICATION) {
                Element elem2 = doc.createElement("UnaryExpression");
                elem.appendChild(elem2);
                elem2.setAttribute("Operator", "!");
                CifToSupremica.addExpr(doc, elem2, bexpr.getLeft());
            } else {
                CifToSupremica.addExpr(doc, elem, bexpr.getLeft());
            }
            CifToSupremica.addExpr(doc, elem, bexpr.getRight());
        } else if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            UnaryOperator op = uexpr.getOperator();
            if (op == UnaryOperator.PLUS) {
                CifToSupremica.addExpr(doc, parent, uexpr.getChild());
            } else {
                String opTxt;
                Element elem = doc.createElement("UnaryExpression");
                parent.appendChild(elem);
                switch (op) {
                    case INVERSE: {
                        opTxt = "!";
                        break;
                    }
                    case NEGATE: {
                        opTxt = "-";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Precond error: " + op);
                    }
                }
                elem.setAttribute("Operator", opTxt);
                CifToSupremica.addExpr(doc, elem, uexpr.getChild());
            }
        } else if (expr instanceof CastExpression) {
            CifToSupremica.addExpr(doc, parent, ((CastExpression)expr).getChild());
        } else {
            throw new RuntimeException("Precond error: " + expr);
        }
    }

    private static void addUpdate(Document doc, Element parent, Update update) {
        Assignment asgn = (Assignment)update;
        Element asgnElem = doc.createElement("BinaryExpression");
        parent.appendChild(asgnElem);
        asgnElem.setAttribute("Operator", "=");
        CifToSupremica.addExpr(doc, asgnElem, asgn.getAddressable());
        CifToSupremica.addExpr(doc, asgnElem, asgn.getValue());
    }

    private static void collectStateInvs(ComplexComponent comp, List<Invariant> invs) {
        invs.addAll((Collection<Invariant>)comp.getInvariants());
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.collectStateInvs((ComplexComponent)child, invs);
            }
        }
    }

    private static void collectComponentMarkeds(ComplexComponent comp, Map<DiscVariable, Expression> markeds) {
        for (Expression marked : comp.getMarkeds()) {
            BinaryExpression bexpr = (BinaryExpression)marked;
            DiscVariableExpression vref = (DiscVariableExpression)bexpr.getLeft();
            DiscVariable var = vref.getVariable();
            Expression prev = markeds.put(var, bexpr.getRight());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.collectComponentMarkeds((ComplexComponent)child, markeds);
            }
        }
    }

    private static void modifyStateInvariants(Specification spec) {
        String evtName;
        List stateInvs = Lists.list();
        CifToSupremica.collectStateInvs((ComplexComponent)spec, stateInvs);
        if (stateInvs.isEmpty()) {
            return;
        }
        List invPreds = Lists.listc((int)stateInvs.size());
        for (Invariant inv : stateInvs) {
            invPreds.add(inv.getPredicate());
        }
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        if (names.contains(evtName = "u_inv_bad")) {
            evtName = CifScopeUtils.getUniqueName((String)evtName, (Set)names, Collections.emptySet());
        }
        names.add(evtName);
        String reqName = "inv_req";
        if (names.contains(reqName)) {
            reqName = CifScopeUtils.getUniqueName((String)reqName, (Set)names, Collections.emptySet());
        }
        names.add(reqName);
        String plantName = "inv_plant";
        if (names.contains(plantName)) {
            plantName = CifScopeUtils.getUniqueName((String)plantName, (Set)names, Collections.emptySet());
        }
        names.add(plantName);
        Event event = CifConstructors.newEvent();
        event.setName(evtName);
        event.setControllable(Boolean.valueOf(false));
        spec.getDeclarations().add((Object)event);
        Automaton reqAut = CifConstructors.newAutomaton();
        spec.getComponents().add((Object)reqAut);
        reqAut.setName(reqName);
        reqAut.setKind(SupKind.REQUIREMENT);
        Location reqLoc = CifConstructors.newLocation();
        reqAut.getLocations().add((Object)reqLoc);
        reqLoc.getInitials().add((Object)CifValueUtils.makeTrue());
        reqLoc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        Edge reqEdge = CifConstructors.newEdge();
        reqLoc.getEdges().add((Object)reqEdge);
        reqEdge.getGuards().add((Object)CifValueUtils.makeFalse());
        EdgeEvent reqEdgeEvent = CifConstructors.newEdgeEvent();
        reqEdge.getEvents().add((Object)reqEdgeEvent);
        EventExpression reqEventRef = CifConstructors.newEventExpression();
        reqEdgeEvent.setEvent((Expression)reqEventRef);
        reqEventRef.setEvent(event);
        reqEventRef.setType((CifType)CifConstructors.newBoolType());
        Automaton plantAut = CifConstructors.newAutomaton();
        spec.getComponents().add((Object)plantAut);
        plantAut.setName(plantName);
        plantAut.setKind(SupKind.PLANT);
        Location plantLoc = CifConstructors.newLocation();
        plantAut.getLocations().add((Object)plantLoc);
        plantLoc.getInitials().add((Object)CifValueUtils.makeTrue());
        plantLoc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        Edge plantEdge = CifConstructors.newEdge();
        plantLoc.getEdges().add((Object)plantEdge);
        UnaryExpression notGuard = CifConstructors.newUnaryExpression();
        plantEdge.getGuards().add((Object)notGuard);
        notGuard.setOperator(UnaryOperator.INVERSE);
        notGuard.setType((CifType)CifConstructors.newBoolType());
        notGuard.setChild(CifValueUtils.createConjunction((List)invPreds));
        EdgeEvent plantEdgeEvent = CifConstructors.newEdgeEvent();
        plantEdge.getEvents().add((Object)plantEdgeEvent);
        EventExpression plantEventRef = CifConstructors.newEventExpression();
        plantEdgeEvent.setEvent((Expression)plantEventRef);
        plantEventRef.setEvent(event);
        plantEventRef.setType((CifType)CifConstructors.newBoolType());
    }

    private static void modifyJumping(ComplexComponent comp) {
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSupremica.modifyJumping((ComplexComponent)child);
            }
            return;
        }
        CifToSupremica.modifyJumping((Automaton)comp);
    }

    private static void modifyJumping(Automaton aut) {
        Set entry;
        Event event;
        Expression eventRef;
        Map mapping = Maps.map();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                Set vars = Sets.set();
                CifAddressableUtils.collectAddrVars((List)edge.getUpdates(), (Set)vars);
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    eventRef = edgeEvent.getEvent();
                    event = ((EventExpression)eventRef).getEvent();
                    entry = (Set)mapping.get(event);
                    if (entry == null) {
                        entry = Sets.set();
                        mapping.put(event, entry);
                    }
                    for (Declaration var : vars) {
                        entry.add((DiscVariable)var);
                    }
                }
            }
        }
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                Set todoVars = Sets.set();
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    eventRef = edgeEvent.getEvent();
                    event = ((EventExpression)eventRef).getEvent();
                    entry = (Set)mapping.get(event);
                    todoVars.addAll(entry);
                }
                Set asgnVars = Sets.set();
                CifAddressableUtils.collectAddrVars((List)edge.getUpdates(), (Set)asgnVars);
                for (Declaration var : asgnVars) {
                    todoVars.remove(var);
                }
                for (Declaration var : todoVars) {
                    DiscVariableExpression varRef = CifConstructors.newDiscVariableExpression();
                    varRef.setVariable((DiscVariable)var);
                    varRef.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
                    Assignment asgn = CifConstructors.newAssignment();
                    asgn.setAddressable((Expression)varRef);
                    asgn.setValue((Expression)EMFHelper.deepclone((EObject)varRef));
                    edge.getUpdates().add((Object)asgn);
                }
            }
        }
    }

    private static String getSupremicaName(PositionObject obj) {
        if (obj instanceof EnumLiteral) {
            EnumLiteral literal = (EnumLiteral)obj;
            return ":lit:" + literal.getName();
        }
        return CifTextUtils.getAbsName((PositionObject)obj, (boolean)false).replace('.', ':');
    }
}

