/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java.typeinfos;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.java.JavaDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.RealTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class JavaRealTypeInfo
extends RealTypeInfo {
    public final boolean contained;
    private static final Map<StdLibFunction, String> STANDARD_FUNCTIONS = Maps.map();

    static {
        STANDARD_FUNCTIONS.put(StdLibFunction.ACOS, "acos(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.ASIN, "asin(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.ATAN, "atan(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.COS, "cos(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.SIN, "sin(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.TAN, "tan(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.EXP, "exp(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.LOG, "log(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.LN, "ln(${args})");
    }

    public JavaRealTypeInfo(CifType cifType, boolean contained) {
        super(cifType);
        this.contained = contained;
    }

    @Override
    public String getTargetType() {
        return this.contained ? "Double" : "double";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(value));
        return result;
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "equalObjs(${left-value}, ${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "!equalObjs(${left-value}, ${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_THAN)) {
            return "(${left-value}) < (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_EQUAL)) {
            return "(${left-value}) <= (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_THAN)) {
            return "(${left-value}) > (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_EQUAL)) {
            return "(${left-value}) >= (${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode convertNegate(UnaryExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(expr.getChild(), null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(Strings.fmt((String)"negate(%s)", (Object[])new Object[]{childCode.getData()})));
        return result;
    }

    @Override
    public ExprCode convertAddition(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "addReal(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    public ExprCode convertSubtraction(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "subtract(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    public ExprCode convertMultiplication(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "multiply(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    protected ExprCode convertDivision(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern;
        if (properties.contains((Object)ExprProperties.RANGE_FAILURE) || properties.contains((Object)ExprProperties.ZERO_DIVIDE_FAILURE)) {
            pattern = "divide(${left-value}, ${right-value})";
        } else {
            Assert.check((properties.size() == 1 && properties.contains((Object)ExprProperties.INT_INT_DIVIDE) ? 1 : 0) != 0);
            pattern = "((double)(${left-value})) / (${right-value})";
        }
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    public ExprCode convertTimeExpression(Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue("time"));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaRealTypeInfo)) {
            return false;
        }
        JavaRealTypeInfo otherReal = (JavaRealTypeInfo)other;
        return this.contained == otherReal.contained;
    }

    @Override
    public int hashCode() {
        return JavaRealTypeInfo.class.hashCode() + (this.contained ? 1 : 0);
    }

    @Override
    public ExprCode convertAbsStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("abs(${args})", Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertMaximumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("max(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertMinimumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("min(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSignStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("sign(${args})", Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertPowerStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("powReal(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSqrtStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("sqrt(${args})", Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertCbrtStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("cbrt(${args})", Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertScaleStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("scale(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertTrigonometryStdLib(StdLibFunction stdLib, Expression expr, Destination dest, CodeContext ctxt) {
        String pattern = STANDARD_FUNCTIONS.get(stdLib);
        Assert.notNull((Object)pattern);
        return TypeInfoHelper.convertFunctionCallPattern(pattern, Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertLogarithmicStdLib(StdLibFunction stdLib, Expression expr, Destination dest, CodeContext ctxt) {
        String pattern = STANDARD_FUNCTIONS.get(stdLib);
        Assert.notNull((Object)pattern);
        return TypeInfoHelper.convertFunctionCallPattern(pattern, Lists.list((Object)expr), dest, ctxt);
    }
}

